/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.txw2;

import com.sun.xml.internal.txw2.NamespaceResolver;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DatatypeWriter<DT> {
    public static final List<DatatypeWriter<?>> BUILTIN = Collections.unmodifiableList(new AbstractList(){
        private DatatypeWriter<?>[] BUILTIN_ARRAY = new DatatypeWriter[]{new DatatypeWriter<String>(){

            @Override
            public Class<String> getType() {
                return String.class;
            }

            @Override
            public void print(String string, NamespaceResolver namespaceResolver, StringBuilder stringBuilder) {
                stringBuilder.append(string);
            }
        }, new DatatypeWriter<Integer>(){

            @Override
            public Class<Integer> getType() {
                return Integer.class;
            }

            @Override
            public void print(Integer n, NamespaceResolver namespaceResolver, StringBuilder stringBuilder) {
                stringBuilder.append(n);
            }
        }, new DatatypeWriter<Float>(){

            @Override
            public Class<Float> getType() {
                return Float.class;
            }

            @Override
            public void print(Float f, NamespaceResolver namespaceResolver, StringBuilder stringBuilder) {
                stringBuilder.append(f);
            }
        }, new DatatypeWriter<Double>(){

            @Override
            public Class<Double> getType() {
                return Double.class;
            }

            @Override
            public void print(Double d, NamespaceResolver namespaceResolver, StringBuilder stringBuilder) {
                stringBuilder.append(d);
            }
        }, new DatatypeWriter<QName>(){

            @Override
            public Class<QName> getType() {
                return QName.class;
            }

            @Override
            public void print(QName qName, NamespaceResolver namespaceResolver, StringBuilder stringBuilder) {
                String string = namespaceResolver.getPrefix(qName.getNamespaceURI());
                if (string.length() != 0) {
                    stringBuilder.append(string).append(':');
                }
                stringBuilder.append(qName.getLocalPart());
            }
        }};

        @Override
        public DatatypeWriter<?> get(int n) {
            return this.BUILTIN_ARRAY[n];
        }

        @Override
        public int size() {
            return this.BUILTIN_ARRAY.length;
        }
    });

    public Class<DT> getType();

    public void print(DT var1, NamespaceResolver var2, StringBuilder var3);
}

