/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt;

import com.yuxingwang.gantt.BaseView;
import com.yuxingwang.gantt.GanttChart;
import com.yuxingwang.gantt.model.GanttModel;
import com.yuxingwang.gantt.model.TaskTreeModel;
import com.yuxingwang.gantt.ui.TaskTreeUI;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Scrollable;
import javax.swing.UIManager;

public class TaskTreeView
extends BaseView
implements AdjustmentListener,
Scrollable,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private TaskTreeUI ttUI = null;
    private int taskCount = 0;

    public TaskTreeView(GanttChart ganttChart) {
        super(ganttChart);
        this.initialize();
    }

    private void initialize() {
        this.logger.info((Object)"Start to initialize TaskTreeView");
        this.setSize(new Dimension(180, 100));
        this.setMinimumSize(new Dimension(30, 50));
        this.ttUI = (TaskTreeUI)UIManager.getUI(this);
        super.setUI(this.ttUI);
        this.logger.info((Object)"Set UI for TaskTreeView");
    }

    public String getUIClassID() {
        return "TaskTreeUI";
    }

    protected void refreshDisplay() {
        int n;
        GanttModel ganttModel = this.ganttChart.getModel();
        if (ganttModel == null) {
            return;
        }
        TaskTreeModel taskTreeModel = this.ganttChart.getModel().getTaskTreeModel();
        Dimension dimension = this.getSize();
        this.logger.debug((Object)("TaskTreeView original component size is: " + dimension));
        int n2 = this.config == null ? 24 : this.config.getGanttChartRowHeight();
        int n3 = taskTreeModel.getLevels();
        int n4 = (n3 + 1) * n2 / 2;
        if (n4 < dimension.width) {
            n4 = dimension.width;
        }
        if ((n = n2 * this.taskCount) < this.getGanttChart().getRowHeader().getSize().height) {
            n = this.getGanttChart().getRowHeader().getSize().height;
        }
        Dimension dimension2 = new Dimension(n4, n);
        this.logger.debug((Object)("TaskTreeView preferred size has been changed to: " + dimension2));
        this.setPreferredSize(dimension2);
        this.setBounds(0, 0, dimension2.width, dimension2.height);
        this.revalidate();
        super.refreshView();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.refreshDisplay();
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public void setTaskCount(int n) {
        this.taskCount = n;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return this.config.getGanttChartRowHeight() * 4;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return this.ganttChart.getConfig().getGanttChartRowHeight();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = adjustmentEvent.getValue();
        this.logger.debug((Object)("Scroll to " + n));
        this.ttUI.setHorizonScrollOffset(n);
        this.refreshView();
    }
}

