/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt;

import com.yuxingwang.gantt.BaseView;
import com.yuxingwang.gantt.GanttChart;
import com.yuxingwang.gantt.ui.TimeScaleUI;
import com.yuxingwang.gantt.ui.timeaxis.BaseTimeAxis;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.UIManager;

public class TimeScaleView
extends BaseView
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private TimeScaleUI tasUI = null;

    public TimeScaleView(GanttChart ganttChart) {
        super(ganttChart);
        this.initialize();
    }

    private void initialize() {
        this.logger.info((Object)"Start to initialize TimeScaleView");
        this.setSize(new Dimension(300, 100));
        this.setMinimumSize(new Dimension(300, 100));
        this.tasUI = (TimeScaleUI)UIManager.getUI(this);
        super.setUI(this.tasUI);
        this.logger.info((Object)"Set UI for TimeScaleView");
    }

    public String getUIClassID() {
        return "TimeScaleUI";
    }

    protected void refreshDisplay() {
        if (this.tasUI == null || this.tasUI.getTimeAxis() == null) {
            return;
        }
        ((BaseTimeAxis)this.tasUI.getTimeAxis()).setTotalStepsCount(this.totalSteps);
        Dimension dimension = this.getSize();
        this.logger.debug((Object)("TimeScaleView original component size is: " + dimension));
        int n = this.config == null ? 24 : this.config.getTimeUnitWidth();
        int n2 = this.totalSteps * n;
        if (n2 < dimension.width) {
            n2 = dimension.width;
        }
        int n3 = 24;
        int n4 = n3 * 2 + 1;
        Dimension dimension2 = new Dimension(n2, n4);
        this.logger.debug((Object)("TimeScaleView preferred size has been changed to: " + dimension2));
        this.setPreferredSize(dimension2);
        this.setBounds(0, 0, dimension2.width, dimension2.height);
        this.revalidate();
        super.refreshView();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.refreshDisplay();
    }
}

