/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt.common;

import com.yuxingwang.gantt.Config;
import java.util.Calendar;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class CalendarUtils {
    static Logger logger = null;

    public static int getYearInterval(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            return 0;
        }
        int n = calendar2.get(1) - calendar.get(1);
        return n;
    }

    public static int getMonthInterval(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null || calendar.after(calendar2)) {
            return 0;
        }
        int n = CalendarUtils.getYearInterval(calendar, calendar2);
        int n2 = calendar2.get(2) - calendar.get(2) + n * 12;
        return n2;
    }

    public static int getWeekInterval(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            return 0;
        }
        int n = calendar2.get(3) - calendar.get(3);
        return n;
    }

    public static int getDateInterval(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            return 0;
        }
        Calendar calendar3 = CalendarUtils.truncateCloneTime(calendar, 5);
        Calendar calendar4 = CalendarUtils.truncateCloneTime(calendar2, 5);
        long l = calendar4.getTimeInMillis() - calendar3.getTimeInMillis();
        int n = 86400000;
        long l2 = l / (long)n;
        return (int)l2;
    }

    public static int getHourInterval(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            return 0;
        }
        Calendar calendar3 = CalendarUtils.truncateCloneTime(calendar, 11);
        Calendar calendar4 = CalendarUtils.truncateCloneTime(calendar2, 11);
        long l = calendar4.getTimeInMillis() - calendar3.getTimeInMillis();
        long l2 = l / 3600000L;
        return (int)l2;
    }

    public static Calendar truncateCloneTime(Calendar calendar, int n) {
        Calendar calendar2 = (Calendar)calendar.clone();
        CalendarUtils.truncateTime(calendar2, n);
        return calendar2;
    }

    public static void truncateTime(Calendar calendar, int n) {
        switch (n) {
            case 1: {
                calendar.set(2, 0);
            }
            case 2: {
                calendar.set(5, 0);
            }
            case 5: {
                calendar.set(11, 0);
            }
            case 10: 
            case 11: {
                calendar.set(12, 0);
            }
        }
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static int calcWorkingDays(Calendar calendar, int n) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(5, n);
        return CalendarUtils.calcWorkingDays(calendar, calendar2, null);
    }

    public static int calcWorkingDays(Calendar calendar, Calendar calendar2, int[] nArray) {
        int n;
        int n2 = 0;
        if (nArray == null || nArray.length < 2) {
            nArray = Config.DEFAULT_WORKING_DAYS_SPAN_OF_WEEK;
        }
        int n3 = nArray[0];
        int n4 = nArray[1];
        if (n3 < 0 || n4 > 7 || n3 > n4) {
            throw new IllegalArgumentException("Working duration in week is invalid");
        }
        int n5 = n4 - n3 + 1;
        int n6 = 7 - n5;
        int n7 = CalendarUtils.getDateInterval(calendar, calendar2) + 1;
        if (n7 <= 0) {
            return 0;
        }
        int n8 = calendar.get(7);
        if (n8 < n3) {
            n8 = n3;
        }
        if (n8 > n4) {
            n8 = n3;
            n7 -= n6;
        }
        if ((n = calendar2.get(7)) < n3) {
            n = n4;
            n7 -= n6;
        }
        if (n > n4) {
            n = n4;
        }
        int n9 = n - n8 + 1;
        int n10 = 0;
        n10 = n9 < 0 ? (n7 >= 0 ? n7 / 7 + 1 : -1) : (n7 >= 0 ? n7 / 7 : -1);
        n2 = n10 * n5;
        return n2 += n9;
    }

    public static int calcWorkingHourDurationLen(Calendar calendar, Calendar calendar2, int n, int n2) {
        boolean bl;
        int n3 = 0;
        int n4 = calendar.get(11);
        int n5 = calendar2.get(11);
        boolean bl2 = n4 >= n2 && n5 <= n + n2 - 1;
        boolean bl3 = bl = n4 < n2 && n5 > n + n2 - 1;
        if (DateUtils.isSameDay((Calendar)calendar, (Calendar)calendar2)) {
            if (bl2) {
                n3 = calendar2.get(11) - calendar.get(11) + 1;
            } else if (bl) {
                n3 = n;
            } else if (n4 < n2) {
                n3 = n5 - n2 + 1;
            } else if (n5 > n + n2 - 1) {
                n3 = n2 + n - 1 - n4 + 1;
            }
        } else {
            n3 = CalendarUtils.calcWorkingHours(calendar, calendar2, n + 1, n2);
        }
        return n3;
    }

    public static int calcWorkingHours(Calendar calendar, Calendar calendar2, int n, int n2) {
        int n3 = n - (calendar.get(11) - n2);
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > n) {
            n3 = n;
        }
        int n4 = calendar2.get(11) - n2 + 1;
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 > n) {
            n4 = n;
        }
        int n5 = calendar2.get(5) - calendar.get(5) - 1;
        int n6 = n3 + n4 + n5 * n;
        return n6;
    }

    public static Calendar cloneTimeByDateOffset(Calendar calendar, int n) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(5, n);
        return calendar2;
    }

    static {
        logger = LogManager.getLogger(CalendarUtils.class);
    }
}

