/*
 * Decompiled with CFR 0.152.
 */
package yuxingwang.common.time;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import yuxingwang.common.time.DatetimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateSpan
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Date dateFrom = new Date();
    private Date dateTo = new Date();

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
        if (this.dateFrom == null || this.dateTo == null) {
            return "Not correctly initialized date span";
        }
        return String.valueOf(sdf.format(this.dateFrom)) + " - " + sdf.format(this.dateTo);
    }

    public List<Date> getAllDate() {
        GregorianCalendar calendar = new GregorianCalendar();
        ArrayList<Date> dates = new ArrayList<Date>();
        Date curDate = this.dateFrom;
        while (curDate.before(this.dateTo) || curDate.equals(this.dateTo)) {
            dates.add(curDate);
            calendar.setTime(curDate);
            calendar.add(5, 1);
            curDate = calendar.getTime();
        }
        return dates;
    }

    public List<String> getAllDates(String format) {
        GregorianCalendar calendar = new GregorianCalendar();
        ArrayList<String> dates = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date curDate = this.dateFrom;
        while (curDate.before(this.dateTo) || curDate.equals(this.dateTo)) {
            calendar.setTime(curDate);
            dates.add(sdf.format(curDate));
            calendar.add(5, 1);
            curDate = calendar.getTime();
        }
        return dates;
    }

    public void moveDates(int offset) {
        Calendar from = Calendar.getInstance();
        from.setTime(this.dateFrom);
        from.add(6, offset);
        this.dateFrom = from.getTime();
        Calendar to = Calendar.getInstance();
        to.setTime(this.dateTo);
        to.add(6, offset);
        this.dateTo = to.getTime();
    }

    public int dayOfDate(Date curDate) {
        if (curDate.before(this.dateFrom) || curDate.after(this.dateTo)) {
            return -1;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(curDate);
        int month = c.get(2);
        int date = c.get(5);
        Calendar cFrom = Calendar.getInstance();
        cFrom.setTime(this.dateFrom);
        int monthFrom = cFrom.get(2);
        int dateFrom = cFrom.get(5);
        int monthCount = cFrom.getActualMaximum(5);
        if (month > monthFrom) {
            return date - (dateFrom - monthCount);
        }
        return date - dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom = DatetimeUtil.stripTimeOfDate(dateFrom);
    }

    public void SetTimeFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo = DatetimeUtil.stripTimeOfDate(dateTo);
    }

    public void setTimeTo(Date dateTo) {
        this.dateTo = dateTo;
    }
}

