using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace ASFBufferFix {
	public partial class frmASFBufferFix : Form {
		public frmASFBufferFix() {
			InitializeComponent();
		}

		private void frmASFBufferFix_DragEnter(object sender, DragEventArgs e) {
			if (e.Data.GetDataPresent(DataFormats.FileDrop)) {
				e.Effect = DragDropEffects.Copy;
			}
		}

		private void frmASFBufferFix_DragDrop(object sender, DragEventArgs e) {
			if (e.Data.GetDataPresent(DataFormats.FileDrop)) {
				string[] drops = (string[])e.Data.GetData(DataFormats.FileDrop);

				for (int i = 0; i < drops.Length; i++) {
					FixFile(drops[i]);
				}
			}
		}

		private void FixFile(string path) {
			string mbStart = Path.GetFileName(path) + Environment.NewLine + Environment.NewLine;

			try {
				ASFParse a = new ASFParse(path);
				int n = a.FixBufferSizes();

				MessageBox.Show(mbStart + String.Format("Finished, patched {0} Extended " +
					"Stream Properties objects.", n), "Done.", MessageBoxButtons.OK,
					MessageBoxIcon.Information);
			}
			catch (Exception ex) {
				MessageBox.Show(mbStart + ex.Message, "Error", MessageBoxButtons.OK,
					MessageBoxIcon.Error);
			}
		}

		private void aboutToolStripMenuItem_Click(object sender, EventArgs e) {
			MessageBox.Show(String.Format("ASF Buffer Fix v1.0.0{0}Copyright 2006 Moitah{0}" +
				"http://www.moitah.net/", Environment.NewLine), "About", MessageBoxButtons.OK,
				MessageBoxIcon.Information);
		}
	}
}