/*
 * Decompiled with CFR 0.152.
 */
package yuxingwang.common.debug;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Date;
import java.util.EventObject;
import org.apache.commons.lang.time.DateFormatUtils;

public class DebugConsole {
    private static boolean debug = true;

    public static void setDebug(boolean debugg) {
        debug = debugg;
    }

    public static void title(Object message) {
        System.out.println("----------------\t" + message + "\t----------------");
    }

    public static void error(Object message) {
        System.err.println("[ERROR] : " + message);
    }

    public static void event(EventObject e, Object message) {
        String source = e == null ? null : e.getSource().getClass().getName();
        System.err.println("  [EVENT]: [" + source + "]~~~~~~~~~\t" + message + "\t~~~~~~~~");
    }

    public static void info(Object message) {
        System.out.println("    [INFO] : " + message);
    }

    public static void debug(Object message) {
        if (!debug) {
            return;
        }
        System.out.println("      [DEBUG] : " + message);
    }

    public static void debug(Object message, Date date) {
        if (!debug) {
            return;
        }
        String dateTime = DateFormatUtils.format((Date)date, (String)"yyyy/MM/dd hh:mm:ss");
        System.out.println("      [DEBUG] : " + message + " : " + dateTime);
    }

    public static void paintebug(Object message) {
        if (!debug) {
            return;
        }
        System.out.println("        [PAINT] : " + message);
    }

    public static void paintebug(Object message, Point leftTopPoint, Rectangle clientRect) {
        if (!debug) {
            return;
        }
        System.out.println("        [PAINT] [START POINT:" + leftTopPoint.x + "," + leftTopPoint.y + "]\t[CLIENT RECTANGLE:" + clientRect.width + ", " + clientRect.height + "] : " + message);
    }
}

