/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt.ui;

import com.yuxingwang.gantt.BaseView;
import com.yuxingwang.gantt.Config;
import com.yuxingwang.gantt.GanttChart;
import com.yuxingwang.gantt.common.EventLogger;
import com.yuxingwang.gantt.common.LogHelper;
import com.yuxingwang.gantt.event.TimeUnitChangeEvent;
import com.yuxingwang.gantt.event.TimeUnitChangeListener;
import com.yuxingwang.gantt.ui.TimeUnit;
import com.yuxingwang.gantt.ui.timeaxis.AllDayTimeAxis;
import com.yuxingwang.gantt.ui.timeaxis.BaseTimeAxis;
import com.yuxingwang.gantt.ui.timeaxis.DailyTimeAxis;
import com.yuxingwang.gantt.ui.timeaxis.HourlyTimeAxis;
import com.yuxingwang.gantt.ui.timeaxis.MonthlyTimeAxis;
import com.yuxingwang.gantt.ui.timeaxis.TimeAxis;
import com.yuxingwang.gantt.ui.timeaxis.WeeklyTimeAxis;
import com.yuxingwang.gantt.ui.timeaxis.YearlyTimeAxis;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class BaseGanttChartUI
extends ComponentUI {
    protected Logger logger = LogManager.getLogger(this.getClass());
    protected GanttChart ganttChart = null;
    protected TimeAxis timeAxis = null;
    protected Config config = null;
    protected int clientWidth = 0;
    protected int clientHeight = 0;

    public void installUI(JComponent jComponent) {
        this.logger.debug((Object)"Install UI");
        BaseView baseView = (BaseView)jComponent;
        this.ganttChart = baseView.getGanttChart();
        this.ganttChart.addTimeUnitChangeListener(new TimeUnitChangeListener(){

            public void timeUnitChanged(TimeUnitChangeEvent timeUnitChangeEvent) {
                EventLogger.event(timeUnitChangeEvent, "Property " + timeUnitChangeEvent.getPropertyName() + " changed from " + timeUnitChangeEvent.getOldValue() + " to " + timeUnitChangeEvent.getNewValue());
                BaseTimeAxis baseTimeAxis = null;
                TimeUnit timeUnit = timeUnitChangeEvent.getNewTimeUnit();
                if (timeUnit == TimeUnit.Hour) {
                    baseTimeAxis = new HourlyTimeAxis(BaseGanttChartUI.this.ganttChart);
                } else if (timeUnit == TimeUnit.AllDay) {
                    baseTimeAxis = new AllDayTimeAxis(BaseGanttChartUI.this.ganttChart);
                } else if (timeUnit == TimeUnit.Day) {
                    baseTimeAxis = new DailyTimeAxis(BaseGanttChartUI.this.ganttChart);
                } else if (timeUnit == TimeUnit.Week) {
                    baseTimeAxis = new WeeklyTimeAxis(BaseGanttChartUI.this.ganttChart);
                } else if (timeUnit == TimeUnit.Month) {
                    baseTimeAxis = new MonthlyTimeAxis(BaseGanttChartUI.this.ganttChart);
                } else if (timeUnit == TimeUnit.Year) {
                    baseTimeAxis = new YearlyTimeAxis(BaseGanttChartUI.this.ganttChart);
                } else {
                    throw new NullPointerException("Time Unit is not acceptable");
                }
                BaseGanttChartUI.this.timeAxis = baseTimeAxis;
            }
        });
        this.ganttChart.fireTimeUnitChange(this, null, (Object)this.ganttChart.getTimeUnit());
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        LogHelper.title(this.logger, "Start to paint gantt UI");
        EventLogger.paintebug("The size of the component " + jComponent.getSize());
        Insets insets = jComponent.getInsets();
        graphics.translate(insets.left, insets.top);
        this.clientWidth = jComponent.getPreferredSize().width - insets.left - insets.right;
        this.clientHeight = jComponent.getPreferredSize().height - insets.top - insets.bottom;
        EventLogger.paintebug("The client size adjusted to " + new Dimension(this.clientWidth, this.clientHeight));
    }

    public TimeAxis getTimeAxis() {
        return this.timeAxis;
    }

    public void setTimeAxis(TimeAxis timeAxis) {
        this.timeAxis = timeAxis;
    }
}

