/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt.ui;

import com.yuxingwang.gantt.Config;
import com.yuxingwang.gantt.GanttChart;
import com.yuxingwang.gantt.model.Task;
import com.yuxingwang.gantt.ui.Paintable;
import com.yuxingwang.gantt.ui.timeaxis.TimeAxisUtils;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Calendar;
import javax.swing.JComponent;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class BaseTaskRenderer
implements Paintable {
    protected Logger logger = LogManager.getLogger(this.getClass());
    protected boolean isDebug = false;
    protected int step_length = 0;
    protected int row_height = 0;
    protected int task_bar_height = 0;
    protected int progress_bar_height = 0;
    protected int space_to_bar = 0;
    protected Graphics g = null;
    protected GanttChart gantt = null;
    protected Config config = null;
    protected Rectangle rect = null;

    public void paint(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        this.step_length = this.gantt.getConfig().getTimeUnitWidth();
        this.row_height = this.config.getGanttChartRowHeight();
        this.task_bar_height = this.config.getTaskBarHeight();
        this.progress_bar_height = this.config.getProgressBarHeight();
        this.space_to_bar = (this.row_height - this.task_bar_height) / 2;
    }

    protected int calcTaskStartPointX(Task task) {
        this.logger.debug((Object)("    Calculate X for Start time of task: " + task));
        Calendar calendar = this.gantt.getModel().getKickoffTime();
        Calendar calendar2 = null;
        if (task.isLeaf()) {
            calendar2 = task.getActualStart();
        } else {
            calendar2 = task.getEarliestSubTask().getActualStart();
            if (calendar2.after(task.getActualStart())) {
                calendar2 = task.getActualStart();
            }
        }
        int n = TimeAxisUtils.getTimeIntervalByTimeUnit(this.gantt.getTimeUnit(), calendar, calendar2);
        int n2 = (n + this.config.getBlankStepsToKickoffTime()) * this.step_length;
        this.logger.debug((Object)("      = " + n + "*" + this.step_length + " + (kickoff point x) = " + n2));
        return n2;
    }

    protected int calcTaskEndPointX(int n, Task task) {
        this.logger.debug((Object)("    Calculate X for End time of task: " + task));
        int n2 = 0;
        n2 = n + task.calcTaskSteps() * this.step_length;
        this.logger.debug((Object)("      = " + n2));
        return n2;
    }

    protected int calcTaskPointY(Task task, int n) {
        this.logger.debug((Object)("    Calculate Y of task: " + task + " for row: " + n));
        int n2 = this.rect.y + this.row_height * n + this.space_to_bar;
        this.logger.debug((Object)("      = " + n2));
        return n2;
    }

    protected Polygon createDiamondShape(int n, int n2, int n3) {
        int[] nArray = new int[]{n, n + n3, n, n - n3};
        int[] nArray2 = new int[]{n2, n2 + n3, n2 + n3 * 2, n2 + n3};
        return new Polygon(nArray, nArray2, 4);
    }
}

