/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt.ui.timeaxis;

import com.yuxingwang.gantt.GanttChart;
import com.yuxingwang.gantt.TimeScaleView;
import com.yuxingwang.gantt.common.EventLogger;
import com.yuxingwang.gantt.ui.timeaxis.BaseTimeAxis;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public abstract class BaseRestoutTimeAxis
extends BaseTimeAxis {
    public BaseRestoutTimeAxis(GanttChart ganttChart) {
        this.gantt = ganttChart;
    }

    public void paint(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        super.paint(graphics, jComponent, rectangle);
        int n = this.calcPositionInMajorScale(this.kickoffTime);
        int n2 = n - this.config.getBlankStepsToKickoffTime();
        this.stepsToFirstMajorScale = STEPS_OF_MAJOR_SCALE - n2 + 1;
        if (this.stepsToFirstMajorScale >= STEPS_OF_MAJOR_SCALE) {
            this.stepsToFirstMajorScale -= STEPS_OF_MAJOR_SCALE;
        }
        EventLogger.paintebug("The steps to first full major scale is: " + this.stepsToFirstMajorScale);
        this.totalMajorStepsCount = (this.totalStepsCount - this.stepsToFirstMajorScale) / STEPS_OF_MAJOR_SCALE + 1;
        super.paintMutual();
    }

    protected void drawMajorTimeScaleBorder() {
        EventLogger.paintebug("Start to draw major time scale borders");
        this.g.setColor(Color.black);
        for (int i = 0; i < this.totalMajorStepsCount; ++i) {
            int n = this.step_length * (i * STEPS_OF_MAJOR_SCALE + this.stepsToFirstMajorScale);
            this.g.drawRect(n, 0, this.componentRect.width - 1, this.row_height);
            String string = this.formatToMajorLabel(this.firstStepOfChart, i);
            this.g.drawChars(string.toCharArray(), 0, string.length(), n + 4, 0 + this.row_height - 4);
        }
    }

    protected void drawMinorTimeScaleBackground(int n, int n2) {
        int n3;
        EventLogger.paintebug("Start to draw minor time scale background");
        for (n3 = 0; n3 < this.totalStepsCount; ++n3) {
            if (this.isFreeTime(n3)) {
                this.g.setColor(this.config.getRestoutTimeBackColor());
                this.g.fillRect(this.step_length * n3, n, this.step_length, n2);
                continue;
            }
            this.g.setColor(this.config.getWorkingTimeBackColor());
            this.g.fillRect(this.step_length * n3, n, this.step_length, n2);
        }
        super.drawMajorScaleSeperator();
        super.drawKickoffTime(n, n2);
        super.drawDeadline(n, n2);
        if (this.component instanceof TimeScaleView) {
            EventLogger.paintebug("Start to draw minor time scale labels");
            for (n3 = 0; n3 < this.totalStepsCount; ++n3) {
                this.drawMinorTimeScaleLabel(n3, this.step_length * n3, this.row_height);
            }
        }
    }

    protected abstract void drawMinorTimeScaleLabel(int var1, int var2, int var3);

    protected abstract boolean isFreeTime(int var1);
}

