=begin
 SP sample script
 ----------------
 Move selected subtitle text lines up by one line
 Keep existing timestamps
 With each continuous selected area, there will be one subtitle text lost 
 (at the top of the area) and one line dulicated (at the bottom of the area)
 
 This sample uses the SP high-level class
=end

require 'data/script/SP/sp.rb'

# Method that will execute the main function of the script
def move_lines_up
  # Log a string to Log window
  SP.ui.log('move_lines_up() started')
  # call the main method, move up by one line
  move_lines(-1)
  # Log successfull finish
  SP.ui.log('move_lines_up() finished')
end 

def move_lines_down
  SP.ui.log('move_lines_down() started')
  # call the main method, move down by one line
  move_lines(1)
  SP.ui.log('move_lines_down() finished')
end


# Move text lines up or down by delta lines
def move_lines(delta)
#  SP.ui.msg_box("Move by #{delta} lines", 1, 0)

  #Get selection, sort it
  selection = SP.editor.get_selected_area
  
  #Sort selection in place (sort!})
  # We want it to be sorted in increasing order if we are moving text up and in decreasing
  # order if we are moving down
  # So using the ternary operator, when delta is less than 0 (up), compare first and second item
  # otherwise compare second and first -> reverse order!
  # Using this sort, we will only lose the lines at the beginning of each selection section
  selection.sort!{|x,y| (delta < 0 ? x <=> y : y <=> x)}
  #Get number of subtitles
  subs_count = SP.subs_first.count
#  SP.ui.msg_box("Subs count: #{subs_count}", 1, 0)

  # For each selected subtitle
  selection.each do |sel|
    if (delta<0) then #Moving up
      #can't move by delta up if it would result in negative index
      #SP has subtitles indexed from 0 to (count-1)!!!
      if ((sel + delta) >= 0) then
#        SP.ui.msg_box("Moving #{sel} up", 1, 0)
        #Finally move the text, get it from one subtitle and assign to the other
        SP.subs_first.subs[sel + delta].text = SP.subs_first.subs[sel].text
      end  
    else #Moving down
      #Likewise, check if it won't move past count
      if ((sel + delta) < subs_count) then
#        SP.ui.msg_box("Moving #{sel} down", 1, 0)
        SP.subs_first.subs[sel + delta].text = SP.subs_first.subs[sel].text
      end  
    end
  end
  
  SP.display_subtitles
  
  #Now shift the selection, it would be cool if we could press the button 
  #repeatedly to move the lines further, wouldn't it?
  
  # select_by_array works differently, it takes array of booleans specifying
  # whether subtitle should be selected or not. This array must have
  # same length as subtitles count
  bool_sel = []
  # fill with falses
  subs_count.times do |i|
    bool_sel[i] = false
  end
    
  #fill true where subtitle should be selected  
  selection.size.times do |i|
    resulting_i = selection[i] + delta
    bool_sel[resulting_i] = true unless ((resulting_i < 0) or (resulting_i >= subs_count))
  end
#  puts bool_sel
  
  SP.editor.select_by_array(bool_sel)
end


# This function is called everytime SP initializes scripts.
# The parameter file gets the actual path to the script file
def sp_query(file)
  SP.ui.log('registering move_lines_up.rb')
  #Register the script as Editor toolbar button
  # Green Up arrow image (13)
  # Green Down arrow image (12)
  # get translated texts - any string constant from frmMain can be used.
  caption = SP.ui.get_translation('S_SCRIPT_Text')
  hint_up = SP.ui.get_translation('S_SCRIPT_TextHintUp')
  hint_down = SP.ui.get_translation('S_SCRIPT_TextHintDown')
  
  #We will register two buttons, one for up method, one for down method
  #SP remembers the 'expression' (last parameter) and executes it when the button
  #is clicked
  SP.register_toolbar_script(caption, hint_up, 13, file, 'move_lines_up')
  SP.register_toolbar_script(caption, hint_down, 12, file, 'move_lines_down')
end