# SP sample script
# ----------------
# Demonstrates registration of scripts as SP Editor toolbar scripts

# Method that will execute the main function of the script
def my_cool_script
  # Log a string to Log window
  SPUIInterface.log('Script is working')
  # Get a string value from the user
  name = SPUIInterface.input_dlg('Sample script', 'Enter your name', 'Jan', 300, 100, false, false);
  # Show an information message box
  SPUIInterface.msg_box("Hello #{name}", 1, 0)
end 

# This function is called everytime SP initializes scripts.
# The parameter file gets the actual path to the script file
def sp_query(file)
  SPUIInterface.log('registering toolbar')
  #get translated texts
  caption = SPUIInterface.get_translation('S_SCRIPT_Sample')
  hint = SPUIInterface.get_translation('S_SCRIPT_SampleScript')
  #Register the script as Editor toolbar button
  SPIntegrationInterface.register_toolbar_script(caption, hint, 71, file, 'my_cool_script') 
end