/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.activities;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesManager;
import com.aelitis.azureus.buddy.VuzeBuddy;
import com.aelitis.azureus.buddy.VuzeBuddyListener;
import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.util.MapUtils;
import java.util.Map;

public class VuzeActivitiesEntryBuddy
extends VuzeActivitiesEntry
implements VuzeBuddyListener {
    protected VuzeBuddy buddy;
    private String buddyID;

    public void loadCommonFromMap(Map map) {
        super.loadCommonFromMap(map);
        Map mapNewBuddy = (Map)MapUtils.getMapObject(map, "buddy", null, Map.class);
        if (mapNewBuddy == null) {
            String buddyID = MapUtils.getMapString(map, "buddyID", null);
            if (buddyID != null) {
                this.buddy = VuzeBuddyManager.getBuddyByLoginID(buddyID);
            }
        } else {
            this.buddy = VuzeBuddyManager.getOrCreatePotentialBuddy(mapNewBuddy);
        }
        if (this.buddy != null) {
            this.buddy.addListener(this);
        }
    }

    public Map toMap() {
        Map map = super.toMap();
        if (this.buddy != null) {
            map.put("buddy", this.buddy.toMap());
            map.put("buddyID", this.buddy.getLoginID());
        } else if (this.buddyID != null) {
            map.put("buddyID", this.buddyID);
        }
        return map;
    }

    public VuzeBuddy getBuddy() {
        return this.buddy;
    }

    public void setBuddy(VuzeBuddy buddy) {
        if (buddy != this.buddy && this.buddy != null) {
            buddy.removeListener(this);
        }
        this.buddy = buddy;
        if (buddy != null) {
            buddy.addListener(this);
        }
    }

    public void setBuddyID(String buddyID) {
        this.buddyID = buddyID;
        this.buddy = null;
    }

    public void buddyAdded(VuzeBuddy buddy, int position) {
    }

    public void buddyChanged(VuzeBuddy buddy) {
        VuzeActivitiesManager.triggerEntryChanged(this);
    }

    public void buddyOrderChanged() {
    }

    public void buddyRemoved(VuzeBuddy buddy) {
    }
}

