/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.buddy.chat;

import com.aelitis.azureus.buddy.VuzeBuddy;
import com.aelitis.azureus.buddy.chat.ChatDiscussion;
import com.aelitis.azureus.buddy.chat.ChatListener;
import com.aelitis.azureus.buddy.chat.ChatMessage;
import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.buddy.impl.VuzeBuddyMessageListener;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.security.CryptoHandler;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.security.CryptoManagerKeyListener;
import com.aelitis.azureus.login.NotLoggedInException;
import com.aelitis.azureus.ui.swt.utils.SWTLoginUtils;
import com.aelitis.azureus.util.LoginInfoManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.SystemTime;

public class Chat
implements VuzeBuddyMessageListener {
    Map discussions = new HashMap();
    List listeners = new ArrayList();
    LoginInfoManager loginInfoManager = LoginInfoManager.getInstance();

    public Chat() {
        VuzeBuddyManager.addMessageListener(this);
        CryptoManagerFactory.getSingleton().addKeyListener(new CryptoManagerKeyListener(){

            public void keyChanged(CryptoHandler handler) {
            }

            public void keyLockStatusChanged(CryptoHandler handler) {
                if (handler.isUnlocked()) {
                    new AEThread2("Chat:check", true){

                        public void run() {
                            Chat.this.checkPersistentMessages();
                        }
                    }.start();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPersistentMessages() {
        ArrayList to_check;
        Map map = this.discussions;
        synchronized (map) {
            to_check = new ArrayList(this.discussions.values());
        }
        for (int i = 0; i < to_check.size(); ++i) {
            ChatDiscussion d = (ChatDiscussion)to_check.get(i);
            if (!d.checkPersistentMessages()) continue;
            this.notifyListenersOfChat(d.getBuddy());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBuddy(VuzeBuddy buddy) {
        boolean new_chat = false;
        boolean check_persistent = CryptoManagerFactory.getSingleton().getECCHandler().isUnlocked();
        Map map = this.discussions;
        synchronized (map) {
            ChatDiscussion result = (ChatDiscussion)this.discussions.get(buddy);
            if (result == null) {
                result = new ChatDiscussion(buddy, check_persistent);
                this.discussions.put(buddy, result);
                new_chat = true;
            }
        }
        if (new_chat) {
            this.notifyListenersOfChat(buddy);
        }
    }

    public void messageRecieved(VuzeBuddy buddy, String senderPK, String namespace, long sentAt, Map message) {
        if (namespace.equals("chat")) {
            this.messageReceived(buddy, senderPK, sentAt, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChatDiscussion getChatDiscussionFor(VuzeBuddy buddy) {
        boolean check_persistent = CryptoManagerFactory.getSingleton().getECCHandler().isUnlocked();
        Map map = this.discussions;
        synchronized (map) {
            ChatDiscussion result = (ChatDiscussion)this.discussions.get(buddy);
            if (result == null) {
                result = new ChatDiscussion(buddy, check_persistent);
                this.discussions.put(buddy, result);
            }
            return result;
        }
    }

    public void messageReceived(VuzeBuddy from, String fromPK, long sentAt, Map message) {
        String text = new String((byte[])message.get("text"));
        long originalTimeStamp = sentAt;
        if (text != null) {
            ChatDiscussion discussion = this.getChatDiscussionFor(from);
            ChatMessage localMessage = new ChatMessage(fromPK, originalTimeStamp, SystemTime.getCurrentTime(), from.getDisplayName(), text);
            discussion.addMessage(localMessage);
            this.notifyListenersOfNewMessage(from, localMessage);
        }
    }

    public void sendMessage(final VuzeBuddy to, final String text) {
        SWTLoginUtils.waitForLogin(new SWTLoginUtils.loginWaitListener(){

            public void loginComplete() {
                Chat.this.internalSendMessage(to, text);
            }
        });
    }

    private void internalSendMessage(final VuzeBuddy to, final String text) {
        AEThread2 sender = new AEThread2("message sender", true){

            public void run() {
                try {
                    HashMap<String, Object> message = new HashMap<String, Object>();
                    long timeStamp = SystemTime.getCurrentTime();
                    message.put("timestamp", new Long(timeStamp -= AzureusCoreFactory.getSingleton().getInstanceManager().getClockSkew()));
                    message.put("text", text);
                    to.sendBuddyMessage("chat", message);
                    ChatDiscussion discussion = Chat.this.getChatDiscussionFor(to);
                    ChatMessage localMessage = new ChatMessage(null, timeStamp, timeStamp, Chat.this.loginInfoManager.getUserInfo().displayName, text);
                    discussion.addMessage(localMessage);
                    Chat.this.notifyListenersOfNewMessage(to, localMessage);
                }
                catch (NotLoggedInException notLoggedInException) {
                    // empty catch block
                }
            }
        };
        sender.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListenersOfNewMessage(VuzeBuddy from, ChatMessage message) {
        List list = this.listeners;
        synchronized (list) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ChatListener listener = (ChatListener)this.listeners.get(i);
                listener.newMessage(from, message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListenersOfChat(VuzeBuddy buddy) {
        List list = this.listeners;
        synchronized (list) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ChatListener listener = (ChatListener)this.listeners.get(i);
                listener.updatedChat(buddy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChatListener(ChatListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChatListener(ChatListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }
}

