/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.content;

import com.aelitis.azureus.core.content.AzureusContent;
import com.aelitis.azureus.core.content.AzureusContentDirectory;
import com.aelitis.azureus.core.content.AzureusContentDirectoryManager;
import com.aelitis.azureus.util.ConstantsV3;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

public class AzureusPlatformContentDirectory
implements AzureusContentDirectory {
    private static boolean registered = false;

    public static synchronized void register() {
        if (!registered) {
            registered = true;
            AzureusContentDirectoryManager.registerDirectory(new AzureusPlatformContentDirectory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AzureusContent lookupContent(Map attributes) {
        AzureusPlatformContent azureusPlatformContent;
        byte[] hash = (byte[])attributes.get("btih");
        if (hash == null) {
            return null;
        }
        String url_str = ConstantsV3.URL_PREFIX + "download/" + Base32.encode(hash) + ".torrent";
        ResourceDownloaderFactory rdf = ResourceDownloaderFactoryImpl.getSingleton();
        ResourceDownloader rd = rdf.create(new URL(url_str));
        InputStream is = rd.download();
        try {
            TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(is);
            azureusPlatformContent = new AzureusPlatformContent(new TorrentImpl(torrent));
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        is.close();
        return azureusPlatformContent;
    }

    protected class AzureusPlatformContent
    implements AzureusContent {
        private Torrent torrent;

        protected AzureusPlatformContent(Torrent _torrent) {
            this.torrent = _torrent;
        }

        public Torrent getTorrent() {
            return this.torrent;
        }
    }
}

