/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.nat.impl;

import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTOperationAdapter;
import com.aelitis.azureus.core.dht.DHTOperationListener;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncher;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncherAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportProgressListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportTransferHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDP;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDPContact;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.Formatters;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.Semaphore;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;

public class DHTNATPuncherImpl
implements DHTNATPuncher {
    private static boolean TESTING = false;
    private static boolean TRACE = false;
    private static final int RT_BIND_REQUEST = 0;
    private static final int RT_BIND_REPLY = 1;
    private static final int RT_PUNCH_REQUEST = 2;
    private static final int RT_PUNCH_REPLY = 3;
    private static final int RT_CONNECT_REQUEST = 4;
    private static final int RT_CONNECT_REPLY = 5;
    private static final int RT_TUNNEL_INBOUND = 6;
    private static final int RT_TUNNEL_OUTBOUND = 7;
    private static final int RT_QUERY_REQUEST = 8;
    private static final int RT_QUERY_REPLY = 9;
    private static final int RT_CLOSE_REQUEST = 10;
    private static final int RT_CLOSE_REPLY = 11;
    private static final int RESP_OK = 0;
    private static final int RESP_NOT_OK = 1;
    private static final int RESP_FAILED = 2;
    private static byte[] transfer_handler_key;
    private boolean started;
    private DHTNATPuncherAdapter adapter;
    private DHT dht;
    private DHTLogger logger;
    private PluginInterface plugin_interface;
    private Formatters formatters;
    private UTTimer timer;
    private static final int REPUBLISH_TIME_MIN = 300000;
    private static final int TRANSFER_TIMEOUT = 30000;
    private static final int RENDEZVOUS_LOOKUP_TIMEOUT = 30000;
    private static final int TUNNEL_TIMEOUT = 3000;
    private static final int RENDEZVOUS_SERVER_MAX = 8;
    private static final int RENDEZVOUS_SERVER_TIMEOUT = 300000;
    private static final int RENDEZVOUS_CLIENT_PING_PERIOD = 50000;
    private static final int RENDEZVOUS_PING_FAIL_LIMIT = 4;
    private Monitor server_mon;
    private Map rendezvous_bindings = new HashMap();
    private long last_publish;
    private Monitor pub_mon;
    private boolean publish_in_progress;
    private volatile DHTTransportContact rendezvous_local_contact;
    private volatile DHTTransportContact rendezvous_target;
    private volatile DHTTransportContact last_ok_rendezvous;
    private static final int FAILED_RENDEZVOUS_HISTORY_MAX = 16;
    private Map failed_rendezvous = new LinkedHashMap(16, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 16;
        }
    };
    private boolean rendezvous_thread_running;
    private Map explicit_rendezvous_map = new HashMap();
    private Monitor punch_mon;
    private List oustanding_punches = new ArrayList();
    private DHTTransportContact current_local = null;
    private DHTTransportContact current_target = null;
    private int rendevzous_fail_count = 0;

    public DHTNATPuncherImpl(DHTNATPuncherAdapter _adapter, DHT _dht) {
        this.adapter = _adapter;
        this.dht = _dht;
        this.logger = this.dht.getLogger();
        this.plugin_interface = this.dht.getLogger().getPluginInterface();
        this.formatters = this.plugin_interface.getUtilities().getFormatters();
        this.pub_mon = this.plugin_interface.getUtilities().getMonitor();
        this.server_mon = this.plugin_interface.getUtilities().getMonitor();
        this.punch_mon = this.plugin_interface.getUtilities().getMonitor();
        this.timer = this.plugin_interface.getUtilities().createTimer("DHTNATPuncher:refresher", true);
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        DHTTransport transport = this.dht.getTransport();
        transport.addListener(new DHTTransportListener(){

            public void localContactChanged(DHTTransportContact local_contact) {
                DHTNATPuncherImpl.this.publish(false);
            }

            public void currentAddress(String address) {
            }

            public void reachabilityChanged(boolean reacheable) {
                DHTNATPuncherImpl.this.publish(false);
            }
        });
        transport.registerTransferHandler(transfer_handler_key, new DHTTransportTransferHandler(){

            public String getName() {
                return "NAT Traversal";
            }

            public byte[] handleRead(DHTTransportContact originator, byte[] key) {
                return null;
            }

            public byte[] handleWrite(DHTTransportContact originator, byte[] key, byte[] value) {
                return DHTNATPuncherImpl.this.receiveRequest((DHTTransportUDPContact)originator, value);
            }
        });
        this.timer.addPeriodicEvent(300000L, new UTTimerEventPerformer(){

            public void perform(UTTimerEvent event2) {
                DHTNATPuncherImpl.this.publish(false);
            }
        });
        this.timer.addPeriodicEvent(150000L, new UTTimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(UTTimerEvent event2) {
                long now = DHTNATPuncherImpl.this.plugin_interface.getUtilities().getCurrentSystemTime();
                try {
                    DHTNATPuncherImpl.this.server_mon.enter();
                    Iterator it = DHTNATPuncherImpl.this.rendezvous_bindings.values().iterator();
                    while (it.hasNext()) {
                        Object[] entry = (Object[])it.next();
                        long time = (Long)entry[1];
                        boolean removed = false;
                        if (time > now) {
                            it.remove();
                            removed = true;
                        } else if (now - time > 300000L) {
                            it.remove();
                            removed = true;
                        }
                        if (!removed) continue;
                        DHTNATPuncherImpl.this.log("Rendezvous " + ((DHTTransportContact)entry[0]).getString() + " removed due to inactivity");
                    }
                }
                finally {
                    DHTNATPuncherImpl.this.server_mon.exit();
                }
            }
        });
        this.publish(false);
    }

    public boolean active() {
        return this.rendezvous_local_contact != null;
    }

    public boolean operational() {
        DHTTransportContact ok = this.last_ok_rendezvous;
        return ok != null && ok == this.rendezvous_target;
    }

    protected void publish(boolean force) {
        long now = this.plugin_interface.getUtilities().getCurrentSystemTime();
        if (now < this.last_publish && !force) {
            this.last_publish = now;
        } else if (force || now - this.last_publish >= 300000L) {
            this.last_publish = now;
            this.plugin_interface.getUtilities().createThread("DHTNATPuncher:publisher", new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        DHTNATPuncherImpl.this.pub_mon.enter();
                        if (DHTNATPuncherImpl.this.publish_in_progress) {
                            return;
                        }
                        DHTNATPuncherImpl.this.publish_in_progress = true;
                    }
                    finally {
                        DHTNATPuncherImpl.this.pub_mon.exit();
                    }
                    try {
                        DHTNATPuncherImpl.this.publishSupport();
                    }
                    finally {
                        try {
                            DHTNATPuncherImpl.this.pub_mon.enter();
                            DHTNATPuncherImpl.this.publish_in_progress = false;
                        }
                        finally {
                            DHTNATPuncherImpl.this.pub_mon.exit();
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishSupport() {
        DHTTransport transport = this.dht.getTransport();
        if (TESTING || !transport.isReachable()) {
            int i;
            boolean force;
            DHTTransportContact local_contact = transport.getLocalContact();
            boolean bl = force = this.rendezvous_target != null && this.failed_rendezvous.containsKey(this.rendezvous_target.getAddress());
            if (this.rendezvous_local_contact != null && !force && local_contact.getAddress().equals(this.rendezvous_local_contact.getAddress())) {
                return;
            }
            DHTTransportContact explicit = (DHTTransportContact)this.explicit_rendezvous_map.get(local_contact.getAddress());
            if (explicit != null) {
                try {
                    this.pub_mon.enter();
                    this.rendezvous_local_contact = local_contact;
                    this.rendezvous_target = explicit;
                    this.runRendezvous();
                }
                finally {
                    this.pub_mon.exit();
                }
            }
            final DHTTransportContact[] new_rendezvous_target = new DHTTransportContact[]{null};
            DHTTransportContact[] reachables = this.dht.getTransport().getReachableContacts();
            int reachables_tried = 0;
            int reachables_skipped = 0;
            final Semaphore sem = this.plugin_interface.getUtilities().getSemaphore();
            for (i = 0; i < reachables.length; ++i) {
                DHTTransportContact contact = reachables[i];
                try {
                    this.pub_mon.enter();
                    if (new_rendezvous_target[0] != null) break;
                    if (this.failed_rendezvous.containsKey(contact.getAddress())) {
                        ++reachables_skipped;
                        sem.release();
                        continue;
                    }
                }
                finally {
                    this.pub_mon.exit();
                }
                if (i > 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                ++reachables_tried;
                contact.sendPing(new DHTTransportReplyHandlerAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void pingReply(DHTTransportContact ok_contact) {
                        DHTNATPuncherImpl.this.trace("Punch:" + ok_contact.getString() + " OK");
                        try {
                            DHTNATPuncherImpl.this.pub_mon.enter();
                            if (new_rendezvous_target[0] == null) {
                                new_rendezvous_target[0] = ok_contact;
                            }
                        }
                        finally {
                            DHTNATPuncherImpl.this.pub_mon.exit();
                            sem.release();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void failed(DHTTransportContact failed_contact, Throwable e) {
                        try {
                            DHTNATPuncherImpl.this.trace("Punch:" + failed_contact.getString() + " Failed");
                        }
                        finally {
                            sem.release();
                        }
                    }
                });
            }
            for (i = 0; i < reachables.length; ++i) {
                sem.reserve();
                try {
                    this.pub_mon.enter();
                    if (new_rendezvous_target[0] == null) continue;
                    this.rendezvous_target = new_rendezvous_target[0];
                    this.rendezvous_local_contact = local_contact;
                    this.log("Rendezvous found: " + this.rendezvous_local_contact.getString() + " -> " + this.rendezvous_target.getString());
                    this.runRendezvous();
                    break;
                }
                finally {
                    this.pub_mon.exit();
                }
            }
            if (new_rendezvous_target[0] == null) {
                this.log("No rendezvous found: candidates=" + reachables.length + ",tried=" + reachables_tried + ",skipped=" + reachables_skipped);
                try {
                    this.pub_mon.enter();
                    this.rendezvous_local_contact = null;
                    this.rendezvous_target = null;
                }
                finally {
                    this.pub_mon.exit();
                }
            }
        } else {
            try {
                this.pub_mon.enter();
                this.rendezvous_local_contact = null;
                this.rendezvous_target = null;
            }
            finally {
                this.pub_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runRendezvous() {
        try {
            this.pub_mon.enter();
            if (!this.rendezvous_thread_running) {
                this.rendezvous_thread_running = true;
                this.plugin_interface.getUtilities().createThread("DHTNatPuncher:rendevzous", new Runnable(){

                    public void run() {
                        DHTNATPuncherImpl.this.runRendezvousSupport();
                    }
                });
            }
        }
        finally {
            this.pub_mon.exit();
        }
    }

    protected void runRendezvousSupport() {
        SimpleTimer.addPeriodicEvent("DHTNAT:cp", 50000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent ev) {
                try {
                    DHTTransportContact latest_target;
                    DHTTransportContact latest_local;
                    try {
                        DHTNATPuncherImpl.this.pub_mon.enter();
                        latest_local = DHTNATPuncherImpl.this.rendezvous_local_contact;
                        latest_target = DHTNATPuncherImpl.this.rendezvous_target;
                    }
                    finally {
                        DHTNATPuncherImpl.this.pub_mon.exit();
                    }
                    if (DHTNATPuncherImpl.this.current_local != null || latest_local != null) {
                        if (DHTNATPuncherImpl.this.current_local != latest_local) {
                            if (DHTNATPuncherImpl.this.current_local != null) {
                                DHTNATPuncherImpl.this.log("Removing publish for " + DHTNATPuncherImpl.this.current_local.getString() + " -> " + DHTNATPuncherImpl.this.current_target.getString());
                                DHTNATPuncherImpl.this.dht.remove(DHTNATPuncherImpl.this.getPublishKey(DHTNATPuncherImpl.this.current_local), "DHTNatPuncher: removal of publish", new DHTOperationListener(){

                                    public void searching(DHTTransportContact contact, int level, int active_searches) {
                                    }

                                    public void found(DHTTransportContact contact) {
                                    }

                                    public void diversified(String desc) {
                                    }

                                    public void read(DHTTransportContact contact, DHTTransportValue value) {
                                    }

                                    public void wrote(DHTTransportContact contact, DHTTransportValue value) {
                                    }

                                    public void complete(boolean timeout) {
                                    }
                                });
                            }
                            if (latest_local != null) {
                                DHTNATPuncherImpl.this.log("Adding publish for " + latest_local.getString() + " -> " + latest_target.getString());
                                DHTNATPuncherImpl.this.rendevzous_fail_count = 2;
                                DHTNATPuncherImpl.this.dht.put(DHTNATPuncherImpl.this.getPublishKey(latest_local), "NAT Traversal: rendezvous publish", DHTNATPuncherImpl.this.encodePublishValue(latest_target), (byte)0, new DHTOperationListener(){

                                    public void searching(DHTTransportContact contact, int level, int active_searches) {
                                    }

                                    public void found(DHTTransportContact contact) {
                                    }

                                    public void diversified(String desc) {
                                    }

                                    public void read(DHTTransportContact contact, DHTTransportValue value) {
                                    }

                                    public void wrote(DHTTransportContact contact, DHTTransportValue value) {
                                    }

                                    public void complete(boolean timeout) {
                                    }
                                });
                            }
                        } else if (DHTNATPuncherImpl.this.current_target != latest_target) {
                            DHTNATPuncherImpl.this.log("Updating publish for " + latest_local.getString() + " -> " + latest_target.getString());
                            DHTNATPuncherImpl.this.rendevzous_fail_count = 2;
                            DHTNATPuncherImpl.this.dht.put(DHTNATPuncherImpl.this.getPublishKey(latest_local), "DHTNatPuncher: update publish", DHTNATPuncherImpl.this.encodePublishValue(latest_target), (byte)0, new DHTOperationListener(){

                                public void searching(DHTTransportContact contact, int level, int active_searches) {
                                }

                                public void found(DHTTransportContact contact) {
                                }

                                public void diversified(String desc) {
                                }

                                public void read(DHTTransportContact contact, DHTTransportValue value) {
                                }

                                public void wrote(DHTTransportContact contact, DHTTransportValue value) {
                                }

                                public void complete(boolean timeout) {
                                }
                            });
                        }
                    }
                    DHTNATPuncherImpl.this.current_local = latest_local;
                    DHTNATPuncherImpl.this.current_target = latest_target;
                    if (DHTNATPuncherImpl.this.current_target != null) {
                        int bind_result = DHTNATPuncherImpl.this.sendBind(DHTNATPuncherImpl.this.current_target);
                        if (bind_result == 0) {
                            DHTNATPuncherImpl.this.trace("Rendezvous:" + DHTNATPuncherImpl.this.current_target.getString() + " OK");
                            DHTNATPuncherImpl.this.rendevzous_fail_count = 0;
                            if (DHTNATPuncherImpl.this.last_ok_rendezvous != DHTNATPuncherImpl.this.current_target) {
                                DHTNATPuncherImpl.this.last_ok_rendezvous = DHTNATPuncherImpl.this.current_target;
                                DHTNATPuncherImpl.this.log("Rendezvous " + latest_target.getString() + " operational");
                            }
                        } else {
                            if (bind_result == 1) {
                                DHTNATPuncherImpl.this.rendevzous_fail_count = 4;
                            } else {
                                DHTNATPuncherImpl.this.rendevzous_fail_count++;
                            }
                            if (DHTNATPuncherImpl.this.rendevzous_fail_count == 4) {
                                DHTNATPuncherImpl.this.rendezvousFailed(DHTNATPuncherImpl.this.current_target, false);
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    DHTNATPuncherImpl.this.log(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rendezvousFailed(DHTTransportContact current_target, boolean tidy) {
        this.log("Rendezvous " + (tidy ? "closed" : "failed") + ": " + current_target.getString());
        try {
            this.pub_mon.enter();
            this.failed_rendezvous.put(current_target.getAddress(), "");
        }
        finally {
            this.pub_mon.exit();
        }
        this.publish(true);
    }

    protected byte[] sendRequest(DHTTransportContact target, byte[] data, int timeout) {
        try {
            return this.dht.getTransport().writeReadTransfer(new DHTTransportProgressListener(){

                public void reportSize(long size) {
                }

                public void reportActivity(String str) {
                }

                public void reportCompleteness(int percent) {
                }
            }, target, transfer_handler_key, data, timeout);
        }
        catch (DHTTransportException e) {
            return null;
        }
    }

    protected byte[] receiveRequest(DHTTransportUDPContact originator, byte[] data) {
        try {
            Map res = this.receiveRequest(originator, this.formatters.bDecode(data));
            if (res == null) {
                return null;
            }
            return this.formatters.bEncode(res);
        }
        catch (Throwable e) {
            this.log(e);
            return null;
        }
    }

    protected Map sendRequest(DHTTransportContact target, Map data, int timeout) {
        try {
            byte[] res = this.sendRequest(target, this.formatters.bEncode(data), timeout);
            if (res == null) {
                return null;
            }
            return this.formatters.bDecode(res);
        }
        catch (Throwable e) {
            this.log(e);
            return null;
        }
    }

    protected Map receiveRequest(DHTTransportUDPContact originator, Map data) {
        int type = ((Long)data.get("type")).intValue();
        HashMap<String, Long> response = new HashMap<String, Long>();
        switch (type) {
            case 0: {
                response.put("type", new Long(1L));
                this.receiveBind(originator, data, response);
                break;
            }
            case 10: {
                response.put("type", new Long(11L));
                this.receiveClose(originator, data, response);
                break;
            }
            case 8: {
                response.put("type", new Long(9L));
                this.receiveQuery(originator, data, response);
                break;
            }
            case 2: {
                response.put("type", new Long(3L));
                this.receivePunch(originator, data, response);
                break;
            }
            case 4: {
                response.put("type", new Long(5L));
                this.receiveConnect(originator, data, response);
                break;
            }
            case 6: {
                this.receiveTunnelInbound(originator, data);
                response = null;
                break;
            }
            case 7: {
                this.receiveTunnelOutbound(originator, data);
                response = null;
                break;
            }
            default: {
                response = null;
            }
        }
        return response;
    }

    protected boolean sendTunnelMessage(DHTTransportContact target, Map data) {
        try {
            return this.sendTunnelMessage(target, this.formatters.bEncode(data));
        }
        catch (Throwable e) {
            this.log(e);
            return false;
        }
    }

    protected boolean sendTunnelMessage(DHTTransportContact target, byte[] data) {
        try {
            this.dht.getTransport().writeTransfer(new DHTTransportProgressListener(){

                public void reportSize(long size) {
                }

                public void reportActivity(String str) {
                }

                public void reportCompleteness(int percent) {
                }
            }, target, transfer_handler_key, new byte[0], data, 3000L);
            return true;
        }
        catch (DHTTransportException e) {
            return false;
        }
    }

    protected int sendBind(DHTTransportContact target) {
        try {
            HashMap<String, Long> request2 = new HashMap<String, Long>();
            request2.put("type", new Long(0L));
            Map response = this.sendRequest(target, request2, 30000);
            if (response == null) {
                return 2;
            }
            if (((Long)response.get("type")).intValue() == 1) {
                int result = ((Long)response.get("ok")).intValue();
                this.trace("received bind reply: " + (result == 0 ? "failed" : "ok"));
                if (result == 1) {
                    return 0;
                }
            }
            return 1;
        }
        catch (Throwable e) {
            this.log(e);
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveBind(DHTTransportUDPContact originator, Map request2, Map response) {
        this.trace("received bind request");
        boolean ok = true;
        boolean log = true;
        try {
            this.server_mon.enter();
            Object[] entry = (Object[])this.rendezvous_bindings.get(originator.getAddress().toString());
            if (entry == null) {
                if (this.rendezvous_bindings.size() == 8) {
                    ok = false;
                }
            } else {
                log = false;
            }
            if (ok) {
                long now = this.plugin_interface.getUtilities().getCurrentSystemTime();
                this.rendezvous_bindings.put(originator.getAddress().toString(), new Object[]{originator, new Long(now)});
                response.put("port", new Long(originator.getAddress().getPort()));
            }
        }
        finally {
            this.server_mon.exit();
        }
        if (log) {
            this.log("Rendezvous request from " + originator.getString() + " " + (ok ? "accepted" : "denied"));
        }
        response.put("ok", new Long(ok ? 1L : 0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.server_mon.enter();
            for (Object[] entry : this.rendezvous_bindings.values()) {
                final DHTTransportUDPContact contact = (DHTTransportUDPContact)entry[0];
                new AEThread2("DHTNATPuncher:destroy", true){

                    public void run() {
                        DHTNATPuncherImpl.this.sendClose(contact);
                    }
                }.start();
            }
        }
        catch (Throwable e) {
            this.log(e);
        }
        finally {
            this.server_mon.exit();
        }
    }

    protected int sendClose(DHTTransportContact target) {
        try {
            HashMap<String, Long> request2 = new HashMap<String, Long>();
            request2.put("type", new Long(10L));
            Map response = this.sendRequest(target, request2, 30000);
            if (response == null) {
                return 2;
            }
            if (((Long)response.get("type")).intValue() == 11) {
                int result = ((Long)response.get("ok")).intValue();
                this.trace("received close reply: " + (result == 0 ? "failed" : "ok"));
                if (result == 1) {
                    return 0;
                }
            }
            return 1;
        }
        catch (Throwable e) {
            this.log(e);
            return 2;
        }
    }

    protected void receiveClose(DHTTransportUDPContact originator, Map request2, Map response) {
        this.trace("received close request");
        final DHTTransportContact current_target = this.rendezvous_target;
        if (current_target != null && Arrays.equals(current_target.getID(), originator.getID())) {
            new AEThread2("DHTNATPuncher:close", true){

                public void run() {
                    DHTNATPuncherImpl.this.rendezvousFailed(current_target, true);
                }
            }.start();
        }
        response.put("ok", new Long(1L));
    }

    private int sendQuery(DHTTransportContact target) {
        try {
            HashMap<String, Long> request2 = new HashMap<String, Long>();
            request2.put("type", new Long(8L));
            Map response = this.sendRequest(target, request2, 30000);
            if (response == null) {
                return 2;
            }
            if (((Long)response.get("type")).intValue() == 9) {
                int result = ((Long)response.get("ok")).intValue();
                this.trace("received query reply: " + (result == 0 ? "failed" : "ok"));
                if (result == 1) {
                    return 0;
                }
            }
            return 1;
        }
        catch (Throwable e) {
            this.log(e);
            return 2;
        }
    }

    protected void receiveQuery(DHTTransportUDPContact originator, Map request2, Map response) {
        this.trace("received query request");
        InetSocketAddress address = originator.getTransportAddress();
        response.put("ip", address.getAddress().getHostAddress().getBytes());
        response.put("port", new Long(address.getPort()));
        response.put("ok", new Long(1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map sendPunch(DHTTransportContact rendezvous, final DHTTransportUDPContact target, Map originator_client_data, boolean no_tunnel) {
        AESemaphore wait_sem = new AESemaphore("DHTNatPuncher::sendPunch");
        Object[] wait_data = new Object[]{target, wait_sem, new Integer(0)};
        try {
            Map response;
            try {
                this.punch_mon.enter();
                this.oustanding_punches.add(wait_data);
            }
            finally {
                this.punch_mon.exit();
            }
            HashMap<String, Object> request2 = new HashMap<String, Object>();
            request2.put("type", new Long(2L));
            request2.put("target", target.getAddress().toString().getBytes());
            if (originator_client_data != null) {
                if (no_tunnel) {
                    originator_client_data.put("_notunnel", new Long(1L));
                }
                request2.put("client_data", originator_client_data);
            }
            if ((response = this.sendRequest(rendezvous, request2, no_tunnel ? 60000 : 30000)) == null) {
                Map map = null;
                return map;
            }
            if (((Long)response.get("type")).intValue() == 3) {
                int result = ((Long)response.get("ok")).intValue();
                this.trace("received " + (no_tunnel ? "message" : "punch") + " reply: " + (result == 0 ? "failed" : "ok"));
                if (result == 1) {
                    HashMap target_client_data;
                    InetSocketAddress existing_address;
                    int transport_port;
                    Long indirect_port = (Long)response.get("port");
                    if (indirect_port != null && (transport_port = indirect_port.intValue()) != 0 && transport_port != (existing_address = target.getTransportAddress()).getPort()) {
                        target.setTransportAddress(new InetSocketAddress(existing_address.getAddress(), transport_port));
                    }
                    if (!no_tunnel) {
                        UTTimerEvent event2 = this.timer.addPeriodicEvent(3000L, new UTTimerEventPerformer(){
                            private int pings = 1;

                            public void perform(UTTimerEvent event2) {
                                if (this.pings > 3) {
                                    event2.cancel();
                                    return;
                                }
                                ++this.pings;
                                if (DHTNATPuncherImpl.this.sendTunnelOutbound(target)) {
                                    event2.cancel();
                                }
                            }
                        });
                        if (this.sendTunnelOutbound(target)) {
                            event2.cancel();
                        }
                        if (wait_sem.reserve(10000L)) {
                            event2.cancel();
                        }
                    }
                    transport_port = 0;
                    try {
                        this.punch_mon.enter();
                        transport_port = (Integer)wait_data[2];
                    }
                    finally {
                        this.punch_mon.exit();
                    }
                    if (transport_port != 0 && transport_port != (existing_address = target.getTransportAddress()).getPort()) {
                        target.setTransportAddress(new InetSocketAddress(existing_address.getAddress(), transport_port));
                    }
                    if ((target_client_data = (HashMap)response.get("client_data")) == null) {
                        target_client_data = new HashMap();
                    }
                    HashMap hashMap = target_client_data;
                    return hashMap;
                }
            }
            Map map = null;
            return map;
        }
        catch (Throwable e) {
            this.log(e);
            Map map = null;
            return map;
        }
        finally {
            try {
                this.punch_mon.enter();
                this.oustanding_punches.remove(wait_data);
            }
            finally {
                this.punch_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receivePunch(DHTTransportUDPContact originator, Map request2, Map response) {
        DHTTransportUDPContact target;
        Map target_client_data;
        Object[] entry;
        this.trace("received punch request");
        boolean ok = false;
        String target_str = new String((byte[])request2.get("target"));
        try {
            this.server_mon.enter();
            entry = (Object[])this.rendezvous_bindings.get(target_str);
        }
        finally {
            this.server_mon.exit();
        }
        if (entry != null && (target_client_data = this.sendConnect(target = (DHTTransportUDPContact)entry[0], originator, (Map)request2.get("client_data"))) != null) {
            response.put("client_data", target_client_data);
            response.put("port", new Long(target.getTransportAddress().getPort()));
            ok = true;
        }
        this.log("Rendezvous punch request from " + originator.getString() + " to " + target_str + " " + (ok ? "initiated" : "failed"));
        response.put("ok", new Long(ok ? 1L : 0L));
    }

    protected Map sendConnect(DHTTransportContact target, DHTTransportContact originator, Map originator_client_data) {
        try {
            Map response;
            HashMap<String, Object> request2 = new HashMap<String, Object>();
            request2.put("type", new Long(4L));
            request2.put("origin", this.encodeContact(originator));
            request2.put("port", new Long(((DHTTransportUDPContact)originator).getTransportAddress().getPort()));
            if (originator_client_data != null) {
                request2.put("client_data", originator_client_data);
            }
            if ((response = this.sendRequest(target, request2, 30000)) == null) {
                return null;
            }
            if (((Long)response.get("type")).intValue() == 5) {
                int result = ((Long)response.get("ok")).intValue();
                this.trace("received connect reply: " + (result == 0 ? "failed" : "ok"));
                if (result == 1) {
                    HashMap target_client_data = (HashMap)response.get("client_data");
                    if (target_client_data == null) {
                        target_client_data = new HashMap();
                    }
                    return target_client_data;
                }
            }
            return null;
        }
        catch (Throwable e) {
            this.log(e);
            return null;
        }
    }

    protected void receiveConnect(DHTTransportContact rendezvous, Map request2, Map response) {
        this.trace("received connect request");
        boolean ok = false;
        DHTTransportContact rt = this.rendezvous_target;
        if (rt != null && rt.getAddress().equals(rendezvous.getAddress())) {
            final DHTTransportUDPContact target = this.decodeContact((byte[])request2.get("origin"));
            if (target != null) {
                InetSocketAddress existing_address;
                int transport_port = 0;
                Long indirect_port = (Long)request2.get("port");
                if (indirect_port != null) {
                    transport_port = indirect_port.intValue();
                }
                if (transport_port != 0 && transport_port != (existing_address = target.getTransportAddress()).getPort()) {
                    target.setTransportAddress(new InetSocketAddress(existing_address.getAddress(), transport_port));
                }
                HashMap originator_client_data = (HashMap)request2.get("client_data");
                boolean no_tunnel = false;
                if (originator_client_data == null) {
                    originator_client_data = new HashMap();
                } else {
                    boolean bl = no_tunnel = originator_client_data.get("_notunnel") != null;
                }
                if (no_tunnel) {
                    this.log("Received message from " + target.getString());
                } else {
                    this.log("Received connect request from " + target.getString());
                    UTTimerEvent event2 = this.timer.addPeriodicEvent(3000L, new UTTimerEventPerformer(){
                        private int pings = 1;

                        public void perform(UTTimerEvent ev) {
                            if (this.pings > 3) {
                                ev.cancel();
                                return;
                            }
                            ++this.pings;
                            if (DHTNATPuncherImpl.this.sendTunnelInbound(target)) {
                                ev.cancel();
                            }
                        }
                    });
                    if (this.sendTunnelInbound(target)) {
                        event2.cancel();
                    }
                }
                HashMap client_data = this.adapter.getClientData(target.getTransportAddress(), originator_client_data);
                if (client_data == null) {
                    client_data = new HashMap();
                }
                response.put("client_data", client_data);
                ok = true;
            } else {
                this.log("Connect request: failed to decode target");
            }
        } else {
            this.log("Connect request from invalid rendezvous: " + rendezvous.getString());
        }
        response.put("ok", new Long(ok ? 1L : 0L));
    }

    protected boolean sendTunnelInbound(DHTTransportContact target) {
        this.log("Sending tunnel inbound message to " + target.getString());
        try {
            HashMap<String, Long> message = new HashMap<String, Long>();
            message.put("type", new Long(6L));
            return this.sendTunnelMessage(target, message);
        }
        catch (Throwable e) {
            this.log(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveTunnelInbound(DHTTransportUDPContact originator, Map data) {
        this.log("Received tunnel inbound message from " + originator.getString());
        try {
            this.punch_mon.enter();
            for (int i = 0; i < this.oustanding_punches.size(); ++i) {
                Object[] wait_data = (Object[])this.oustanding_punches.get(i);
                DHTTransportContact wait_contact = (DHTTransportContact)wait_data[0];
                if (!originator.getAddress().getAddress().equals(wait_contact.getAddress().getAddress())) continue;
                wait_data[2] = new Integer(originator.getTransportAddress().getPort());
                ((AESemaphore)wait_data[1]).release();
            }
        }
        finally {
            this.punch_mon.exit();
        }
    }

    protected boolean sendTunnelOutbound(DHTTransportContact target) {
        this.log("Sending tunnel outbound message to " + target.getString());
        try {
            HashMap<String, Long> message = new HashMap<String, Long>();
            message.put("type", new Long(7L));
            return this.sendTunnelMessage(target, message);
        }
        catch (Throwable e) {
            this.log(e);
            return false;
        }
    }

    protected void receiveTunnelOutbound(DHTTransportContact originator, Map data) {
        this.log("Received tunnel outbound message from " + originator.getString());
    }

    public Map punch(String reason, InetSocketAddress[] target, DHTTransportContact[] rendezvous_used, Map originator_client_data) {
        try {
            DHTTransportUDP transport = (DHTTransportUDP)this.dht.getTransport();
            DHTTransportUDPContact contact = transport.importContact(target[0], transport.getProtocolVersion());
            Map result = this.punch(reason, contact, rendezvous_used, originator_client_data);
            target[0] = contact.getTransportAddress();
            return result;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public Map punch(String reason, DHTTransportContact _target, DHTTransportContact[] rendezvous_used, Map originator_client_data) {
        DHTTransportUDPContact target = (DHTTransportUDPContact)_target;
        try {
            DHTTransportContact rendezvous = this.getRendezvous(reason, target);
            if (rendezvous_used != null && rendezvous_used.length > 0) {
                rendezvous_used[0] = rendezvous;
            }
            if (rendezvous == null) {
                return null;
            }
            Map target_client_data = this.sendPunch(rendezvous, target, originator_client_data, false);
            if (target_client_data != null) {
                this.log("    punch to " + target.getString() + " succeeded");
                return target_client_data;
            }
        }
        catch (Throwable e) {
            this.log(e);
        }
        this.log("    punch to " + target.getString() + " failed");
        return null;
    }

    public Map sendMessage(InetSocketAddress rendezvous, InetSocketAddress target, Map message) {
        try {
            DHTTransportUDP transport = (DHTTransportUDP)this.dht.getTransport();
            DHTTransportUDPContact rend_contact = transport.importContact(rendezvous, transport.getProtocolVersion());
            DHTTransportUDPContact target_contact = transport.importContact(target, transport.getProtocolVersion());
            Map result = this.sendPunch(rend_contact, target_contact, message, true);
            return result;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public void setRendezvous(DHTTransportContact target, DHTTransportContact rendezvous) {
        this.explicit_rendezvous_map.put(target.getAddress(), rendezvous);
        if (target.getAddress().equals(this.dht.getTransport().getLocalContact().getAddress())) {
            this.publish(true);
        }
    }

    protected DHTTransportContact getRendezvous(String reason, DHTTransportContact target) {
        DHTTransportContact explicit = (DHTTransportContact)this.explicit_rendezvous_map.get(target.getAddress());
        if (explicit != null) {
            return explicit;
        }
        byte[] key = this.getPublishKey(target);
        final DHTTransportValue[] result_value = new DHTTransportValue[]{null};
        final Semaphore sem = this.plugin_interface.getUtilities().getSemaphore();
        this.dht.get(key, reason + ": lookup for '" + target.getString() + "'", (byte)0, 1, 30000L, false, true, new DHTOperationAdapter(){

            public void read(DHTTransportContact contact, DHTTransportValue value) {
                result_value[0] = value;
                sem.release();
            }

            public void complete(boolean timeout) {
                sem.release();
            }
        });
        sem.reserve();
        DHTTransportContact result = null;
        if (result_value[0] != null) {
            byte[] bytes = result_value[0].getValue();
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                DataInputStream dis = new DataInputStream(bais);
                byte version = dis.readByte();
                if (version != 0) {
                    throw new Exception("Unsupported rendezvous version '" + version + "'");
                }
                result = this.dht.getTransport().importContact(dis);
            }
            catch (Throwable e) {
                this.log(e);
            }
        }
        this.log("Lookup of rendezvous for " + target.getString() + " -> " + (result == null ? "None" : result.getString()));
        return result;
    }

    protected byte[] getPublishKey(DHTTransportContact contact) {
        byte[] id = contact.getID();
        byte[] suffix = ":DHTNATPuncher".getBytes();
        byte[] res = new byte[id.length + suffix.length];
        System.arraycopy(id, 0, res, 0, id.length);
        System.arraycopy(suffix, 0, res, id.length, suffix.length);
        return res;
    }

    protected byte[] encodePublishValue(DHTTransportContact contact) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeByte(0);
            contact.exportContact(dos);
            dos.close();
            return baos.toByteArray();
        }
        catch (Throwable e) {
            this.log(e);
            return new byte[0];
        }
    }

    protected byte[] encodeContact(DHTTransportContact contact) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            contact.exportContact(dos);
            dos.close();
            return baos.toByteArray();
        }
        catch (Throwable e) {
            this.log(e);
            return null;
        }
    }

    protected DHTTransportUDPContact decodeContact(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStream dis = new DataInputStream(bais);
            return (DHTTransportUDPContact)this.dht.getTransport().importContact(dis);
        }
        catch (Throwable e) {
            this.log(e);
            return null;
        }
    }

    protected void log(String str) {
        if (TRACE) {
            System.out.println(str);
        }
        this.logger.log("NATPuncher: " + str);
    }

    protected void log(Throwable e) {
        if (TRACE) {
            e.printStackTrace();
        }
        this.logger.log("NATPuncher: error occurred");
        this.logger.log(e);
    }

    protected void trace(String str) {
        if (TRACE) {
            System.out.println(str);
        }
    }

    static {
        if (TESTING) {
            System.out.println("**** DHTNATPuncher test on ****");
        }
        if (TRACE) {
            System.out.println("**** DHTNATPuncher trace on ****");
        }
        transfer_handler_key = new SHA1Simple().calculateHash("Aelitis:NATPuncher:TransferHandlerKey".getBytes());
    }
}

