/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.instancemanager.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.instancemanager.impl.AZInstanceImpl;
import com.aelitis.azureus.core.instancemanager.impl.AZInstanceManagerImpl;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginListener;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;

public class AZMyInstanceImpl
extends AZInstanceImpl {
    public static final long FORCE_READ_EXT_MIN = 28800000L;
    public static final long UPNP_READ_MIN = 300000L;
    private AzureusCore core;
    private AZInstanceManagerImpl manager;
    private String id;
    private InetAddress internal_address;
    private int tcp_port;
    private int udp_port;
    private int udp_non_data_port;
    private long last_upnp_read;
    private InetAddress dht_address;
    private long dht_address_time;
    private long last_force_read_ext;
    private InetAddress last_external_address;

    protected AZMyInstanceImpl(AzureusCore _core, AZInstanceManagerImpl _manager) {
        this.core = _core;
        this.manager = _manager;
        this.id = COConfigurationManager.getStringParameter("ID", "");
        if (this.id.length() == 0) {
            this.id = "" + SystemTime.getCurrentTime();
        }
        this.id = ByteFormatter.encodeString(new SHA1Simple().calculateHash(this.id.getBytes()));
        COConfigurationManager.addListener(new COConfigurationListener(){

            public void configurationSaved() {
                AZMyInstanceImpl.this.readConfig(false);
            }
        });
        this.readConfig(true);
        this.core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public void started(AzureusCore core) {
                core.removeLifecycleListener(this);
                PluginInterface dht_pi = core.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
                DHTPlugin dht = null;
                if (dht_pi != null && (dht = (DHTPlugin)dht_pi.getPlugin()) != null) {
                    dht.addListener(new DHTPluginListener(){

                        public void localAddressChanged(DHTPluginContact local_contact) {
                            InetAddress latest_dht_address = local_contact.getAddress().getAddress();
                            if (AZMyInstanceImpl.this.sameFamily(AZMyInstanceImpl.this.internal_address, latest_dht_address)) {
                                AZMyInstanceImpl.this.dht_address = latest_dht_address;
                                AZMyInstanceImpl.this.dht_address_time = SystemTime.getCurrentTime();
                                AZMyInstanceImpl.this.manager.informChanged(AZMyInstanceImpl.this);
                            }
                        }
                    });
                }
            }
        });
    }

    protected void readConfig(boolean first_time) {
        InetAddress new_internal_address = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
        if (new_internal_address == null) {
            try {
                new_internal_address = InetAddress.getByName("0.0.0.0");
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        int new_tcp_port = TCPNetworkManager.getSingleton().getTCPListeningPortNumber();
        int new_udp_port = UDPNetworkManager.getSingleton().getUDPListeningPortNumber();
        int new_udp_non_data_port = UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber();
        boolean same = true;
        if (!first_time) {
            same = this.internal_address.equals(new_internal_address) && this.tcp_port == new_tcp_port && this.udp_port == new_udp_port && this.udp_non_data_port == new_udp_non_data_port;
        }
        this.internal_address = new_internal_address;
        this.tcp_port = new_tcp_port;
        this.udp_port = new_udp_port;
        this.udp_non_data_port = new_udp_non_data_port;
        if (!same) {
            this.manager.informChanged(this);
        }
    }

    protected InetAddress readExternalAddress() {
        boolean ok_to_try_ext;
        long now;
        InetAddress external_address;
        block27: {
            String str_address;
            long cache_time;
            external_address = null;
            if (this.manager.isClosing()) {
                external_address = this.last_external_address;
                if (external_address == null) {
                    try {
                        external_address = InetAddress.getByName("127.0.0.1");
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                return external_address;
            }
            PluginInterface dht_pi = this.core.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            DHTPlugin dht = null;
            if (dht_pi != null) {
                dht = (DHTPlugin)dht_pi.getPlugin();
            }
            if (this.dht_address != null && this.dht_address_time <= SystemTime.getCurrentTime() && (cache_time = VersionCheckClient.getSingleton().getCacheTime(false)) <= this.dht_address_time) {
                external_address = this.dht_address;
            }
            if (external_address == null && (dht == null || dht.getStatus() != 3) && (str_address = VersionCheckClient.getSingleton().getExternalIpAddress(true, false)) != null) {
                try {
                    external_address = InetAddress.getByName(str_address);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            if (external_address == null && dht != null) {
                try {
                    InetAddress latest_dht_address = dht.getLocalAddress().getAddress().getAddress();
                    if (this.sameFamily(this.internal_address, latest_dht_address)) {
                        external_address = latest_dht_address;
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (this.last_force_read_ext > (now = SystemTime.getCurrentTime())) {
                this.last_force_read_ext = now;
            }
            boolean bl = ok_to_try_ext = now - this.last_force_read_ext > 28800000L;
            if (external_address == null && this.last_external_address != null) {
                if (this.last_upnp_read > now) {
                    this.last_upnp_read = now;
                }
                if (now - this.last_upnp_read > 300000L || ok_to_try_ext) {
                    this.last_upnp_read = now;
                    try {
                        PluginInterface upnp_pi = this.core.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
                        if (upnp_pi == null) break block27;
                        UPnPPlugin upnp = (UPnPPlugin)upnp_pi.getPlugin();
                        String[] addresses = upnp.getExternalIPAddresses();
                        for (int i = 0; i < addresses.length; ++i) {
                            if (!addresses[i].equals(this.last_external_address.getHostAddress())) continue;
                            external_address = this.last_external_address;
                            break;
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        }
        if (external_address == null && ok_to_try_ext) {
            this.last_force_read_ext = now;
            external_address = this.core.getPluginManager().getDefaultPluginInterface().getUtilities().getPublicAddress();
        }
        if (external_address == null) {
            if (this.last_external_address != null) {
                external_address = this.last_external_address;
            } else {
                try {
                    external_address = InetAddress.getByName("127.0.0.1");
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        } else {
            this.last_external_address = external_address;
        }
        return external_address;
    }

    protected boolean sameFamily(InetAddress a1, InetAddress a2) {
        return a1 instanceof Inet4Address == a2 instanceof Inet4Address;
    }

    public String getID() {
        return this.id;
    }

    public InetAddress getInternalAddress() {
        return this.internal_address;
    }

    public List getInternalAddresses() {
        ArrayList<InetAddress> l = new ArrayList<InetAddress>();
        if (this.internal_address != null) {
            l.add(this.internal_address);
        }
        return l;
    }

    public InetAddress getExternalAddress() {
        return this.readExternalAddress();
    }

    public int getTCPListenPort() {
        return this.tcp_port;
    }

    public int getUDPListenPort() {
        return this.udp_port;
    }

    public int getUDPNonDataListenPort() {
        return this.udp_non_data_port;
    }
}

