/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.lws;

import com.aelitis.azureus.core.lws.LightWeightSeed;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;

public class LWSTorrent
extends LogRelation
implements TOTorrent {
    private static TOTorrentAnnounceURLGroup announce_group = new TOTorrentAnnounceURLGroup(){

        public TOTorrentAnnounceURLSet[] getAnnounceURLSets() {
            return new TOTorrentAnnounceURLSet[0];
        }

        public void setAnnounceURLSets(TOTorrentAnnounceURLSet[] sets) {
            LWSTorrent.notSupported();
        }

        public TOTorrentAnnounceURLSet createAnnounceURLSet(URL[] urls) {
            LWSTorrent.notSupported();
            return null;
        }
    };
    private LightWeightSeed lws;

    private static void notSupported() {
        Debug.out("Not Supported");
    }

    protected LWSTorrent(LightWeightSeed _lws) {
        this.lws = _lws;
    }

    protected TOTorrent getDelegate() {
        return this.lws.getTOTorrent(true);
    }

    public byte[] getName() {
        return this.lws.getName().getBytes();
    }

    public boolean isSimpleTorrent() {
        return this.getDelegate().isSimpleTorrent();
    }

    public byte[] getComment() {
        return this.getDelegate().getComment();
    }

    public void setComment(String comment) {
        this.getDelegate().setComment(comment);
    }

    public long getCreationDate() {
        return this.getDelegate().getCreationDate();
    }

    public void setCreationDate(long date) {
        this.getDelegate().setCreationDate(date);
    }

    public byte[] getCreatedBy() {
        return this.getDelegate().getCreatedBy();
    }

    public boolean isCreated() {
        return true;
    }

    public URL getAnnounceURL() {
        return this.lws.getAnnounceURL();
    }

    public boolean setAnnounceURL(URL url) {
        LWSTorrent.notSupported();
        return false;
    }

    public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
        return announce_group;
    }

    public byte[][] getPieces() throws TOTorrentException {
        return this.getDelegate().getPieces();
    }

    public void setPieces(byte[][] pieces) throws TOTorrentException {
        this.getDelegate().setPieces(pieces);
    }

    public long getPieceLength() {
        return this.getDelegate().getPieceLength();
    }

    public int getNumberOfPieces() {
        return this.getDelegate().getNumberOfPieces();
    }

    public long getSize() {
        return this.lws.getSize();
    }

    public TOTorrentFile[] getFiles() {
        return this.getDelegate().getFiles();
    }

    public byte[] getHash() throws TOTorrentException {
        return this.lws.getHash().getBytes();
    }

    public HashWrapper getHashWrapper() throws TOTorrentException {
        return this.lws.getHash();
    }

    public void setHashOverride(byte[] hash) throws TOTorrentException {
        throw new TOTorrentException("Not supported", 8);
    }

    public boolean hasSameHashAs(TOTorrent other) {
        try {
            byte[] other_hash = other.getHash();
            return Arrays.equals(this.getHash(), other_hash);
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    public boolean getPrivate() {
        return false;
    }

    public void setPrivate(boolean _private) throws TOTorrentException {
        LWSTorrent.notSupported();
    }

    public void setAdditionalStringProperty(String name, String value) {
        this.getDelegate().setAdditionalStringProperty(name, value);
    }

    public String getAdditionalStringProperty(String name) {
        return this.getDelegate().getAdditionalStringProperty(name);
    }

    public void setAdditionalByteArrayProperty(String name, byte[] value) {
        this.getDelegate().setAdditionalByteArrayProperty(name, value);
    }

    public byte[] getAdditionalByteArrayProperty(String name) {
        return this.getDelegate().getAdditionalByteArrayProperty(name);
    }

    public void setAdditionalLongProperty(String name, Long value) {
        this.getDelegate().setAdditionalLongProperty(name, value);
    }

    public Long getAdditionalLongProperty(String name) {
        return this.getDelegate().getAdditionalLongProperty(name);
    }

    public void setAdditionalListProperty(String name, List value) {
        this.getDelegate().setAdditionalListProperty(name, value);
    }

    public List getAdditionalListProperty(String name) {
        return this.getDelegate().getAdditionalListProperty(name);
    }

    public void setAdditionalMapProperty(String name, Map value) {
        this.getDelegate().setAdditionalMapProperty(name, value);
    }

    public Map getAdditionalMapProperty(String name) {
        return this.getDelegate().getAdditionalMapProperty(name);
    }

    public Object getAdditionalProperty(String name) {
        if (name.equals("url-list") || name.equals("httpseeds")) {
            return null;
        }
        return this.getDelegate().getAdditionalProperty(name);
    }

    public void setAdditionalProperty(String name, Object value) {
        this.getDelegate().setAdditionalProperty(name, value);
    }

    public void removeAdditionalProperty(String name) {
        this.getDelegate().removeAdditionalProperty(name);
    }

    public void removeAdditionalProperties() {
        this.getDelegate().removeAdditionalProperties();
    }

    public void serialiseToBEncodedFile(File file) throws TOTorrentException {
        this.getDelegate().serialiseToBEncodedFile(file);
    }

    public Map serialiseToMap() throws TOTorrentException {
        return this.getDelegate().serialiseToMap();
    }

    public void serialiseToXMLFile(File file) throws TOTorrentException {
        this.getDelegate().serialiseToXMLFile(file);
    }

    public AEMonitor getMonitor() {
        return this.getDelegate().getMonitor();
    }

    public void print() {
        this.getDelegate().print();
    }

    public String getRelationText() {
        return "LWTorrent: '" + new String(this.getName()) + "'";
    }

    public Object[] getQueryableInterfaces() {
        return new Object[]{this.lws};
    }
}

