/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.browser;

import com.aelitis.azureus.core.messenger.browser.listeners.MessageCompletionListener;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.JSFunctionParametersParser;
import com.aelitis.azureus.util.JSONUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Debug;

public class BrowserMessage {
    public static final String MESSAGE_PREFIX = "AZMSG";
    public static final String MESSAGE_DELIM = ";";
    public static String MESSAGE_DELIM_ENCODED;
    public static final int NO_PARAM = 0;
    public static final int OBJECT_PARAM = 1;
    public static final int ARRAY_PARAM = 2;
    public static final int LIST_PARAM = 3;
    static int seqFake;
    private int sequence;
    private String listenerId;
    private String operationId;
    private String params;
    private int paramType;
    private Object decodedParams;
    private String sFullMessage;
    private ArrayList completionListeners = new ArrayList();
    private boolean completed;
    private boolean completeDelayed;
    private String referer;

    public BrowserMessage(String sMsg) {
        if (sMsg == null) {
            throw new IllegalArgumentException("event must be non-null");
        }
        this.sFullMessage = sMsg;
        this.parse();
    }

    public void addCompletionListener(MessageCompletionListener l) {
        this.completionListeners.add(l);
    }

    public void complete(boolean bOnlyNonDelayed, boolean success, Object data) {
        if (this.completed || bOnlyNonDelayed && this.completeDelayed) {
            return;
        }
        this.triggerCompletionListeners(success, data);
        this.completed = true;
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public void debug(String message, Throwable t) {
        try {
            AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("v3.CMsgr");
            String out = "[" + this.getListenerId() + ":" + this.getOperationId() + "] " + message;
            diag_logger.log(out);
            if (t != null) {
                diag_logger.log(t);
            }
            if (ConstantsV3.DIAG_TO_STDOUT) {
                System.out.println(out);
                if (t != null) {
                    t.printStackTrace();
                }
            }
        }
        catch (Throwable t2) {
            Debug.out(t2);
        }
    }

    public List getDecodedArray() {
        if (!this.isParamArray()) {
            throw new IllegalStateException("Decoded parameter is not a List");
        }
        return (List)this.decodedParams;
    }

    public List getDecodedList() {
        if (!this.isParamList()) {
            throw new IllegalStateException("Decoded parameter is not a List");
        }
        return (List)this.decodedParams;
    }

    public Map getDecodedMap() {
        if (!this.isParamObject()) {
            throw new IllegalStateException("Decoded parameter is not a Map");
        }
        return (Map)this.decodedParams;
    }

    public String getFullMessage() {
        return this.sFullMessage;
    }

    public String getListenerId() {
        return this.listenerId;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getParams() {
        return this.params;
    }

    public String getReferer() {
        return this.referer;
    }

    public int getSequence() {
        return this.sequence;
    }

    public boolean isParamArray() {
        return this.paramType == 2;
    }

    public boolean isParamList() {
        return this.paramType == 3;
    }

    public boolean isParamObject() {
        return this.paramType == 1;
    }

    protected void parse() {
        String text = this.sFullMessage;
        int delimSeqNum = text.indexOf(MESSAGE_DELIM);
        if (delimSeqNum == -1) {
            throw new IllegalArgumentException("Message has no delimeters: " + text);
        }
        if (delimSeqNum == text.length() - 1) {
            throw new IllegalArgumentException("Message has no sequence number: " + text);
        }
        int delimListener = text.indexOf(MESSAGE_DELIM, delimSeqNum + 1);
        if (delimListener == -1 || delimListener == text.length() - 1) {
            throw new IllegalArgumentException("Message has no listener ID: " + text);
        }
        try {
            this.sequence = Integer.parseInt(text.substring(delimSeqNum + 1, delimListener));
        }
        catch (NumberFormatException e) {
            System.err.println("Plese put the throw back in once souk fixes the seq # bug");
            this.sequence = seqFake++;
        }
        int delimOperation = text.indexOf(MESSAGE_DELIM, delimListener + 1);
        if (delimOperation == -1 || delimOperation == text.length() - 1) {
            throw new IllegalArgumentException("Message has no operation ID: " + text);
        }
        this.listenerId = text.substring(delimListener + 1, delimOperation);
        int delimParams = text.indexOf(MESSAGE_DELIM, delimOperation + 1);
        if (delimParams == -1) {
            this.operationId = text.substring(delimOperation + 1);
        } else if (delimParams == text.length() - 1) {
            this.operationId = text.substring(delimOperation + 1, delimParams);
            this.params = null;
            this.paramType = 0;
            this.decodedParams = null;
        } else {
            this.operationId = text.substring(delimOperation + 1, delimParams);
            this.params = text.substring(delimParams + 1);
            char leading = this.params.charAt(0);
            try {
                switch (leading) {
                    case '{': {
                        this.paramType = 1;
                        this.decodedParams = JSONUtils.decodeJSON(this.params);
                        break;
                    }
                    case '[': {
                        this.paramType = 2;
                        Map decodeJSON = JSONUtils.decodeJSON(this.params);
                        if (decodeJSON != null) {
                            this.decodedParams = decodeJSON.get("value");
                            break;
                        }
                        this.decodedParams = null;
                        break;
                    }
                    default: {
                        this.paramType = 3;
                        this.decodedParams = JSFunctionParametersParser.parse(this.params);
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.decodedParams = null;
            }
            if (this.decodedParams == null) {
                this.paramType = 0;
            }
        }
    }

    public void removeCompletionListener(MessageCompletionListener l) {
        this.completionListeners.remove(l);
    }

    public void setCompleteDelayed(boolean bCompleteDelayed) {
        this.completeDelayed = bCompleteDelayed;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public String toString() {
        return "[" + this.sequence + "] " + this.listenerId + "." + this.operationId + "(" + this.params + ")";
    }

    private void triggerCompletionListeners(boolean success, Object data) {
        for (MessageCompletionListener l : this.completionListeners) {
            try {
                l.completed(success, data);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    static {
        try {
            MESSAGE_DELIM_ENCODED = URLEncoder.encode(MESSAGE_DELIM, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            MESSAGE_DELIM_ENCODED = MESSAGE_DELIM;
        }
        seqFake = 1;
    }
}

