/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.core.crypto.VuzeCryptoException;
import com.aelitis.azureus.core.crypto.VuzeCryptoManager;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.login.NotLoggedInException;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.MapUtils;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;

public class PlatformKeyExchangeMessenger {
    public static final String LISTENER_ID = "exchange";
    public static final String PREFIX = "key";
    public static String OP_GETPASSWORD = "getPassword";
    public static String OP_SETPUBLICKEY = "setPublicKey";

    public static void getPassword(final platformPasswordListener l) throws NotLoggedInException {
        if (!System.getProperty("crypto.skip", "").equals("")) {
            VuzeCryptoManager.getSingleton().setPassword(System.getProperty("crypto.skip"));
            if (l != null) {
                l.passwordRetrieved();
            }
            return;
        }
        PlatformMessage message = new PlatformMessage(PREFIX, LISTENER_ID, OP_GETPASSWORD, new Object[0], 1000L);
        message.setRequiresAuthorization(true, false);
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                if (!replyType.equals(PlatformMessenger.REPLY_RESULT)) {
                    return;
                }
                String pw = MapUtils.getMapString(reply, "password", null);
                if (pw != null && pw.length() > 0) {
                    VuzeBuddyManager.log("Got PW from webapp");
                    VuzeCryptoManager.getSingleton().setPassword(pw);
                    if (l != null) {
                        l.passwordRetrieved();
                    }
                }
            }

            public void messageSent(PlatformMessage message) {
            }
        };
        PlatformMessenger.pushMessageNow(message, listener);
    }

    public static void setPublicKey() throws NotLoggedInException {
        String myPK;
        try {
            myPK = VuzeCryptoManager.getSingleton().getPublicKey(null);
        }
        catch (VuzeCryptoException e) {
            Debug.out(e);
            return;
        }
        PlatformMessage message = new PlatformMessage(PREFIX, LISTENER_ID, OP_SETPUBLICKEY, new Object[]{"azid", ConstantsV3.AZID, "publicKey", myPK}, 1000L);
        message.setRequiresAuthorization(true, false);
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                VuzeBuddyManager.log("Webapp setPK: " + replyType);
            }

            public void messageSent(PlatformMessage message) {
            }
        };
        PlatformMessenger.pushMessageNow(message, listener);
    }

    public static interface platformPasswordListener {
        public void passwordRetrieved();
    }
}

