/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;

public class PlatformTorrentMessenger {
    public static String LISTENER_ID = "torrent";
    public static String OP_GETMETADATA = "get-metadata";
    public static String OP_STREAMCOMPLETE = "stream-complete";

    public static void getMetaData(TOTorrent[] torrents, long maxDelayMS, final GetMetaDataReplyListener replyListener) {
        HashMap mapParameters = new HashMap();
        ArrayList listContent = new ArrayList();
        ArrayList<String> listHashes = new ArrayList<String>();
        mapParameters.put("content-list", listContent);
        if (PlatformConfigMessenger.getRPCVersion() == 0) {
            mapParameters.put("hashes", listHashes);
        }
        for (int i = 0; i < torrents.length; ++i) {
            TOTorrent torrent = torrents[i];
            if (!PlatformTorrentUtils.isContent(torrent, true)) continue;
            String hash = null;
            try {
                hash = torrent.getHashWrapper().toBase32String();
            }
            catch (TOTorrentException e) {
                e.printStackTrace();
            }
            if (hash == null) continue;
            listHashes.add(hash);
            HashMap<String, Object> jsonSubObject = new HashMap<String, Object>();
            listContent.add(jsonSubObject);
            jsonSubObject.put("hash", hash);
            jsonSubObject.put("last-revision", new Long(PlatformTorrentUtils.getContentLastUpdated(torrent)));
        }
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, OP_GETMETADATA, mapParameters, maxDelayMS);
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void messageSent(PlatformMessage message) {
                replyListener.messageSent();
            }

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                if (reply != null) {
                    replyListener.replyReceived(replyType, reply);
                } else {
                    replyListener.replyReceived(replyType, new HashMap());
                }
            }
        };
        PlatformMessenger.queueMessage(message, listener);
    }

    public static void streamComplete(TOTorrent torrent, long waitTime, int maxSeekAheadSecs, int numRebuffers, int numHardRebuffers) {
        String hash = null;
        try {
            hash = torrent.getHashWrapper().toBase32String();
        }
        catch (TOTorrentException e) {
            // empty catch block
        }
        if (hash == null) {
            return;
        }
        HashMap<String, Object> mapParameters = new HashMap<String, Object>();
        mapParameters.put("torrent-hash", hash);
        mapParameters.put("wait-time", new Long(waitTime));
        mapParameters.put("max-seek", new Long(maxSeekAheadSecs));
        mapParameters.put("num-rebuffers", new Long(numRebuffers));
        mapParameters.put("num-hard-rebuffers", new Long(numHardRebuffers));
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, OP_STREAMCOMPLETE, mapParameters, 3000L);
        PlatformMessenger.queueMessage(message, null);
    }

    public static void streamComplete(TOTorrent torrent, Map info) {
        String hash = null;
        try {
            hash = torrent.getHashWrapper().toBase32String();
        }
        catch (TOTorrentException e) {
            // empty catch block
        }
        if (hash == null) {
            return;
        }
        HashMap<String, String> mapParameters = new HashMap<String, String>(info);
        mapParameters.put("torrent-hash", hash);
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, OP_STREAMCOMPLETE, mapParameters, 3000L);
        PlatformMessenger.queueMessage(message, null);
    }

    public static interface GetMetaDataReplyListener {
        public void messageSent();

        public void replyReceived(String var1, Map var2);
    }
}

