/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.web.regex;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchException;
import com.aelitis.azureus.core.metasearch.SearchLoginException;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.EngineImpl;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchImpl;
import com.aelitis.azureus.core.metasearch.impl.web.FieldMapping;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.metasearch.impl.web.WebResult;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TimeLimitedTask;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.json.simple.JSONObject;

public class RegexEngine
extends WebEngine {
    private String pattern_str;
    private Pattern pattern;

    public static EngineImpl importFromBEncodedMap(MetaSearchImpl meta_search, Map map) throws IOException {
        return new RegexEngine(meta_search, map);
    }

    public static Engine importFromJSONString(MetaSearchImpl meta_search, long id, long last_updated, String name, JSONObject map) throws IOException {
        return new RegexEngine(meta_search, id, last_updated, name, map);
    }

    public RegexEngine(MetaSearchImpl meta_search, long id, long last_updated, String name, String searchURLFormat, String resultPattern, String timeZone, boolean automaticDateFormat, String userDateFormat, FieldMapping[] mappings, boolean needs_auth, String auth_method, String login_url, String[] required_cookies) {
        super(meta_search, 1, id, last_updated, name, searchURLFormat, timeZone, automaticDateFormat, userDateFormat, mappings, needs_auth, auth_method, login_url, required_cookies);
        this.init(resultPattern);
        this.setSource(2);
        this.setSelectionState(2);
    }

    protected RegexEngine(MetaSearchImpl meta_search, Map map) throws IOException {
        super(meta_search, map);
        String resultPattern = ImportExportUtils.importString(map, "regex.pattern");
        this.init(resultPattern);
    }

    protected RegexEngine(MetaSearchImpl meta_search, long id, long last_updated, String name, JSONObject map) throws IOException {
        super(meta_search, 1, id, last_updated, name, map);
        String resultPattern = ImportExportUtils.importString(map, "regexp");
        resultPattern = URLDecoder.decode(resultPattern, "UTF-8");
        this.init(resultPattern);
    }

    public Map exportToBencodedMap() throws IOException {
        HashMap res = new HashMap();
        ImportExportUtils.exportString(res, "regex.pattern", this.pattern_str);
        super.exportToBencodedMap(res);
        return res;
    }

    protected void exportToJSONObject(JSONObject res) throws IOException {
        res.put("regexp", UrlUtils.encode(this.pattern_str));
        super.exportToJSONObject(res);
    }

    protected void init(String resultPattern) {
        this.pattern_str = resultPattern.trim();
        this.pattern = Pattern.compile(this.pattern_str);
    }

    protected Result[] searchSupport(final SearchParameter[] searchParameters, Map searchContext, int desired_max_matches, final int o_absolute_max_matches, String headers, final ResultListener listener) throws SearchException {
        this.debugStart();
        final WebEngine.pageDetails page_details = this.getWebPageContent(searchParameters, searchContext, headers, false);
        final String page = page_details.getContent();
        if (listener != null) {
            listener.contentReceived(this, page);
        }
        this.debugLog("pattern: " + this.pattern_str);
        try {
            TimeLimitedTask task2 = new TimeLimitedTask("MetaSearch:regexpr", 30000, 4, new TimeLimitedTask.task(){

                public Object run() throws Exception {
                    int max_matches = o_absolute_max_matches;
                    if (max_matches < 0 || max_matches > 1024) {
                        max_matches = 1024;
                    }
                    String searchQuery = null;
                    for (int i = 0; i < searchParameters.length; ++i) {
                        if (!searchParameters[i].getMatchPattern().equals("s")) continue;
                        searchQuery = searchParameters[i].getValue();
                    }
                    FieldMapping[] mappings = RegexEngine.this.getMappings();
                    try {
                        ArrayList<WebResult> results = new ArrayList<WebResult>();
                        Matcher m = RegexEngine.this.pattern.matcher(page);
                        while (m.find() && (max_matches < 0 || --max_matches >= 0)) {
                            if (listener != null) {
                                String[] groups = new String[m.groupCount()];
                                for (int i = 0; i < groups.length; ++i) {
                                    groups[i] = m.group(i + 1);
                                }
                                listener.matchFound(RegexEngine.this, groups);
                            }
                            RegexEngine.this.debugLog("Found match:");
                            WebResult result = new WebResult(RegexEngine.this, RegexEngine.this.getRootPage(), RegexEngine.this.getBasePage(), RegexEngine.this.getDateParser(), searchQuery);
                            int fields_matched = 0;
                            block25: for (int i = 0; i < mappings.length; ++i) {
                                int group = -1;
                                try {
                                    group = Integer.parseInt(mappings[i].getName());
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                if (group <= 0 || group > m.groupCount()) continue;
                                int field = mappings[i].getField();
                                String groupContent = m.group(group);
                                RegexEngine.this.debugLog("    " + field + "=" + groupContent);
                                ++fields_matched;
                                switch (field) {
                                    case 1: {
                                        result.setNameFromHTML(groupContent);
                                        continue block25;
                                    }
                                    case 3: {
                                        result.setSizeFromHTML(groupContent);
                                        continue block25;
                                    }
                                    case 4: {
                                        result.setNbPeersFromHTML(groupContent);
                                        continue block25;
                                    }
                                    case 5: {
                                        result.setNbSeedsFromHTML(groupContent);
                                        continue block25;
                                    }
                                    case 6: {
                                        result.setCategoryFromHTML(groupContent);
                                        continue block25;
                                    }
                                    case 2: {
                                        result.setPublishedDateFromHTML(groupContent);
                                        continue block25;
                                    }
                                    case 103: {
                                        result.setCDPLink(groupContent);
                                        continue block25;
                                    }
                                    case 102: {
                                        result.setTorrentLink(groupContent);
                                        continue block25;
                                    }
                                    case 104: {
                                        result.setPlayLink(groupContent);
                                        continue block25;
                                    }
                                    case 105: {
                                        result.setDownloadButtonLink(groupContent);
                                        continue block25;
                                    }
                                    case 7: {
                                        result.setCommentsFromHTML(groupContent);
                                        continue block25;
                                    }
                                    case 10: {
                                        result.setVotesFromHTML(groupContent);
                                        continue block25;
                                    }
                                    case 11: {
                                        result.setNbSuperSeedsFromHTML(groupContent);
                                        continue block25;
                                    }
                                    case 12: {
                                        result.setPrivateFromHTML(groupContent);
                                        continue block25;
                                    }
                                    case 13: {
                                        result.setDrmKey(groupContent);
                                        continue block25;
                                    }
                                    case 14: {
                                        result.setVotesDownFromHTML(groupContent);
                                        continue block25;
                                    }
                                    default: {
                                        --fields_matched;
                                    }
                                }
                            }
                            if (fields_matched <= 0) continue;
                            results.add(result);
                        }
                        if (results.size() == 0 && RegexEngine.this.isNeedsAuth() && page_details.getInitialURL().getProtocol().equalsIgnoreCase("http") && page_details.getFinalURL().getProtocol().equalsIgnoreCase("https")) {
                            throw new SearchLoginException("login possibly required");
                        }
                        return results.toArray(new Result[results.size()]);
                    }
                    catch (Throwable e) {
                        RegexEngine.this.log("Failed process result", e);
                        if (e instanceof SearchException) {
                            throw (SearchException)e;
                        }
                        throw new SearchException(e);
                    }
                }
            });
            Result[] res = (Result[])task2.run();
            this.debugLog("success: found " + res.length + " results");
            return res;
        }
        catch (Throwable e) {
            this.debugLog("failed: " + Debug.getNestedExceptionMessageAndStack(e));
            if (e instanceof SearchException) {
                throw (SearchException)e;
            }
            throw new SearchException("Regex matching failed", e);
        }
    }
}

