/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminHTTPProxy;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelperFilterFactory;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportImpl;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class NetworkAdminHTTPProxyImpl
implements NetworkAdminHTTPProxy {
    private static final String NL = "\r\n";
    private final String TARGET_HOST = "version.azureusplatform.com";
    private final int TARGET_PORT = 80;
    private String http_host = System.getProperty("http.proxyHost", "").trim();
    private String http_port = System.getProperty("http.proxyPort", "").trim();
    private String https_host = System.getProperty("https.proxyHost", "").trim();
    private String https_port = System.getProperty("https.proxyPort", "").trim();
    private String user = System.getProperty("http.proxyUser", "").trim();
    private String password = System.getProperty("http.proxyPassword", "").trim();
    private String[] non_proxy_hosts;

    protected NetworkAdminHTTPProxyImpl() {
        String nph = System.getProperty("http.nonProxyHosts", "").trim();
        StringTokenizer tok = new StringTokenizer(nph, "|");
        this.non_proxy_hosts = new String[tok.countTokens()];
        int pos = 0;
        while (tok.hasMoreTokens()) {
            this.non_proxy_hosts[pos++] = tok.nextToken();
        }
    }

    public String getName() {
        String res = "";
        if (this.http_host.length() > 0) {
            res = "http=" + this.http_host + ":" + this.http_port;
        }
        if (this.https_host.length() > 0) {
            res = res + (res.length() == 0 ? "" : ", ") + "https=" + this.https_host + ":" + this.https_port;
        }
        return res;
    }

    protected boolean isConfigured() {
        return this.http_host.length() > 0 || this.https_host.length() > 0;
    }

    public String getHTTPHost() {
        return this.http_host;
    }

    public String getHTTPPort() {
        return this.http_port;
    }

    public String getHTTPSHost() {
        return this.https_host;
    }

    public String getHTTPSPort() {
        return this.https_port;
    }

    public String getUser() {
        return this.user;
    }

    public String[] getNonProxyHosts() {
        return this.non_proxy_hosts;
    }

    public String getString() {
        String res = this.getName();
        if (this.user.length() > 0) {
            res = res + " [auth=" + this.user + "]";
        }
        try {
            NetworkAdminHTTPProxy.Details details = this.getDetails();
            res = res + " server=" + details.getServerName();
            res = res + ", response=" + details.getResponse();
            res = res + ", auth=" + details.getAuthenticationType();
        }
        catch (NetworkAdminException e) {
            res = res + " failed to query proxy - " + e.getLocalizedMessage();
        }
        return res;
    }

    public NetworkAdminHTTPProxy.Details getDetails() throws NetworkAdminException {
        boolean RES_CONNECT_FAILED = false;
        boolean RES_PROXY_FAILED = true;
        int RES_OK = 3;
        final AESemaphore sem = new AESemaphore("NetworkAdminSocksProxy:test");
        final int[] result = new int[]{0};
        final NetworkAdminException[] error = new NetworkAdminException[]{null};
        final ProxyDetails[] details = new ProxyDetails[]{null};
        try {
            InetSocketAddress socks_address = new InetSocketAddress(InetAddress.getByName(this.http_host), Integer.parseInt(this.http_port));
            final InetSocketAddress target_address = new InetSocketAddress("version.azureusplatform.com", 80);
            TCPConnectionManager.ConnectListener connect_listener = new TCPConnectionManager.ConnectListener(){

                public void connectAttemptStarted() {
                }

                public void connectSuccess(SocketChannel channel) {
                    final TCPTransportImpl transport = new TCPTransportImpl(new ProtocolEndpointTCP(target_address), false, false, null);
                    transport.setFilter(TCPTransportHelperFilterFactory.createTransparentFilter(channel));
                    final long start_time = SystemTime.getCurrentTime();
                    try {
                        String get_str = VersionCheckClient.getSingleton().getHTTPGetString(true, false);
                        ByteBuffer request2 = ByteBuffer.wrap(get_str.getBytes());
                        while (request2.hasRemaining()) {
                            if (transport.write(new ByteBuffer[]{request2}, 0, 1) >= 1L) continue;
                            if (SystemTime.getCurrentTime() - start_time > 30000L) {
                                String error2 = "proxy handshake message send timed out after 30sec";
                                Debug.out(error2);
                                throw new IOException(error2);
                            }
                            try {
                                Thread.sleep(50L);
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                        TCPNetworkManager.getSingleton().getReadSelector().register(transport.getSocketChannel(), new VirtualChannelSelector.VirtualSelectorListener(){
                            private byte[] reply_buffer = new byte[8192];
                            private ByteBuffer reply = ByteBuffer.wrap(this.reply_buffer);

                            public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                                try {
                                    if (SystemTime.getCurrentTime() - start_time > 30000L) {
                                        throw new Exception("Timeout");
                                    }
                                    long len = transport.read(new ByteBuffer[]{this.reply}, 0, 1);
                                    if (len <= 0L) {
                                        return false;
                                    }
                                    String str = new String(this.reply_buffer, 0, this.reply.position());
                                    if (str.indexOf("\r\n\r\n") != -1) {
                                        System.out.println(str);
                                        String server_name = "unknown";
                                        String auth = "none";
                                        String response = "unknown";
                                        StringTokenizer tok = new StringTokenizer(str, "\n");
                                        int line_num = 0;
                                        while (tok.hasMoreTokens()) {
                                            int pos;
                                            String token = tok.nextToken().trim();
                                            if (token.length() == 0) continue;
                                            if (++line_num == 1) {
                                                pos = token.indexOf(32);
                                                if (pos == -1) continue;
                                                response = token.substring(pos + 1).trim();
                                                continue;
                                            }
                                            pos = token.indexOf(58);
                                            if (pos == -1) continue;
                                            String lhs = token.substring(0, pos).trim().toLowerCase();
                                            String rhs = token.substring(pos + 1).trim();
                                            if (lhs.equals("server")) {
                                                if (response.startsWith("200")) continue;
                                                server_name = rhs;
                                                continue;
                                            }
                                            if (lhs.equals("via")) {
                                                server_name = rhs;
                                                int p = server_name.indexOf(32);
                                                if (p == -1) continue;
                                                server_name = server_name.substring(p + 1).trim();
                                                continue;
                                            }
                                            if (!lhs.equals("proxy-authenticate")) continue;
                                            auth = rhs;
                                        }
                                        details[0] = new ProxyDetails(server_name, response, auth);
                                        transport.close("Done");
                                        result[0] = 3;
                                        sem.release();
                                    } else {
                                        TCPNetworkManager.getSingleton().getReadSelector().resumeSelects(transport.getSocketChannel());
                                    }
                                    return true;
                                }
                                catch (Throwable t) {
                                    return false;
                                }
                            }

                            public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                                result[0] = 1;
                                error[0] = new NetworkAdminException("Proxy error", msg);
                                transport.close("Proxy error");
                                sem.release();
                            }
                        }, null);
                    }
                    catch (Throwable t) {
                        result[0] = 1;
                        error[0] = new NetworkAdminException("Proxy connect failed", t);
                        sem.release();
                    }
                }

                public void connectFailure(Throwable failure_msg) {
                    result[0] = 0;
                    error[0] = new NetworkAdminException("Connect failed", failure_msg);
                    sem.release();
                }
            };
            TCPNetworkManager.getSingleton().getConnectDisconnectManager().requestNewConnection(socks_address, connect_listener, 2);
        }
        catch (Throwable e) {
            result[0] = 0;
            error[0] = new NetworkAdminException("Connect failed", e);
            sem.release();
        }
        if (!sem.reserve(10000L)) {
            result[0] = 0;
            error[0] = new NetworkAdminException("Connect timeout");
        }
        if (result[0] == 3) {
            return details[0];
        }
        throw error[0];
    }

    protected class ProxyDetails
    implements NetworkAdminHTTPProxy.Details {
        private String name;
        private String response;
        private String auth_type;

        protected ProxyDetails(String _name, String _response, String _auth_type) {
            this.name = _name;
            this.response = _response;
            this.auth_type = _auth_type;
        }

        public String getServerName() {
            return this.name;
        }

        public String getResponse() {
            return this.response;
        }

        public String getAuthenticationType() {
            return this.auth_type;
        }
    }
}

