/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.instancemanager.AZInstance;
import com.aelitis.azureus.core.instancemanager.AZInstanceManager;
import com.aelitis.azureus.core.instancemanager.AZInstanceManagerListener;
import com.aelitis.azureus.core.instancemanager.AZInstanceTracked;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASN;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminHTTPProxy;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNATDevice;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterface;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNode;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProtocol;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminRouteListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminRoutesListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSocksProxy;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTestScheduler;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminASNImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminASNLookupImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminHTTPProxyImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminNATDeviceImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminProtocolImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSocksProxyImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSpeedTestSchedulerImpl;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.proxy.socks.AESocksProxy;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.azureus.plugins.upnp.UPnPPluginService;
import java.io.PrintWriter;
import java.net.Authenticator;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.platform.PlatformManagerPingCallback;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class NetworkAdminImpl
extends NetworkAdmin
implements AEDiagnosticsEvidenceGenerator {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final boolean FULL_INTF_PROBE = false;
    private Set old_network_interfaces;
    private InetAddress[] currentBindIPs = new InetAddress[]{null};
    private boolean supportsIPv6withNIO = true;
    private boolean supportsIPv6 = true;
    private boolean supportsIPv4 = true;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private NetworkAdminRouteListener trace_route_listener = new NetworkAdminRouteListener(){
        private int node_count = 0;

        public boolean foundNode(NetworkAdminNode node, int distance, int rtt) {
            ++this.node_count;
            return true;
        }

        public boolean timeout(int distance) {
            return distance != 3 || this.node_count != 0;
        }
    };
    private static final int ASN_MIN_CHECK = 1800000;
    private long last_asn_lookup_time;
    private List asn_ips_checked = new ArrayList(0);
    private List as_history = new ArrayList();
    private int roundRobinCounterV4 = 0;
    private int roundRobinCounterV6 = 0;
    private static InetAddress anyLocalAddressIPv4;
    private static InetAddress anyLocalAddressIPv6;
    private static InetAddress localhostV4;
    private static InetAddress localhostV6;

    public NetworkAdminImpl() {
        COConfigurationManager.addParameterListener(new String[]{"Bind IP", "Enforce Bind IP"}, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                NetworkAdminImpl.this.checkDefaultBindAddress(false);
            }
        });
        SimpleTimer.addPeriodicEvent("NetworkAdmin:checker", 15000L, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                NetworkAdminImpl.this.checkNetworkInterfaces(false);
            }
        });
        this.checkNetworkInterfaces(true);
        this.checkDefaultBindAddress(true);
        AEDiagnostics.addEvidenceGenerator(this);
    }

    protected void checkNetworkInterfaces(boolean first_time) {
        block20: {
            try {
                Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                boolean changed = false;
                if (nis != null || this.old_network_interfaces != null) {
                    HashSet<NetworkInterface> new_network_interfaces;
                    if (nis == null) {
                        this.old_network_interfaces = null;
                        changed = true;
                    } else if (this.old_network_interfaces == null) {
                        new_network_interfaces = new HashSet<NetworkInterface>();
                        while (nis.hasMoreElements()) {
                            new_network_interfaces.add(nis.nextElement());
                        }
                        this.old_network_interfaces = new_network_interfaces;
                        changed = true;
                    } else {
                        new_network_interfaces = new HashSet();
                        while (nis.hasMoreElements()) {
                            NetworkInterface ni = nis.nextElement();
                            if (!this.old_network_interfaces.contains(ni)) {
                                changed = true;
                            }
                            new_network_interfaces.add(ni);
                        }
                        if (this.old_network_interfaces.size() != new_network_interfaces.size()) {
                            changed = true;
                        }
                        this.old_network_interfaces = new_network_interfaces;
                    }
                }
                if (!changed) break block20;
                boolean newV6 = false;
                boolean newV4 = false;
                Set interfaces = this.old_network_interfaces;
                if (interfaces != null) {
                    for (NetworkInterface ni : interfaces) {
                        Enumeration<InetAddress> addresses = ni.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            InetAddress ia = addresses.nextElement();
                            if (ia.isLoopbackAddress()) continue;
                            if (ia instanceof Inet6Address && !ia.isLinkLocalAddress()) {
                                newV6 = true;
                                continue;
                            }
                            if (!(ia instanceof Inet4Address)) continue;
                            newV4 = true;
                        }
                    }
                }
                this.supportsIPv4 = newV4;
                this.supportsIPv6 = newV6;
                Logger.log(new LogEvent(LOGID, "NetworkAdmin: ipv4 supported: " + this.supportsIPv4 + "; ipv6: " + this.supportsIPv6 + "; probing v6+nio functionality"));
                if (newV6) {
                    ServerSocketChannel channel = ServerSocketChannel.open();
                    try {
                        channel.configureBlocking(false);
                        channel.socket().bind(new InetSocketAddress(anyLocalAddressIPv6, 0));
                        Logger.log(new LogEvent(LOGID, "NetworkAdmin: testing nio + ipv6 bind successful"));
                        this.supportsIPv6withNIO = true;
                    }
                    catch (Exception e) {
                        Logger.log(new LogEvent(LOGID, 1, "nio + ipv6 test failed", (Throwable)e));
                        this.supportsIPv6withNIO = false;
                    }
                    channel.close();
                } else {
                    this.supportsIPv6withNIO = false;
                }
                if (!first_time) {
                    Logger.log(new LogEvent(LOGID, "NetworkAdmin: network interfaces have changed"));
                }
                this.firePropertyChange("Network Interfaces");
                this.checkDefaultBindAddress(first_time);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public InetAddress getMultiHomedOutgoingRoundRobinBindAddress(InetAddress target) {
        InetAddress[] addresses = this.currentBindIPs;
        boolean v6 = target instanceof Inet6Address;
        int previous = (v6 ? this.roundRobinCounterV6 : this.roundRobinCounterV4) % addresses.length;
        InetAddress toReturn = null;
        int i = previous;
        do {
            ++i;
            if (target == null || v6 && addresses[i %= addresses.length] instanceof Inet6Address || !v6 && addresses[i] instanceof Inet4Address) {
                toReturn = addresses[i];
                break;
            }
            if (v6 || !addresses[i].isAnyLocalAddress()) continue;
            toReturn = anyLocalAddressIPv4;
            break;
        } while (i != previous);
        if (v6) {
            this.roundRobinCounterV6 = i;
        } else {
            this.roundRobinCounterV4 = i;
        }
        return toReturn != null ? toReturn : (v6 ? localhostV6 : localhostV4);
    }

    public InetAddress[] getMultiHomedServiceBindAddresses(boolean nio) {
        InetAddress[] bindIPs = this.currentBindIPs;
        for (int i = 0; i < bindIPs.length; ++i) {
            if (!bindIPs[i].isAnyLocalAddress()) continue;
            return new InetAddress[]{nio && !this.supportsIPv6withNIO && bindIPs[i] instanceof Inet6Address ? anyLocalAddressIPv4 : bindIPs[i]};
        }
        return bindIPs;
    }

    public InetAddress getSingleHomedServiceBindAddress(int proto) {
        InetAddress[] addrs = this.currentBindIPs;
        if (proto == 0) {
            return addrs[0];
        }
        for (int i = 0; i < addrs.length; ++i) {
            if ((proto != 1 || !(addrs[i] instanceof Inet4Address)) && !addrs[i].isAnyLocalAddress() && (proto != 2 || !(addrs[i] instanceof Inet6Address))) continue;
            return addrs[i];
        }
        throw new UnsupportedAddressTypeException();
    }

    public InetAddress[] getAllBindAddresses() {
        return this.currentBindIPs;
    }

    private InetAddress[] calcBindAddresses(String addressString, boolean enforceBind) {
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        Pattern addressSplitter = Pattern.compile(";");
        Pattern interfaceSplitter = Pattern.compile("[\\]\\[]");
        String[] tokens = addressSplitter.split(addressString);
        block8: for (int i = 0; i < tokens.length; ++i) {
            String currentAddress = tokens[i];
            InetAddress parsedAddress = null;
            try {
                if (currentAddress.indexOf(46) != -1 || currentAddress.indexOf(58) != -1) {
                    parsedAddress = InetAddress.getByName(currentAddress);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (parsedAddress != null) {
                block17: {
                    try {
                        if (!(parsedAddress.isAnyLocalAddress() && addrs.size() <= 0 || NetworkInterface.getByInetAddress(parsedAddress) != null)) {
                        }
                        break block17;
                    }
                    catch (SocketException e) {
                        Debug.printStackTrace(e);
                    }
                    continue;
                }
                addrs.add(parsedAddress);
                continue;
            }
            String[] ifaces = interfaceSplitter.split(currentAddress);
            NetworkInterface netInterface = null;
            try {
                netInterface = NetworkInterface.getByName(ifaces[0]);
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            if (netInterface == null) continue;
            Enumeration<InetAddress> interfaceAddresses = netInterface.getInetAddresses();
            if (ifaces.length != 2) {
                while (interfaceAddresses.hasMoreElements()) {
                    addrs.add(interfaceAddresses.nextElement());
                }
                continue;
            }
            int selectedAddress = 0;
            try {
                selectedAddress = Integer.parseInt(ifaces[1]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            int j = 0;
            while (interfaceAddresses.hasMoreElements()) {
                if (j == selectedAddress) {
                    addrs.add(interfaceAddresses.nextElement());
                    continue block8;
                }
                ++j;
                interfaceAddresses.nextElement();
            }
        }
        if (addrs.size() < 1) {
            return new InetAddress[]{enforceBind ? localhostV4 : (this.hasIPV6Potential() ? anyLocalAddressIPv6 : anyLocalAddressIPv4)};
        }
        return addrs.toArray(new InetAddress[0]);
    }

    protected void checkDefaultBindAddress(boolean first_time) {
        boolean enforceBind;
        boolean changed = false;
        String bind_ip = COConfigurationManager.getStringParameter("Bind IP", "").trim();
        Object[] addrs = this.calcBindAddresses(bind_ip, enforceBind = COConfigurationManager.getBooleanParameter("Enforce Bind IP"));
        boolean bl = changed = !Arrays.equals(this.currentBindIPs, addrs);
        if (changed) {
            this.currentBindIPs = addrs;
            if (!first_time) {
                String logmsg = "NetworkAdmin: default bind ip has changed to '";
                for (int i = 0; i < addrs.length; ++i) {
                    logmsg = logmsg + (addrs[i] == null ? "none" : ((InetAddress)addrs[i]).getHostAddress()) + (i < addrs.length ? ";" : "");
                }
                logmsg = logmsg + "'";
                Logger.log(new LogEvent(LOGID, logmsg));
            }
            this.firePropertyChange("Default Bind IP");
        }
    }

    public String getNetworkInterfacesAsString() {
        Set interfaces = this.old_network_interfaces;
        if (interfaces == null) {
            return "";
        }
        Iterator it = interfaces.iterator();
        String str = "";
        while (it.hasNext()) {
            NetworkInterface ni = (NetworkInterface)it.next();
            Enumeration<InetAddress> addresses = ni.getInetAddresses();
            str = str + ni.getName() + "\t(" + ni.getDisplayName() + ")\n";
            int i = 0;
            while (addresses.hasMoreElements()) {
                str = str + "\t" + ni.getName() + "[" + i++ + "]\t" + addresses.nextElement().getHostAddress() + "\n";
            }
        }
        return str;
    }

    public boolean hasIPV4Potential() {
        return this.supportsIPv4;
    }

    public boolean hasIPV6Potential(boolean nio) {
        return nio ? this.supportsIPv6withNIO : this.supportsIPv6;
    }

    public InetAddress guessRoutableBindAddress() {
        try {
            ArrayList<InetAddress> local_addresses = new ArrayList<InetAddress>();
            ArrayList<InetAddress> non_local_addresses = new ArrayList<InetAddress>();
            try {
                NetworkAdminNetworkInterface[] interfaces = this.getInterfaces();
                ArrayList<InetAddress> possible = new ArrayList<InetAddress>();
                for (int i = 0; i < interfaces.length; ++i) {
                    NetworkAdminNetworkInterface intf = interfaces[i];
                    NetworkAdminNetworkInterfaceAddress[] addresses = intf.getAddresses();
                    for (int j = 0; j < addresses.length; ++j) {
                        NetworkAdminNetworkInterfaceAddress address = addresses[j];
                        InetAddress ia = address.getAddress();
                        if (ia.isLoopbackAddress()) continue;
                        if (ia.isLinkLocalAddress() || ia.isSiteLocalAddress()) {
                            local_addresses.add(ia);
                        } else {
                            non_local_addresses.add(ia);
                        }
                        if ((!this.hasIPV4Potential() || !(ia instanceof Inet4Address)) && (!this.hasIPV6Potential() || !(ia instanceof Inet6Address))) continue;
                        possible.add(ia);
                    }
                }
                if (possible.size() == 1) {
                    return (InetAddress)possible.get(0);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                NetworkAdminSocksProxy[] socks = this.getSocksProxies();
                if (socks.length > 0) {
                    return this.mapAddressToBindIP(InetAddress.getByName(socks[0].getHost()));
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                NetworkAdminNATDevice[] nat = this.getNATDevices();
                if (nat.length > 0) {
                    return this.mapAddressToBindIP(nat[0].getAddress());
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                final AESemaphore sem = new AESemaphore("NA:conTest");
                final InetAddress[] can_connect = new InetAddress[]{null};
                int timeout = 10000;
                for (int i = 0; i < local_addresses.size(); ++i) {
                    final InetAddress address = (InetAddress)local_addresses.get(i);
                    new AEThread2("NA:conTest", true){

                        public void run() {
                            if (NetworkAdminImpl.this.canConnectWithBind(address, 10000)) {
                                can_connect[0] = address;
                                sem.release();
                            }
                        }
                    }.start();
                }
                if (sem.reserve(10000L)) {
                    return can_connect[0];
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (non_local_addresses.size() > 0) {
                return this.guessAddress(non_local_addresses);
            }
            if (local_addresses.size() > 0) {
                return this.guessAddress(local_addresses);
            }
            return null;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean canConnectWithBind(InetAddress bind_address, int timeout) {
        boolean bl;
        Socket socket = null;
        try {
            socket = new Socket();
            socket.bind(new InetSocketAddress(bind_address, 0));
            socket.setSoTimeout(timeout);
            socket.connect(new InetSocketAddress("www.google.com", 80), timeout);
            bl = true;
            if (socket == null) return bl;
        }
        catch (Throwable e) {
            try {
                boolean bl2 = false;
                return bl2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Throwable f) {}
                }
            }
        }
        try {
            socket.close();
            return bl;
        }
        catch (Throwable f) {
            // empty catch block
        }
        return bl;
    }

    protected InetAddress mapAddressToBindIP(InetAddress address) {
        boolean[] address_bits = this.bytesToBits(address.getAddress());
        NetworkAdminNetworkInterface[] interfaces = this.getInterfaces();
        InetAddress best_bind_address = null;
        int best_prefix = 0;
        for (int i = 0; i < interfaces.length; ++i) {
            NetworkAdminNetworkInterface intf = interfaces[i];
            NetworkAdminNetworkInterfaceAddress[] addresses = intf.getAddresses();
            for (int j = 0; j < addresses.length; ++j) {
                NetworkAdminNetworkInterfaceAddress bind_address = addresses[j];
                InetAddress ba = bind_address.getAddress();
                byte[] bind_bytes = ba.getAddress();
                if (address_bits.length != bind_bytes.length) continue;
                boolean[] bind_bits = this.bytesToBits(bind_bytes);
                for (int k = 0; k < bind_bits.length && address_bits[k] == bind_bits[k]; ++k) {
                    if (k <= best_prefix) continue;
                    best_prefix = k;
                    best_bind_address = ba;
                }
            }
        }
        return best_bind_address;
    }

    protected boolean[] bytesToBits(byte[] bytes) {
        boolean[] res = new boolean[bytes.length * 8];
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            for (int j = 0; j < 8; ++j) {
                res[i * 8 + j] = (b & (byte)(1 << 7 - j)) != 0;
            }
        }
        return res;
    }

    protected InetAddress guessAddress(List addresses) {
        InetAddress address;
        int i;
        for (i = 0; i < addresses.size(); ++i) {
            address = (InetAddress)addresses.get(i);
            String str = address.getHostAddress();
            if (!str.startsWith("192.168.0.") && !str.startsWith("192.168.1.")) continue;
            return address;
        }
        for (i = 0; i < addresses.size(); ++i) {
            address = (InetAddress)addresses.get(i);
            if (!(address instanceof Inet4Address)) continue;
            return address;
        }
        for (i = 0; i < addresses.size(); ++i) {
            address = (InetAddress)addresses.get(i);
            if (!(address instanceof Inet6Address)) continue;
            return address;
        }
        if (addresses.size() > 0) {
            return (InetAddress)addresses.get(0);
        }
        return null;
    }

    protected void firePropertyChange(String property) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((NetworkAdminPropertyChangeListener)it.next()).propertyChanged(property);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public NetworkAdminNetworkInterface[] getInterfaces() {
        Set interfaces = this.old_network_interfaces;
        if (interfaces == null) {
            return new NetworkAdminNetworkInterface[0];
        }
        NetworkAdminNetworkInterface[] res = new NetworkAdminNetworkInterface[interfaces.size()];
        Iterator it = interfaces.iterator();
        int pos = 0;
        while (it.hasNext()) {
            NetworkInterface ni = (NetworkInterface)it.next();
            res[pos++] = new networkInterface(ni);
        }
        return res;
    }

    public NetworkAdminProtocol[] getOutboundProtocols() {
        AzureusCore azureus_core = AzureusCoreFactory.getSingleton();
        NetworkAdminProtocol[] res = new NetworkAdminProtocol[]{new NetworkAdminProtocolImpl(azureus_core, 1), new NetworkAdminProtocolImpl(azureus_core, 2), new NetworkAdminProtocolImpl(azureus_core, 3)};
        return res;
    }

    public NetworkAdminProtocol[] getInboundProtocols() {
        HTTPNetworkManager http_manager;
        int port;
        AzureusCore azureus_core = AzureusCoreFactory.getSingleton();
        ArrayList<NetworkAdminProtocolImpl> protocols = new ArrayList<NetworkAdminProtocolImpl>();
        TCPNetworkManager tcp_manager = TCPNetworkManager.getSingleton();
        if (tcp_manager.isTCPListenerEnabled()) {
            protocols.add(new NetworkAdminProtocolImpl(azureus_core, 2, tcp_manager.getTCPListeningPortNumber()));
        }
        UDPNetworkManager udp_manager = UDPNetworkManager.getSingleton();
        int done_udp = -1;
        if (udp_manager.isUDPListenerEnabled()) {
            done_udp = udp_manager.getUDPListeningPortNumber();
            protocols.add(new NetworkAdminProtocolImpl(azureus_core, 3, done_udp));
        }
        if (udp_manager.isUDPNonDataListenerEnabled() && (port = udp_manager.getUDPNonDataListeningPortNumber()) != done_udp) {
            done_udp = udp_manager.getUDPNonDataListeningPortNumber();
            protocols.add(new NetworkAdminProtocolImpl(azureus_core, 3, done_udp));
        }
        if ((http_manager = HTTPNetworkManager.getSingleton()).isHTTPListenerEnabled()) {
            protocols.add(new NetworkAdminProtocolImpl(azureus_core, 1, http_manager.getHTTPListeningPortNumber()));
        }
        return protocols.toArray(new NetworkAdminProtocol[protocols.size()]);
    }

    public InetAddress testProtocol(NetworkAdminProtocol protocol) throws NetworkAdminException {
        return protocol.test(null);
    }

    public NetworkAdminSocksProxy[] getSocksProxies() {
        String host = System.getProperty("socksProxyHost", "").trim();
        String port = System.getProperty("socksProxyPort", "").trim();
        String user = System.getProperty("java.net.socks.username", "").trim();
        String password = System.getProperty("java.net.socks.password", "").trim();
        ArrayList<NetworkAdminSocksProxyImpl> res = new ArrayList<NetworkAdminSocksProxyImpl>();
        NetworkAdminSocksProxyImpl p1 = new NetworkAdminSocksProxyImpl(host, port, user, password);
        if (p1.isConfigured()) {
            res.add(p1);
        }
        if (COConfigurationManager.getBooleanParameter("Proxy.Data.Enable") && !COConfigurationManager.getBooleanParameter("Proxy.Data.Same")) {
            NetworkAdminSocksProxyImpl p2;
            host = COConfigurationManager.getStringParameter("Proxy.Data.Host");
            port = COConfigurationManager.getStringParameter("Proxy.Data.Port");
            user = COConfigurationManager.getStringParameter("Proxy.Data.Username");
            if (user.trim().equalsIgnoreCase("<none>")) {
                user = "";
            }
            if ((p2 = new NetworkAdminSocksProxyImpl(host, port, user, password = COConfigurationManager.getStringParameter("Proxy.Data.Password"))).isConfigured()) {
                res.add(p2);
            }
        }
        return res.toArray(new NetworkAdminSocksProxy[res.size()]);
    }

    public NetworkAdminHTTPProxy getHTTPProxy() {
        NetworkAdminHTTPProxyImpl res = new NetworkAdminHTTPProxyImpl();
        if (!res.isConfigured()) {
            res = null;
        }
        return res;
    }

    public NetworkAdminNATDevice[] getNATDevices() {
        ArrayList<NetworkAdminNATDeviceImpl> devices = new ArrayList<NetworkAdminNATDeviceImpl>();
        try {
            PluginInterface upnp_pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
            if (upnp_pi != null) {
                UPnPPlugin upnp = (UPnPPlugin)upnp_pi.getPlugin();
                UPnPPluginService[] services = upnp.getServices();
                for (int i = 0; i < services.length; ++i) {
                    devices.add(new NetworkAdminNATDeviceImpl(services[i]));
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return devices.toArray(new NetworkAdminNATDevice[devices.size()]);
    }

    public NetworkAdminASN getCurrentASN() {
        List asns = COConfigurationManager.getListParameter("ASN Details", new ArrayList());
        if (asns.size() == 0) {
            String as = "";
            String asn = "";
            String bgp = "";
            try {
                as = COConfigurationManager.getStringParameter("ASN AS");
                asn = COConfigurationManager.getStringParameter("ASN ASN");
                bgp = COConfigurationManager.getStringParameter("ASN BGP");
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            COConfigurationManager.removeParameter("ASN AS");
            COConfigurationManager.removeParameter("ASN ASN");
            COConfigurationManager.removeParameter("ASN BGP");
            COConfigurationManager.removeParameter("ASN Autocheck Performed Time");
            asns.add(this.ASNToMap(new NetworkAdminASNImpl(as, asn, bgp)));
            COConfigurationManager.setParameter("ASN Details", asns);
        }
        if (asns.size() > 0) {
            Map m = (Map)asns.get(0);
            return this.ASNFromMap(m);
        }
        return new NetworkAdminASNImpl("", "", "");
    }

    protected Map ASNToMap(NetworkAdminASNImpl x) {
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        byte[] as = new byte[]{};
        byte[] asn = new byte[]{};
        byte[] bgp = new byte[]{};
        try {
            as = x.getAS().getBytes("UTF-8");
            asn = x.getASName().getBytes("UTF-8");
            bgp = x.getBGPPrefix().getBytes("UTF-8");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        m.put("as", as);
        m.put("name", asn);
        m.put("bgp", bgp);
        return m;
    }

    protected NetworkAdminASNImpl ASNFromMap(Map m) {
        String as = "";
        String asn = "";
        String bgp = "";
        try {
            as = new String((byte[])m.get("as"), "UTF-8");
            asn = new String((byte[])m.get("name"), "UTF-8");
            bgp = new String((byte[])m.get("bgp"), "UTF-8");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return new NetworkAdminASNImpl(as, asn, bgp);
    }

    public NetworkAdminASN lookupCurrentASN(InetAddress address) throws NetworkAdminException {
        NetworkAdminASN current = this.getCurrentASN();
        if (current.matchesCIDR(address)) {
            return current;
        }
        List asns = COConfigurationManager.getListParameter("ASN Details", new ArrayList());
        for (int i = 0; i < asns.size(); ++i) {
            Map m = (Map)asns.get(i);
            NetworkAdminASNImpl x = this.ASNFromMap(m);
            if (!x.matchesCIDR(address)) continue;
            asns.remove(i);
            asns.add(0, m);
            this.firePropertyChange("AS");
            return x;
        }
        if (this.asn_ips_checked.contains(address)) {
            return current;
        }
        long now = SystemTime.getCurrentTime();
        if (now < this.last_asn_lookup_time || now - this.last_asn_lookup_time > 1800000L) {
            this.last_asn_lookup_time = now;
            NetworkAdminASNLookupImpl lookup = new NetworkAdminASNLookupImpl(address);
            NetworkAdminASNImpl x = lookup.lookup();
            this.asn_ips_checked.add(address);
            asns.add(0, this.ASNToMap(x));
            this.firePropertyChange("AS");
            return x;
        }
        return current;
    }

    public NetworkAdminASN lookupASN(InetAddress address) throws NetworkAdminException {
        NetworkAdminASN existing = this.getFromASHistory(address);
        if (existing != null) {
            return existing;
        }
        NetworkAdminASNLookupImpl lookup = new NetworkAdminASNLookupImpl(address);
        NetworkAdminASNImpl result = lookup.lookup();
        this.addToASHistory(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToASHistory(NetworkAdminASN asn) {
        List list = this.as_history;
        synchronized (list) {
            boolean found = false;
            for (int i = 0; i < this.as_history.size(); ++i) {
                NetworkAdminASN x = (NetworkAdminASN)this.as_history.get(i);
                if (asn.getAS() != x.getAS()) continue;
                found = true;
                break;
            }
            if (!found) {
                this.as_history.add(asn);
                if (this.as_history.size() > 256) {
                    this.as_history.remove(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NetworkAdminASN getFromASHistory(InetAddress address) {
        List list = this.as_history;
        synchronized (list) {
            for (int i = 0; i < this.as_history.size(); ++i) {
                NetworkAdminASN x = (NetworkAdminASN)this.as_history.get(i);
                if (!x.matchesCIDR(address)) continue;
                return x;
            }
        }
        return null;
    }

    public void runInitialChecks() {
        AZInstanceManager i_man = AzureusCoreFactory.getSingleton().getInstanceManager();
        final AZInstance my_instance = i_man.getMyInstance();
        i_man.addListener(new AZInstanceManagerListener(){
            private InetAddress external_address;

            public void instanceFound(AZInstance instance) {
            }

            public void instanceChanged(AZInstance instance) {
                if (instance == my_instance) {
                    InetAddress address = instance.getExternalAddress();
                    if (this.external_address == null || !this.external_address.equals(address)) {
                        this.external_address = address;
                        try {
                            NetworkAdminImpl.this.lookupCurrentASN(address);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            }

            public void instanceLost(AZInstance instance) {
            }

            public void instanceTracked(AZInstanceTracked instance) {
            }
        });
        if (COConfigurationManager.getBooleanParameter("Proxy.Check.On.Start")) {
            NetworkAdminSocksProxy[] socks = this.getSocksProxies();
            for (int i = 0; i < socks.length; ++i) {
                NetworkAdminSocksProxy sock = socks[i];
                try {
                    sock.getVersionsSupported();
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    Logger.log(new LogAlert(true, 1, "Socks proxy " + sock.getName() + " check failed: " + Debug.getNestedExceptionMessage(e)));
                }
            }
            NetworkAdminHTTPProxy http_proxy = this.getHTTPProxy();
            if (http_proxy != null) {
                try {
                    http_proxy.getDetails();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    Logger.log(new LogAlert(true, 1, "HTTP proxy " + http_proxy.getName() + " check failed: " + Debug.getNestedExceptionMessage(e)));
                }
            }
        }
        NetworkAdminSpeedTestScheduler nast = NetworkAdminSpeedTestSchedulerImpl.getInstance();
        nast.initialise();
    }

    public boolean canTraceRoute() {
        PlatformManager pm = PlatformManagerFactory.getPlatformManager();
        return pm.hasCapability(PlatformManagerCapabilities.TraceRouteAvailability);
    }

    public NetworkAdminNode[] getRoute(InetAddress interface_address, InetAddress target, final int max_millis, final NetworkAdminRouteListener listener) throws NetworkAdminException {
        PlatformManager pm = PlatformManagerFactory.getPlatformManager();
        if (!this.canTraceRoute()) {
            throw new NetworkAdminException("No trace-route capability on platform");
        }
        final ArrayList nodes = new ArrayList();
        try {
            pm.traceRoute(interface_address, target, new PlatformManagerPingCallback(){
                private long start_time = SystemTime.getCurrentTime();

                public boolean reportNode(int distance, InetAddress address, int millis) {
                    boolean timeout = false;
                    if (max_millis >= 0) {
                        long now = SystemTime.getCurrentTime();
                        if (now < this.start_time) {
                            this.start_time = now;
                        }
                        if (now - this.start_time >= (long)max_millis) {
                            timeout = true;
                        }
                    }
                    networkNode node = null;
                    if (address != null) {
                        node = new networkNode(address, distance, millis);
                        nodes.add(node);
                    }
                    boolean result = listener == null ? true : (node == null ? listener.timeout(distance) : listener.foundNode(node, distance, millis));
                    return result && !timeout;
                }
            });
        }
        catch (PlatformManagerException e) {
            throw new NetworkAdminException("trace-route failed", e);
        }
        return nodes.toArray(new NetworkAdminNode[nodes.size()]);
    }

    public boolean canPing() {
        PlatformManager pm = PlatformManagerFactory.getPlatformManager();
        return pm.hasCapability(PlatformManagerCapabilities.PingAvailability);
    }

    public NetworkAdminNode pingTarget(InetAddress interface_address, InetAddress target, final int max_millis, final NetworkAdminRouteListener listener) throws NetworkAdminException {
        PlatformManager pm = PlatformManagerFactory.getPlatformManager();
        if (!this.canPing()) {
            throw new NetworkAdminException("No ping capability on platform");
        }
        final NetworkAdminNode[] nodes = new NetworkAdminNode[]{null};
        try {
            pm.ping(interface_address, target, new PlatformManagerPingCallback(){
                private long start_time = SystemTime.getCurrentTime();

                public boolean reportNode(int distance, InetAddress address, int millis) {
                    boolean timeout = false;
                    if (max_millis >= 0) {
                        long now = SystemTime.getCurrentTime();
                        if (now < this.start_time) {
                            this.start_time = now;
                        }
                        if (now - this.start_time >= (long)max_millis) {
                            timeout = true;
                        }
                    }
                    networkNode node = null;
                    if (address != null) {
                        node = new networkNode(address, distance, millis);
                        nodes[0] = node;
                    }
                    boolean result = listener == null ? false : (node == null ? listener.timeout(distance) : listener.foundNode(node, distance, millis));
                    return result && !timeout;
                }
            });
        }
        catch (PlatformManagerException e) {
            throw new NetworkAdminException("ping failed", e);
        }
        return nodes[0];
    }

    public void getRoutes(final InetAddress target, int max_millis, final NetworkAdminRoutesListener listener) throws NetworkAdminException {
        int i;
        ArrayList<AESemaphore> sems = new ArrayList<AESemaphore>();
        ArrayList traces = new ArrayList();
        NetworkAdminNetworkInterface[] interfaces = this.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            NetworkAdminNetworkInterface interf = interfaces[i];
            NetworkAdminNetworkInterfaceAddress[] addresses = interf.getAddresses();
            for (int j = 0; j < addresses.length; ++j) {
                final NetworkAdminNetworkInterfaceAddress address = addresses[j];
                InetAddress ia = address.getAddress();
                if (ia.isLoopbackAddress() || ia instanceof Inet6Address) continue;
                final AESemaphore sem = new AESemaphore("parallelRouter");
                final ArrayList trace = new ArrayList();
                sems.add(sem);
                traces.add(trace);
                new AEThread2("parallelRouter", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            address.getRoute(target, 30000, new NetworkAdminRouteListener(){

                                public boolean foundNode(NetworkAdminNode node, int distance, int rtt) {
                                    trace.add(node);
                                    NetworkAdminNode[] route = new NetworkAdminNode[trace.size()];
                                    trace.toArray(route);
                                    return listener.foundNode(address, route, distance, rtt);
                                }

                                public boolean timeout(int distance) {
                                    NetworkAdminNode[] route = new NetworkAdminNode[trace.size()];
                                    trace.toArray(route);
                                    return listener.timeout(address, route, distance);
                                }
                            });
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        finally {
                            sem.release();
                        }
                    }
                }.start();
            }
        }
        for (i = 0; i < sems.size(); ++i) {
            ((AESemaphore)sems.get(i)).reserve();
        }
    }

    public void pingTargets(final InetAddress target, int max_millis, final NetworkAdminRoutesListener listener) throws NetworkAdminException {
        int i;
        ArrayList<AESemaphore> sems = new ArrayList<AESemaphore>();
        ArrayList traces = new ArrayList();
        NetworkAdminNetworkInterface[] interfaces = this.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            NetworkAdminNetworkInterface interf = interfaces[i];
            NetworkAdminNetworkInterfaceAddress[] addresses = interf.getAddresses();
            for (int j = 0; j < addresses.length; ++j) {
                final NetworkAdminNetworkInterfaceAddress address = addresses[j];
                InetAddress ia = address.getAddress();
                if (ia.isLoopbackAddress() || ia instanceof Inet6Address) continue;
                final AESemaphore sem = new AESemaphore("parallelPinger");
                final ArrayList trace = new ArrayList();
                sems.add(sem);
                traces.add(trace);
                new AEThread2("parallelPinger", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            address.pingTarget(target, 30000, new NetworkAdminRouteListener(){

                                public boolean foundNode(NetworkAdminNode node, int distance, int rtt) {
                                    trace.add(node);
                                    NetworkAdminNode[] route = new NetworkAdminNode[trace.size()];
                                    trace.toArray(route);
                                    return listener.foundNode(address, route, distance, rtt);
                                }

                                public boolean timeout(int distance) {
                                    NetworkAdminNode[] route = new NetworkAdminNode[trace.size()];
                                    trace.toArray(route);
                                    return listener.timeout(address, route, distance);
                                }
                            });
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        finally {
                            sem.release();
                        }
                    }
                }.start();
            }
        }
        for (i = 0; i < sems.size(); ++i) {
            ((AESemaphore)sems.get(i)).reserve();
        }
    }

    public void addPropertyChangeListener(NetworkAdminPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void addAndFirePropertyChangeListener(NetworkAdminPropertyChangeListener listener) {
        this.listeners.add(listener);
        for (int i = 0; i < NetworkAdmin.PR_NAMES.length; ++i) {
            try {
                listener.propertyChanged(PR_NAMES[i]);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void removePropertyChangeListener(NetworkAdminPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("Network Admin");
        try {
            writer.indent();
            NetworkAdminHTTPProxy proxy = this.getHTTPProxy();
            if (proxy == null) {
                writer.println("HTTP proxy: none");
            } else {
                writer.println("HTTP proxy: " + proxy.getName());
                try {
                    NetworkAdminHTTPProxy.Details details = proxy.getDetails();
                    writer.println("    name: " + details.getServerName());
                    writer.println("    resp: " + details.getResponse());
                    writer.println("    auth: " + details.getAuthenticationType());
                }
                catch (NetworkAdminException e) {
                    writer.println("    failed: " + e.getLocalizedMessage());
                }
            }
            NetworkAdminSocksProxy[] socks = this.getSocksProxies();
            if (socks.length == 0) {
                writer.println("Socks proxy: none");
            } else {
                for (int i = 0; i < socks.length; ++i) {
                    NetworkAdminSocksProxy sock = socks[i];
                    writer.println("Socks proxy: " + sock.getName());
                    try {
                        String[] versions = sock.getVersionsSupported();
                        String str = "";
                        for (int j = 0; j < versions.length; ++j) {
                            str = str + (j == 0 ? "" : ",") + versions[j];
                        }
                        writer.println("   version: " + str);
                        continue;
                    }
                    catch (NetworkAdminException e) {
                        writer.println("    failed: " + e.getLocalizedMessage());
                    }
                }
            }
            NetworkAdminNATDevice[] nat_devices = this.getNATDevices();
            writer.println("NAT Devices: " + nat_devices.length);
            for (int i = 0; i < nat_devices.length; ++i) {
                NetworkAdminNATDevice device = nat_devices[i];
                writer.println("    " + device.getName() + ",address=" + device.getAddress().getHostAddress() + ":" + device.getPort() + ",ext=" + device.getExternalAddress());
            }
            writer.println("Interfaces");
            writer.println("   " + this.getNetworkInterfacesAsString());
        }
        finally {
            writer.exdent();
        }
    }

    public void generateDiagnostics(final IndentWriter iw) {
        InetAddress ext_addr;
        int i;
        HashSet<InetAddress> public_addresses = new HashSet<InetAddress>();
        NetworkAdminHTTPProxy proxy = this.getHTTPProxy();
        if (proxy == null) {
            iw.println("HTTP proxy: none");
        } else {
            iw.println("HTTP proxy: " + proxy.getName());
            try {
                NetworkAdminHTTPProxy.Details details = proxy.getDetails();
                iw.println("    name: " + details.getServerName());
                iw.println("    resp: " + details.getResponse());
                iw.println("    auth: " + details.getAuthenticationType());
            }
            catch (NetworkAdminException e) {
                iw.println("    failed: " + e.getLocalizedMessage());
            }
        }
        NetworkAdminSocksProxy[] socks = this.getSocksProxies();
        if (socks.length == 0) {
            iw.println("Socks proxy: none");
        } else {
            for (int i2 = 0; i2 < socks.length; ++i2) {
                NetworkAdminSocksProxy sock = socks[i2];
                iw.println("Socks proxy: " + sock.getName());
                try {
                    String[] versions = sock.getVersionsSupported();
                    String str = "";
                    for (int j = 0; j < versions.length; ++j) {
                        str = str + (j == 0 ? "" : ",") + versions[j];
                    }
                    iw.println("   version: " + str);
                    continue;
                }
                catch (NetworkAdminException e) {
                    iw.println("    failed: " + e.getLocalizedMessage());
                }
            }
        }
        NetworkAdminNATDevice[] nat_devices = this.getNATDevices();
        iw.println("NAT Devices: " + nat_devices.length);
        for (int i3 = 0; i3 < nat_devices.length; ++i3) {
            NetworkAdminNATDevice device = nat_devices[i3];
            iw.println("    " + device.getName() + ",address=" + device.getAddress().getHostAddress() + ":" + device.getPort() + ",ext=" + device.getExternalAddress());
            public_addresses.add(device.getExternalAddress());
        }
        iw.println("Interfaces");
        NetworkAdminNetworkInterface[] interfaces = this.getInterfaces();
        try {
            this.pingTargets(InetAddress.getByName("www.google.com"), 30000, new NetworkAdminRoutesListener(){
                private int timeouts = 0;

                public boolean foundNode(NetworkAdminNetworkInterfaceAddress intf, NetworkAdminNode[] route, int distance, int rtt) {
                    iw.println(intf.getAddress().getHostAddress() + ": " + route[route.length - 1].getAddress().getHostAddress() + " (" + distance + ")");
                    return false;
                }

                public boolean timeout(NetworkAdminNetworkInterfaceAddress intf, NetworkAdminNode[] route, int distance) {
                    iw.println(intf.getAddress().getHostAddress() + ": timeout (dist=" + distance + ")");
                    ++this.timeouts;
                    return this.timeouts < 3;
                }
            });
        }
        catch (Throwable e) {
            iw.println("getRoutes failed: " + Debug.getNestedExceptionMessage(e));
        }
        iw.println("Inbound protocols: default routing");
        NetworkAdminProtocol[] protocols = this.getInboundProtocols();
        for (i = 0; i < protocols.length; ++i) {
            NetworkAdminProtocol protocol = protocols[i];
            try {
                ext_addr = this.testProtocol(protocol);
                if (ext_addr != null) {
                    public_addresses.add(ext_addr);
                }
                iw.println("    " + protocol.getName() + " - " + ext_addr);
                continue;
            }
            catch (NetworkAdminException e) {
                iw.println("    " + protocol.getName() + " - " + Debug.getNestedExceptionMessage(e));
            }
        }
        iw.println("Outbound protocols: default routing");
        protocols = this.getOutboundProtocols();
        for (i = 0; i < protocols.length; ++i) {
            NetworkAdminProtocol protocol = protocols[i];
            try {
                ext_addr = this.testProtocol(protocol);
                if (ext_addr != null) {
                    public_addresses.add(ext_addr);
                }
                iw.println("    " + protocol.getName() + " - " + ext_addr);
                continue;
            }
            catch (NetworkAdminException e) {
                iw.println("    " + protocol.getName() + " - " + Debug.getNestedExceptionMessage(e));
            }
        }
        Iterator it = public_addresses.iterator();
        iw.println("Public Addresses");
        while (it.hasNext()) {
            InetAddress pub_address = (InetAddress)it.next();
            try {
                NetworkAdminASN res = this.lookupCurrentASN(pub_address);
                iw.println("    " + pub_address.getHostAddress() + " -> " + res.getAS() + "/" + res.getASName());
            }
            catch (Throwable e) {
                iw.println("    " + pub_address.getHostAddress() + " -> " + Debug.getNestedExceptionMessage(e));
            }
        }
    }

    protected void generateDiagnostics(IndentWriter iw, NetworkAdminProtocol[] protocols) {
        for (int i = 0; i < protocols.length; ++i) {
            NetworkAdminProtocol protocol = protocols[i];
            iw.println("Testing " + protocol.getName());
            try {
                InetAddress ext_addr = this.testProtocol(protocol);
                iw.println("    -> OK, public address=" + ext_addr);
                continue;
            }
            catch (NetworkAdminException e) {
                iw.println("    -> Failed: " + Debug.getNestedExceptionMessage(e));
            }
        }
    }

    public void logNATStatus(IndentWriter iw) {
        this.generateDiagnostics(iw, this.getInboundProtocols());
    }

    public static void main(String[] args) {
        boolean TEST_SOCKS_PROXY = false;
        boolean TEST_HTTP_PROXY = false;
        try {
            if (TEST_SOCKS_PROXY) {
                AESocksProxy proxy = AESocksProxyFactory.create(4567, 10000L, 10000L);
                proxy.setAllowExternalConnections(true);
                System.setProperty("socksProxyHost", "localhost");
                System.setProperty("socksProxyPort", "4567");
            }
            if (TEST_HTTP_PROXY) {
                System.setProperty("http.proxyHost", "localhost");
                System.setProperty("http.proxyPort", "3128");
                System.setProperty("https.proxyHost", "localhost");
                System.setProperty("https.proxyPort", "3128");
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication("fred", "bill".toCharArray());
                    }
                });
            }
            IndentWriter iw = new IndentWriter(new PrintWriter(System.out));
            iw.setForce(true);
            COConfigurationManager.initialise();
            AzureusCoreFactory.create();
            NetworkAdmin admin = NetworkAdminImpl.getSingleton();
            admin.generateDiagnostics(iw);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            anyLocalAddressIPv4 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
            anyLocalAddressIPv6 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
            localhostV4 = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            localhostV6 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    protected class networkNode
    implements NetworkAdminNode {
        private InetAddress address;
        private int distance;
        private int rtt;

        protected networkNode(InetAddress _address, int _distance, int _millis) {
            this.address = _address;
            this.distance = _distance;
            this.rtt = _millis;
        }

        public InetAddress getAddress() {
            return this.address;
        }

        public boolean isLocalAddress() {
            return this.address.isLinkLocalAddress() || this.address.isSiteLocalAddress();
        }

        public int getDistance() {
            return this.distance;
        }

        public int getRTT() {
            return this.rtt;
        }

        protected String getString() {
            if (this.address == null) {
                return "" + this.distance;
            }
            return this.distance + "," + this.address + "[local=" + this.isLocalAddress() + "]," + this.rtt;
        }
    }

    protected class networkInterface
    implements NetworkAdminNetworkInterface {
        private NetworkInterface ni;

        protected networkInterface(NetworkInterface _ni) {
            this.ni = _ni;
        }

        public String getDisplayName() {
            return this.ni.getDisplayName();
        }

        public String getName() {
            return this.ni.getName();
        }

        public NetworkAdminNetworkInterfaceAddress[] getAddresses() {
            Enumeration<InetAddress> e = this.ni.getInetAddresses();
            ArrayList<networkAddress> addresses = new ArrayList<networkAddress>();
            while (e.hasMoreElements()) {
                addresses.add(new networkAddress(e.nextElement()));
            }
            return addresses.toArray(new NetworkAdminNetworkInterfaceAddress[addresses.size()]);
        }

        public String getString() {
            String str = this.getDisplayName() + "/" + this.getName() + " [";
            NetworkAdminNetworkInterfaceAddress[] addresses = this.getAddresses();
            for (int i = 0; i < addresses.length; ++i) {
                networkAddress addr = (networkAddress)addresses[i];
                str = str + (i == 0 ? "" : ",") + addr.getAddress().getHostAddress();
            }
            return str + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generateDiagnostics(IndentWriter iw, Set public_addresses) {
            iw.println(this.getDisplayName() + "/" + this.getName());
            NetworkAdminNetworkInterfaceAddress[] addresses = this.getAddresses();
            for (int i = 0; i < addresses.length; ++i) {
                networkAddress addr = (networkAddress)addresses[i];
                iw.indent();
                try {
                    addr.generateDiagnostics(iw, public_addresses);
                    continue;
                }
                finally {
                    iw.exdent();
                }
            }
        }

        protected class networkAddress
        implements NetworkAdminNetworkInterfaceAddress {
            private InetAddress address;

            protected networkAddress(InetAddress _address) {
                this.address = _address;
            }

            public NetworkAdminNetworkInterface getInterface() {
                return networkInterface.this;
            }

            public InetAddress getAddress() {
                return this.address;
            }

            public boolean isLoopback() {
                return this.address.isLoopbackAddress();
            }

            public NetworkAdminNode[] getRoute(InetAddress target, int max_millis, NetworkAdminRouteListener listener) throws NetworkAdminException {
                return NetworkAdminImpl.this.getRoute(this.address, target, max_millis, listener);
            }

            public NetworkAdminNode pingTarget(InetAddress target, int max_millis, NetworkAdminRouteListener listener) throws NetworkAdminException {
                return NetworkAdminImpl.this.pingTarget(this.address, target, max_millis, listener);
            }

            public InetAddress testProtocol(NetworkAdminProtocol protocol) throws NetworkAdminException {
                return protocol.test(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void generateDiagnostics(IndentWriter iw, Set public_addresses) {
                block15: {
                    iw.println("" + this.getAddress());
                    try {
                        InetAddress res;
                        NetworkAdminProtocol protocol;
                        int i;
                        iw.println("  Trace route");
                        iw.indent();
                        if (this.isLoopback()) {
                            iw.println("Loopback - ignoring");
                            break block15;
                        }
                        try {
                            NetworkAdminNode[] nodes = this.getRoute(InetAddress.getByName("www.google.com"), 30000, NetworkAdminImpl.this.trace_route_listener);
                            for (i = 0; i < nodes.length; ++i) {
                                networkNode node = (networkNode)nodes[i];
                                iw.println(node.getString());
                            }
                        }
                        catch (Throwable e) {
                            iw.println("Can't resolve host for route trace - " + e.getMessage());
                        }
                        iw.println("Outbound protocols: bound");
                        NetworkAdminProtocol[] protocols = NetworkAdminImpl.this.getOutboundProtocols();
                        for (i = 0; i < protocols.length; ++i) {
                            protocol = protocols[i];
                            try {
                                res = this.testProtocol(protocol);
                                if (res != null) {
                                    public_addresses.add(res);
                                }
                                iw.println("    " + protocol.getName() + " - " + res);
                                continue;
                            }
                            catch (NetworkAdminException e) {
                                iw.println("    " + protocol.getName() + " - " + Debug.getNestedExceptionMessage(e));
                            }
                        }
                        iw.println("Inbound protocols: bound");
                        protocols = NetworkAdminImpl.this.getInboundProtocols();
                        for (i = 0; i < protocols.length; ++i) {
                            protocol = protocols[i];
                            try {
                                res = this.testProtocol(protocol);
                                if (res != null) {
                                    public_addresses.add(res);
                                }
                                iw.println("    " + protocol.getName() + " - " + res);
                                continue;
                            }
                            catch (NetworkAdminException e) {
                                iw.println("    " + protocol.getName() + " - " + Debug.getNestedExceptionMessage(e));
                            }
                        }
                    }
                    finally {
                        iw.exdent();
                    }
                }
            }
        }
    }
}

