/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.http;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessageDecoder;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkConnection;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkManager;
import com.aelitis.azureus.core.util.HTTPUtils;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;

public class HTTPNetworkConnectionFile
extends HTTPNetworkConnection {
    protected HTTPNetworkConnectionFile(HTTPNetworkManager _manager, NetworkConnection _connection, PEPeerTransport _peer) {
        super(_manager, _connection, _peer);
    }

    protected void decodeHeader(HTTPMessageDecoder decoder, String header) throws IOException {
        boolean partial_content;
        if (!this.isSeed()) {
            return;
        }
        DiskManager dm = this.getPeerControl().getDiskManager();
        if (dm == null) {
            Debug.out("Disk manager is null");
            throw new IOException("Disk manager unavailable");
        }
        TOTorrent to_torrent = dm.getTorrent();
        char[] chars = header.toCharArray();
        int last_pos = 0;
        int line_num = 0;
        String target_str = null;
        DiskManagerFileInfo target_file = null;
        long file_offset = 0L;
        ArrayList<long[]> ranges = new ArrayList<long[]>();
        boolean keep_alive = false;
        block4: for (int i = 1; i < chars.length; ++i) {
            if (chars[i - 1] != '\r' || chars[i] != '\n') continue;
            String line = new String(chars, last_pos, i - last_pos).trim();
            last_pos = i;
            if (++line_num == 1) {
                String file;
                line = line.substring(line.indexOf("files/") + 6);
                line = line.substring(line.indexOf("/") + 1);
                target_str = file = (line = line.substring(0, line.lastIndexOf(32)));
                StringTokenizer tok = new StringTokenizer(file, "/");
                ArrayList<byte[]> bits = new ArrayList<byte[]>();
                while (tok.hasMoreTokens()) {
                    bits.add(URLDecoder.decode(tok.nextToken(), "ISO-8859-1").getBytes("ISO-8859-1"));
                }
                if (!to_torrent.isSimpleTorrent() && bits.size() > 1 && Arrays.equals(to_torrent.getName(), (byte[])bits.get(0))) {
                    bits.remove(0);
                }
                DiskManagerFileInfo[] files = dm.getFiles();
                file_offset = 0L;
                for (int j = 0; j < files.length; ++j) {
                    TOTorrentFile torrent_file = files[j].getTorrentFile();
                    byte[][] comps = torrent_file.getPathComponents();
                    if (comps.length == bits.size()) {
                        boolean match = true;
                        for (int k = 0; k < comps.length; ++k) {
                            if (Arrays.equals(comps[k], (byte[])bits.get(k))) continue;
                            match = false;
                            break;
                        }
                        if (match) {
                            target_file = files[j];
                            continue block4;
                        }
                    }
                    file_offset += torrent_file.getLength();
                }
                continue;
            }
            if ((line = line.toLowerCase()).startsWith("range") && target_file != null) {
                if (!(line = line.substring(5).trim()).startsWith(":")) continue;
                String range_str = line.substring(1).trim();
                if (range_str.startsWith("bytes=")) {
                    long file_length = target_file.getLength();
                    StringTokenizer tok2 = new StringTokenizer(range_str.substring(6), ",");
                    while (tok2.hasMoreTokens()) {
                        String range = tok2.nextToken();
                        try {
                            long start;
                            long end;
                            int pos = range.indexOf(45);
                            if (pos == -1) continue;
                            String lhs = range.substring(0, pos);
                            String rhs = range.substring(pos + 1);
                            if (lhs.length() == 0) {
                                end = file_length - 1L;
                                start = file_length - Long.parseLong(rhs);
                            } else if (rhs.length() == 0) {
                                end = file_length - 1L;
                                start = Long.parseLong(lhs);
                            } else {
                                start = Long.parseLong(lhs);
                                end = Long.parseLong(rhs);
                            }
                            ranges.add(new long[]{start, end});
                        }
                        catch (Throwable e) {}
                    }
                }
                if (ranges.size() != 0) continue;
                this.log("Invalid range specification: '" + line + "'");
                this.sendAndClose(this.getManager().getRangeNotSatisfiable());
                return;
            }
            if (line.indexOf("keep-alive") == -1) continue;
            keep_alive = true;
        }
        if (target_file == null) {
            this.log("Failed to find file '" + target_str + "'");
            this.sendAndClose(this.getManager().getNotFound());
            return;
        }
        try {
            String name = target_file.getFile(true).getName();
            int pos = name.lastIndexOf(".");
            if (pos != -1) {
                this.setContentType(HTTPUtils.guessContentTypeFromFileType(name.substring(pos + 1)));
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        long file_length = target_file.getLength();
        boolean bl = partial_content = ranges.size() > 0;
        if (!partial_content) {
            ranges.add(new long[]{0L, file_length - 1L});
        }
        long[] offsets = new long[ranges.size()];
        long[] lengths = new long[ranges.size()];
        for (int i = 0; i < ranges.size(); ++i) {
            long[] range = (long[])ranges.get(i);
            long start = range[0];
            long end = range[1];
            if (start < 0L || start >= file_length || end < 0L || end >= file_length || start > end) {
                this.log("Invalid range specification: '" + start + "-" + end + "'");
                this.sendAndClose(this.getManager().getRangeNotSatisfiable());
                return;
            }
            offsets[i] = file_offset + start;
            lengths[i] = end - start + 1L;
        }
        this.addRequest(new HTTPNetworkConnection.httpRequest(offsets, lengths, partial_content, keep_alive));
    }
}

