/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.LTMessage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class LTHandshake
implements LTMessage {
    private Map data_dict;
    private byte[] bencoded_data;
    private String bencoded_string;
    private String description;
    private byte version;
    private DirectByteBuffer[] buffer_array;

    public LTHandshake(Map data_dict, byte version) {
        this.data_dict = data_dict == null ? Collections.EMPTY_MAP : data_dict;
        this.version = version;
    }

    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (data.remaining((byte)11) < 1) {
            throw new MessageException("[" + this.getID() + "] decode error: less than 1 byte in payload");
        }
        Map res_data_dict = MessagingUtil.convertBencodedByteStreamToPayload(data, 1, this.getID());
        LTHandshake result = new LTHandshake(res_data_dict, this.version);
        return result;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer_array == null) {
            DirectByteBuffer buffer;
            this.buffer_array = new DirectByteBuffer[1];
            this.buffer_array[0] = buffer = DirectByteBufferPool.getBuffer((byte)28, this.getBencodedData().length);
            buffer.put((byte)11, this.getBencodedData());
            buffer.flip((byte)11);
        }
        return this.buffer_array;
    }

    public void destroy() {
        this.data_dict = null;
        this.bencoded_data = null;
        this.description = null;
        if (this.buffer_array != null) {
            this.buffer_array[0].returnToPool();
        }
        this.buffer_array = null;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "lt_handshake".toUpperCase() + ": " + this.getBencodedString();
        }
        return this.description;
    }

    public String getBencodedString() {
        if (this.bencoded_string == null) {
            try {
                this.bencoded_string = new String(this.getBencodedData(), "ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                this.bencoded_string = "";
                Debug.printStackTrace(uee);
            }
        }
        return this.bencoded_string;
    }

    public byte[] getBencodedData() {
        if (this.bencoded_data == null) {
            try {
                this.bencoded_data = BEncoder.encode(this.data_dict);
            }
            catch (IOException ioe) {
                this.bencoded_data = new byte[0];
                Debug.printStackTrace(ioe);
            }
        }
        return this.bencoded_data;
    }

    public Map getDataMap() {
        return this.data_dict;
    }

    public String getClientName() {
        byte[] client_name = (byte[])this.data_dict.get("v");
        if (client_name == null) {
            return null;
        }
        try {
            return new String(client_name, "UTF8");
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public boolean isUploadOnly() {
        Long ulOnly = (Long)this.data_dict.get("upload_only");
        return ulOnly != null && ulOnly > 0L;
    }

    public int getTCPListeningPort() {
        Long port = (Long)this.data_dict.get("p");
        if (port == null) {
            return 0;
        }
        int val = port.intValue();
        if (val <= 65535 && val > 0) {
            return val;
        }
        return 0;
    }

    public Boolean isCryptoRequested() {
        Long crypto = (Long)this.data_dict.get("e");
        if (crypto == null) {
            return null;
        }
        return crypto == 1L;
    }

    public Map getExtensionMapping() {
        Map result = (Map)this.data_dict.get("m");
        return result == null ? Collections.EMPTY_MAP : result;
    }

    public String getFeatureID() {
        return "LT1";
    }

    public int getFeatureSubID() {
        return 0;
    }

    public String getID() {
        return "lt_handshake";
    }

    public byte[] getIDBytes() {
        return ID_LT_HANDSHAKE_BYTES;
    }

    public int getType() {
        return 0;
    }

    public byte getVersion() {
        return this.version;
    }
}

