/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.speedmanager.impl.v2.LimitControl;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMConst;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMUpdate;
import com.aelitis.azureus.core.speedmanager.impl.v2.SaturatedMode;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerLogger;
import com.aelitis.azureus.core.speedmanager.impl.v2.TransferMode;

public class LimitControlDropUploadFirst
implements LimitControl {
    private float valueUp = 0.5f;
    int upMax;
    int upCurr;
    int upMin;
    SaturatedMode upUsage;
    private float valueDown = 1.0f;
    int downMax;
    int downCurr;
    int downMin;
    SaturatedMode downUsage;
    TransferMode mode;
    float usedUpMaxDownloadMode = 0.6f;
    boolean isDownloadUnlimited = false;

    public void updateStatus(int currUpLimit, SaturatedMode uploadUsage, int currDownLimit, SaturatedMode downloadUsage, TransferMode transferMode) {
        this.upCurr = currUpLimit;
        this.upUsage = uploadUsage;
        this.downCurr = currDownLimit;
        this.downUsage = downloadUsage;
        this.mode = transferMode;
    }

    public void setDownloadUnlimitedMode(boolean isUnlimited) {
        this.isDownloadUnlimited = isUnlimited;
        if (isUnlimited) {
            this.valueDown = 1.0f;
        }
    }

    public boolean isDownloadUnlimitedMode() {
        return this.isDownloadUnlimited;
    }

    public void updateLimits(int _upMax, int _upMin, int _downMax, int _downMin) {
        if (_upMax < 30720) {
            _upMax = 30720;
        }
        if (_downMax < 61440) {
            _downMax = 61440;
        }
        if (_downMax < _upMax) {
            _downMax = _upMax;
        }
        _upMin = SMConst.calculateMinUpload(_upMax);
        _downMin = SMConst.calculateMinDownload(_downMax);
        this.upMax = _upMax;
        this.upMin = _upMin;
        this.downMax = _downMax;
        this.downMin = _downMin;
    }

    private int usedUploadCapacity() {
        float usedUpMax = this.upMax;
        if (this.mode.getMode() == TransferMode.State.SEEDING) {
            usedUpMax = this.upMax;
        } else if (this.mode.getMode() == TransferMode.State.DOWNLOADING) {
            usedUpMax = (float)this.upMax * this.usedUpMaxDownloadMode;
        } else if (this.mode.getMode() == TransferMode.State.DOWNLOAD_LIMIT_SEARCH) {
            usedUpMax = (float)this.upMax * this.usedUpMaxDownloadMode;
        } else if (this.mode.getMode() == TransferMode.State.UPLOAD_LIMIT_SEARCH) {
            usedUpMax = this.upMax;
        } else {
            SpeedManagerLogger.trace("LimitControlDropUploadFirst -> unrecognized transfer mode. ");
        }
        return Math.round(usedUpMax);
    }

    public void updateSeedSettings(float downloadModeUsed) {
        if (downloadModeUsed < 1.0f && downloadModeUsed > 0.1f) {
            this.usedUpMaxDownloadMode = downloadModeUsed;
            SpeedManagerLogger.trace("LimitControlDropUploadFirst %used upload used while downloading: " + downloadModeUsed);
        }
    }

    public SMUpdate adjust(float amount) {
        boolean increase = true;
        if (amount < 0.0f) {
            increase = false;
        }
        float factor = amount / 10.0f;
        int usedUpMax = this.usedUploadCapacity();
        float gamma = (float)usedUpMax / (float)this.downMax;
        if (increase) {
            if (this.valueDown < 0.99f) {
                this.valueDown = this.calculateNewValue(this.valueDown, factor);
            } else if (this.upUsage == SaturatedMode.AT_LIMIT) {
                this.valueUp = this.calculateNewValue(this.valueUp, gamma * 0.5f * factor);
            }
        } else if (this.valueUp > 0.01f) {
            this.valueUp = this.calculateNewValue(this.valueUp, gamma * factor);
        } else {
            this.valueDown = this.calculateNewValue(this.valueDown, factor);
        }
        return this.update();
    }

    private SMUpdate update() {
        int usedUpMax = this.usedUploadCapacity();
        int upLimit = Math.round((float)(usedUpMax - this.upMin) * this.valueUp + (float)this.upMin);
        if (upLimit > this.upMax || Float.isNaN(this.valueUp)) {
            SpeedManagerLogger.trace("Limit - should upload have an unlimited condition? Setting to usedUpMax");
            upLimit = usedUpMax;
        }
        int downLimit = this.isDownloadUnlimited ? 0 : Math.round((float)(this.downMax - this.downMin) * this.valueDown + (float)this.downMin);
        if ((double)this.valueDown == 1.0) {
            downLimit = 0;
        }
        StringBuffer msg = new StringBuffer(" create-update: valueUp=" + this.valueUp + ",upLimit=" + upLimit + ",valueDown=");
        if ((double)this.valueDown == 1.0) {
            msg.append("_unlimited_");
        } else {
            msg.append(this.valueDown);
        }
        msg.append(",downLimit=" + downLimit + ",upMax=" + this.upMax + ",usedUpMax=" + usedUpMax + ",upMin=" + this.upMin + ",downMax=" + this.downMax);
        msg.append(",downMin=" + this.downMin + ",transferMode=" + this.mode.getString() + ",isDownUnlimited=" + this.isDownloadUnlimited);
        SpeedManagerLogger.log(msg.toString());
        return new SMUpdate(upLimit, true, downLimit, true);
    }

    private float calculateNewValue(float curr, float amount) {
        if (Float.isNaN(curr)) {
            SpeedManagerLogger.trace("calculateNewValue - curr=NaN");
        }
        if (Float.isNaN(amount)) {
            SpeedManagerLogger.trace("calculateNewValue = amount=NaN");
        }
        if ((curr += amount) > 1.0f) {
            curr = 1.0f;
        }
        if (curr < 0.0f) {
            curr = 0.0f;
        }
        if (Float.isNaN(curr)) {
            curr = 0.0f;
        }
        return curr;
    }
}

