/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionHistory;
import com.aelitis.azureus.core.subs.SubscriptionResult;
import com.aelitis.azureus.core.subs.impl.SubscriptionImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionManagerImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionResultImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.SystemTime;

public class SubscriptionHistoryImpl
implements SubscriptionHistory {
    private SubscriptionManagerImpl manager;
    private SubscriptionImpl subs;
    private boolean enabled;
    private boolean auto_dl;
    private long last_scan;
    private long last_new_result;
    private int num_unread;
    private int num_read;
    private String last_error;
    private boolean auth_failed;

    protected SubscriptionHistoryImpl(SubscriptionManagerImpl _manager, SubscriptionImpl _subs) {
        this.manager = _manager;
        this.subs = _subs;
        this.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SubscriptionResultImpl[] reconcileResults(SubscriptionResultImpl[] latest_results) {
        SubscriptionResultImpl[] result;
        int new_unread = 0;
        int new_read = 0;
        if (this.last_scan == 0L) {
            for (int i = 0; i < latest_results.length; ++i) {
                latest_results[i].setReadInternal(true);
            }
        }
        long now = SystemTime.getCurrentTime();
        int max_results = this.manager.getMaxNonDeletedResults();
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            SubscriptionResultImpl r;
            int i;
            boolean got_new_or_changed_result = false;
            SubscriptionResultImpl[] existing_results = this.manager.loadResults(this.subs);
            ByteArrayHashMap result_key_map = new ByteArrayHashMap();
            ByteArrayHashMap result_key2_map = new ByteArrayHashMap();
            ArrayList<SubscriptionResultImpl> new_results = new ArrayList<SubscriptionResultImpl>();
            for (i = 0; i < existing_results.length; ++i) {
                r = existing_results[i];
                result_key_map.put(r.getKey1(), r);
                byte[] key2 = r.getKey2();
                if (key2 != null) {
                    result_key2_map.put(key2, r);
                }
                new_results.add(r);
                if (r.isDeleted()) continue;
                if (r.getRead()) {
                    ++new_read;
                    continue;
                }
                ++new_unread;
            }
            for (i = 0; i < latest_results.length; ++i) {
                byte[] key2;
                r = latest_results[i];
                SubscriptionResultImpl existing = (SubscriptionResultImpl)result_key_map.get(r.getKey1());
                if (existing == null && (key2 = r.getKey2()) != null) {
                    existing = (SubscriptionResultImpl)result_key2_map.get(key2);
                }
                if (existing == null) {
                    this.last_new_result = now;
                    new_results.add(r);
                    result_key_map.put(r.getKey1(), r);
                    key2 = r.getKey2();
                    if (key2 != null) {
                        result_key2_map.put(key2, r);
                    }
                    got_new_or_changed_result = true;
                    if (r.getRead()) {
                        ++new_read;
                        continue;
                    }
                    ++new_unread;
                    continue;
                }
                if (!existing.updateFrom(r)) continue;
                got_new_or_changed_result = true;
            }
            if (max_results > 0 && new_unread + new_read > max_results) {
                for (i = 0; i < new_results.size(); ++i) {
                    r = (SubscriptionResultImpl)new_results.get(i);
                    if (r.isDeleted()) continue;
                    if (r.getRead()) {
                        --new_read;
                    } else {
                        --new_unread;
                    }
                    r.deleteInternal();
                    got_new_or_changed_result = true;
                    if (new_unread + new_read <= max_results) break;
                }
            }
            if (got_new_or_changed_result) {
                result = new_results.toArray(new SubscriptionResultImpl[new_results.size()]);
                this.manager.saveResults(this.subs, result);
            } else {
                result = existing_results;
            }
            this.last_scan = now;
            this.num_unread = new_unread;
            this.num_read = new_read;
        }
        this.saveConfig();
        return result;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean _enabled) {
        if (_enabled != this.enabled) {
            this.enabled = _enabled;
            this.saveConfig();
        }
    }

    public boolean isAutoDownload() {
        return this.auto_dl;
    }

    public void setAutoDownload(boolean _auto_dl) {
        if (_auto_dl != this.auto_dl) {
            this.auto_dl = _auto_dl;
            this.saveConfig();
            if (this.auto_dl) {
                this.downloadNow();
            }
        }
    }

    public void setDetails(boolean _enabled, boolean _auto_dl) {
        if (this.enabled != _enabled || this.auto_dl != _auto_dl) {
            this.enabled = _enabled;
            this.auto_dl = _auto_dl;
            this.saveConfig();
            if (this.enabled && this.auto_dl) {
                this.downloadNow();
            }
        }
    }

    protected void downloadNow() {
        try {
            this.subs.getManager().getScheduler().downloadAsync(this.subs, false);
        }
        catch (Throwable e) {
            this.log("Failed to initiate download", e);
        }
    }

    public long getLastScanTime() {
        return this.last_scan;
    }

    public long getLastNewResultTime() {
        return this.last_new_result;
    }

    public long getNextScanTime() {
        Map schedule = this.subs.getScheduleConfig();
        if (schedule.size() == 0) {
            this.log("Schedule is empty!");
            return Long.MAX_VALUE;
        }
        try {
            long interval_min = (Long)schedule.get("interval");
            return this.last_scan + interval_min * 60L * 1000L;
        }
        catch (Throwable e) {
            this.log("Failed to decode schedule " + schedule, e);
            return Long.MAX_VALUE;
        }
    }

    public int getCheckFrequencyMins() {
        Map schedule = this.subs.getScheduleConfig();
        if (schedule.size() == 0) {
            return 120;
        }
        try {
            int interval_min = ((Long)schedule.get("interval")).intValue();
            return interval_min;
        }
        catch (Throwable e) {
            return 120;
        }
    }

    public int getNumUnread() {
        return this.num_unread;
    }

    public int getNumRead() {
        return this.num_read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriptionResult[] getResults(boolean include_deleted) {
        SubscriptionResult[] results;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            results = this.manager.loadResults(this.subs);
        }
        if (include_deleted) {
            return results;
        }
        ArrayList<SubscriptionResult> l = new ArrayList<SubscriptionResult>(results.length);
        for (int i = 0; i < results.length; ++i) {
            if (results[i].isDeleted()) continue;
            l.add(results[i]);
        }
        return l.toArray(new SubscriptionResult[l.size()]);
    }

    public SubscriptionResult getResult(String result_id) {
        SubscriptionResult[] results = this.getResults(true);
        for (int i = 0; i < results.length; ++i) {
            if (!results[i].getID().equals(result_id)) continue;
            return results[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateResult(SubscriptionResultImpl result) {
        byte[] key = result.getKey1();
        boolean changed = false;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            SubscriptionResultImpl[] results = this.manager.loadResults(this.subs);
            for (int i = 0; i < results.length; ++i) {
                if (!Arrays.equals(results[i].getKey1(), key)) continue;
                results[i] = result;
                changed = true;
            }
            if (changed) {
                this.updateReadUnread(results);
                this.manager.saveResults(this.subs, results);
            }
        }
        if (changed) {
            this.saveConfig();
        }
        if (this.isAutoDownload() && !result.getRead() && !result.isDeleted()) {
            this.manager.getScheduler().download((Subscription)this.subs, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResults(String[] result_ids) {
        ByteArrayHashMap rids = new ByteArrayHashMap();
        for (int i = 0; i < result_ids.length; ++i) {
            rids.put(Base32.decode(result_ids[i]), "");
        }
        boolean changed = false;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            SubscriptionResultImpl[] results = this.manager.loadResults(this.subs);
            for (int i = 0; i < results.length; ++i) {
                SubscriptionResultImpl result = results[i];
                if (result.isDeleted() || !rids.containsKey(result.getKey1())) continue;
                changed = true;
                result.deleteInternal();
            }
            if (changed) {
                this.updateReadUnread(results);
                this.manager.saveResults(this.subs, results);
            }
        }
        if (changed) {
            this.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllResults() {
        boolean changed = false;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            SubscriptionResultImpl[] results = this.manager.loadResults(this.subs);
            for (int i = 0; i < results.length; ++i) {
                SubscriptionResultImpl result = results[i];
                if (result.isDeleted()) continue;
                changed = true;
                result.deleteInternal();
            }
            if (changed) {
                this.updateReadUnread(results);
                this.manager.saveResults(this.subs, results);
            }
        }
        if (changed) {
            this.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAllResultsRead() {
        boolean changed = false;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            SubscriptionResultImpl[] results = this.manager.loadResults(this.subs);
            for (int i = 0; i < results.length; ++i) {
                SubscriptionResultImpl result = results[i];
                if (result.getRead()) continue;
                changed = true;
                result.setReadInternal(true);
            }
            if (changed) {
                this.updateReadUnread(results);
                this.manager.saveResults(this.subs, results);
            }
        }
        if (changed) {
            this.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markResults(String[] result_ids, boolean[] reads) {
        ByteArrayHashMap rid_map = new ByteArrayHashMap();
        for (int i = 0; i < result_ids.length; ++i) {
            rid_map.put(Base32.decode(result_ids[i]), new Boolean(reads[i]));
        }
        boolean changed = false;
        ArrayList<SubscriptionResultImpl> newly_unread = new ArrayList<SubscriptionResultImpl>();
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            SubscriptionResultImpl[] results = this.manager.loadResults(this.subs);
            for (int i = 0; i < results.length; ++i) {
                Boolean b_read;
                SubscriptionResultImpl result = results[i];
                if (result.isDeleted() || (b_read = (Boolean)rid_map.get(result.getKey1())) == null) continue;
                boolean read = b_read;
                if (result.getRead() == read) continue;
                changed = true;
                result.setReadInternal(read);
                if (read) continue;
                newly_unread.add(result);
            }
            if (changed) {
                this.updateReadUnread(results);
                this.manager.saveResults(this.subs, results);
            }
        }
        if (changed) {
            this.saveConfig();
        }
        if (this.isAutoDownload()) {
            for (int i = 0; i < newly_unread.size(); ++i) {
                this.manager.getScheduler().download((Subscription)this.subs, (SubscriptionResult)newly_unread.get(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            SubscriptionResultImpl[] results = this.manager.loadResults(this.subs);
            if (results.length > 0) {
                results = new SubscriptionResultImpl[]{};
                this.manager.saveResults(this.subs, results);
            }
            this.updateReadUnread(results);
        }
        this.last_error = null;
        this.last_new_result = 0L;
        this.last_scan = 0L;
        this.saveConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkMaxResults(int max_results) {
        if (max_results <= 0) {
            return;
        }
        boolean changed = false;
        SubscriptionHistoryImpl subscriptionHistoryImpl = this;
        synchronized (subscriptionHistoryImpl) {
            if (this.num_unread + this.num_read > max_results) {
                SubscriptionResultImpl[] results = this.manager.loadResults(this.subs);
                for (int i = 0; i < results.length; ++i) {
                    SubscriptionResultImpl r = results[i];
                    if (r.isDeleted()) continue;
                    if (r.getRead()) {
                        --this.num_read;
                    } else {
                        --this.num_unread;
                    }
                    r.deleteInternal();
                    changed = true;
                    if (this.num_unread + this.num_read <= max_results) break;
                }
                if (changed) {
                    this.manager.saveResults(this.subs, results);
                }
            }
        }
        if (changed) {
            this.saveConfig();
        }
    }

    protected void updateReadUnread(SubscriptionResultImpl[] results) {
        int new_unread = 0;
        int new_read = 0;
        for (int i = 0; i < results.length; ++i) {
            SubscriptionResultImpl result = results[i];
            if (result.isDeleted()) continue;
            if (result.getRead()) {
                ++new_read;
                continue;
            }
            ++new_unread;
        }
        this.num_read = new_read;
        this.num_unread = new_unread;
    }

    protected void setLastError(String _last_error, boolean _auth_failed) {
        this.last_error = _last_error;
        this.auth_failed = _auth_failed;
        this.subs.fireChanged();
    }

    public String getLastError() {
        return this.last_error;
    }

    public boolean isAuthFail() {
        return this.auth_failed;
    }

    protected void loadConfig() {
        Map map = this.subs.getHistoryConfig();
        Long l_enabled = (Long)map.get("enabled");
        this.enabled = l_enabled == null ? true : l_enabled == 1L;
        Long l_auto_dl = (Long)map.get("auto_dl");
        this.auto_dl = l_auto_dl == null ? false : l_auto_dl == 1L;
        Long l_last_scan = (Long)map.get("last_scan");
        this.last_scan = l_last_scan == null ? 0L : l_last_scan;
        Long l_last_new = (Long)map.get("last_new");
        this.last_new_result = l_last_new == null ? 0L : l_last_new;
        Long l_num_unread = (Long)map.get("num_unread");
        this.num_unread = l_num_unread == null ? 0 : l_num_unread.intValue();
        Long l_num_read = (Long)map.get("num_read");
        this.num_read = l_num_read == null ? 0 : l_num_read.intValue();
    }

    protected void saveConfig() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("enabled", new Long(this.enabled ? 1L : 0L));
        map.put("auto_dl", new Long(this.auto_dl ? 1L : 0L));
        map.put("last_scan", new Long(this.last_scan));
        map.put("last_new", new Long(this.last_new_result));
        map.put("num_unread", new Long(this.num_unread));
        map.put("num_read", new Long(this.num_read));
        this.subs.updateHistoryConfig(map);
    }

    protected void log(String str) {
        this.subs.log("History: " + str);
    }

    protected void log(String str, Throwable e) {
        this.subs.log("History: " + str, e);
    }
}

