/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.lws.LightWeightSeed;
import com.aelitis.azureus.core.lws.LightWeightSeedAdapter;
import com.aelitis.azureus.core.lws.LightWeightSeedManager;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import com.aelitis.azureus.core.security.CryptoECCUtils;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionException;
import com.aelitis.azureus.core.subs.SubscriptionHistory;
import com.aelitis.azureus.core.subs.SubscriptionListener;
import com.aelitis.azureus.core.subs.SubscriptionManager;
import com.aelitis.azureus.core.subs.SubscriptionPopularityListener;
import com.aelitis.azureus.core.subs.impl.SubscriptionBodyImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionHistoryImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionManagerImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionResultFilter;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.util.ImportExportUtils;
import com.aelitis.azureus.util.JSONUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.json.simple.JSONObject;

public class SubscriptionImpl
implements Subscription {
    public static final int ADD_TYPE_CREATE = 1;
    public static final int ADD_TYPE_IMPORT = 2;
    public static final int ADD_TYPE_LOOKUP = 3;
    private static final int MAX_ASSOCIATIONS = 256;
    private static final int MIN_RECENT_ASSOC_TO_RETAIN = 16;
    private SubscriptionManagerImpl manager;
    private byte[] public_key;
    private byte[] private_key;
    private String name;
    private String name_ex;
    private int version;
    private int az_version;
    private boolean is_public;
    private Map singleton_details;
    private byte[] hash;
    private byte[] sig;
    private int sig_data_size;
    private int add_type;
    private long add_time;
    private boolean is_subscribed;
    private int highest_prompted_version;
    private byte[] short_id;
    private List associations = new ArrayList();
    private int fixed_random;
    private long popularity = -1L;
    private long last_auto_upgrade_check = -1L;
    private boolean published;
    private boolean server_published;
    private boolean server_publication_outstanding;
    private boolean singleton_sp_attempted;
    private LightWeightSeed lws;
    private int lws_skip_check;
    private boolean destroyed;
    private Map history_map;
    private Map schedule_map;
    private Map user_data = new LightHashMap();
    private final SubscriptionHistoryImpl history;
    private String referer;
    private CopyOnWriteList listeners = new CopyOnWriteList();

    protected static byte[] intToBytes(int version) {
        return new byte[]{(byte)(version >> 24), (byte)(version >> 16), (byte)(version >> 8), (byte)version};
    }

    protected static int bytesToInt(byte[] bytes) {
        return bytes[0] << 24 & 0xFF000000 | bytes[1] << 16 & 0xFF0000 | bytes[2] << 8 & 0xFF00 | bytes[3] & 0xFF;
    }

    protected static String getSkeletonJSON(Engine engine, int check_interval_mins) {
        JSONObject map = new JSONObject();
        map.put("engine_id", new Long(engine.getId()));
        map.put("search_term", "");
        map.put("filters", new HashMap());
        map.put("options", new HashMap());
        HashMap<String, Serializable> schedule = new HashMap<String, Serializable>();
        schedule.put("interval", new Long(check_interval_mins));
        ArrayList<String> days = new ArrayList<String>();
        for (int i = 1; i <= 7; ++i) {
            days.add(String.valueOf(i));
        }
        schedule.put("days", days);
        map.put("schedule", schedule);
        SubscriptionImpl.embedEngines(map, engine);
        return JSONUtils.encodeToJSON(map);
    }

    protected SubscriptionImpl(SubscriptionManagerImpl _manager, String _name, boolean _public, Map _singleton_details, String _json_content, int _add_type) throws SubscriptionException {
        this.manager = _manager;
        this.history_map = new HashMap();
        this.history = new SubscriptionHistoryImpl(this.manager, this);
        this.name = _name;
        this.is_public = _public;
        this.singleton_details = _singleton_details;
        this.version = 1;
        this.az_version = 1;
        this.add_type = _add_type;
        this.add_time = SystemTime.getCurrentTime();
        this.is_subscribed = true;
        try {
            KeyPair kp = CryptoECCUtils.createKeys();
            this.public_key = CryptoECCUtils.keyToRawdata(kp.getPublic());
            this.private_key = CryptoECCUtils.keyToRawdata(kp.getPrivate());
            this.fixed_random = new Random().nextInt();
            this.init();
            String json_content = this.embedEngines(_json_content);
            SubscriptionBodyImpl body = new SubscriptionBodyImpl(this.manager, this.name, this.is_public, json_content, this.public_key, this.version, this.az_version, this.singleton_details);
            this.syncToBody(body);
        }
        catch (Throwable e) {
            throw new SubscriptionException("Failed to create subscription", e);
        }
    }

    protected SubscriptionImpl(SubscriptionManagerImpl _manager, Map map) throws IOException {
        this.manager = _manager;
        this.fromMap(map);
        this.history = new SubscriptionHistoryImpl(this.manager, this);
        this.init();
    }

    protected SubscriptionImpl(SubscriptionManagerImpl _manager, SubscriptionBodyImpl _body, int _add_type, boolean _is_subscribed) throws SubscriptionException {
        this.manager = _manager;
        this.history_map = new HashMap();
        this.history = new SubscriptionHistoryImpl(this.manager, this);
        this.syncFromBody(_body);
        this.add_type = _add_type;
        this.add_time = SystemTime.getCurrentTime();
        this.is_subscribed = _is_subscribed;
        this.fixed_random = new Random().nextInt();
        this.init();
        this.syncToBody(_body);
    }

    protected void syncFromBody(SubscriptionBodyImpl body) throws SubscriptionException {
        this.public_key = body.getPublicKey();
        this.version = body.getVersion();
        this.az_version = body.getAZVersion();
        this.name = body.getName();
        this.is_public = body.isPublic();
        this.singleton_details = body.getSingletonDetails();
        if (this.az_version > 1) {
            throw new SubscriptionException(MessageText.getString("subscription.version.bad", new String[]{this.name}));
        }
    }

    protected void syncToBody(SubscriptionBodyImpl body) throws SubscriptionException {
        body.writeVuzeFile(this);
        this.hash = body.getHash();
        this.sig = body.getSig();
        this.sig_data_size = body.getSigDataSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map toMap() throws IOException {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", this.name.getBytes("UTF-8"));
            map.put("public_key", this.public_key);
            map.put("version", new Long(this.version));
            map.put("az_version", new Long(this.az_version));
            map.put("is_public", new Long(this.is_public ? 1L : 0L));
            if (this.singleton_details != null) {
                map.put("sin_details", this.singleton_details);
                map.put("spa", new Long(this.singleton_sp_attempted ? 1L : 0L));
            }
            map.put("hash", this.hash);
            map.put("sig", this.sig);
            map.put("sig_data_size", new Long(this.sig_data_size));
            if (this.private_key != null) {
                map.put("private_key", this.private_key);
            }
            map.put("add_type", new Long(this.add_type));
            map.put("add_time", new Long(this.add_time));
            map.put("subscribed", new Long(this.is_subscribed ? 1L : 0L));
            map.put("pop", new Long(this.popularity));
            map.put("rand", new Long(this.fixed_random));
            map.put("hupv", new Long(this.highest_prompted_version));
            map.put("sp", new Long(this.server_published ? 1L : 0L));
            map.put("spo", new Long(this.server_publication_outstanding ? 1L : 0L));
            if (this.associations.size() > 0) {
                ArrayList l_assoc = new ArrayList();
                map.put("assoc", l_assoc);
                for (int i = 0; i < this.associations.size(); ++i) {
                    association assoc = (association)this.associations.get(i);
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    l_assoc.add(m);
                    m.put("h", assoc.getHash());
                    m.put("w", new Long(assoc.getWhen()));
                }
            }
            map.put("history", this.history_map);
            return map;
        }
    }

    protected void fromMap(Map map) throws IOException {
        List l_assoc;
        this.name = new String((byte[])map.get("name"), "UTF-8");
        this.public_key = (byte[])map.get("public_key");
        this.private_key = (byte[])map.get("private_key");
        this.version = ((Long)map.get("version")).intValue();
        this.az_version = (int)ImportExportUtils.importLong(map, "az_version", 1L);
        this.is_public = ((Long)map.get("is_public")).intValue() == 1;
        this.singleton_details = (Map)map.get("sin_details");
        this.hash = (byte[])map.get("hash");
        this.sig = (byte[])map.get("sig");
        this.sig_data_size = ((Long)map.get("sig_data_size")).intValue();
        this.fixed_random = ((Long)map.get("rand")).intValue();
        this.add_type = ((Long)map.get("add_type")).intValue();
        this.add_time = (Long)map.get("add_time");
        this.is_subscribed = ((Long)map.get("subscribed")).intValue() == 1;
        this.popularity = (Long)map.get("pop");
        this.highest_prompted_version = ((Long)map.get("hupv")).intValue();
        this.server_published = ((Long)map.get("sp")).intValue() == 1;
        this.server_publication_outstanding = ((Long)map.get("spo")).intValue() == 1;
        Long l_spa = (Long)map.get("spa");
        if (l_spa != null) {
            boolean bl = this.singleton_sp_attempted = l_spa == 1L;
        }
        if ((l_assoc = (List)map.get("assoc")) != null) {
            for (int i = 0; i < l_assoc.size(); ++i) {
                Map m = (Map)l_assoc.get(i);
                byte[] hash = (byte[])m.get("h");
                long when = (Long)m.get("w");
                this.associations.add(new association(hash, when));
            }
        }
        this.history_map = (Map)map.get("history");
        if (this.history_map == null) {
            this.history_map = new HashMap();
        }
    }

    protected Map getScheduleConfig() {
        if (this.schedule_map == null) {
            try {
                Map map = JSONUtils.decodeJSON(this.getJSON());
                this.schedule_map = (Map)map.get("schedule");
                if (this.schedule_map == null) {
                    this.schedule_map = new HashMap();
                }
            }
            catch (Throwable e) {
                this.log("Failed to load schedule", e);
                this.schedule_map = new HashMap();
            }
        }
        return this.schedule_map;
    }

    protected Map getHistoryConfig() {
        return this.history_map;
    }

    protected void updateHistoryConfig(Map _history_map) {
        this.history_map = _history_map;
        this.fireChanged();
    }

    protected void upgrade(SubscriptionBodyImpl body) throws SubscriptionException {
        this.syncFromBody(body);
        this.syncToBody(body);
        this.fireChanged();
    }

    protected void init() {
        this.short_id = SubscriptionBodyImpl.deriveShortID(this.public_key, this.singleton_details);
    }

    public boolean isSingleton() {
        return this.singleton_details != null;
    }

    public boolean isShareable() {
        try {
            return this.getEngine().isShareable() && !this.isSingleton();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    protected Map getSingletonDetails() {
        return this.singleton_details;
    }

    protected boolean getSingletonPublishAttempted() {
        return this.singleton_sp_attempted;
    }

    protected void setSingletonPublishAttempted() {
        if (!this.singleton_sp_attempted) {
            this.singleton_sp_attempted = true;
            this.manager.configDirty(this);
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String _name) throws SubscriptionException {
        if (!this.name.equals(_name)) {
            boolean ok = false;
            String old_name = this.name;
            int old_version = this.version++;
            try {
                this.name = _name;
                SubscriptionBodyImpl body = new SubscriptionBodyImpl(this.manager, this);
                this.syncToBody(body);
                this.versionUpdated(body, false);
                ok = true;
            }
            finally {
                if (!ok) {
                    this.name = old_name;
                    this.version = old_version;
                }
            }
            this.fireChanged();
        }
    }

    public String getNameEx() {
        if (this.name_ex == null) {
            try {
                Map map = JSONUtils.decodeJSON(this.getJSON());
                String search_term = (String)map.get("search_term");
                Map filters = (Map)map.get("filters");
                Engine engine = this.manager.getEngine(this, map, true);
                String engine_name = engine.getNameEx();
                this.name_ex = this.name.startsWith(engine_name) ? this.name : (engine_name.startsWith(this.name) ? engine_name : this.name + ": " + engine.getNameEx());
                if (search_term != null && search_term.length() > 0) {
                    this.name_ex = this.name_ex + ", query=" + search_term;
                }
                if (filters != null && filters.size() > 0) {
                    this.name_ex = this.name_ex + ", filters=" + new SubscriptionResultFilter(filters).getString();
                }
            }
            catch (Throwable e) {
                this.name_ex = this.name + ": " + Debug.getNestedExceptionMessage(e);
            }
        }
        return this.name_ex;
    }

    public boolean isPublic() {
        return this.is_public;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPublic(boolean _is_public) throws SubscriptionException {
        if (this.is_public != _is_public) {
            boolean ok = false;
            boolean old_public = this.is_public;
            int old_version = this.version++;
            try {
                this.is_public = _is_public;
                SubscriptionBodyImpl body = new SubscriptionBodyImpl(this.manager, this);
                this.syncToBody(body);
                this.versionUpdated(body, false);
                ok = true;
            }
            finally {
                if (!ok) {
                    this.version = old_version;
                    this.is_public = old_public;
                }
            }
            this.fireChanged();
        }
    }

    protected boolean getServerPublicationOutstanding() {
        return this.server_publication_outstanding;
    }

    protected void setServerPublicationOutstanding() {
        if (!this.server_publication_outstanding) {
            this.server_publication_outstanding = true;
            this.fireChanged();
        }
    }

    protected void setServerPublished() {
        if (this.server_publication_outstanding || !this.server_published) {
            this.server_published = true;
            this.server_publication_outstanding = false;
            this.fireChanged();
        }
    }

    protected boolean getServerPublished() {
        return this.server_published;
    }

    public String getJSON() throws SubscriptionException {
        SubscriptionBodyImpl body = new SubscriptionBodyImpl(this.manager, this);
        return body.getJSON();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setJSON(String _json) throws SubscriptionException {
        SubscriptionBodyImpl body;
        String old_json;
        String json = this.embedEngines(_json);
        if (!json.equals(old_json = (body = new SubscriptionBodyImpl(this.manager, this)).getJSON())) {
            boolean ok = false;
            int old_version = this.version++;
            try {
                body.setJSON(json);
                this.syncToBody(body);
                this.versionUpdated(body, true);
                this.referer = null;
                ok = true;
            }
            finally {
                if (!ok) {
                    this.version = old_version;
                }
            }
            this.fireChanged();
            return true;
        }
        return false;
    }

    protected String embedEngines(String json_in) {
        Map map = JSONUtils.decodeJSON(json_in);
        long engine_id = (Long)map.get("engine_id");
        String json_out = json_in;
        if (engine_id >= Integer.MAX_VALUE || engine_id < 0L) {
            Engine engine = MetaSearchManagerFactory.getSingleton().getMetaSearch().getEngine(engine_id);
            if (engine == null) {
                this.log("Private search template with id '" + engine_id + "' not found!!!!");
            } else {
                try {
                    SubscriptionImpl.embedEngines(map, engine);
                    json_out = JSONUtils.encodeToJSON(map);
                    this.log("Embedded private search template '" + engine.getName() + "'");
                }
                catch (Throwable e) {
                    this.log("Failed to embed private search template", e);
                }
            }
        }
        return json_out;
    }

    protected static void embedEngines(Map map, Engine engine) {
        HashMap engines = new HashMap();
        map.put("engines", engines);
        HashMap<String, String> engine_map = new HashMap<String, String>();
        try {
            String engine_str = new String(Base64.encode(BEncoder.encode(engine.exportToBencodedMap())), "UTF-8");
            engine_map.put("content", engine_str);
            engines.put(String.valueOf(engine.getId()), engine_map);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected Engine extractEngine(Map json_map, long id) {
        Map engine_map;
        Map engines = (Map)json_map.get("engines");
        if (engines != null && (engine_map = (Map)engines.get(String.valueOf(id))) != null) {
            String engine_str = (String)engine_map.get("content");
            try {
                Map map = BDecoder.decode(Base64.decode(engine_str.getBytes("UTF-8")));
                return MetaSearchManagerFactory.getSingleton().getMetaSearch().importFromBEncodedMap(map);
            }
            catch (Throwable e) {
                this.log("failed to import engine", e);
            }
        }
        return null;
    }

    public Engine getEngine() throws SubscriptionException {
        return this.getEngine(true);
    }

    protected Engine getEngine(boolean local_only) throws SubscriptionException {
        Map map = JSONUtils.decodeJSON(this.getJSON());
        return this.manager.getEngine(this, map, local_only);
    }

    protected void engineUpdated(Engine engine) {
        try {
            String json = this.getJSON();
            Map map = JSONUtils.decodeJSON(json);
            long id = (Long)map.get("engine_id");
            if (id == engine.getId() && this.setJSON(json)) {
                this.log("Engine has been updated, saved");
            }
        }
        catch (Throwable e) {
            this.log("Engine update failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDetails(String _name, boolean _is_public, String _json) throws SubscriptionException {
        SubscriptionBodyImpl body;
        String old_json;
        boolean json_changed;
        boolean bl = json_changed = !(_json = this.embedEngines(_json)).equals(old_json = (body = new SubscriptionBodyImpl(this.manager, this)).getJSON());
        if (!_name.equals(this.name) || _is_public != this.is_public || json_changed) {
            boolean ok = false;
            String old_name = this.name;
            boolean old_public = this.is_public;
            int old_version = this.version++;
            try {
                this.is_public = _is_public;
                this.name = _name;
                body.setJSON(_json);
                this.syncToBody(body);
                this.versionUpdated(body, json_changed);
                ok = true;
            }
            finally {
                if (!ok) {
                    this.version = old_version;
                    this.is_public = old_public;
                    this.name = old_name;
                }
            }
            this.fireChanged();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void versionUpdated(SubscriptionBodyImpl body, boolean json_changed) {
        if (json_changed) {
            try {
                Map map = JSONUtils.decodeJSON(body.getJSON());
                this.schedule_map = (Map)map.get("schedule");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.name_ex = null;
        if (this.is_public) {
            this.manager.updatePublicSubscription(this);
            this.setPublished(false);
            SubscriptionImpl subscriptionImpl = this;
            synchronized (subscriptionImpl) {
                for (int i = 0; i < this.associations.size(); ++i) {
                    ((association)this.associations.get(i)).setPublished(false);
                }
            }
        }
    }

    public byte[] getPublicKey() {
        return this.public_key;
    }

    public byte[] getShortID() {
        return this.short_id;
    }

    public String getID() {
        return Base32.encode(this.getShortID());
    }

    protected byte[] getPrivateKey() {
        return this.private_key;
    }

    protected int getFixedRandom() {
        return this.fixed_random;
    }

    public int getVersion() {
        return this.version;
    }

    public int getAZVersion() {
        return this.az_version;
    }

    protected void setHighestUserPromptedVersion(int v) {
        if (v < this.version) {
            v = this.version;
        }
        if (this.highest_prompted_version != v) {
            this.highest_prompted_version = v;
            this.fireChanged();
        }
    }

    protected int getHighestUserPromptedVersion() {
        return this.highest_prompted_version;
    }

    public int getHighestVersion() {
        return Math.max(this.version, this.highest_prompted_version);
    }

    public void resetHighestVersion() {
        if (this.highest_prompted_version > 0) {
            this.highest_prompted_version = 0;
            this.fireChanged();
            this.manager.checkUpgrade(this);
        }
    }

    public boolean isMine() {
        if (this.private_key == null) {
            return false;
        }
        return !this.isSingleton() || this.add_type == 1;
    }

    public boolean isUpdateable() {
        return this.private_key != null;
    }

    public boolean isSubscribed() {
        return this.is_subscribed;
    }

    public void setSubscribed(boolean s) {
        if (this.is_subscribed != s) {
            this.is_subscribed = s;
            if (this.is_subscribed) {
                this.manager.setSelected(this);
            }
            this.fireChanged();
        }
    }

    public void getPopularity(final SubscriptionPopularityListener listener) throws SubscriptionException {
        new AEThread2("subs:popwait", true){

            public void run() {
                try {
                    SubscriptionImpl.this.manager.getPopularity(SubscriptionImpl.this, new SubscriptionPopularityListener(){

                        public void gotPopularity(long pop) {
                            if (pop != SubscriptionImpl.this.popularity) {
                                SubscriptionImpl.this.popularity = pop;
                                SubscriptionImpl.this.fireChanged();
                            }
                            listener.gotPopularity(SubscriptionImpl.this.popularity);
                        }

                        public void failed(SubscriptionException e) {
                            if (SubscriptionImpl.this.popularity == -1L) {
                                listener.failed(new SubscriptionException("Failed to read popularity", e));
                            } else {
                                listener.gotPopularity(SubscriptionImpl.this.popularity);
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    if (SubscriptionImpl.this.popularity == -1L) {
                        listener.failed(new SubscriptionException("Failed to read popularity", e));
                    }
                    listener.gotPopularity(SubscriptionImpl.this.popularity);
                }
            }
        }.start();
    }

    public long getCachedPopularity() {
        return this.popularity;
    }

    protected void setCachedPopularity(long pop) {
        if (pop != this.popularity) {
            this.popularity = pop;
            this.fireChanged();
        }
    }

    public String getReferer() {
        if (this.referer == null) {
            try {
                Map map = JSONUtils.decodeJSON(this.getJSON());
                Engine engine = this.manager.getEngine(this, map, false);
                if (engine != null) {
                    this.referer = engine.getReferer();
                }
            }
            catch (Throwable e) {
                this.log("Failed to get referer", e);
            }
            if (this.referer == null) {
                this.referer = "";
            }
        }
        return this.referer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPublish() {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            if (this.destroyed) {
                return;
            }
            if (this.isSingleton()) {
                return;
            }
            if (!this.isSubscribed()) {
                return;
            }
            if (this.popularity > 100L) {
                if (this.lws_skip_check == 2) {
                    return;
                }
                if (this.lws_skip_check == 0) {
                    if (new Random().nextInt((int)((this.popularity + 99L) / 100L)) == 0) {
                        this.lws_skip_check = 1;
                    } else {
                        this.lws_skip_check = 2;
                        return;
                    }
                }
            }
            if (this.hash != null) {
                boolean create = false;
                if (this.lws == null) {
                    create = true;
                } else if (!Arrays.equals(this.lws.getHash().getBytes(), this.hash)) {
                    this.lws.remove();
                    create = true;
                }
                if (create) {
                    try {
                        File original_data_location = this.manager.getVuzeFile(this);
                        if (original_data_location.exists()) {
                            File versioned_data_location = new File(original_data_location.getParent(), original_data_location.getName() + "." + this.getVersion());
                            if (!versioned_data_location.exists() && !FileUtil.copyFile(original_data_location, versioned_data_location)) {
                                throw new Exception("Failed to copy file to '" + versioned_data_location + "'");
                            }
                            this.lws = LightWeightSeedManager.getSingleton().add(this.getName(), new HashWrapper(this.hash), TorrentUtils.getDecentralisedEmptyURL(), versioned_data_location, new LightWeightSeedAdapter(){

                                public TOTorrent getTorrent(byte[] hash, URL announce_url, File data_location) throws Exception {
                                    SubscriptionImpl.this.log(" - generating torrent: " + Debug.getCompressedStackTrace());
                                    TOTorrentCreator creator = TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(data_location, announce_url, 262144L);
                                    TOTorrent t = creator.create();
                                    t.setHashOverride(hash);
                                    return t;
                                }
                            });
                        }
                    }
                    catch (Throwable e) {
                        this.log("Failed to create light-weight-seed", e);
                    }
                }
            }
        }
    }

    protected synchronized boolean canAutoUpgradeCheck() {
        if (this.isSingleton()) {
            return false;
        }
        long now = SystemTime.getMonotonousTime();
        if (this.last_auto_upgrade_check == -1L || now - this.last_auto_upgrade_check > 14400000L) {
            this.last_auto_upgrade_check = now;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAssociation(byte[] hash) {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            for (int i = 0; i < this.associations.size(); ++i) {
                association assoc = (association)this.associations.get(i);
                if (!Arrays.equals(assoc.getHash(), hash)) continue;
                return;
            }
            this.associations.add(new association(hash, SystemTime.getCurrentTime()));
            if (this.associations.size() > 256) {
                this.associations.remove(new Random().nextInt(240));
            }
        }
        this.fireChanged();
        this.manager.associationAdded(this, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAssociation(byte[] hash) {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            for (int i = 0; i < this.associations.size(); ++i) {
                association assoc = (association)this.associations.get(i);
                if (!Arrays.equals(assoc.getHash(), hash)) continue;
                return true;
            }
        }
        return false;
    }

    public void addPotentialAssociation(String result_id, String key) {
        this.manager.addPotentialAssociation(this, result_id, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAssociationCount() {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            return this.associations.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected association getAssociationForPublish() {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            int num_assoc = this.associations.size();
            for (int i = num_assoc - 1; i >= Math.max(0, num_assoc - 16); --i) {
                association assoc = (association)this.associations.get(i);
                if (assoc.getPublished()) continue;
                assoc.setPublished(true);
                return assoc;
            }
            int rem = this.associations.size() - 16;
            if (rem > 0) {
                ArrayList l = new ArrayList(this.associations.subList(0, rem));
                Collections.shuffle(l);
                for (int i = 0; i < l.size(); ++i) {
                    association assoc = (association)l.get(i);
                    if (assoc.getPublished()) continue;
                    assoc.setPublished(true);
                    return assoc;
                }
            }
        }
        return null;
    }

    protected boolean getPublished() {
        return this.published;
    }

    protected void setPublished(boolean b) {
        this.published = b;
    }

    protected int getVerifiedPublicationVersion(Map details) {
        if (!this.verifyPublicationDetails(details)) {
            return -1;
        }
        return SubscriptionImpl.getPublicationVersion(details);
    }

    protected static int getPublicationVersion(Map details) {
        return ((Long)details.get("v")).intValue();
    }

    protected byte[] getPublicationHash() {
        return this.hash;
    }

    protected static byte[] getPublicationHash(Map details) {
        return (byte[])details.get("h");
    }

    protected static int getPublicationSize(Map details) {
        return ((Long)details.get("z")).intValue();
    }

    protected Map getPublicationDetails() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("h", this.hash);
        result.put("v", new Long(this.version));
        result.put("z", new Long(this.sig_data_size));
        result.put("s", this.sig);
        if (this.singleton_details != null) {
            result.put("x", this.singleton_details);
        }
        return result;
    }

    protected boolean verifyPublicationDetails(Map details) {
        byte[] hash = (byte[])details.get("h");
        int version = ((Long)details.get("v")).intValue();
        int size = ((Long)details.get("z")).intValue();
        byte[] sig = (byte[])details.get("s");
        return SubscriptionBodyImpl.verify(this.public_key, hash, version, size, sig);
    }

    protected void fireChanged() {
        this.manager.configDirty(this);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((SubscriptionListener)it.next()).subscriptionChanged(this);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void fireDownloaded(boolean was_auto) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((SubscriptionListener)it.next()).subscriptionDownloaded(this, was_auto);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void addListener(SubscriptionListener l) {
        this.listeners.add(l);
    }

    public void removeListener(SubscriptionListener l) {
        this.listeners.remove(l);
    }

    public SubscriptionHistory getHistory() {
        return this.history;
    }

    public SubscriptionManager getManager() {
        return this.manager;
    }

    public VuzeFile getVuzeFile() throws SubscriptionException {
        try {
            return VuzeFileHandler.getSingleton().loadVuzeFile(this.manager.getVuzeFile(this).getAbsolutePath());
        }
        catch (Throwable e) {
            throw new SubscriptionException("Failed to get Vuze file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        LightWeightSeed l;
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            this.destroyed = true;
            l = this.lws;
        }
        if (l != null) {
            l.remove();
        }
    }

    public void remove() {
        this.destroy();
        this.manager.removeSubscription(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRemoved() {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            return this.destroyed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserData(Object key, Object data) {
        Map map = this.user_data;
        synchronized (map) {
            if (data == null) {
                this.user_data.remove(key);
            } else {
                this.user_data.put(key, data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getUserData(Object key) {
        Map map = this.user_data;
        synchronized (map) {
            return this.user_data.get(key);
        }
    }

    protected void log(String str) {
        this.manager.log(this.getString() + ": " + str);
    }

    protected void log(String str, Throwable e) {
        this.manager.log(this.getString() + ": " + str, e);
    }

    public String getString() {
        return "name=" + this.name + ",sid=" + ByteFormatter.encodeString(this.short_id) + ",ver=" + this.version + ",pub=" + this.is_public + ",mine=" + this.isMine() + ",sub=" + this.is_subscribed + ",pop=" + this.popularity + (this.server_publication_outstanding ? ",spo=true" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generate(IndentWriter writer) {
        String engine_str;
        try {
            engine_str = "" + this.getEngine().getId();
        }
        catch (Throwable e) {
            engine_str = Debug.getNestedExceptionMessage(e);
        }
        writer.println(this.getString() + ": engine=" + engine_str);
        try {
            writer.indent();
            SubscriptionImpl subscriptionImpl = this;
            synchronized (subscriptionImpl) {
                for (int i = 0; i < this.associations.size(); ++i) {
                    ((association)this.associations.get(i)).generate(writer);
                }
            }
        }
        finally {
            writer.exdent();
        }
    }

    protected static class association {
        private byte[] hash;
        private long when;
        private boolean published;

        protected association(byte[] _hash, long _when) {
            this.hash = _hash;
            this.when = _when;
        }

        protected byte[] getHash() {
            return this.hash;
        }

        protected long getWhen() {
            return this.when;
        }

        protected boolean getPublished() {
            return this.published;
        }

        protected void setPublished(boolean b) {
            this.published = b;
        }

        protected String getString() {
            return ByteFormatter.encodeString(this.hash) + ", pub=" + this.published;
        }

        protected void generate(IndentWriter writer) {
            writer.println(this.getString());
        }
    }
}

