/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionDownloadListener;
import com.aelitis.azureus.core.subs.SubscriptionException;
import com.aelitis.azureus.core.subs.SubscriptionHistory;
import com.aelitis.azureus.core.subs.SubscriptionManagerListener;
import com.aelitis.azureus.core.subs.SubscriptionResult;
import com.aelitis.azureus.core.subs.SubscriptionScheduler;
import com.aelitis.azureus.core.subs.impl.SubscriptionDownloader;
import com.aelitis.azureus.core.subs.impl.SubscriptionImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionManagerImpl;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class SubscriptionSchedulerImpl
implements SubscriptionScheduler,
SubscriptionManagerListener {
    private static final Object SCHEDULER_NEXT_SCAN_KEY = new Object();
    private static final Object SCHEDULER_FAILED_SCAN_CONSEC_KEY = new Object();
    private static final Object SCHEDULER_FAILED_SCAN_TIME_KEY = new Object();
    private static final int FAIL_INIT_DELAY = 600000;
    private static final int FAIL_MAX_DELAY = 28800000;
    private SubscriptionManagerImpl manager;
    private Map active_subscription_downloaders = new HashMap();
    private boolean active_subs_download_is_auto;
    private Set active_result_downloaders = new HashSet();
    private AsyncDispatcher result_downloader = new AsyncDispatcher();
    private boolean schedulng_permitted;
    private TimerEvent schedule_event;
    private boolean schedule_in_progress;
    private long last_schedule;

    protected SubscriptionSchedulerImpl(SubscriptionManagerImpl _manager) {
        this.manager = _manager;
        this.manager.addListener(this);
        UtilitiesImpl.DelayedTaskImpl delayed_task = UtilitiesImpl.addDelayedTask("Subscriptions Scheduler", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SubscriptionSchedulerImpl subscriptionSchedulerImpl = SubscriptionSchedulerImpl.this;
                synchronized (subscriptionSchedulerImpl) {
                    SubscriptionSchedulerImpl.this.schedulng_permitted = true;
                }
                SubscriptionSchedulerImpl.this.calculateSchedule();
            }
        });
        delayed_task.queue();
    }

    public void downloadAsync(Subscription subs, boolean is_auto) throws SubscriptionException {
        this.download(subs, is_auto, new SubscriptionDownloadListener(){

            public void complete(Subscription subs) {
            }

            public void failed(Subscription subs, SubscriptionException error) {
                SubscriptionSchedulerImpl.this.log("Async download of " + subs.getName() + " failed", error);
            }
        });
    }

    public void download(final Subscription subs, final boolean is_auto, final SubscriptionDownloadListener listener) {
        new AEThread2("SS:download", true){

            public void run() {
                try {
                    SubscriptionSchedulerImpl.this.download(subs, is_auto);
                    listener.complete(subs);
                }
                catch (SubscriptionException e) {
                    listener.failed(subs, e);
                }
                catch (Throwable e) {
                    listener.failed(subs, new SubscriptionException("Download failed", e));
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(Subscription subs, boolean is_auto) throws SubscriptionException {
        SubscriptionDownloader downloader;
        AESemaphore sem = null;
        Map map = this.active_subscription_downloaders;
        synchronized (map) {
            List waiting = (List)this.active_subscription_downloaders.get(subs);
            if (waiting != null) {
                sem = new AESemaphore("SS:waiter");
                waiting.add(sem);
                if (!is_auto) {
                    this.active_subs_download_is_auto = false;
                }
            } else {
                this.active_subscription_downloaders.put(subs, new ArrayList());
                this.active_subs_download_is_auto = is_auto;
            }
            downloader = new SubscriptionDownloader(this.manager, (SubscriptionImpl)subs);
        }
        try {
            if (sem == null) {
                downloader.download();
            } else {
                sem.reserve();
            }
        }
        finally {
            boolean was_auto;
            Map map2 = this.active_subscription_downloaders;
            synchronized (map2) {
                List waiting = (List)this.active_subscription_downloaders.remove(subs);
                if (waiting != null) {
                    for (int i = 0; i < waiting.size(); ++i) {
                        ((AESemaphore)waiting.get(i)).release();
                    }
                }
                was_auto = this.active_subs_download_is_auto;
            }
            ((SubscriptionImpl)subs).fireDownloaded(was_auto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(final Subscription subs, final SubscriptionResult result) {
        final String dl = result.getDownloadLink();
        if (dl == null) {
            this.log(subs.getName() + ": can't download " + result.getID() + " as no direct download link available");
            return;
        }
        final String key = subs.getID() + ":" + result.getID();
        Set set = this.active_result_downloaders;
        synchronized (set) {
            if (this.active_result_downloaders.contains(key)) {
                return;
            }
            this.active_result_downloaders.add(key);
            this.result_downloader.dispatch(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    Object url;
                    try {
                        String cookies;
                        WebEngine we;
                        url = new URL(dl);
                        ResourceDownloaderFactory rdf = StaticUtilities.getResourceDownloaderFactory();
                        ResourceDownloader url_rd = rdf.create((URL)url);
                        UrlUtils.setBrowserHeaders(url_rd, subs.getReferer());
                        Engine engine = subs.getEngine();
                        if (engine instanceof WebEngine && (we = (WebEngine)engine).isNeedsAuth() && (cookies = we.getCookies()) != null && cookies.length() > 0) {
                            url_rd.setProperty("URL_Cookie", cookies);
                        }
                        ResourceDownloader mr_rd = rdf.getMetaRefreshDownloader(url_rd);
                        InputStream is = mr_rd.download();
                        TorrentImpl torrent = new TorrentImpl(TOTorrentFactory.deserialiseFromBEncodedInputStream(is));
                        Download download = StaticUtilities.getDefaultPluginInterface().getDownloadManager().addDownload(torrent);
                        if (subs.isPublic()) {
                            subs.addAssociation(torrent.getHash());
                        }
                        result.setRead(true);
                        SubscriptionSchedulerImpl.this.log(subs.getName() + ": added download " + download.getName());
                    }
                    catch (Throwable e) {
                        SubscriptionSchedulerImpl.this.log(subs.getName() + ": Failed to download result " + dl, e);
                    }
                    finally {
                        url = SubscriptionSchedulerImpl.this.active_result_downloaders;
                        synchronized (url) {
                            SubscriptionSchedulerImpl.this.active_result_downloaders.remove(key);
                        }
                        SubscriptionSchedulerImpl.this.calculateSchedule();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculateSchedule() {
        Subscription[] subs = this.manager.getSubscriptions();
        SubscriptionSchedulerImpl subscriptionSchedulerImpl = this;
        synchronized (subscriptionSchedulerImpl) {
            if (!this.schedulng_permitted) {
                return;
            }
            if (this.schedule_in_progress) {
                return;
            }
            long next_ready_time = Long.MAX_VALUE;
            for (int i = 0; i < subs.length; ++i) {
                SubscriptionHistory history;
                Subscription sub = subs[i];
                if (!sub.isSubscribed() || !(history = sub.getHistory()).isEnabled()) continue;
                long next_scan = this.getNextScan(sub);
                sub.setUserData(SCHEDULER_NEXT_SCAN_KEY, new Long(next_scan));
                if (next_scan >= next_ready_time) continue;
                next_ready_time = next_scan;
            }
            long old_when = 0L;
            if (this.schedule_event != null) {
                old_when = this.schedule_event.getWhen();
                this.schedule_event.cancel();
                this.schedule_event = null;
            }
            if (next_ready_time < Long.MAX_VALUE) {
                long now = SystemTime.getCurrentTime();
                if ((now < this.last_schedule || now - this.last_schedule < 30000L) && next_ready_time - now < 30000L) {
                    next_ready_time = now + 30000L;
                }
                this.log("Calculate : old_time=" + new SimpleDateFormat().format(new Date(old_when)) + ", new_time=" + new SimpleDateFormat().format(new Date(next_ready_time)));
                this.schedule_event = SimpleTimer.addEvent("SS:Scheduler", next_ready_time, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void perform(TimerEvent event2) {
                        SubscriptionSchedulerImpl subscriptionSchedulerImpl = SubscriptionSchedulerImpl.this;
                        synchronized (subscriptionSchedulerImpl) {
                            if (SubscriptionSchedulerImpl.this.schedule_in_progress) {
                                return;
                            }
                            SubscriptionSchedulerImpl.this.schedule_in_progress = true;
                            SubscriptionSchedulerImpl.this.last_schedule = SystemTime.getCurrentTime();
                            SubscriptionSchedulerImpl.this.schedule_event = null;
                        }
                        new AEThread2("SS:Sched", true){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                try {
                                    SubscriptionSchedulerImpl.this.schedule();
                                }
                                finally {
                                    SubscriptionSchedulerImpl subscriptionSchedulerImpl = SubscriptionSchedulerImpl.this;
                                    synchronized (subscriptionSchedulerImpl) {
                                        SubscriptionSchedulerImpl.this.schedule_in_progress = false;
                                    }
                                    SubscriptionSchedulerImpl.this.calculateSchedule();
                                }
                            }
                        }.start();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule() {
        Subscription[] subs = this.manager.getSubscriptions();
        long now = SystemTime.getCurrentTime();
        for (int i = 0; i < subs.length; ++i) {
            SubscriptionHistory history;
            Subscription sub = subs[i];
            if (!sub.isSubscribed() || !(history = sub.getHistory()).isEnabled()) continue;
            SubscriptionSchedulerImpl subscriptionSchedulerImpl = this;
            synchronized (subscriptionSchedulerImpl) {
                Long scan_due = (Long)sub.getUserData(SCHEDULER_NEXT_SCAN_KEY);
                if (scan_due == null) {
                    continue;
                }
                long diff = now - scan_due;
                if (diff < -10000L) {
                    continue;
                }
                sub.setUserData(SCHEDULER_NEXT_SCAN_KEY, null);
            }
            long last_scan = history.getLastScanTime();
            try {
                this.download(sub, true);
                continue;
            }
            catch (Throwable e) {
                continue;
            }
            finally {
                long new_last_scan = history.getLastScanTime();
                if (new_last_scan == last_scan) {
                    this.scanFailed(sub);
                } else {
                    this.scanSuccess(sub);
                }
            }
        }
    }

    protected long getNextScan(Subscription sub) {
        SubscriptionHistory history = sub.getHistory();
        Long fail_count = (Long)sub.getUserData(SCHEDULER_FAILED_SCAN_CONSEC_KEY);
        if (fail_count != null) {
            long fail_time = (Long)sub.getUserData(SCHEDULER_FAILED_SCAN_TIME_KEY);
            long fails = fail_count;
            long backoff = 600000L;
            int i = 1;
            while ((long)i < fails) {
                if ((backoff <<= 1) > 28800000L) {
                    backoff = 28800000L;
                    break;
                }
                ++i;
            }
            return fail_time + backoff;
        }
        return history.getNextScanTime();
    }

    protected void scanSuccess(Subscription sub) {
        sub.setUserData(SCHEDULER_FAILED_SCAN_CONSEC_KEY, null);
    }

    protected void scanFailed(Subscription sub) {
        sub.setUserData(SCHEDULER_FAILED_SCAN_TIME_KEY, new Long(SystemTime.getCurrentTime()));
        Long fail_count = (Long)sub.getUserData(SCHEDULER_FAILED_SCAN_CONSEC_KEY);
        fail_count = fail_count == null ? new Long(1L) : new Long(fail_count + 1L);
        sub.setUserData(SCHEDULER_FAILED_SCAN_CONSEC_KEY, fail_count);
    }

    protected void log(String str) {
        this.manager.log("Scheduler: " + str);
    }

    protected void log(String str, Throwable e) {
        this.manager.log("Scheduler: " + str, e);
    }

    public void subscriptionAdded(Subscription subscription) {
        this.calculateSchedule();
    }

    public void subscriptionChanged(Subscription subscription) {
        this.calculateSchedule();
    }

    public void subscriptionSelected(Subscription subscription) {
    }

    public void subscriptionRemoved(Subscription subscription) {
        this.calculateSchedule();
    }

    public void associationsChanged(byte[] association_hash) {
    }
}

