/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.torrent;

import com.aelitis.azureus.core.torrent.RatingInfoList;
import com.aelitis.azureus.util.MapUtils;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;

public class PlatformRatingInfoList
extends RatingInfoList {
    private final Map reply;

    public PlatformRatingInfoList(Map message) {
        this.reply = message == null ? new HashMap() : message;
    }

    public boolean hasHash(String hash) {
        return this.reply.get(hash) != null;
    }

    public long getRatingValue(String hash, String type) {
        Object val;
        Map mapValues;
        int rating = -1;
        Map mapRating = (Map)this.reply.get(hash);
        if (mapRating != null && (mapValues = (Map)mapRating.get("content")) != null && (val = mapValues.get("value")) instanceof Number) {
            rating = ((Number)val).intValue();
        }
        return rating;
    }

    public long getRatingCount(String hash, String type) {
        long rating = -1L;
        try {
            Object val;
            Map mapValues;
            Map mapRating = (Map)this.reply.get(hash);
            if (mapRating != null && (mapValues = (Map)mapRating.get("content")) != null && (val = mapValues.get("count")) instanceof Number) {
                rating = ((Number)val).longValue();
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
        return rating;
    }

    public String getRatingString(String hash, String type) {
        String rating = "--";
        try {
            Map mapValues;
            Map mapRating = (Map)this.reply.get(hash);
            if (mapRating != null && (mapValues = (Map)mapRating.get("content")) != null) {
                Object val = mapValues.get("value");
                if (val instanceof String) {
                    rating = (String)val;
                } else if (val instanceof Double) {
                    rating = ((Double)val).toString();
                }
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
        return rating;
    }

    public String getRatingColor(String hash, String type) {
        String color = null;
        try {
            Map map;
            Map mapValues;
            Map mapRating = (Map)this.reply.get(hash);
            if (mapRating != null && (mapValues = (Map)mapRating.get("content")) != null && (map = (Map)MapUtils.getMapObject(mapRating, "display-settings", null, Map.class)) != null && map.containsKey("color")) {
                color = (String)map.get("color");
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
        return color;
    }

    public long getRatingExpireyMins(String hash, String type) {
        long expiryMins = -1L;
        try {
            Object val;
            Map mapValues;
            Map mapRating = (Map)this.reply.get(hash);
            if (mapRating != null && (mapValues = (Map)mapRating.get("content")) != null && (val = mapValues.get("expires-in-mins")) instanceof Long) {
                expiryMins = (Long)val;
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
        return expiryMins;
    }

    public Map getMap() {
        return this.reply;
    }
}

