/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteCountedInputStream
extends FilterInputStream {
    private long position;
    private long mark;

    public ByteCountedInputStream(InputStream is) {
        super(is);
    }

    public int read() throws IOException {
        int read = this.in.read();
        this.position += (long)read;
        return read;
    }

    public int read(byte[] b) throws IOException {
        int read = this.read(b, 0, b.length);
        this.position += (long)read;
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        this.position += (long)read;
        return read;
    }

    public long skip(long n) throws IOException {
        long skipped = this.in.skip(n);
        this.position += skipped;
        return skipped;
    }

    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.position;
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.position = this.mark;
    }

    public long getPosition() {
        return this.position;
    }
}

