/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CopyOnWriteList {
    private static final boolean LOG_STATS = false;
    private List list = Collections.EMPTY_LIST;
    private boolean visible = false;
    private int initialCapacity;
    private static CopyOnWriteList stats;

    public CopyOnWriteList(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        if (stats != null) {
            stats.add(new WeakReference<CopyOnWriteList>(this));
        }
    }

    public CopyOnWriteList() {
        this.initialCapacity = 1;
        if (stats != null) {
            stats.add(new WeakReference<CopyOnWriteList>(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object obj) {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            if (this.visible) {
                ArrayList<Object> new_list = new ArrayList<Object>(this.list);
                new_list.add(obj);
                this.list = new_list;
                this.visible = false;
            } else {
                if (this.list == Collections.EMPTY_LIST) {
                    this.list = new ArrayList(this.initialCapacity);
                }
                this.list.add(obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object obj) {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            if (this.visible) {
                ArrayList new_list = new ArrayList(this.list);
                boolean result = new_list.remove(obj);
                this.list = new_list;
                this.visible = false;
                return result;
            }
            return this.list.remove(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            this.list = Collections.EMPTY_LIST;
            this.visible = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object obj) {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            return this.list.contains(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            this.visible = true;
            return new CopyOnWriteListIterator(this.list.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getList() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            this.visible = true;
            return this.list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            return this.list.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            return this.list.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            return this.list.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] x) {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            return this.list.toArray(x);
        }
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    private class CopyOnWriteListIterator
    implements Iterator {
        private Iterator it;
        private Object last;

        protected CopyOnWriteListIterator(Iterator _it) {
            this.it = _it;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            this.last = this.it.next();
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException("next has not been called!");
            }
            CopyOnWriteList.this.remove(this.last);
        }
    }
}

