/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

public class Java15Utils {
    private static volatile Java15UtilsProvider provider;

    public static boolean isAvailable() {
        return provider != null;
    }

    public static void setProvider(Java15UtilsProvider _provider) {
        provider = _provider;
    }

    public static void setConnectTimeout(URLConnection con, int timeout) {
        if (provider != null) {
            provider.setConnectTimeout(con, timeout);
        }
    }

    public static void setReadTimeout(URLConnection con, int timeout) {
        if (provider != null) {
            provider.setReadTimeout(con, timeout);
        }
    }

    public static long getThreadCPUTime() {
        if (provider != null) {
            return provider.getThreadCPUTime();
        }
        return 0L;
    }

    public static void dumpThreads() {
        if (provider != null) {
            provider.dumpThreads();
        }
    }

    public static URLConnection openConnectionForceNoProxy(URL url) throws IOException {
        if (provider != null) {
            return provider.openConnectionForceNoProxy(url);
        }
        return url.openConnection();
    }

    public static interface Java15UtilsProvider {
        public void setConnectTimeout(URLConnection var1, int var2);

        public void setReadTimeout(URLConnection var1, int var2);

        public long getThreadCPUTime();

        public void dumpThreads();

        public URLConnection openConnectionForceNoProxy(URL var1) throws IOException;
    }
}

