/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.launcher;

import com.aelitis.azureus.launcher.ClassLoaderWitness;
import com.aelitis.azureus.launcher.MainExecutor;
import com.aelitis.azureus.launcher.classloading.PeeringClassloader;
import com.aelitis.azureus.launcher.classloading.PrimaryClassloader;
import com.aelitis.azureus.launcher.classloading.SecondaryClassLoader;
import java.lang.reflect.Method;
import java.net.URL;
import org.gudy.azureus2.core3.util.Constants;

public class Launcher {
    private static final boolean LOADER_ENABLED = !Constants.isOSX;

    public static void launch(Class MainClass, String[] args) {
        ClassLoader primaryloader = PrimaryClassloader.getBootstrappedLoader();
        try {
            Method mainWrapper = primaryloader.loadClass(MainExecutor.class.getName()).getDeclaredMethod("load", ClassLoader.class, String.class, String[].class);
            mainWrapper.setAccessible(true);
            mainWrapper.invoke(null, primaryloader, MainClass.getName(), args);
        }
        catch (Exception e) {
            System.err.println("Bootstrapping failed");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static boolean checkAndLaunch(Class MainClass, String[] args) {
        if (Launcher.isBootStrapped()) {
            return false;
        }
        Launcher.launch(MainClass, args);
        return true;
    }

    public static boolean isBootStrapped() {
        return !LOADER_ENABLED || ClassLoaderWitness.class.getClassLoader() instanceof PeeringClassloader;
    }

    public static SecondaryClassLoader getComponentLoader(URL[] urls) {
        if (!Launcher.isBootStrapped()) {
            throw new IllegalStateException("Current Classloader is not part of the peering hierarchy!");
        }
        ClassLoader primary = ClassLoaderWitness.class.getClassLoader();
        while (!(primary instanceof PrimaryClassloader)) {
            primary = primary.getParent();
        }
        return new SecondaryClassLoader(urls, (PrimaryClassloader)primary);
    }

    public static void main(String[] args) {
    }
}

