/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.dht;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.control.DHTControlActivity;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncher;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDP;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginKeyStats;
import com.aelitis.azureus.plugins.dht.DHTPluginListener;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginTransferHandler;
import com.aelitis.azureus.plugins.dht.DHTPluginValue;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginContactImpl;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginImpl;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginImplAdapter;
import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfigListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.components.UITextField;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.LabelParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;

public class DHTPlugin
implements Plugin {
    public static final int EVENT_DHT_AVAILABLE = 1024;
    public static final int STATUS_DISABLED = 1;
    public static final int STATUS_INITALISING = 2;
    public static final int STATUS_RUNNING = 3;
    public static final int STATUS_FAILED = 4;
    public static final byte FLAG_SINGLE_VALUE = 0;
    public static final byte FLAG_DOWNLOADING = 1;
    public static final byte FLAG_SEEDING = 2;
    public static final byte FLAG_MULTI_VALUE = 4;
    public static final byte FLAG_STATS = 8;
    public static final byte FLAG_ANON = 16;
    public static final byte FLAG_PRECIOUS = 32;
    public static final byte DT_NONE = 1;
    public static final byte DT_FREQUENCY = 2;
    public static final byte DT_SIZE = 3;
    public static final int MAX_VALUE_SIZE = 512;
    private static final String PLUGIN_VERSION = "1.0";
    private static final String PLUGIN_NAME = "Distributed DB";
    private static final String PLUGIN_CONFIGSECTION_ID = "plugins.dht";
    private static final String PLUGIN_RESOURCE_ID = "ConfigView.section.plugins.dht";
    private static final boolean MAIN_DHT_ENABLE = true;
    private static final boolean CVS_DHT_ENABLE = true;
    private static final boolean MAIN_DHT_V6_ENABLE = true;
    private PluginInterface plugin_interface;
    private int status = 1;
    private DHTPluginImpl[] dhts;
    private DHTPluginImpl main_dht;
    private DHTPluginImpl cvs_dht;
    private DHTPluginImpl main_v6_dht;
    private ActionParameter reseed;
    private boolean enabled;
    private int dht_data_port;
    private boolean got_extended_use;
    private boolean extended_use;
    private AESemaphore init_sem = new AESemaphore("DHTPlugin:init");
    private AEMonitor port_change_mon = new AEMonitor("DHTPlugin:portChanger");
    private boolean port_changing;
    private int port_change_outstanding;
    private boolean[] ipfilter_logging = new boolean[1];
    private BooleanParameter warn_user;
    private UPnPMapping upnp_mapping;
    private LoggerChannel log;
    private DHTLogger dht_log;
    private List listeners = new ArrayList();
    private long start_mono_time = SystemTime.getMonotonousTime();

    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", PLUGIN_VERSION);
        plugin_interface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
    }

    public void initialize(PluginInterface _plugin_interface) {
        this.status = 2;
        this.plugin_interface = _plugin_interface;
        this.dht_data_port = UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber();
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel(PLUGIN_NAME);
        UIManager ui_manager = this.plugin_interface.getUIManager();
        final BasicPluginViewModel model = ui_manager.createBasicPluginViewModel(PLUGIN_RESOURCE_ID);
        model.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        BasicPluginConfigModel config = ui_manager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        config.addLabelParameter2("dht.info");
        BooleanParameter enabled_param = config.addBooleanParameter2("dht.enabled", "dht.enabled", true);
        this.plugin_interface.getPluginconfig().addListener(new PluginConfigListener(){

            public void configSaved() {
                int new_dht_data_port = UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber();
                if (new_dht_data_port != DHTPlugin.this.dht_data_port) {
                    DHTPlugin.this.changePort(new_dht_data_port);
                }
            }
        });
        LabelParameter reseed_label = config.addLabelParameter2("dht.reseed.label");
        final StringParameter reseed_ip = config.addStringParameter2("dht.reseed.ip", "dht.reseed.ip", "");
        final IntParameter reseed_port = config.addIntParameter2("dht.reseed.port", "dht.reseed.port", 0);
        this.reseed = config.addActionParameter2("dht.reseed.info", "dht.reseed");
        this.reseed.setEnabled(false);
        config.createGroup("dht.reseed.group", new Parameter[]{reseed_label, reseed_ip, reseed_port, this.reseed});
        final BooleanParameter ipfilter_logging_param = config.addBooleanParameter2("dht.ipfilter.log", "dht.ipfilter.log", true);
        this.ipfilter_logging[0] = ipfilter_logging_param.getValue();
        ipfilter_logging_param.addListener(new ParameterListener(){

            public void parameterChanged(Parameter p) {
                ((DHTPlugin)DHTPlugin.this).ipfilter_logging[0] = ipfilter_logging_param.getValue();
            }
        });
        this.warn_user = config.addBooleanParameter2("dht.warn.user", "dht.warn.user", true);
        final BooleanParameter advanced = config.addBooleanParameter2("dht.advanced", "dht.advanced", false);
        LabelParameter advanced_label = config.addLabelParameter2("dht.advanced.label");
        final StringParameter override_ip = config.addStringParameter2("dht.override.ip", "dht.override.ip", "");
        config.createGroup("dht.advanced.group", new Parameter[]{advanced_label, override_ip});
        advanced.addEnabledOnSelection(advanced_label);
        advanced.addEnabledOnSelection(override_ip);
        final StringParameter command = config.addStringParameter2("dht.execute.command", "dht.execute.command", "print");
        ActionParameter execute = config.addActionParameter2("dht.execute.info", "dht.execute");
        final BooleanParameter logging = config.addBooleanParameter2("dht.logging", "dht.logging", false);
        config.createGroup("dht.diagnostics.group", new Parameter[]{command, execute, logging});
        logging.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                if (DHTPlugin.this.dhts != null) {
                    for (int i = 0; i < DHTPlugin.this.dhts.length; ++i) {
                        DHTPlugin.this.dhts[i].setLogging(logging.getValue());
                    }
                }
            }
        });
        final DHTPluginOperationListener log_polistener = new DHTPluginOperationListener(){

            public void diversified() {
            }

            public void starts(byte[] key) {
            }

            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                DHTPlugin.this.log.log("valueRead: " + new String(value.getValue()) + " from " + originator.getName());
                if ((value.getFlags() & 8) != 0) {
                    DHTPluginKeyStats stats = DHTPlugin.this.decodeStats(value);
                    DHTPlugin.this.log.log("    stats: size=" + stats.getSize());
                }
            }

            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                DHTPlugin.this.log.log("valueWritten:" + new String(value.getValue()) + " to " + target.getName());
            }

            public void complete(byte[] key, boolean timeout_occurred) {
                DHTPlugin.this.log.log("complete: timeout = " + timeout_occurred);
            }
        };
        execute.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                AEThread2 t = new AEThread2("DHT:commandrunner", true){

                    public void run() {
                        if (DHTPlugin.this.dhts == null) {
                            return;
                        }
                        for (int i = 0; i < DHTPlugin.this.dhts.length; ++i) {
                            DHT dht = DHTPlugin.this.dhts[i].getDHT();
                            DHTTransportUDP transport = (DHTTransportUDP)dht.getTransport();
                            String c = command.getValue().trim();
                            String lc = c.toLowerCase();
                            if (lc.equals("print")) {
                                dht.print(true);
                                DHTPlugin.this.dhts[i].logStats();
                                continue;
                            }
                            if (lc.equals("pingall")) {
                                if (i != 1) continue;
                                dht.getControl().pingAll();
                                continue;
                            }
                            if (lc.equals("testca")) {
                                ((DHTTransportUDPImpl)transport).testExternalAddressChange();
                                continue;
                            }
                            if (lc.equals("testnd")) {
                                ((DHTTransportUDPImpl)transport).testNetworkAlive(false);
                                continue;
                            }
                            if (lc.equals("testna")) {
                                ((DHTTransportUDPImpl)transport).testNetworkAlive(true);
                                continue;
                            }
                            int pos = c.indexOf(32);
                            if (pos == -1) continue;
                            String lhs = lc.substring(0, pos);
                            String rhs = c.substring(pos + 1);
                            if (lhs.equals("set")) {
                                pos = rhs.indexOf(61);
                                if (pos == -1) continue;
                                DHTPlugin.this.put(rhs.substring(0, pos).getBytes(), "DHT Plugin: set", rhs.substring(pos + 1).getBytes(), (byte)0, log_polistener);
                                continue;
                            }
                            if (lhs.equals("get")) {
                                DHTPlugin.this.get(rhs.getBytes(), "DHT Plugin: get", (byte)0, 1, 10000L, true, false, log_polistener);
                                continue;
                            }
                            if (lhs.equals("query")) {
                                DHTPlugin.this.get(rhs.getBytes(), "DHT Plugin: get", (byte)8, 1, 10000L, true, false, log_polistener);
                                continue;
                            }
                            if (lhs.equals("punch")) {
                                HashMap<String, String> originator_data = new HashMap<String, String>();
                                originator_data.put("hello", "mum");
                                DHTNATPuncher puncher = dht.getNATPuncher();
                                if (puncher == null) continue;
                                puncher.punch("Test", transport.getLocalContact(), null, originator_data);
                                continue;
                            }
                            if (!lhs.equals("stats")) continue;
                            try {
                                DHTTransportContact contact;
                                pos = rhs.lastIndexOf(":");
                                if (pos == -1) {
                                    contact = transport.getLocalContact();
                                } else {
                                    String host = rhs.substring(0, pos);
                                    int port = Integer.parseInt(rhs.substring(pos + 1));
                                    contact = transport.importContact(new InetSocketAddress(host, port), transport.getProtocolVersion());
                                }
                                DHTPlugin.this.log.log("Stats request to " + contact.getName());
                                DHTTransportFullStats stats = contact.getStats();
                                DHTPlugin.this.log.log("Stats:" + (stats == null ? "<null>" : stats.getString()));
                                DHTControlActivity[] activities = dht.getControl().getActivities();
                                for (int j = 0; j < activities.length; ++j) {
                                    DHTPlugin.this.log.log("    act:" + activities[j].getString());
                                }
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                };
                t.start();
            }
        });
        this.reseed.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                DHTPlugin.this.reseed.setEnabled(false);
                AEThread2 t = new AEThread2("DHT:reseeder", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            String ip = reseed_ip.getValue().trim();
                            if (DHTPlugin.this.dhts == null) {
                                return;
                            }
                            int port = reseed_port.getValue();
                            for (int i = 0; i < DHTPlugin.this.dhts.length; ++i) {
                                DHTPluginImpl dht = DHTPlugin.this.dhts[i];
                                if (ip.length() == 0 || port == 0) {
                                    dht.checkForReSeed(true);
                                    continue;
                                }
                                if (dht.importSeed(ip, port) == null) continue;
                                dht.integrateDHT(false, null);
                            }
                        }
                        finally {
                            DHTPlugin.this.reseed.setEnabled(true);
                        }
                    }
                };
                t.start();
            }
        });
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String message) {
                model.getLogArea().appendText(message + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                model.getLogArea().appendText(error.toString() + "\n");
            }
        });
        this.dht_log = new DHTLogger(){

            public void log(String str) {
                DHTPlugin.this.log.log(str);
            }

            public void log(Throwable e) {
                DHTPlugin.this.log.log(e);
            }

            public void log(int log_type, String str) {
                if (this.isEnabled(log_type)) {
                    DHTPlugin.this.log.log(str);
                }
            }

            public boolean isEnabled(int log_type) {
                if (log_type == 2) {
                    return DHTPlugin.this.ipfilter_logging[0];
                }
                return true;
            }

            public PluginInterface getPluginInterface() {
                return DHTPlugin.this.log.getLogger().getPluginInterface();
            }
        };
        if (!enabled_param.getValue()) {
            model.getStatus().setText("Disabled");
            this.status = 1;
            this.init_sem.releaseForever();
            return;
        }
        this.setPluginInfo();
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                PluginInterface pi_upnp = DHTPlugin.this.plugin_interface.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
                if (pi_upnp == null) {
                    DHTPlugin.this.log.log("UPnP plugin not found, can't map port");
                } else {
                    DHTPlugin.this.upnp_mapping = ((UPnPPlugin)pi_upnp.getPlugin()).addMapping(DHTPlugin.this.plugin_interface.getPluginName(), false, DHTPlugin.this.dht_data_port, true);
                }
                String ip = null;
                if (advanced.getValue() && (ip = override_ip.getValue().trim()).length() == 0) {
                    ip = null;
                }
                DHTPlugin.this.initComplete(model.getStatus(), logging.getValue(), ip);
            }

            public void closedownInitiated() {
                if (DHTPlugin.this.dhts != null) {
                    for (int i = 0; i < DHTPlugin.this.dhts.length; ++i) {
                        DHTPlugin.this.dhts[i].closedownInitiated();
                    }
                }
                DHTPlugin.this.saveClockSkew();
            }

            public void closedownComplete() {
            }
        });
        int sample_frequency = 60000;
        int sample_stats_ticks = 15;
        this.plugin_interface.getUtilities().createTimer("DHTStats", true).addPeriodicEvent(60000L, new UTTimerEventPerformer(){

            public void perform(UTTimerEvent event2) {
                if (DHTPlugin.this.dhts != null) {
                    for (int i = 0; i < DHTPlugin.this.dhts.length; ++i) {
                        DHTPlugin.this.dhts[i].updateStats(15);
                    }
                }
                DHTPlugin.this.setPluginInfo();
                DHTPlugin.this.saveClockSkew();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changePort(int _new_port) {
        try {
            this.port_change_mon.enter();
            this.port_change_outstanding = _new_port;
            if (this.port_changing) {
                return;
            }
            this.port_changing = true;
        }
        finally {
            this.port_change_mon.exit();
        }
        new AEThread2("DHTPlugin:portChanger", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block11: while (true) {
                    int new_port;
                    try {
                        DHTPlugin.this.port_change_mon.enter();
                        new_port = DHTPlugin.this.port_change_outstanding;
                    }
                    finally {
                        DHTPlugin.this.port_change_mon.exit();
                    }
                    try {
                        DHTPlugin.this.dht_data_port = new_port;
                        if (DHTPlugin.this.upnp_mapping != null && DHTPlugin.this.upnp_mapping.getPort() != new_port) {
                            DHTPlugin.this.upnp_mapping.setPort(new_port);
                        }
                        if (DHTPlugin.this.status != 3 || DHTPlugin.this.dhts == null) continue;
                        int i = 0;
                        while (true) {
                            if (i >= DHTPlugin.this.dhts.length) continue block11;
                            if (DHTPlugin.this.dhts[i].getPort() != new_port) {
                                DHTPlugin.this.dhts[i].setPort(new_port);
                            }
                            ++i;
                        }
                    }
                    finally {
                        try {
                            DHTPlugin.this.port_change_mon.enter();
                            if (new_port != DHTPlugin.this.port_change_outstanding) continue;
                            DHTPlugin.this.port_changing = false;
                        }
                        finally {
                            DHTPlugin.this.port_change_mon.exit();
                            continue;
                        }
                    }
                    break;
                }
            }
        }.start();
    }

    protected void initComplete(final UITextField status_area, final boolean logging, final String override_ip) {
        AEThread2 t = new AEThread2("DHTPlugin.init", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean went_async = false;
                try {
                    DHTPlugin.this.enabled = VersionCheckClient.getSingleton().DHTEnableAllowed();
                    if (DHTPlugin.this.enabled) {
                        status_area.setText("Initialising");
                        DelayedTask dt = DHTPlugin.this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

                            public void run() {
                                new AEThread2("DHTPlugin.init2", true){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void run() {
                                        try {
                                            ArrayList<DHTPluginImpl> plugins = new ArrayList<DHTPluginImpl>();
                                            DHTPluginImplAdapter adapter = new DHTPluginImplAdapter(){

                                                public void localContactChanged(DHTPluginContact local_contact) {
                                                    for (int i = 0; i < DHTPlugin.this.listeners.size(); ++i) {
                                                        ((DHTPluginListener)DHTPlugin.this.listeners.get(i)).localAddressChanged(local_contact);
                                                    }
                                                }
                                            };
                                            DHTPlugin.this.main_dht = new DHTPluginImpl(DHTPlugin.this.plugin_interface, AzureusCoreFactory.getSingleton().getNATTraverser(), adapter, 21, 0, false, override_ip, DHTPlugin.this.dht_data_port, DHTPlugin.this.reseed, DHTPlugin.this.warn_user, logging, DHTPlugin.this.log, DHTPlugin.this.dht_log);
                                            plugins.add(DHTPlugin.this.main_dht);
                                            adapter = null;
                                            if (NetworkAdmin.getSingleton().hasIPV6Potential(false)) {
                                                DHTPlugin.this.main_v6_dht = new DHTPluginImpl(DHTPlugin.this.plugin_interface, AzureusCoreFactory.getSingleton().getNATTraverser(), adapter, 21, 3, true, null, DHTPlugin.this.dht_data_port, DHTPlugin.this.reseed, DHTPlugin.this.warn_user, logging, DHTPlugin.this.log, DHTPlugin.this.dht_log);
                                                plugins.add(DHTPlugin.this.main_v6_dht);
                                                adapter = null;
                                            }
                                            if (Constants.isCVSVersion()) {
                                                DHTPlugin.this.cvs_dht = new DHTPluginImpl(DHTPlugin.this.plugin_interface, AzureusCoreFactory.getSingleton().getNATTraverser(), adapter, 21, 1, false, override_ip, DHTPlugin.this.dht_data_port, DHTPlugin.this.reseed, DHTPlugin.this.warn_user, logging, DHTPlugin.this.log, DHTPlugin.this.dht_log);
                                                plugins.add(DHTPlugin.this.cvs_dht);
                                                adapter = null;
                                            }
                                            DHTPluginImpl[] _dhts = new DHTPluginImpl[plugins.size()];
                                            plugins.toArray(_dhts);
                                            DHTPlugin.access$202(DHTPlugin.this, _dhts);
                                            DHTPlugin.this.status = DHTPlugin.this.dhts[0].getStatus();
                                            status_area.setText(DHTPlugin.this.dhts[0].getStatusText());
                                        }
                                        catch (Throwable e) {
                                            DHTPlugin.this.enabled = false;
                                            DHTPlugin.this.status = 1;
                                            status_area.setText("Disabled due to error during initialisation");
                                            DHTPlugin.this.log.log(e);
                                            Debug.printStackTrace(e);
                                        }
                                        finally {
                                            DHTPlugin.this.init_sem.releaseForever();
                                        }
                                        if (DHTPlugin.this.status == 3) {
                                            DHTPlugin.this.changePort(DHTPlugin.this.dht_data_port);
                                        }
                                    }
                                }.start();
                            }
                        });
                        dt.queue();
                        went_async = true;
                    } else {
                        DHTPlugin.this.status = 1;
                        status_area.setText("Disabled administratively due to network problems");
                    }
                }
                catch (Throwable e) {
                    DHTPlugin.this.enabled = false;
                    DHTPlugin.this.status = 1;
                    status_area.setText("Disabled due to error during initialisation");
                    DHTPlugin.this.log.log(e);
                    Debug.printStackTrace(e);
                }
                finally {
                    if (!went_async) {
                        DHTPlugin.this.init_sem.releaseForever();
                    }
                }
            }
        };
        t.start();
    }

    protected void setPluginInfo() {
        boolean reachable = this.plugin_interface.getPluginconfig().getPluginBooleanParameter("dht.reachable.0", true);
        this.plugin_interface.getPluginconfig().setPluginParameter("plugin.info", reachable ? "1" : "0");
    }

    public boolean isEnabled() {
        if (this.plugin_interface == null) {
            Debug.out("Called too early!");
            return false;
        }
        if (this.plugin_interface.isInitialisationThread() && !this.init_sem.isReleasedForever()) {
            Debug.out("Initialisation deadlock detected");
            return true;
        }
        this.init_sem.reserve();
        return this.enabled;
    }

    public boolean peekEnabled() {
        if (this.init_sem.isReleasedForever()) {
            return this.enabled;
        }
        return true;
    }

    public boolean isInitialising() {
        return !this.init_sem.isReleasedForever();
    }

    public boolean isExtendedUseAllowed() {
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.got_extended_use) {
            this.got_extended_use = true;
            this.extended_use = VersionCheckClient.getSingleton().DHTExtendedUseAllowed();
        }
        return this.extended_use;
    }

    public boolean isReachable() {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        return this.dhts[0].isReachable();
    }

    public boolean isDiversified(byte[] key) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        return this.dhts[0].isDiversified(key);
    }

    public void put(byte[] key, String description, byte[] value, byte flags, DHTPluginOperationListener listener) {
        this.put(key, description, value, flags, true, listener);
    }

    public void put(byte[] key, String description, byte[] value, byte flags, boolean high_priority, final DHTPluginOperationListener listener) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        if (this.dhts.length == 1) {
            this.dhts[0].put(key, description, value, flags, high_priority, listener);
        } else {
            final int[] completes_to_go = new int[]{this.dhts.length};
            DHTPluginOperationListener main_listener = new DHTPluginOperationListener(){

                public void diversified() {
                    listener.diversified();
                }

                public void starts(byte[] key) {
                    listener.starts(key);
                }

                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    listener.valueRead(originator, value);
                }

                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                    listener.valueWritten(target, value);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void complete(byte[] key, boolean timeout_occurred) {
                    int[] nArray = completes_to_go;
                    synchronized (completes_to_go) {
                        completes_to_go[0] = completes_to_go[0] - 1;
                        if (completes_to_go[0] == 0) {
                            listener.complete(key, timeout_occurred);
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                }
            };
            this.dhts[0].put(key, description, value, flags, high_priority, main_listener);
            for (int i = 1; i < this.dhts.length; ++i) {
                this.dhts[i].put(key, description, value, flags, high_priority, new DHTPluginOperationListener(){

                    public void diversified() {
                    }

                    public void starts(byte[] key) {
                    }

                    public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    }

                    public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void complete(byte[] key, boolean timeout_occurred) {
                        int[] nArray = completes_to_go;
                        synchronized (completes_to_go) {
                            completes_to_go[0] = completes_to_go[0] - 1;
                            if (completes_to_go[0] == 0) {
                                listener.complete(key, timeout_occurred);
                            }
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return;
                        }
                    }
                });
            }
        }
    }

    public DHTPluginValue getLocalValue(byte[] key) {
        return this.main_dht.getLocalValue(key);
    }

    public void get(final byte[] original_key, String description, byte flags, int max_values, final long timeout, boolean exhaustive, boolean high_priority, final DHTPluginOperationListener original_listener) {
        DHTPluginOperationListener main_listener;
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        if (this.cvs_dht == null) {
            main_listener = original_listener;
        } else {
            final int[] completes_to_go = new int[]{2};
            final boolean[] main_timeout = new boolean[]{false};
            main_listener = new DHTPluginOperationListener(){

                public void diversified() {
                    original_listener.diversified();
                }

                public void starts(byte[] key) {
                    original_listener.starts(original_key);
                }

                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    original_listener.valueRead(originator, value);
                }

                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                    original_listener.valueWritten(target, value);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void complete(byte[] key, boolean timeout_occurred) {
                    int[] nArray = completes_to_go;
                    synchronized (completes_to_go) {
                        completes_to_go[0] = completes_to_go[0] - 1;
                        main_timeout[0] = timeout_occurred;
                        if (completes_to_go[0] == 0) {
                            original_listener.complete(original_key, timeout_occurred);
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                }
            };
            this.cvs_dht.get(original_key, description, flags, max_values, timeout, exhaustive, high_priority, new DHTPluginOperationListener(){

                public void diversified() {
                }

                public void starts(byte[] key) {
                }

                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                }

                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void complete(byte[] key, boolean timeout_occurred) {
                    int[] nArray = completes_to_go;
                    synchronized (completes_to_go) {
                        completes_to_go[0] = completes_to_go[0] - 1;
                        if (completes_to_go[0] == 0) {
                            original_listener.complete(original_key, main_timeout[0]);
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
        if (this.main_dht != null && this.main_v6_dht == null) {
            this.main_dht.get(original_key, description, flags, max_values, timeout, exhaustive, high_priority, main_listener);
        } else if (this.main_dht == null && this.main_v6_dht != null) {
            this.main_v6_dht.get(original_key, description, flags, max_values, timeout, exhaustive, high_priority, main_listener);
        } else {
            byte[] v4_key = original_key;
            final byte[] v6_key = (byte[])original_key.clone();
            DHTPluginOperationListener dual_listener = new DHTPluginOperationListener(){
                private long start_time = SystemTime.getCurrentTime();
                private boolean started;
                private int complete_count = 0;
                private int result_count = 0;

                public void diversified() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void starts(byte[] key) {
                    17 var2_2 = this;
                    synchronized (var2_2) {
                        if (this.started) {
                            return;
                        }
                        this.started = true;
                    }
                    main_listener.starts(original_key);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    17 var3_3 = this;
                    synchronized (var3_3) {
                        ++this.result_count;
                        if (this.complete_count < 2) {
                            main_listener.valueRead(originator, value);
                        }
                    }
                }

                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                    Debug.out("eh?");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void complete(final byte[] timeout_key, boolean timeout_occurred) {
                    17 var3_3 = this;
                    synchronized (var3_3) {
                        ++this.complete_count;
                        if (this.complete_count == 2) {
                            main_listener.complete(original_key, this.result_count > 0 ? false : timeout_occurred);
                            return;
                        }
                        if (this.complete_count > 2) {
                            return;
                        }
                        if (timeout_occurred) {
                            return;
                        }
                        if (timeout_key == v6_key) {
                            return;
                        }
                        long now = SystemTime.getCurrentTime();
                        long elapsed = now - this.start_time;
                        long rem = timeout - elapsed;
                        if (rem <= 0L) {
                            this.complete(timeout_key, true);
                        } else {
                            SimpleTimer.addEvent("DHTPlugin:dual_dht_early_timeout", now + rem, new TimerEventPerformer(){

                                public void perform(TimerEvent event2) {
                                    this.complete(timeout_key, true);
                                }
                            });
                        }
                    }
                }
            };
            this.main_dht.get(v4_key, description, flags, max_values, timeout, exhaustive, high_priority, dual_listener);
            this.main_v6_dht.get(v6_key, description, flags, max_values, timeout, exhaustive, high_priority, dual_listener);
        }
    }

    public boolean hasLocalKey(byte[] hash) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        return this.dhts[0].getLocalValue(hash) != null;
    }

    public void remove(final byte[] key, final String description, DHTPluginOperationListener listener) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        this.dhts[0].remove(key, description, listener);
        int i = 1;
        while (i < this.dhts.length) {
            final int f_i = i++;
            new AEThread2("multi-dht: remove", true){

                public void run() {
                    DHTPlugin.this.dhts[f_i].remove(key, description, new DHTPluginOperationListener(){

                        public void diversified() {
                        }

                        public void starts(byte[] key) {
                        }

                        public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                        }

                        public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                        }

                        public void complete(byte[] key, boolean timeout_occurred) {
                        }
                    });
                }
            }.start();
        }
    }

    public void remove(DHTPluginContact[] targets, byte[] key, String description, DHTPluginOperationListener listener) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        HashMap<DHTPluginImpl, ArrayList<DHTPluginContactImpl>> dht_map = new HashMap<DHTPluginImpl, ArrayList<DHTPluginContactImpl>>();
        for (int i = 0; i < targets.length; ++i) {
            DHTPluginContactImpl target = (DHTPluginContactImpl)targets[i];
            DHTPluginImpl dht = target.getDHT();
            ArrayList<DHTPluginContactImpl> c = (ArrayList<DHTPluginContactImpl>)dht_map.get(dht);
            if (c == null) {
                c = new ArrayList<DHTPluginContactImpl>();
                dht_map.put(dht, c);
            }
            c.add(target);
        }
        Iterator it = dht_map.entrySet().iterator();
        boolean primary = true;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            DHTPluginImpl dht = (DHTPluginImpl)entry.getKey();
            List contacts = (List)entry.getValue();
            DHTPluginContact[] dht_targets = new DHTPluginContact[contacts.size()];
            contacts.toArray(dht_targets);
            if (primary) {
                primary = false;
                dht.remove(dht_targets, key, description, listener);
                continue;
            }
            dht.remove(dht_targets, key, description, new DHTPluginOperationListener(){

                public void diversified() {
                }

                public void starts(byte[] key) {
                }

                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                }

                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                }

                public void complete(byte[] key, boolean timeout_occurred) {
                }
            });
        }
    }

    public DHTPluginContact importContact(InetSocketAddress address) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        return this.dhts[0].importContact(address);
    }

    public DHTPluginContact getLocalAddress() {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        return this.dhts[0].getLocalAddress();
    }

    public void registerHandler(byte[] handler_key, DHTPluginTransferHandler handler) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        for (int i = 0; i < this.dhts.length; ++i) {
            this.dhts[i].registerHandler(handler_key, handler);
        }
    }

    public int getStatus() {
        return this.status;
    }

    public DHT[] getDHTs() {
        if (this.dhts == null) {
            return new DHT[0];
        }
        DHT[] res = new DHT[this.dhts.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.dhts[i].getDHT();
        }
        return res;
    }

    public DHT getDHT(int network) {
        if (this.dhts == null) {
            return null;
        }
        for (int i = 0; i < this.dhts.length; ++i) {
            if (this.dhts[i].getDHT().getTransport().getNetwork() != network) continue;
            return this.dhts[i].getDHT();
        }
        return null;
    }

    protected long loadClockSkew() {
        return this.plugin_interface.getPluginconfig().getPluginLongParameter("dht.skew", 0L);
    }

    protected void saveClockSkew() {
        long current;
        long existing = this.loadClockSkew();
        if (Math.abs(existing - (current = this.getClockSkew())) > 5000L) {
            this.plugin_interface.getPluginconfig().setPluginParameter("dht.skew", this.getClockSkew());
        }
    }

    public long getClockSkew() {
        if (this.dhts == null || this.dhts.length == 0) {
            return 0L;
        }
        long uptime = SystemTime.getMonotonousTime() - this.start_mono_time;
        if (uptime < 300000L) {
            return this.loadClockSkew();
        }
        long skew = this.dhts[0].getClockSkew();
        if (skew > 86400000L) {
            skew = 0L;
        }
        skew = skew / 500L * 500L;
        return skew;
    }

    public DHTPluginKeyStats decodeStats(DHTPluginValue value) {
        return this.dhts[0].decodeStats(value);
    }

    public void addListener(DHTPluginListener l) {
        this.listeners.add(l);
    }

    public void removeListener(DHTPluginListener l) {
        this.listeners.remove(l);
    }

    public void log(String str) {
        this.log.log(str);
    }

    static /* synthetic */ DHTPluginImpl[] access$202(DHTPlugin x0, DHTPluginImpl[] x1) {
        x0.dhts = x1;
        return x1;
    }
}

