/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.impl.getright;

import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.impl.ExternalSeedReaderImpl;
import com.aelitis.azureus.plugins.extseed.impl.ExternalSeedReaderRequest;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloader;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderListener;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class ExternalSeedReaderGetRight
extends ExternalSeedReaderImpl {
    private static final int TARGET_REQUEST_SIZE_DEFAULT = 262144;
    private URL url;
    private String ip;
    private int port;
    private ExternalSeedHTTPDownloader[] http_downloaders;
    private long[] downloader_offsets;
    private long[] downloader_lengths;
    private int piece_size;
    private int piece_group_size;

    protected ExternalSeedReaderGetRight(ExternalSeedPlugin _plugin, Torrent _torrent, URL _url, Map _params) throws Exception {
        super(_plugin, _torrent, _params);
        int target_request_size = this.getIntParam(_params, "req_size", 262144);
        this.url = _url;
        this.ip = this.url.getHost();
        this.port = this.url.getPort();
        if (this.port == -1) {
            this.port = this.url.getDefaultPort();
        }
        this.piece_size = (int)this.getTorrent().getPieceSize();
        this.piece_group_size = target_request_size / this.piece_size;
        if (this.piece_group_size == 0) {
            this.piece_group_size = 1;
        }
        TOTorrent to_torrent = ((TorrentImpl)_torrent).getTorrent();
        String ua = this.getUserAgent();
        if (to_torrent.isSimpleTorrent()) {
            this.http_downloaders = new ExternalSeedHTTPDownloader[]{new ExternalSeedHTTPDownloader(this.url, ua)};
            this.downloader_offsets = new long[]{0L};
            this.downloader_lengths = new long[]{to_torrent.getSize()};
        } else {
            TOTorrentFile[] files = to_torrent.getFiles();
            this.http_downloaders = new ExternalSeedHTTPDownloader[files.length];
            this.downloader_offsets = new long[files.length];
            this.downloader_lengths = new long[files.length];
            long offset = 0L;
            String base_url = this.url.toString();
            if (base_url.endsWith("/")) {
                base_url = base_url.substring(0, base_url.length() - 1);
            }
            base_url = base_url + "/" + URLEncoder.encode(new String(to_torrent.getName(), "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
            for (int i = 0; i < files.length; ++i) {
                TOTorrentFile file = files[i];
                long length = file.getLength();
                String file_url_str = base_url;
                byte[][] bits = file.getPathComponents();
                for (int j = 0; j < bits.length; ++j) {
                    file_url_str = file_url_str + "/" + URLEncoder.encode(new String(bits[j], "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
                }
                this.http_downloaders[i] = new ExternalSeedHTTPDownloader(new URL(file_url_str), ua);
                this.downloader_offsets[i] = offset;
                this.downloader_lengths[i] = length;
                offset += length;
            }
        }
    }

    public boolean sameAs(ExternalSeedReader other) {
        if (other instanceof ExternalSeedReaderGetRight) {
            return this.url.toString().equals(((ExternalSeedReaderGetRight)other).url.toString());
        }
        return false;
    }

    public String getName() {
        return "GR: " + this.url;
    }

    public String getIP() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    protected int getPieceGroupSize() {
        return this.piece_group_size;
    }

    protected boolean getRequestCanSpanPieces() {
        return true;
    }

    protected void readData(ExternalSeedReaderRequest request2) throws ExternalSeedException {
        this.readData(request2.getStartPieceNumber(), request2.getStartPieceOffset(), request2.getLength(), request2);
    }

    protected void readData(int start_piece_number, int start_piece_offset, int length, final ExternalSeedHTTPDownloaderListener listener) throws ExternalSeedException {
        this.setReconnectDelay(30000, false);
        long request_start = start_piece_number * this.piece_size + start_piece_offset;
        int request_length = length;
        if (this.http_downloaders.length == 1) {
            ExternalSeedHTTPDownloader http_downloader = this.http_downloaders[0];
            try {
                http_downloader.downloadRange(request_start, request_length, listener, this.isTransient());
            }
            catch (ExternalSeedException ese) {
                if (http_downloader.getLastResponse() == 503 && http_downloader.getLast503RetrySecs() >= 0) {
                    int retry_secs = http_downloader.getLast503RetrySecs();
                    this.setReconnectDelay(retry_secs * 1000, true);
                    throw new ExternalSeedException("Server temporarily unavailable, retrying in " + retry_secs + " seconds");
                }
                throw ese;
            }
        } else {
            long request_end = request_start + (long)request_length;
            final byte[][] overlap_buffer = new byte[][]{null};
            final int[] overlap_buffer_position = new int[]{0};
            for (int i = 0; i < this.http_downloaders.length; ++i) {
                long this_start = this.downloader_offsets[i];
                long this_end = this_start + this.downloader_lengths[i];
                if (this_end <= request_start) continue;
                if (this_start >= request_end) break;
                long sub_request_start = Math.max(request_start, this_start);
                long sub_request_end = Math.min(request_end, this_end);
                final int sub_len = (int)(sub_request_end - sub_request_start);
                if (sub_len == 0) continue;
                ExternalSeedHTTPDownloader http_downloader = this.http_downloaders[i];
                ExternalSeedHTTPDownloaderListener sub_request = new ExternalSeedHTTPDownloaderListener(){
                    private int bytes_read;
                    private byte[] current_buffer;
                    private int current_buffer_position;
                    private int current_buffer_length;
                    {
                        this.current_buffer = overlap_buffer[0];
                        this.current_buffer_position = overlap_buffer_position[0];
                        this.current_buffer_length = this.current_buffer == null ? -1 : Math.min(this.current_buffer.length, this.current_buffer_position + sub_len);
                    }

                    public byte[] getBuffer() throws ExternalSeedException {
                        if (this.current_buffer == null) {
                            this.current_buffer = listener.getBuffer();
                            this.current_buffer_position = 0;
                            this.current_buffer_length = Math.min(this.current_buffer.length, sub_len - this.bytes_read);
                        }
                        return this.current_buffer;
                    }

                    public void setBufferPosition(int position) {
                        this.current_buffer_position = position;
                        listener.setBufferPosition(position);
                    }

                    public int getBufferPosition() {
                        return this.current_buffer_position;
                    }

                    public int getBufferLength() {
                        return this.current_buffer_length;
                    }

                    public int getPermittedBytes() throws ExternalSeedException {
                        return listener.getPermittedBytes();
                    }

                    public int getPermittedTime() {
                        return listener.getPermittedTime();
                    }

                    public void reportBytesRead(int num) {
                        this.bytes_read += num;
                        listener.reportBytesRead(num);
                    }

                    public void done() {
                        int rem = this.current_buffer.length - this.current_buffer_length;
                        if (this.bytes_read == sub_len) {
                            if (rem == 0) {
                                overlap_buffer[0] = null;
                                overlap_buffer_position[0] = 0;
                            } else {
                                overlap_buffer[0] = this.current_buffer;
                                overlap_buffer_position[0] = this.current_buffer_length;
                            }
                        }
                        this.current_buffer = null;
                        if (rem == 0) {
                            listener.done();
                        }
                    }
                };
                try {
                    http_downloader.downloadRange(sub_request_start - this_start, sub_len, sub_request, this.isTransient());
                    continue;
                }
                catch (ExternalSeedException ese) {
                    if (http_downloader.getLastResponse() == 503 && http_downloader.getLast503RetrySecs() >= 0) {
                        int retry_secs = http_downloader.getLast503RetrySecs();
                        this.setReconnectDelay(retry_secs * 1000, true);
                        throw new ExternalSeedException("Server temporarily unavailable, retrying in " + retry_secs + " seconds");
                    }
                    throw ese;
                }
            }
        }
    }
}

