/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.security.CryptoHandler;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.security.CryptoManagerKeyListener;
import com.aelitis.azureus.core.security.CryptoManagerPasswordException;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginAZ2;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddy;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyRequestListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginException;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginPasswordException;
import com.aelitis.azureus.plugins.net.buddy.swt.BuddyPluginView;
import com.aelitis.azureus.plugins.net.buddy.tracker.BuddyPluginTracker;
import java.io.File;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseContact;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseEvent;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKey;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnection;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageHandler;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageRegistration;
import org.gudy.azureus2.plugins.network.RateLimiter;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.StringListParameter;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.LocaleListener;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;
import org.gudy.azureus2.plugins.utils.security.SEPublicKey;
import org.gudy.azureus2.plugins.utils.security.SEPublicKeyLocator;
import org.gudy.azureus2.plugins.utils.security.SESecurityManager;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;

public class BuddyPlugin
implements Plugin {
    public static final boolean SUPPORT_ONLINE_STATUS = true;
    public static final int VERSION_INITIAL = 1;
    public static final int VERSION_CHAT = 2;
    public static final int VERSION_CURRENT = 2;
    public static final int MT_V3_CHAT = 1;
    public static final int MAX_MESSAGE_SIZE = 0x400000;
    public static final int SUBSYSTEM_INTERNAL = 0;
    public static final int SUBSYSTEM_AZ2 = 1;
    public static final int SUBSYSTEM_AZ3 = 2;
    protected static final int SUBSYSTEM_MSG_TYPE_BASE = 1024;
    public static final int STATUS_ONLINE = 0;
    public static final int STATUS_AWAY = 1;
    public static final int STATUS_NOT_AVAILABLE = 2;
    public static final int STATUS_BUSY = 3;
    public static final int STATUS_APPEAR_OFFLINE = 4;
    public static final String[] STATUS_VALUES = new String[]{"0", "1", "2", "3", "4"};
    public static final String[] STATUS_KEYS = new String[]{"os_online", "os_away", "os_not_avail", "os_busy", "os_offline"};
    public static final String[] STATUS_STRINGS = new String[STATUS_KEYS.length];
    protected static final int RT_INTERNAL_REQUEST_PING = 1;
    protected static final int RT_INTERNAL_REPLY_PING = 2;
    protected static final int RT_INTERNAL_REQUEST_CLOSE = 3;
    protected static final int RT_INTERNAL_REPLY_CLOSE = 4;
    protected static final int RT_INTERNAL_FRAGMENT = 5;
    protected static final boolean TRACE = false;
    private static final String VIEW_ID = "azbuddy";
    private static final int INIT_UNKNOWN = 0;
    private static final int INIT_OK = 1;
    private static final int INIT_BAD = 2;
    private static final int MAX_UNAUTH_BUDDIES = 16;
    public static final int TIMER_PERIOD = 10000;
    private static final int BUDDY_STATUS_CHECK_PERIOD_MIN = 180000;
    private static final int BUDDY_STATUS_CHECK_PERIOD_INC = 60000;
    protected static final int STATUS_REPUBLISH_PERIOD = 600000;
    private static final int STATUS_REPUBLISH_TICKS = 60;
    private static final int CHECK_YGM_PERIOD = 300000;
    private static final int CHECK_YGM_TICKS = 30;
    private static final int YGM_BLOOM_LIFE_PERIOD = 3600000;
    private static final int YGM_BLOOM_LIFE_TICKS = 360;
    private static final int SAVE_CONFIG_PERIOD = 60000;
    private static final int SAVE_CONFIG_TICKS = 6;
    public static final int PERSISTENT_MSG_RETRY_PERIOD = 300000;
    private static final int PERSISTENT_MSG_CHECK_PERIOD = 60000;
    private static final int PERSISTENT_MSG_CHECK_TICKS = 6;
    private static final int UNAUTH_BLOOM_RECREATE = 120000;
    private static final int UNAUTH_BLOOM_CHUNK = 1000;
    private static BloomFilter unauth_bloom;
    private static long unauth_bloom_create_time;
    private static final int BLOOM_CHECK_PERIOD = 60000;
    private static final int BLOOM_CHECK_TICKS = 6;
    private static BloomFilter ygm_unauth_bloom;
    public static final int STREAM_CRYPTO = 3;
    public static final int BLOCK_CRYPTO = 2;
    private volatile int initialisation_state = 0;
    private PluginInterface plugin_interface;
    private LoggerChannel logger;
    private BooleanParameter enabled_param;
    private StringParameter nick_name_param;
    private StringListParameter online_status_param;
    private BooleanParameter enable_chat_notifications;
    private boolean ready_to_publish;
    private publishDetails current_publish;
    private publishDetails latest_publish = this.current_publish = new publishDetails();
    private long last_publish_start;
    private TimerEvent republish_delay_event;
    private AsyncDispatcher publish_dispatcher = new AsyncDispatcher();
    private DistributedDatabase ddb;
    private CryptoHandler ecc_handler = CryptoManagerFactory.getSingleton().getECCHandler();
    private List buddies = new ArrayList();
    private Map buddies_map = new HashMap();
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private CopyOnWriteList request_listeners = new CopyOnWriteList();
    private SESecurityManager sec_man;
    private GenericMessageRegistration msg_registration;
    private int inbound_limit;
    private int outbound_limit;
    private RateLimiter inbound_limiter = new RateLimiter(){

        public int getRateLimitBytesPerSecond() {
            return BuddyPlugin.this.inbound_limit;
        }
    };
    private RateLimiter outbound_limiter = new RateLimiter(){

        public int getRateLimitBytesPerSecond() {
            return BuddyPlugin.this.outbound_limit;
        }
    };
    private boolean config_dirty;
    private Random random = new SecureRandom();
    private BuddyPluginAZ2 az2_handler;
    private List publish_write_contacts = new ArrayList();
    private int status_seq;
    private Set pd_preinit;
    private List pd_queue;
    private AESemaphore pd_queue_sem;
    private AEThread2 pd_thread;
    private boolean bogus_ygm_written;
    private BuddyPluginTracker buddy_tracker;

    public BuddyPlugin() {
        while (this.status_seq == 0) {
            this.status_seq = this.random.nextInt();
        }
        this.pd_preinit = new HashSet();
        this.pd_queue = new ArrayList();
        this.pd_queue_sem = new AESemaphore("BuddyPlugin:persistDispatch");
    }

    public static void load(PluginInterface plugin_interface) {
        String name = plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("Views.plugins.azbuddy.title");
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", name);
    }

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.az2_handler = new BuddyPluginAZ2(this);
        this.sec_man = this.plugin_interface.getUtilities().getSecurityManager();
        this.logger = this.plugin_interface.getLogger().getChannel("Friends");
        this.logger.setDiagnostic();
        final LocaleUtilities lu = this.plugin_interface.getUtilities().getLocaleUtilities();
        lu.addListener(new LocaleListener(){

            public void localeChanged(Locale l) {
                BuddyPlugin.this.updateLocale(lu);
            }
        });
        this.updateLocale(lu);
        BasicPluginConfigModel config = this.plugin_interface.getUIManager().createBasicPluginConfigModel("Views.plugins.azbuddy.title");
        this.enabled_param = config.addBooleanParameter2("azbuddy.enabled", "azbuddy.enabled", false);
        this.nick_name_param = config.addStringParameter2("azbuddy.nickname", "azbuddy.nickname", "");
        this.nick_name_param.setGenerateIntermediateEvents(false);
        this.nick_name_param.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                BuddyPlugin.this.updateNickName(BuddyPlugin.this.nick_name_param.getValue());
            }
        });
        String[] os_values = STATUS_VALUES;
        String[] os_labels = STATUS_STRINGS;
        this.online_status_param = config.addStringListParameter2("azbuddy.online_status", "azbuddy.online_status", os_values, os_labels, os_values[0]);
        this.online_status_param.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                int status = Integer.parseInt(BuddyPlugin.this.online_status_param.getValue());
                BuddyPlugin.this.updateOnlineStatus(status);
            }
        });
        this.online_status_param.setVisible(true);
        final IntParameter protocol_speed = config.addIntParameter2("azbuddy.protocolspeed", "azbuddy.protocolspeed", 32);
        protocol_speed.setMinimumRequiredUserMode(2);
        this.inbound_limit = protocol_speed.getValue() * 1024;
        protocol_speed.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                BuddyPlugin.this.inbound_limit = protocol_speed.getValue() * 1024;
            }
        });
        this.enable_chat_notifications = config.addBooleanParameter2("azbuddy.enable_chat_notif", "azbuddy.enable_chat_notif", true);
        final TableContextMenuItem menu_item_itorrents = this.plugin_interface.getUIManager().getTableManager().addContextMenuItem("MyTorrents", "azbuddy.contextmenu");
        final TableContextMenuItem menu_item_ctorrents = this.plugin_interface.getUIManager().getTableManager().addContextMenuItem("MySeeders", "azbuddy.contextmenu");
        menu_item_itorrents.setStyle(5);
        menu_item_ctorrents.setStyle(5);
        MenuItemFillListener menu_fill_listener = new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object _target) {
                Download download;
                if (!BuddyPlugin.this.isEnabled() || !BuddyPlugin.this.isAvailable()) {
                    menu.setEnabled(false);
                    return;
                }
                Object obj = null;
                if (_target instanceof TableRow) {
                    obj = ((TableRow)_target).getDataSource();
                } else {
                    TableRow[] rows = (TableRow[])_target;
                    if (rows.length > 0) {
                        obj = rows[0].getDataSource();
                    }
                }
                if (obj == null) {
                    menu.setEnabled(false);
                    return;
                }
                if (obj instanceof Download) {
                    download = (Download)obj;
                } else {
                    DiskManagerFileInfo file = (DiskManagerFileInfo)obj;
                    try {
                        download = file.getDownload();
                    }
                    catch (DownloadException e) {
                        Debug.printStackTrace(e);
                        return;
                    }
                }
                Torrent torrent = download.getTorrent();
                boolean enabled = torrent != null && !torrent.isPrivate();
                menu.removeAllChildItems();
                if (enabled) {
                    List buddies = BuddyPlugin.this.getBuddies();
                    boolean incomplete = ((TableContextMenuItem)menu).getTableID() == "MyTorrents";
                    TableContextMenuItem parent = incomplete ? menu_item_itorrents : menu_item_ctorrents;
                    final Download f_download = download;
                    for (int i = 0; i < buddies.size(); ++i) {
                        final BuddyPluginBuddy buddy = (BuddyPluginBuddy)buddies.get(i);
                        if (!buddy.isOnline(true)) continue;
                        TableContextMenuItem item = BuddyPlugin.this.plugin_interface.getUIManager().getTableManager().addContextMenuItem(parent, "!" + buddy.getName() + "!");
                        item.addListener(new MenuItemListener(){

                            public void selected(MenuItem menu, Object target) {
                                BuddyPlugin.this.az2_handler.sendAZ2Torrent(f_download.getTorrent(), buddy);
                            }
                        });
                    }
                }
                menu.setEnabled(enabled);
            }
        };
        menu_item_itorrents.addFillListener(menu_fill_listener);
        menu_item_ctorrents.addFillListener(menu_fill_listener);
        this.buddy_tracker = new BuddyPluginTracker(this, config);
        this.plugin_interface.getUIManager().addUIListener(new UIManagerListener(){

            public void UIAttached(UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    UISWTInstance swt_ui = (UISWTInstance)instance;
                    BuddyPluginView view = new BuddyPluginView(BuddyPlugin.this, swt_ui);
                    swt_ui.addView("Main", BuddyPlugin.VIEW_ID, view);
                }
                BuddyPlugin.this.setupDisablePrompt(instance);
            }

            public void UIDetached(UIInstance instance) {
            }
        });
        ParameterListener enabled_listener = new ParameterListener(){

            public void parameterChanged(Parameter param) {
                int i;
                UIInstance[] uis;
                boolean enabled = BuddyPlugin.this.enabled_param.getValue();
                if (param != null && !enabled && (uis = BuddyPlugin.this.plugin_interface.getUIManager().getUIInstances()) != null && uis.length > 0 && (i = BuddyPlugin.this.promptUserOnDisable(uis[0])) != 0) {
                    BuddyPlugin.this.enabled_param.setValue(true);
                    BuddyPlugin.this.fireEnabledStateChanged();
                    return;
                }
                BuddyPlugin.this.nick_name_param.setEnabled(enabled);
                if (param != null) {
                    BuddyPlugin.this.setEnabledInternal(enabled);
                    BuddyPlugin.this.fireEnabledStateChanged();
                }
            }
        };
        enabled_listener.parameterChanged(null);
        this.enabled_param.addListener(enabled_listener);
        this.loadConfig();
        this.registerMessageHandler();
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                DelayedTask dt = BuddyPlugin.this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

                    public void run() {
                        new AEThread2("BuddyPlugin:init", true){

                            public void run() {
                                BuddyPlugin.this.startup();
                            }
                        }.start();
                    }
                });
                dt.queue();
            }

            public void closedownInitiated() {
                BuddyPlugin.this.saveConfig(true);
                BuddyPlugin.this.closedown();
            }

            public void closedownComplete() {
            }
        });
    }

    protected void updateLocale(LocaleUtilities lu) {
        for (int i = 0; i < STATUS_STRINGS.length; ++i) {
            BuddyPlugin.STATUS_STRINGS[i] = lu.getLocalisedMessageText("azbuddy." + STATUS_KEYS[i]);
        }
        if (this.online_status_param != null) {
            this.online_status_param.setLabels(STATUS_STRINGS);
        }
    }

    protected void setupDisablePrompt(final UIInstance ui) {
        if (this.plugin_interface == null) {
            return;
        }
        String enabledConfigID = "PluginInfo." + this.plugin_interface.getPluginID() + ".enabled";
        COConfigurationManager.addParameterListener(enabledConfigID, new org.gudy.azureus2.core3.config.ParameterListener(){

            public void parameterChanged(String parameterName) {
                boolean enabled = COConfigurationManager.getBooleanParameter(parameterName);
                if (enabled) {
                    BuddyPlugin.this.fireEnabledStateChanged();
                    return;
                }
                if (BuddyPlugin.this.promptUserOnDisable(ui) != 0) {
                    BuddyPlugin.this.plugin_interface.getPluginState().setDisabled(false);
                    BuddyPlugin.this.plugin_interface.getPluginState().setLoadedAtStartup(true);
                } else {
                    BuddyPlugin.this.fireEnabledStateChanged();
                }
            }
        });
    }

    protected int promptUserOnDisable(UIInstance ui) {
        if ("az2".equals(COConfigurationManager.getStringParameter("ui", "az3"))) {
            return 0;
        }
        LocaleUtilities localeUtil = this.plugin_interface.getUtilities().getLocaleUtilities();
        return ui.promptUser(localeUtil.getLocalisedMessageText("azbuddy.ui.dialog.disable.title"), localeUtil.getLocalisedMessageText("azbuddy.ui.dialog.disable.text"), new String[]{localeUtil.getLocalisedMessageText("Button.yes"), localeUtil.getLocalisedMessageText("Button.no")}, 1);
    }

    public void showConfig() {
        this.plugin_interface.getUIManager().showConfigSection("Views.plugins.azbuddy.title");
    }

    protected void startup() {
        try {
            this.ddb = this.plugin_interface.getDistributedDatabase();
            if (!this.ddb.isAvailable()) {
                throw new Exception("DDB Unavailable");
            }
            this.ddb.addListener(new DistributedDatabaseListener(){

                public void event(DistributedDatabaseEvent event2) {
                    if (event2.getType() == 10) {
                        BuddyPlugin.this.updateIP();
                    }
                }
            });
            this.updateIP();
            this.updateNickName(this.nick_name_param.getValue());
            this.updateOnlineStatus(Integer.parseInt(this.online_status_param.getValue()));
            COConfigurationManager.addAndFireParameterListeners(new String[]{"TCP.Listen.Port", "TCP.Listen.Port.Enable", "UDP.Listen.Port", "UDP.Listen.Port.Enable"}, new org.gudy.azureus2.core3.config.ParameterListener(){

                public void parameterChanged(String parameterName) {
                    BuddyPlugin.this.updateListenPorts();
                }
            });
            CryptoManagerFactory.getSingleton().addKeyListener(new CryptoManagerKeyListener(){

                public void keyChanged(CryptoHandler handler) {
                    BuddyPlugin.this.updateKey();
                }

                public void keyLockStatusChanged(CryptoHandler handler) {
                    boolean unlocked = handler.isUnlocked();
                    if (unlocked) {
                        if (BuddyPlugin.this.latest_publish.isEnabled()) {
                            BuddyPlugin.this.updatePublish(BuddyPlugin.this.latest_publish);
                        }
                    } else {
                        new AEThread2("BuddyPlugin:disc", true){

                            public void run() {
                                List buddies = BuddyPlugin.this.getAllBuddies();
                                for (int i = 0; i < buddies.size(); ++i) {
                                    ((BuddyPluginBuddy)buddies.get(i)).disconnect();
                                }
                            }
                        }.start();
                    }
                }
            });
            this.ready_to_publish = true;
            this.setEnabledInternal(this.enabled_param.getValue());
            this.checkBuddiesAndRepublish();
            this.fireInitialised(true);
        }
        catch (Throwable e) {
            this.log("Initialisation failed", e);
            this.fireInitialised(false);
        }
    }

    public boolean isEnabled() {
        if (this.enabled_param == null) {
            return false;
        }
        return this.enabled_param.getValue();
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled_param == null) {
            return;
        }
        this.enabled_param.setValue(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setEnabledInternal(boolean _enabled) {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            if (this.latest_publish.isEnabled() != _enabled) {
                publishDetails new_publish = this.latest_publish.getCopy();
                new_publish.setEnabled(_enabled);
                this.updatePublish(new_publish);
            }
        }
    }

    public BuddyPluginTracker getTracker() {
        return this.buddy_tracker;
    }

    public String getNickname() {
        return this.nick_name_param.getValue();
    }

    public void setNickname(String str) {
        this.nick_name_param.setValue(str);
    }

    public void setOnlineStatus(int status) {
        this.online_status_param.setValue("" + status);
    }

    public int getOnlineStatus() {
        return this.latest_publish.getOnlineStatus();
    }

    public BooleanParameter getEnableChatNotificationsParameter() {
        return this.enable_chat_notifications;
    }

    protected void registerMessageHandler() {
        try {
            this.addRequestListener(new BuddyPluginBuddyRequestListener(){

                public Map requestReceived(BuddyPluginBuddy from_buddy, int subsystem, Map request2) throws BuddyPluginException {
                    if (subsystem == 0) {
                        if (!from_buddy.isAuthorised()) {
                            throw new BuddyPluginException("Unauthorised");
                        }
                        return BuddyPlugin.this.processInternalRequest(from_buddy, request2);
                    }
                    return null;
                }

                public void pendingMessages(BuddyPluginBuddy[] from_buddies) {
                }
            });
            this.msg_registration = this.plugin_interface.getMessageManager().registerGenericMessageType("AZBUDDY", "Buddy message handler", 3, new GenericMessageHandler(){

                public boolean accept(GenericMessageConnection connection) throws MessageException {
                    if (!BuddyPlugin.this.isEnabled()) {
                        return false;
                    }
                    final String originator = connection.getEndpoint().getNotionalAddress().getAddress().getHostAddress();
                    try {
                        String reason = "Friend: Incoming connection establishment (" + originator + ")";
                        BuddyPlugin.this.addRateLimiters(connection);
                        connection = BuddyPlugin.this.sec_man.getSTSConnection(connection, BuddyPlugin.this.sec_man.getPublicKey(1, reason), new SEPublicKeyLocator(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public boolean accept(Object context, SEPublicKey other_key) {
                                String other_key_str = Base32.encode(other_key.encodeRawPublicKey());
                                try {
                                    BuddyPlugin buddyPlugin = BuddyPlugin.this;
                                    synchronized (buddyPlugin) {
                                        int unauth_count = 0;
                                        for (int i = 0; i < BuddyPlugin.this.buddies.size(); ++i) {
                                            BuddyPluginBuddy buddy = (BuddyPluginBuddy)BuddyPlugin.this.buddies.get(i);
                                            if (buddy.getPublicKey().equals(other_key_str)) {
                                                if (!buddy.isAuthorised()) {
                                                    BuddyPlugin.this.log("Incoming connection from " + originator + " failed as for unauthorised buddy");
                                                    return false;
                                                }
                                                buddy.incomingConnection((GenericMessageConnection)context);
                                                return true;
                                            }
                                            if (buddy.isAuthorised()) continue;
                                            ++unauth_count;
                                        }
                                        if (unauth_count < 16) {
                                            if (BuddyPlugin.this.tooManyUnauthConnections(originator)) {
                                                BuddyPlugin.this.log("Too many recent unauthorised connections from " + originator);
                                                return false;
                                            }
                                            BuddyPluginBuddy buddy = BuddyPlugin.this.addBuddy(other_key_str, 1, false);
                                            buddy.incomingConnection((GenericMessageConnection)context);
                                            return true;
                                        }
                                    }
                                    BuddyPlugin.this.log("Incoming connection from " + originator + " failed due to pk mismatch");
                                    return false;
                                }
                                catch (Throwable e) {
                                    BuddyPlugin.this.log("Incomming connection from " + originator + " failed", e);
                                    return false;
                                }
                            }
                        }, reason, 2);
                    }
                    catch (Throwable e) {
                        connection.close();
                        BuddyPlugin.this.log("Incoming connection from " + originator + " failed", e);
                    }
                    return true;
                }
            });
        }
        catch (Throwable e) {
            this.log("Failed to register message listener", e);
        }
    }

    protected void addRateLimiters(GenericMessageConnection connection) {
        connection.addInboundRateLimiter(this.inbound_limiter);
        connection.addOutboundRateLimiter(this.outbound_limiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tooManyUnauthConnections(String originator) {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            int hit_count;
            if (unauth_bloom == null) {
                unauth_bloom = BloomFilterFactory.createAddRemove4Bit(1000);
                unauth_bloom_create_time = SystemTime.getCurrentTime();
            }
            if ((hit_count = unauth_bloom.add(originator.getBytes())) >= 8) {
                Debug.out("Too many recent unauthorised connection attempts from " + originator);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkUnauthBloom() {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            if (unauth_bloom != null) {
                long now = SystemTime.getCurrentTime();
                if (now < unauth_bloom_create_time) {
                    unauth_bloom_create_time = now;
                } else if (now - unauth_bloom_create_time > 120000L) {
                    unauth_bloom = null;
                }
            }
        }
    }

    protected void checkMaxMessageSize(int size) throws BuddyPluginException {
        if (size > 0x400000) {
            throw new BuddyPluginException("Message is too large to send, limit is " + DisplayFormatters.formatByteCountToKiBEtc(0x400000));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPersistentDispatch() {
        ArrayList buddies_copy;
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            buddies_copy = new ArrayList(this.buddies);
        }
        for (int i = 0; i < buddies_copy.size(); ++i) {
            BuddyPluginBuddy buddy = (BuddyPluginBuddy)buddies_copy.get(i);
            buddy.checkPersistentDispatch();
        }
    }

    protected void persistentDispatchInit() {
        Iterator it = this.pd_preinit.iterator();
        while (it.hasNext()) {
            this.persistentDispatchPending((BuddyPluginBuddy)it.next());
        }
        this.pd_preinit = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistentDispatchPending(BuddyPluginBuddy buddy) {
        List list = this.pd_queue;
        synchronized (list) {
            if (this.initialisation_state == 0) {
                this.pd_preinit.add(buddy);
                return;
            }
            if (!this.pd_queue.contains(buddy)) {
                this.pd_queue.add(buddy);
                this.pd_queue_sem.release();
                if (this.pd_thread == null) {
                    this.pd_thread = new AEThread2("BuddyPlugin:persistDispatch", true){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            while (true) {
                                BuddyPluginBuddy buddy;
                                if (!BuddyPlugin.this.pd_queue_sem.reserve(30000L)) {
                                    List list = BuddyPlugin.this.pd_queue;
                                    synchronized (list) {
                                        if (BuddyPlugin.this.pd_queue.isEmpty()) {
                                            BuddyPlugin.this.pd_thread = null;
                                            break;
                                        }
                                    }
                                }
                                List list = BuddyPlugin.this.pd_queue;
                                synchronized (list) {
                                    buddy = (BuddyPluginBuddy)BuddyPlugin.this.pd_queue.remove(0);
                                }
                                buddy.persistentDispatch();
                            }
                        }
                    };
                    this.pd_thread.start();
                }
            }
        }
    }

    protected Map processInternalRequest(BuddyPluginBuddy from_buddy, Map request2) throws BuddyPluginException {
        int type = ((Long)request2.get("type")).intValue();
        if (type == 1) {
            HashMap<String, Long> reply = new HashMap<String, Long>();
            reply.put("type", new Long(2L));
            return reply;
        }
        if (type == 3) {
            from_buddy.receivedCloseRequest(request2);
            HashMap<String, Long> reply = new HashMap<String, Long>();
            reply.put("type", new Long(4L));
            return reply;
        }
        throw new BuddyPluginException("Unrecognised request type " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateListenPorts() {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            int tcp_port = COConfigurationManager.getIntParameter("TCP.Listen.Port");
            boolean tcp_enabled = COConfigurationManager.getBooleanParameter("TCP.Listen.Port.Enable");
            int udp_port = COConfigurationManager.getIntParameter("UDP.Listen.Port");
            boolean udp_enabled = COConfigurationManager.getBooleanParameter("UDP.Listen.Port.Enable");
            if (!tcp_enabled) {
                tcp_port = 0;
            }
            if (!udp_enabled) {
                udp_port = 0;
            }
            if (this.latest_publish.getTCPPort() != tcp_port || this.latest_publish.getUDPPort() != udp_port) {
                publishDetails new_publish = this.latest_publish.getCopy();
                new_publish.setTCPPort(tcp_port);
                new_publish.setUDPPort(udp_port);
                this.updatePublish(new_publish);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIP() {
        if (this.ddb == null || !this.ddb.isAvailable()) {
            return;
        }
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            InetAddress public_ip = this.ddb.getLocalContact().getAddress().getAddress();
            if (this.latest_publish.getIP() == null || !this.latest_publish.getIP().equals(public_ip)) {
                publishDetails new_publish = this.latest_publish.getCopy();
                new_publish.setIP(public_ip);
                this.updatePublish(new_publish);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNickName(String new_nick) {
        if ((new_nick = new_nick.trim()).length() == 0) {
            new_nick = null;
        }
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            String old_nick = this.latest_publish.getNickName();
            if (!this.stringsEqual(new_nick, old_nick)) {
                publishDetails new_publish = this.latest_publish.getCopy();
                new_publish.setNickName(new_nick);
                this.updatePublish(new_publish);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateOnlineStatus(int new_status) {
        boolean changed;
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            int old_status = this.latest_publish.getOnlineStatus();
            boolean bl = changed = old_status != new_status;
            if (changed) {
                publishDetails new_publish = this.latest_publish.getCopy();
                new_publish.setOnlineStatus(new_status);
                this.updatePublish(new_publish);
            }
        }
        if (changed) {
            List buddies = this.getAllBuddies();
            for (int i = 0; i < buddies.size(); ++i) {
                BuddyPluginBuddy buddy = (BuddyPluginBuddy)buddies.get(i);
                if (!buddy.isConnected()) continue;
                buddy.sendKeepAlive();
            }
        }
    }

    public String getOnlineStatus(int status) {
        if (status >= STATUS_STRINGS.length || status < 0) {
            status = 0;
        }
        return STATUS_STRINGS[status];
    }

    protected boolean stringsEqual(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateKey() {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            publishDetails new_publish = this.latest_publish.getCopy();
            new_publish.setPublicKey(null);
            this.updatePublish(new_publish);
        }
    }

    protected void updatePublish(final publishDetails details) {
        this.latest_publish = details;
        if (this.ddb == null || !this.ready_to_publish) {
            return;
        }
        this.publish_dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                if (BuddyPlugin.this.publish_dispatcher.getQueueSize() > 0) {
                    return;
                }
                BuddyPlugin.this.updatePublishSupport(details);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePublishSupport(publishDetails details) {
        block29: {
            publishDetails existing_details;
            boolean log_this;
            byte[] key_to_remove = null;
            BuddyPlugin buddyPlugin = this;
            synchronized (buddyPlugin) {
                log_this = !this.current_publish.getString().equals(details.getString());
                existing_details = this.current_publish;
                if (!details.isEnabled()) {
                    if (this.current_publish.isPublished()) {
                        key_to_remove = this.current_publish.getPublicKey();
                    }
                } else {
                    byte[] existing_key;
                    if (details.getPublicKey() == null) {
                        try {
                            details.setPublicKey(this.ecc_handler.getPublicKey("Creating online status key"));
                        }
                        catch (Throwable e) {
                            this.log("Failed to publish details", e);
                            return;
                        }
                    }
                    if (this.current_publish.isPublished() && !Arrays.equals(existing_key = this.current_publish.getPublicKey(), details.getPublicKey())) {
                        key_to_remove = existing_key;
                    }
                }
                this.current_publish = details;
            }
            if (key_to_remove != null) {
                this.log("Removing old status publish: " + existing_details.getString());
                try {
                    this.ddb.delete(new DistributedDatabaseListener(){

                        public void event(DistributedDatabaseEvent event2) {
                        }
                    }, this.getStatusKey(key_to_remove, "Friend status de-registration for old key"));
                }
                catch (Throwable e) {
                    this.log("Failed to remove existing publish", e);
                }
            }
            if (details.isEnabled()) {
                InetAddress ip = details.getIP();
                if (ip.isLoopbackAddress() || ip.isLinkLocalAddress() || ip.isSiteLocalAddress()) {
                    this.log("Can't publish as ip address is invalid: " + details.getString());
                    return;
                }
                details.setPublished(true);
                HashMap<String, Object> payload = new HashMap<String, Object>();
                if (details.getTCPPort() > 0) {
                    payload.put("t", new Long(details.getTCPPort()));
                }
                if (details.getUDPPort() > 0) {
                    payload.put("u", new Long(details.getUDPPort()));
                }
                payload.put("i", ip.getAddress());
                String nick = details.getNickName();
                if (nick != null) {
                    if (nick.length() > 32) {
                        nick = nick.substring(0, 32);
                    }
                    payload.put("n", nick);
                }
                payload.put("o", new Long(details.getOnlineStatus()));
                ++this.status_seq;
                int next_seq = this.status_seq++;
                if (next_seq == 0) {
                    next_seq = this.status_seq;
                }
                details.setSequence(next_seq);
                payload.put("s", new Long(next_seq));
                payload.put("v", new Long(2L));
                boolean failed_to_get_key = true;
                try {
                    byte[] data = BEncoder.encode(payload);
                    DistributedDatabaseKey key = this.getStatusKey(details.getPublicKey(), "My buddy status registration " + payload);
                    byte[] signature = this.ecc_handler.sign(data, "Friend online status");
                    failed_to_get_key = false;
                    byte[] signed_payload = new byte[1 + signature.length + data.length];
                    signed_payload[0] = (byte)signature.length;
                    System.arraycopy(signature, 0, signed_payload, 1, signature.length);
                    System.arraycopy(data, 0, signed_payload, 1 + signature.length, data.length);
                    DistributedDatabaseValue value = this.ddb.createValue(signed_payload);
                    final AESemaphore sem = new AESemaphore("BuddyPlugin:reg");
                    if (log_this) {
                        this.logMessage("Publishing status starts: " + details.getString());
                    }
                    this.last_publish_start = SystemTime.getMonotonousTime();
                    this.ddb.write(new DistributedDatabaseListener(){
                        private List write_contacts = new ArrayList();

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void event(DistributedDatabaseEvent event2) {
                            int type = event2.getType();
                            if (type == 1) {
                                this.write_contacts.add(event2.getContact());
                            } else if (type == 5 || type == 4) {
                                List list = BuddyPlugin.this.publish_write_contacts;
                                synchronized (list) {
                                    BuddyPlugin.this.publish_write_contacts.clear();
                                    BuddyPlugin.this.publish_write_contacts.addAll(this.write_contacts);
                                }
                                sem.release();
                            }
                        }
                    }, key, value);
                    sem.reserve();
                    if (log_this) {
                        this.logMessage("My status publish complete");
                    }
                }
                catch (Throwable e) {
                    this.logMessage("Failed to publish online status", e);
                    if (!failed_to_get_key) break block29;
                    BuddyPlugin buddyPlugin2 = this;
                    synchronized (buddyPlugin2) {
                        if (this.republish_delay_event != null) {
                            return;
                        }
                        if (this.last_publish_start == 0L || SystemTime.getMonotonousTime() - this.last_publish_start > 600000L) {
                            this.log("Rescheduling publish as failed to get key");
                            this.republish_delay_event = SimpleTimer.addEvent("BuddyPlugin:republish", SystemTime.getCurrentTime() + 60000L, new TimerEventPerformer(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void perform(TimerEvent event2) {
                                    BuddyPlugin buddyPlugin = BuddyPlugin.this;
                                    synchronized (buddyPlugin) {
                                        BuddyPlugin.this.republish_delay_event = null;
                                    }
                                    if ((BuddyPlugin.this.last_publish_start == 0L || SystemTime.getMonotonousTime() - BuddyPlugin.this.last_publish_start > 600000L) && BuddyPlugin.this.latest_publish.isEnabled()) {
                                        BuddyPlugin.this.updatePublish(BuddyPlugin.this.latest_publish);
                                    }
                                }
                            });
                        }
                    }
                }
            }
        }
    }

    protected int getCurrentStatusSeq() {
        return this.current_publish.getSequence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closedown() {
        this.logMessage("Closing down");
        if (this.ddb != null) {
            boolean restarting = AzureusCoreFactory.getSingleton().isRestarting();
            List buddies = this.getAllBuddies();
            this.logMessage("   closing buddy connections");
            for (int i = 0; i < buddies.size(); ++i) {
                ((BuddyPluginBuddy)buddies.get(i)).sendCloseRequest(restarting);
            }
            if (!restarting) {
                byte[] key_to_remove;
                this.logMessage("   updating online status");
                ArrayList contacts = new ArrayList();
                List list = this.publish_write_contacts;
                synchronized (list) {
                    contacts.addAll(this.publish_write_contacts);
                }
                BuddyPlugin buddyPlugin = this;
                synchronized (buddyPlugin) {
                    key_to_remove = this.current_publish.getPublicKey();
                }
                if (contacts.size() == 0 || key_to_remove == null) {
                    return;
                }
                DistributedDatabaseContact[] contact_a = new DistributedDatabaseContact[contacts.size()];
                contacts.toArray(contact_a);
                try {
                    this.ddb.delete(new DistributedDatabaseListener(){

                        public void event(DistributedDatabaseEvent event2) {
                            if (event2.getType() == 3) {
                                // empty if block
                            }
                        }
                    }, this.getStatusKey(key_to_remove, "Friend status de-registration for closedown"), contact_a);
                }
                catch (Throwable e) {
                    this.log("Failed to remove existing publish", e);
                }
            }
        }
    }

    protected DistributedDatabaseKey getStatusKey(byte[] public_key, String reason) throws Exception {
        byte[] key_prefix = "azbuddy:status".getBytes();
        byte[] key_bytes = new byte[key_prefix.length + public_key.length];
        System.arraycopy(key_prefix, 0, key_bytes, 0, key_prefix.length);
        System.arraycopy(public_key, 0, key_bytes, key_prefix.length, public_key.length);
        DistributedDatabaseKey key = this.ddb.createKey(key_bytes, reason);
        return key;
    }

    protected DistributedDatabaseKey getYGMKey(byte[] public_key, String reason) throws Exception {
        byte[] key_prefix = "azbuddy:ygm".getBytes();
        byte[] key_bytes = new byte[key_prefix.length + public_key.length];
        System.arraycopy(key_prefix, 0, key_bytes, 0, key_prefix.length);
        System.arraycopy(public_key, 0, key_bytes, key_prefix.length, public_key.length);
        DistributedDatabaseKey key = this.ddb.createKey(key_bytes, reason);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConfigDirty() {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            this.config_dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfig() {
        long now = SystemTime.getCurrentTime();
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            Map map = this.readConfig();
            List buddies_config = (List)map.get("friends");
            if (buddies_config != null) {
                for (int i = 0; i < buddies_config.size(); ++i) {
                    Long l_subsystem;
                    long last_time_online;
                    Object o = buddies_config.get(i);
                    if (!(o instanceof Map)) continue;
                    Map details = (Map)o;
                    String key = new String((byte[])details.get("pk"));
                    List recent_ygm = (List)details.get("ygm");
                    String nick = this.decodeString((byte[])details.get("n"));
                    Long l_seq = (Long)details.get("ls");
                    int last_seq = l_seq == null ? 0 : l_seq.intValue();
                    Long l_lo = (Long)details.get("lo");
                    long l = last_time_online = l_lo == null ? 0L : l_lo;
                    if (last_time_online > now) {
                        last_time_online = now;
                    }
                    int subsystem = (l_subsystem = (Long)details.get("ss")) == null ? 1 : l_subsystem.intValue();
                    Long l_ver = (Long)details.get("v");
                    int ver = l_ver == null ? 1 : l_ver.intValue();
                    BuddyPluginBuddy buddy = new BuddyPluginBuddy(this, subsystem, true, key, nick, ver, last_seq, last_time_online, recent_ygm);
                    this.logMessage("Loaded buddy " + buddy.getString());
                    this.buddies.add(buddy);
                    this.buddies_map.put(key, buddy);
                }
            }
        }
    }

    protected String decodeString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, "UTF8");
        }
        catch (Throwable e) {
            return null;
        }
    }

    protected void saveConfig() {
        this.saveConfig(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveConfig(boolean force) {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            if (this.config_dirty || force) {
                ArrayList buddies_config = new ArrayList();
                for (int i = 0; i < this.buddies.size(); ++i) {
                    String nick;
                    BuddyPluginBuddy buddy = (BuddyPluginBuddy)this.buddies.get(i);
                    if (!buddy.isAuthorised()) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("pk", buddy.getPublicKey());
                    List ygm = buddy.getYGMMarkers();
                    if (ygm != null) {
                        map.put("ygm", ygm);
                    }
                    if ((nick = buddy.getNickName()) != null) {
                        map.put("n", nick);
                    }
                    map.put("ls", new Long(buddy.getLastStatusSeq()));
                    map.put("lo", new Long(buddy.getLastTimeOnline()));
                    map.put("ss", new Long(buddy.getSubsystem()));
                    map.put("v", new Long(buddy.getVersion()));
                    buddies_config.add(map);
                }
                HashMap map = new HashMap();
                map.put("friends", buddies_config);
                this.writeConfig(map);
                this.config_dirty = false;
            }
        }
    }

    public BuddyPluginBuddy addBuddy(String key, int subsystem) {
        return this.addBuddy(key, subsystem, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BuddyPluginBuddy addBuddy(String key, int subsystem, boolean authorised) {
        if (key.length() == 0 || !this.verifyPublicKey(key)) {
            return null;
        }
        BuddyPluginBuddy buddy_to_return = null;
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            for (int i = 0; i < this.buddies.size(); ++i) {
                BuddyPluginBuddy buddy = (BuddyPluginBuddy)this.buddies.get(i);
                if (!buddy.getPublicKey().equals(key)) continue;
                if (buddy.getSubsystem() != subsystem) {
                    this.log("Buddy " + buddy.getString() + ": subsystem changed from " + buddy.getSubsystem() + " to " + subsystem);
                    buddy.setSubsystem(subsystem);
                    this.saveConfig(true);
                }
                if (authorised && !buddy.isAuthorised()) {
                    this.log("Buddy " + buddy.getString() + ": no authorised");
                    buddy.setAuthorised(true);
                    buddy_to_return = buddy;
                    continue;
                }
                return buddy;
            }
            if (buddy_to_return == null) {
                buddy_to_return = new BuddyPluginBuddy(this, subsystem, authorised, key, null, 1, 0, 0L, null);
                this.buddies.add(buddy_to_return);
                this.buddies_map.put(key, buddy_to_return);
                if (!authorised) {
                    this.log("Added unauthorised buddy: " + buddy_to_return.getString());
                }
            }
            if (buddy_to_return.isAuthorised()) {
                this.logMessage("Added buddy " + buddy_to_return.getString());
                this.saveConfig(true);
            }
        }
        this.fireAdded(buddy_to_return);
        return buddy_to_return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeBuddy(BuddyPluginBuddy buddy) {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            if (!this.buddies.remove(buddy)) {
                return;
            }
            this.buddies_map.remove(buddy.getPublicKey());
            this.logMessage("Removed friend " + buddy.getString());
            this.saveConfig(true);
        }
        buddy.destroy();
        this.fireRemoved(buddy);
    }

    protected Map readConfig() {
        File config_file = new File(this.plugin_interface.getUtilities().getAzureusUserDir(), "friends.config");
        return this.readConfigFile(config_file);
    }

    protected void writeConfig(Map map) {
        File config_file = new File(this.plugin_interface.getUtilities().getAzureusUserDir(), "friends.config");
        this.writeConfigFile(config_file, map);
    }

    protected Map readConfigFile(File name) {
        HashMap map = this.plugin_interface.getUtilities().readResilientBEncodedFile(name.getParentFile(), name.getName(), true);
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    protected boolean writeConfigFile(File name, Map data) {
        this.plugin_interface.getUtilities().writeResilientBEncodedFile(name.getParentFile(), name.getName(), data, true);
        return name.exists();
    }

    protected File getBuddyConfigDir() {
        return new File(this.plugin_interface.getUtilities().getAzureusUserDir(), "friends");
    }

    public BuddyPluginAZ2 getAZ2Handler() {
        return this.az2_handler;
    }

    public String getPublicKey() {
        try {
            return Base32.encode(this.ecc_handler.getPublicKey("Friend get key"));
        }
        catch (Throwable e) {
            this.logMessage("Failed to access public key", e);
            return null;
        }
    }

    public boolean verifyPublicKey(String key) {
        return this.ecc_handler.verifyPublicKey(Base32.decode(key));
    }

    protected void checkBuddiesAndRepublish() {
        this.updateBuddys();
        this.plugin_interface.getUtilities().createTimer("Buddy checker").addPeriodicEvent(10000L, new UTTimerEventPerformer(){
            int tick_count;

            public void perform(UTTimerEvent event2) {
                ++this.tick_count;
                if (!BuddyPlugin.this.isEnabled()) {
                    return;
                }
                BuddyPlugin.this.updateBuddys();
                if (this.tick_count % 60 == 0 && BuddyPlugin.this.latest_publish.isEnabled()) {
                    BuddyPlugin.this.updatePublish(BuddyPlugin.this.latest_publish);
                }
                if (this.tick_count % 30 == 0) {
                    BuddyPlugin.this.checkMessagePending(this.tick_count);
                }
                if (this.tick_count % 6 == 0) {
                    BuddyPlugin.this.checkUnauthBloom();
                }
                if (this.tick_count % 6 == 0) {
                    BuddyPlugin.this.saveConfig();
                }
                if (this.tick_count % 6 == 0) {
                    BuddyPlugin.this.checkPersistentDispatch();
                }
                if (BuddyPlugin.this.buddy_tracker != null) {
                    BuddyPlugin.this.buddy_tracker.tick(this.tick_count);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBuddys() {
        ArrayList buddies_copy;
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            buddies_copy = new ArrayList(this.buddies);
        }
        long now = SystemTime.getCurrentTime();
        Random random = new Random();
        for (int i = 0; i < buddies_copy.size(); ++i) {
            BuddyPluginBuddy buddy = (BuddyPluginBuddy)buddies_copy.get(i);
            long last_check = buddy.getLastStatusCheckTime();
            buddy.checkTimeouts();
            int period = 180000 + 60000 * buddies_copy.size() / 5;
            if (last_check <= now && now - last_check <= (long)(period += random.nextInt(120000)) || buddy.statusCheckActive() || !buddy.isAuthorised()) continue;
            this.updateBuddyStatus(buddy);
        }
        BuddyPlugin buddyPlugin2 = this;
        synchronized (buddyPlugin2) {
            for (int i = 0; i < buddies_copy.size(); ++i) {
                BuddyPluginBuddy buddy = (BuddyPluginBuddy)buddies_copy.get(i);
                if (!buddy.isIdle() || buddy.isAuthorised()) continue;
                this.removeBuddy(buddy);
            }
        }
    }

    protected void updateBuddyStatus(final BuddyPluginBuddy buddy) {
        if (!buddy.statusCheckStarts()) {
            return;
        }
        this.log("Updating buddy status: " + buddy.getString());
        try {
            final byte[] public_key = buddy.getRawPublicKey();
            DistributedDatabaseKey key = this.getStatusKey(public_key, "Friend status check for " + buddy.getName());
            this.ddb.read(new DistributedDatabaseListener(){
                private long latest_time;
                private Map status;

                public void event(DistributedDatabaseEvent event2) {
                    int type = event2.getType();
                    if (type == 2) {
                        try {
                            byte[] signed_stuff;
                            Map new_status;
                            DistributedDatabaseValue value = event2.getValue();
                            long time = value.getCreationTime();
                            if (time > this.latest_time && (new_status = BuddyPlugin.this.verifyAndExtract(signed_stuff = (byte[])value.getValue(byte[].class), public_key)) != null) {
                                this.status = new_status;
                                this.latest_time = time;
                            }
                        }
                        catch (Throwable e) {
                            BuddyPlugin.this.log("Read failed", e);
                        }
                    } else if (type == 5 || type == 4) {
                        if (this.status == null) {
                            buddy.statusCheckFailed();
                        } else {
                            try {
                                int tcp_port = ((Long)this.status.get("t")).intValue();
                                int udp_port = ((Long)this.status.get("u")).intValue();
                                InetAddress ip = InetAddress.getByAddress((byte[])this.status.get("i"));
                                String nick = BuddyPlugin.this.decodeString((byte[])this.status.get("n"));
                                Long l_seq = (Long)this.status.get("s");
                                int seq = l_seq == null ? 0 : l_seq.intValue();
                                Long l_os = (Long)this.status.get("o");
                                int os = l_os == null ? 0 : l_os.intValue();
                                Long l_ver = (Long)this.status.get("v");
                                int ver = l_ver == null ? 1 : l_ver.intValue();
                                buddy.statusCheckComplete(this.latest_time, ip, tcp_port, udp_port, nick, os, seq, ver);
                            }
                            catch (Throwable e) {
                                buddy.statusCheckFailed();
                                BuddyPlugin.this.log("Status decode failed", e);
                            }
                        }
                    }
                }
            }, key, 120000L);
        }
        catch (Throwable e) {
            buddy.statusCheckFailed();
            this.log("Friend status update failed: " + buddy.getString(), e);
        }
    }

    protected Map verifyAndExtract(byte[] signed_stuff, byte[] public_key) throws BuddyPluginException {
        int signature_length = signed_stuff[0] & 0xFF;
        byte[] signature = new byte[signature_length];
        byte[] data = new byte[signed_stuff.length - 1 - signature_length];
        System.arraycopy(signed_stuff, 1, signature, 0, signature_length);
        System.arraycopy(signed_stuff, 1 + signature_length, data, 0, data.length);
        try {
            if (this.ecc_handler.verify(public_key, data, signature)) {
                return BDecoder.decode(data);
            }
            this.logMessage("Signature verification failed");
            return null;
        }
        catch (Throwable e) {
            this.rethrow("Verification failed", e);
            return null;
        }
    }

    protected byte[] signAndInsert(Map plain_stuff, String reason) throws BuddyPluginException {
        try {
            byte[] data = BEncoder.encode(plain_stuff);
            byte[] signature = this.ecc_handler.sign(data, reason);
            byte[] signed_payload = new byte[1 + signature.length + data.length];
            signed_payload[0] = (byte)signature.length;
            System.arraycopy(signature, 0, signed_payload, 1, signature.length);
            System.arraycopy(data, 0, signed_payload, 1 + signature.length, data.length);
            return signed_payload;
        }
        catch (Throwable e) {
            this.rethrow("Signing failed", e);
            return null;
        }
    }

    public boolean verify(String pk, byte[] payload, byte[] signature) throws BuddyPluginException {
        return this.verify(Base32.decode(pk), payload, signature);
    }

    protected boolean verify(BuddyPluginBuddy buddy, byte[] payload, byte[] signature) throws BuddyPluginException {
        return this.verify(buddy.getRawPublicKey(), payload, signature);
    }

    protected boolean verify(byte[] pk, byte[] payload, byte[] signature) throws BuddyPluginException {
        try {
            return this.ecc_handler.verify(pk, payload, signature);
        }
        catch (Throwable e) {
            this.rethrow("Verification failed", e);
            return false;
        }
    }

    public byte[] sign(byte[] payload) throws BuddyPluginException {
        try {
            return this.ecc_handler.sign(payload, "Friend message signing");
        }
        catch (Throwable e) {
            this.rethrow("Signing failed", e);
            return null;
        }
    }

    protected cryptoResult encrypt(BuddyPluginBuddy buddy, byte[] payload) throws BuddyPluginException {
        return this.encrypt(buddy.getPublicKey(), payload, buddy.getName());
    }

    public cryptoResult encrypt(String pk, byte[] payload, String forWho) throws BuddyPluginException {
        try {
            byte[] hash = new byte[20];
            this.random.nextBytes(hash);
            HashMap<String, byte[]> content = new HashMap<String, byte[]>();
            content.put("h", hash);
            content.put("p", payload);
            final byte[] encrypted = this.ecc_handler.encrypt(Base32.decode(pk), BEncoder.encode(content), "Encrypting message for " + forWho);
            final byte[] sha1_hash = new SHA1Simple().calculateHash(hash);
            return new cryptoResult(){

                public byte[] getChallenge() {
                    return sha1_hash;
                }

                public byte[] getPayload() {
                    return encrypted;
                }
            };
        }
        catch (Throwable e) {
            this.rethrow("Encryption failed", e);
            return null;
        }
    }

    protected cryptoResult decrypt(BuddyPluginBuddy buddy, byte[] content, String forName) throws BuddyPluginException {
        try {
            byte[] decrypted = this.ecc_handler.decrypt(buddy.getRawPublicKey(), content, "Decrypting message for " + buddy.getName());
            final Map map = BDecoder.decode(decrypted);
            return new cryptoResult(){

                public byte[] getChallenge() {
                    return (byte[])map.get("h");
                }

                public byte[] getPayload() {
                    return (byte[])map.get("p");
                }
            };
        }
        catch (Throwable e) {
            this.rethrow("Decryption failed", e);
            return null;
        }
    }

    public cryptoResult decrypt(String public_key, byte[] content) throws BuddyPluginException {
        try {
            byte[] decrypted = this.ecc_handler.decrypt(Base32.decode(public_key), content, "Decrypting message for " + public_key);
            final Map map = BDecoder.decode(decrypted);
            return new cryptoResult(){

                public byte[] getChallenge() {
                    return (byte[])map.get("h");
                }

                public byte[] getPayload() {
                    return (byte[])map.get("p");
                }
            };
        }
        catch (Throwable e) {
            this.rethrow("Decryption failed", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMessagePending(BuddyPluginBuddy buddy, final operationListener listener) throws BuddyPluginException {
        try {
            this.checkAvailable();
            final String reason = "Friend YGM write for " + buddy.getName();
            HashMap<String, Long> payload = new HashMap<String, Long>();
            payload.put("r", new Long(this.random.nextLong()));
            byte[] signed_payload = this.signAndInsert(payload, reason);
            HashMap<String, byte[]> envelope = new HashMap<String, byte[]>();
            envelope.put("pk", this.ecc_handler.getPublicKey(reason));
            envelope.put("ss", signed_payload);
            DistributedDatabaseValue value = this.ddb.createValue(BEncoder.encode(envelope));
            this.logMessage(reason + " starts: " + payload);
            DistributedDatabaseKey key = this.getYGMKey(buddy.getRawPublicKey(), reason);
            this.ddb.write(new DistributedDatabaseListener(){

                public void event(DistributedDatabaseEvent event2) {
                    int type = event2.getType();
                    if (type == 5 || type == 4) {
                        BuddyPlugin.this.logMessage(reason + " complete");
                        listener.complete();
                    }
                }
            }, key, value);
        }
        catch (Throwable e) {
            try {
                this.rethrow("Failed to publish YGM", e);
            }
            finally {
                listener.complete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMessagePending(int tick_count) {
        this.log("Checking YGM");
        if (tick_count % 360 == 0) {
            BuddyPlugin buddyPlugin = this;
            synchronized (buddyPlugin) {
                ygm_unauth_bloom = null;
            }
        }
        try {
            String reason = "Friend YGM check";
            byte[] public_key = this.ecc_handler.getPublicKey(reason);
            DistributedDatabaseKey key = this.getYGMKey(public_key, reason);
            this.ddb.read(new DistributedDatabaseListener(){
                private List new_ygm_buddies = new ArrayList();
                private boolean unauth_permitted = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void event(DistributedDatabaseEvent event2) {
                    block15: {
                        int type = event2.getType();
                        if (type == 2) {
                            try {
                                long rand;
                                DistributedDatabaseValue value = event2.getValue();
                                byte[] envelope = (byte[])value.getValue(byte[].class);
                                Map map = BDecoder.decode(envelope);
                                byte[] pk = (byte[])map.get("pk");
                                if (pk == null) {
                                    return;
                                }
                                String pk_str = Base32.encode(pk);
                                BuddyPluginBuddy buddy = BuddyPlugin.this.getBuddyFromPublicKey(pk_str);
                                if (buddy == null || !buddy.isAuthorised()) {
                                    if (buddy == null) {
                                        BuddyPlugin.this.log("YGM entry from unknown friend '" + pk_str + "' - ignoring");
                                    } else {
                                        BuddyPlugin.this.log("YGM entry from unauthorised friend '" + pk_str + "' - ignoring");
                                    }
                                    byte[] address = event2.getContact().getAddress().getAddress().getAddress();
                                    BuddyPlugin buddyPlugin = BuddyPlugin.this;
                                    synchronized (buddyPlugin) {
                                        if (ygm_unauth_bloom == null) {
                                            ygm_unauth_bloom = BloomFilterFactory.createAddOnly(512);
                                        }
                                        if (!ygm_unauth_bloom.contains(address)) {
                                            ygm_unauth_bloom.add(address);
                                            this.unauth_permitted = true;
                                        }
                                        break block15;
                                    }
                                }
                                byte[] signed_stuff = (byte[])map.get("ss");
                                Map payload = BuddyPlugin.this.verifyAndExtract(signed_stuff, pk);
                                if (payload != null && buddy.addYGMMarker(rand = ((Long)payload.get("r")).longValue())) {
                                    this.new_ygm_buddies.add(buddy);
                                }
                            }
                            catch (Throwable e) {
                                BuddyPlugin.this.log("Read failed", e);
                            }
                        } else if (!(type != 5 && type != 4 || this.new_ygm_buddies.size() <= 0 && !this.unauth_permitted)) {
                            BuddyPluginBuddy[] b = new BuddyPluginBuddy[this.new_ygm_buddies.size()];
                            this.new_ygm_buddies.toArray(b);
                            BuddyPlugin.this.fireYGM(b);
                        }
                    }
                }
            }, key, 120000L, 1);
            boolean write_bogus_ygm = false;
            BuddyPlugin buddyPlugin = this;
            synchronized (buddyPlugin) {
                if (!this.bogus_ygm_written) {
                    write_bogus_ygm = true;
                    this.bogus_ygm_written = true;
                }
            }
            if (write_bogus_ygm) {
                String reason2 = "Friend YGM write for myself";
                HashMap envelope = new HashMap();
                DistributedDatabaseValue value = this.ddb.createValue(BEncoder.encode(envelope));
                this.logMessage("Friend YGM write for myself starts");
                this.ddb.write(new DistributedDatabaseListener(){

                    public void event(DistributedDatabaseEvent event2) {
                        int type = event2.getType();
                        if (type == 4) {
                            BuddyPlugin.this.logMessage("Friend YGM write for myself complete");
                        }
                    }
                }, key, value);
            }
        }
        catch (Throwable e) {
            this.logMessage("YGM check failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuddyPluginBuddy getBuddyFromPublicKey(String key) {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            return (BuddyPluginBuddy)this.buddies_map.get(key);
        }
    }

    public PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    protected SESecurityManager getSecurityManager() {
        return this.sec_man;
    }

    protected GenericMessageRegistration getMessageRegistration() {
        return this.msg_registration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBuddies() {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            ArrayList<BuddyPluginBuddy> result = new ArrayList<BuddyPluginBuddy>();
            for (int i = 0; i < this.buddies.size(); ++i) {
                BuddyPluginBuddy buddy = (BuddyPluginBuddy)this.buddies.get(i);
                if (!buddy.isAuthorised()) continue;
                result.add(buddy);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getAllBuddies() {
        BuddyPlugin buddyPlugin = this;
        synchronized (buddyPlugin) {
            return new ArrayList(this.buddies);
        }
    }

    public boolean isAvailable() {
        try {
            this.checkAvailable();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected void checkAvailable() throws BuddyPluginException {
        if (this.initialisation_state == 0) {
            throw new BuddyPluginException("Plugin not yet initialised");
        }
        if (this.initialisation_state == 2) {
            throw new BuddyPluginException("Plugin unavailable");
        }
    }

    protected void fireInitialised(boolean ok) {
        this.initialisation_state = ok ? 1 : 2;
        this.persistentDispatchInit();
        if (ok) {
            this.buddy_tracker.initialise();
        }
        List listeners_ref = this.listeners.getList();
        for (int i = 0; i < listeners_ref.size(); ++i) {
            try {
                ((BuddyPluginListener)listeners_ref.get(i)).initialised(ok);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void addListener(BuddyPluginListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
        if (this.initialisation_state != 0) {
            listener.initialised(this.initialisation_state == 1);
        }
    }

    public void removeListener(BuddyPluginListener listener) {
        this.listeners.remove(listener);
    }

    protected Map requestReceived(BuddyPluginBuddy from_buddy, int subsystem, Map content) throws BuddyPluginException {
        List listeners_ref = this.request_listeners.getList();
        for (int i = 0; i < listeners_ref.size(); ++i) {
            try {
                Map reply = ((BuddyPluginBuddyRequestListener)listeners_ref.get(i)).requestReceived(from_buddy, subsystem, content);
                if (reply == null) continue;
                return reply;
            }
            catch (BuddyPluginException e) {
                throw e;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                throw new BuddyPluginException("Request processing failed", e);
            }
        }
        return null;
    }

    protected void fireAdded(BuddyPluginBuddy buddy) {
        if (buddy.isAuthorised()) {
            List listeners_ref = this.listeners.getList();
            for (int i = 0; i < listeners_ref.size(); ++i) {
                try {
                    ((BuddyPluginListener)listeners_ref.get(i)).buddyAdded(buddy);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    protected void fireRemoved(BuddyPluginBuddy buddy) {
        if (buddy.isAuthorised()) {
            List listeners_ref = this.listeners.getList();
            for (int i = 0; i < listeners_ref.size(); ++i) {
                try {
                    ((BuddyPluginListener)listeners_ref.get(i)).buddyRemoved(buddy);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    protected void fireDetailsChanged(BuddyPluginBuddy buddy) {
        if (buddy.isAuthorised()) {
            List listeners_ref = this.listeners.getList();
            for (int i = 0; i < listeners_ref.size(); ++i) {
                try {
                    ((BuddyPluginListener)listeners_ref.get(i)).buddyChanged(buddy);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    protected void fireYGM(BuddyPluginBuddy[] from_buddies) {
        List listeners_ref = this.request_listeners.getList();
        for (int i = 0; i < listeners_ref.size(); ++i) {
            try {
                ((BuddyPluginBuddyRequestListener)listeners_ref.get(i)).pendingMessages(from_buddies);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void fireEnabledStateChanged() {
        boolean enabled = !this.plugin_interface.getPluginState().isDisabled() && this.isEnabled();
        List listeners_ref = this.listeners.getList();
        for (int i = 0; i < listeners_ref.size(); ++i) {
            try {
                ((BuddyPluginListener)listeners_ref.get(i)).enabledStateChanged(enabled);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void rethrow(String reason, Throwable e) throws BuddyPluginException {
        this.logMessage(reason, e);
        if (e instanceof CryptoManagerPasswordException) {
            throw new BuddyPluginPasswordException(((CryptoManagerPasswordException)e).wasIncorrect(), reason, e);
        }
        throw new BuddyPluginException(reason, e);
    }

    public void addRequestListener(BuddyPluginBuddyRequestListener listener) {
        this.request_listeners.add(listener);
    }

    public void removeRequestListener(BuddyPluginBuddyRequestListener listener) {
        this.request_listeners.remove(listener);
    }

    public void logMessage(String str, Throwable e) {
        this.logMessage(str + ": " + Debug.getNestedExceptionMessage(e), true);
    }

    public void logMessage(String str) {
        this.logMessage(str, false);
    }

    public void logMessage(String str, boolean is_error) {
        this.log(str);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((BuddyPluginListener)it.next()).messageLogged(str, is_error);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void log(String str) {
        this.logger.log(str);
    }

    public void log(String str, Throwable e) {
        this.logger.log(str + ": " + Debug.getNestedExceptionMessageAndStack(e));
    }

    public static interface cryptoResult {
        public byte[] getChallenge();

        public byte[] getPayload();
    }

    protected static interface operationListener {
        public void complete();
    }

    private class publishDetails
    implements Cloneable {
        private byte[] public_key;
        private InetAddress ip;
        private int tcp_port;
        private int udp_port;
        private String nick_name;
        private int online_status = 0;
        private boolean enabled;
        private boolean published;
        private int sequence;

        private publishDetails() {
        }

        protected publishDetails getCopy() {
            try {
                publishDetails copy = (publishDetails)this.clone();
                copy.published = false;
                return copy;
            }
            catch (Throwable e) {
                return null;
            }
        }

        protected boolean isPublished() {
            return this.published;
        }

        protected void setPublished(boolean b) {
            this.published = b;
        }

        protected boolean isEnabled() {
            return this.enabled;
        }

        protected void setEnabled(boolean _enabled) {
            this.enabled = _enabled;
        }

        protected void setSequence(int seq) {
            this.sequence = seq;
        }

        protected int getSequence() {
            return this.sequence;
        }

        protected byte[] getPublicKey() {
            return this.public_key;
        }

        protected void setPublicKey(byte[] k) {
            this.public_key = k;
        }

        protected InetAddress getIP() {
            return this.ip;
        }

        protected void setIP(InetAddress _ip) {
            this.ip = _ip;
        }

        protected int getTCPPort() {
            return this.tcp_port;
        }

        protected void setTCPPort(int _port) {
            this.tcp_port = _port;
        }

        protected int getUDPPort() {
            return this.udp_port;
        }

        protected void setUDPPort(int _port) {
            this.udp_port = _port;
        }

        protected String getNickName() {
            return this.nick_name;
        }

        protected void setNickName(String n) {
            this.nick_name = n;
        }

        protected int getOnlineStatus() {
            return this.online_status;
        }

        protected void setOnlineStatus(int _status) {
            this.online_status = _status;
        }

        protected String getString() {
            return "enabled=" + this.enabled + ",ip=" + this.ip + ",tcp=" + this.tcp_port + ",udp=" + this.udp_port + ",stat=" + this.online_status + ",key=" + (this.public_key == null ? "<none>" : Base32.encode(this.public_key));
        }
    }
}

