/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy.swt;

import com.aelitis.azureus.core.security.CryptoHandler;
import com.aelitis.azureus.core.security.CryptoManager;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.security.CryptoManagerKeyListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginAZ2;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginAZ2Listener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddy;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginListener;
import com.aelitis.azureus.plugins.net.buddy.swt.BuddyPluginViewChat;
import com.aelitis.azureus.plugins.net.buddy.swt.BuddyPluginViewInstance;
import com.aelitis.azureus.plugins.net.buddy.tracker.BuddyPluginTracker;
import com.aelitis.azureus.plugins.net.buddy.tracker.BuddyPluginTrackerListener;
import java.net.URL;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTStatusEntry;
import org.gudy.azureus2.ui.swt.plugins.UISWTStatusEntryListener;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;

public class BuddyPluginView
implements UISWTViewEventListener {
    private BuddyPlugin plugin;
    private UISWTInstance ui_instance;
    private BuddyPluginViewInstance current_instance;
    private static Image icon_nli = ImageRepository.getImage("bbb_nli");
    private static Image icon_idle = ImageRepository.getImage("bbb_idle");
    private static Image icon_in = ImageRepository.getImage("bbb_in");
    private static Image icon_out = ImageRepository.getImage("bbb_out");

    public BuddyPluginView(BuddyPlugin _plugin, UISWTInstance _ui_instance) {
        this.plugin = _plugin;
        this.ui_instance = _ui_instance;
        this.plugin.getAZ2Handler().addListener(new BuddyPluginAZ2Listener(){

            public void chatCreated(final BuddyPluginAZ2.chatInstance chat) {
                final Display display = BuddyPluginView.this.ui_instance.getDisplay();
                if (!display.isDisposed()) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            if (!display.isDisposed()) {
                                new BuddyPluginViewChat(BuddyPluginView.this.plugin, display, chat);
                            }
                        }
                    });
                }
            }

            public void chatDestroyed(BuddyPluginAZ2.chatInstance chat) {
            }
        });
        SimpleTimer.addEvent("BuddyStatusInit", SystemTime.getOffsetTime(1000L), new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                UISWTStatusEntry label = BuddyPluginView.this.ui_instance.createStatusEntry();
                label.setText(MessageText.getString("azbuddy.tracker.bbb.status.title"));
                new statusUpdater(BuddyPluginView.this.ui_instance);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                if (this.current_instance == null) break;
                return false;
            }
            case 2: {
                this.current_instance = new BuddyPluginViewInstance(this.plugin, this.ui_instance, (Composite)event2.getData());
                break;
            }
            case 7: 
            case 8: {
                try {
                    if (this.current_instance == null) break;
                    this.current_instance.destroy();
                    break;
                }
                finally {
                    this.current_instance = null;
                }
            }
        }
        return true;
    }

    protected class statusUpdater
    implements BuddyPluginTrackerListener {
        private UISWTStatusEntry label;
        private UISWTStatusEntry status;
        private BuddyPluginTracker tracker;
        private TimerEventPeriodic update_event;
        private CryptoManager crypto;
        private boolean crypto_ok;
        private boolean has_buddies;

        protected statusUpdater(UISWTInstance instance) {
            this.status = BuddyPluginView.this.ui_instance.createStatusEntry();
            this.label = BuddyPluginView.this.ui_instance.createStatusEntry();
            this.label.setText(MessageText.getString("azbuddy.tracker.bbb.status.title"));
            this.label.setTooltipText(MessageText.getString("azbuddy.tracker.bbb.status.title.tooltip"));
            this.tracker = BuddyPluginView.this.plugin.getTracker();
            this.status.setText("");
            this.status.setImageEnabled(true);
            this.status.setVisible(this.tracker.isEnabled());
            this.label.setVisible(this.tracker.isEnabled());
            this.tracker.addListener(this);
            this.has_buddies = BuddyPluginView.this.plugin.getBuddies().size() > 0;
            UISWTStatusEntryListener click_listener = new UISWTStatusEntryListener(){

                public void entryClicked(UISWTStatusEntry entry) {
                    try {
                        BuddyPluginView.this.plugin.getPluginInterface().getUIManager().openURL(new URL("http://faq.vuze.com/?View=entry&EntryID=239"));
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            };
            this.status.setListener(click_listener);
            this.label.setListener(click_listener);
            BuddyPluginView.this.plugin.addListener(new BuddyPluginListener(){

                public void initialised(boolean available) {
                }

                public void buddyAdded(BuddyPluginBuddy buddy) {
                    if (!statusUpdater.this.has_buddies) {
                        statusUpdater.this.has_buddies = true;
                        statusUpdater.this.updateStatus();
                    }
                }

                public void buddyRemoved(BuddyPluginBuddy buddy) {
                    statusUpdater.this.has_buddies = BuddyPluginView.this.plugin.getBuddies().size() > 0;
                    if (!statusUpdater.this.has_buddies) {
                        statusUpdater.this.updateStatus();
                    }
                }

                public void buddyChanged(BuddyPluginBuddy buddy) {
                }

                public void messageLogged(String str, boolean error) {
                }

                public void enabledStateChanged(boolean enabled) {
                }
            });
            this.crypto = CryptoManagerFactory.getSingleton();
            this.crypto.addKeyListener(new CryptoManagerKeyListener(){

                public void keyChanged(CryptoHandler handler) {
                }

                public void keyLockStatusChanged(CryptoHandler handler) {
                    boolean ok = statusUpdater.this.crypto.getECCHandler().isUnlocked();
                    if (ok != statusUpdater.this.crypto_ok) {
                        statusUpdater.this.crypto_ok = ok;
                        statusUpdater.this.updateStatus();
                    }
                }
            });
            this.crypto_ok = this.crypto.getECCHandler().isUnlocked();
            this.updateStatus();
        }

        public void networkStatusChanged(BuddyPluginTracker tracker, int new_status) {
            this.updateStatus();
        }

        protected synchronized void updateStatus() {
            if (this.tracker.isEnabled()) {
                this.status.setVisible(true);
                this.label.setVisible(true);
                if (this.has_buddies && !this.crypto_ok) {
                    this.status.setImage(icon_nli);
                    this.status.setTooltipText(MessageText.getString("azbuddy.tracker.bbb.status.nli"));
                    this.disableUpdates();
                } else {
                    int network_status = this.tracker.getNetworkStatus();
                    if (network_status == 1) {
                        this.status.setImage(icon_idle);
                        this.status.setTooltipText(MessageText.getString("azbuddy.tracker.bbb.status.idle"));
                        this.disableUpdates();
                    } else if (network_status == 3) {
                        this.status.setImage(icon_in);
                        this.enableUpdates();
                    } else {
                        this.status.setImage(icon_out);
                        this.enableUpdates();
                    }
                }
            } else {
                this.disableUpdates();
                this.status.setVisible(false);
                this.label.setVisible(false);
            }
        }

        protected void enableUpdates() {
            if (this.update_event == null) {
                this.update_event = SimpleTimer.addPeriodicEvent("Buddy:GuiUpdater", 2500L, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void perform(TimerEvent event2) {
                        statusUpdater statusUpdater2 = statusUpdater.this;
                        synchronized (statusUpdater2) {
                            if (statusUpdater.this.tracker.isEnabled() && (statusUpdater.this.crypto_ok || !statusUpdater.this.has_buddies)) {
                                int ns = statusUpdater.this.tracker.getNetworkStatus();
                                String tt = ns == 1 ? MessageText.getString("azbuddy.tracker.bbb.status.idle") : (ns == 3 ? MessageText.getString("azbuddy.tracker.bbb.status.in") + ": " + DisplayFormatters.formatByteCountToKiBEtcPerSec(statusUpdater.this.tracker.getNetworkReceiveBytesPerSecond()) : MessageText.getString("azbuddy.tracker.bbb.status.out") + ": " + DisplayFormatters.formatByteCountToKiBEtcPerSec(statusUpdater.this.tracker.getNetworkSendBytesPerSecond()));
                                statusUpdater.this.status.setTooltipText(tt);
                            }
                        }
                    }
                });
            }
        }

        protected void disableUpdates() {
            if (this.update_event != null) {
                this.update_event.cancel();
                this.update_event = null;
            }
        }

        public void enabledStateChanged(BuddyPluginTracker tracker, boolean enabled) {
            this.updateStatus();
        }
    }
}

