/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.netstatus.swt;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASN;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminHTTPProxy;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNATDevice;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterface;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNode;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProgressListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProtocol;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminRoutesListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSocksProxy;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusPlugin;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusProtocolTesterBT;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusProtocolTesterListener;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;

public class NetStatusPluginTester {
    public static final int TEST_PING_ROUTE = 1;
    public static final int TEST_NAT_PROXIES = 2;
    public static final int TEST_OUTBOUND = 4;
    public static final int TEST_INBOUND = 8;
    public static final int TEST_BT_CONNECT = 16;
    private static final int ROUTE_TIMEOUT = 120000;
    private NetStatusPlugin plugin;
    private int test_types;
    private loggerProvider logger;
    private volatile boolean test_cancelled;

    protected NetStatusPluginTester(NetStatusPlugin _plugin, int _test_types, loggerProvider _logger) {
        this.plugin = _plugin;
        this.test_types = _test_types;
        this.logger = _logger;
    }

    protected boolean doTest(int type) {
        return (this.test_types & type) != 0;
    }

    protected void run() {
        NetworkAdminProtocol protocol;
        int i;
        final NetworkAdmin admin = NetworkAdmin.getSingleton();
        HashSet<InetAddress> public_addresses = new HashSet<InetAddress>();
        boolean checked_public = false;
        if (this.doTest(1)) {
            int i2;
            String node_str;
            NetworkAdminNode[] route;
            NetworkAdminNetworkInterfaceAddress address;
            this.log("Testing routing for the following interfaces:");
            NetworkAdminNetworkInterface[] interfaces = admin.getInterfaces();
            for (int i3 = 0; i3 < interfaces.length; ++i3) {
                NetworkAdminNetworkInterface intf = interfaces[i3];
                NetworkAdminNetworkInterfaceAddress[] addresses = intf.getAddresses();
                String a_str = "";
                for (int j = 0; j < addresses.length; ++j) {
                    address = addresses[j];
                    InetAddress ia = address.getAddress();
                    if (ia.isLoopbackAddress() || ia instanceof Inet6Address) continue;
                    a_str = a_str + (a_str.length() == 0 ? "" : ",") + ia.getHostAddress();
                }
                if (a_str.length() <= 0) continue;
                this.log("    " + intf.getName() + "/" + intf.getDisplayName() + ": " + a_str);
            }
            if (admin.canPing()) {
                this.log("Running ping tests");
                try {
                    InetAddress target_address = InetAddress.getByName(this.plugin.getPingTarget());
                    final HashMap active_pings = new HashMap();
                    admin.pingTargets(target_address, 120000, new NetworkAdminRoutesListener(){
                        private int timeouts;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public boolean foundNode(NetworkAdminNetworkInterfaceAddress intf, NetworkAdminNode[] route, int distance, int rtt) {
                            if (NetStatusPluginTester.this.test_cancelled) {
                                return false;
                            }
                            Map map = active_pings;
                            synchronized (map) {
                                active_pings.put(intf, route);
                            }
                            NetStatusPluginTester.this.log("  " + intf.getAddress().getHostAddress() + " -> " + route[route.length - 1].getAddress().getHostAddress());
                            return false;
                        }

                        public boolean timeout(NetworkAdminNetworkInterfaceAddress intf, NetworkAdminNode[] route, int distance) {
                            if (NetStatusPluginTester.this.test_cancelled) {
                                return false;
                            }
                            NetStatusPluginTester.this.log("  " + intf.getAddress().getHostAddress() + " - timeout");
                            ++this.timeouts;
                            return this.timeouts < 3;
                        }
                    });
                    if (this.test_cancelled) {
                        return;
                    }
                    int num_routes = active_pings.size();
                    if (num_routes == 0) {
                        this.logError("No active pings found!");
                    }
                    this.log("Found " + num_routes + " pings(s)");
                    for (Map.Entry entry : active_pings.entrySet()) {
                        address = (NetworkAdminNetworkInterfaceAddress)entry.getKey();
                        route = (NetworkAdminNode[])entry.getValue();
                        node_str = "";
                        for (i2 = 0; i2 < route.length; ++i2) {
                            node_str = node_str + (i2 == 0 ? "" : ",") + route[i2].getAddress().getHostAddress();
                        }
                        this.log("    " + address.getInterface().getName() + "/" + address.getAddress().getHostAddress() + " - " + node_str);
                    }
                }
                catch (Throwable e) {
                    this.logError("Pinging failed: " + Debug.getNestedExceptionMessage(e));
                }
            } else {
                this.logError("Can't run ping test as not supported");
            }
            if (this.test_cancelled) {
                return;
            }
            if (admin.canTraceRoute()) {
                this.log("Running trace route tests");
                try {
                    InetAddress target_address = InetAddress.getByName(this.plugin.getPingTarget());
                    final HashMap active_routes = new HashMap();
                    admin.getRoutes(target_address, 120000, new NetworkAdminRoutesListener(){
                        private String last_as = "";

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public boolean foundNode(NetworkAdminNetworkInterfaceAddress intf, NetworkAdminNode[] route, int distance, int rtt) {
                            if (NetStatusPluginTester.this.test_cancelled) {
                                return false;
                            }
                            Map map = active_routes;
                            synchronized (map) {
                                active_routes.put(intf, route);
                            }
                            InetAddress ia = route[route.length - 1].getAddress();
                            String as = "";
                            if (!ia.isLinkLocalAddress() && !ia.isSiteLocalAddress()) {
                                try {
                                    NetworkAdminASN asn = admin.lookupASN(ia);
                                    as = asn.getString();
                                    if (as.equals(this.last_as)) {
                                        as = "";
                                    } else {
                                        this.last_as = as;
                                    }
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                            }
                            NetStatusPluginTester.this.log("  " + intf.getAddress().getHostAddress() + " -> " + ia.getHostAddress() + " (hop=" + distance + ")" + (as.length() == 0 ? "" : " - " + as));
                            return true;
                        }

                        public boolean timeout(NetworkAdminNetworkInterfaceAddress intf, NetworkAdminNode[] route, int distance) {
                            if (NetStatusPluginTester.this.test_cancelled) {
                                return false;
                            }
                            NetStatusPluginTester.this.log("  " + intf.getAddress().getHostAddress() + " - timeout (hop=" + distance + ")");
                            if (route.length == 0 && distance >= 5) {
                                NetStatusPluginTester.this.logError("    giving up, no responses");
                                return false;
                            }
                            if (route.length >= 5 && distance > 6) {
                                NetStatusPluginTester.this.log("    truncating, sufficient responses");
                                return false;
                            }
                            return true;
                        }
                    });
                    if (this.test_cancelled) {
                        return;
                    }
                    int num_routes = active_routes.size();
                    if (num_routes == 0) {
                        this.logError("No active routes found!");
                    }
                    this.log("Found " + num_routes + " route(s)");
                    for (Map.Entry entry : active_routes.entrySet()) {
                        address = (NetworkAdminNetworkInterfaceAddress)entry.getKey();
                        route = (NetworkAdminNode[])entry.getValue();
                        node_str = "";
                        for (i2 = 0; i2 < route.length; ++i2) {
                            node_str = node_str + (i2 == 0 ? "" : ",") + route[i2].getAddress().getHostAddress();
                        }
                        this.log("    " + address.getInterface().getName() + "/" + address.getAddress().getHostAddress() + " - " + node_str);
                    }
                }
                catch (Throwable e) {
                    this.logError("Route tracing failed: " + Debug.getNestedExceptionMessage(e));
                }
            } else {
                this.logError("Can't run trace route test as not supported");
            }
            if (this.test_cancelled) {
                return;
            }
        }
        if (this.doTest(2)) {
            checked_public = true;
            NetworkAdminNATDevice[] nat_devices = admin.getNATDevices();
            this.log(nat_devices.length + " NAT device" + (nat_devices.length == 1 ? "" : "s") + " found");
            for (int i4 = 0; i4 < nat_devices.length; ++i4) {
                NetworkAdminNATDevice device = nat_devices[i4];
                InetAddress ext_address = device.getExternalAddress();
                if (ext_address != null) {
                    public_addresses.add(ext_address);
                }
                this.log("    " + device.getString());
            }
            NetworkAdminSocksProxy[] socks_proxies = admin.getSocksProxies();
            this.log(socks_proxies.length + " SOCKS proxy" + (socks_proxies.length == 1 ? "" : "s") + " found");
            for (int i5 = 0; i5 < socks_proxies.length; ++i5) {
                NetworkAdminSocksProxy proxy = socks_proxies[i5];
                this.log("    " + proxy.getString());
            }
            NetworkAdminHTTPProxy http_proxy = admin.getHTTPProxy();
            if (http_proxy == null) {
                this.log("No HTTP proxy found");
            } else {
                this.log("HTTP proxy found");
                this.log("    " + http_proxy.getString());
            }
        }
        InetAddress[] bind_addresses = admin.getAllBindAddresses();
        int num_binds = 0;
        for (i = 0; i < bind_addresses.length; ++i) {
            if (bind_addresses[i] == null) continue;
            ++num_binds;
        }
        if (num_binds == 0) {
            this.log("No explicit bind addresses");
        } else {
            this.log(num_binds + " bind addresses");
            for (i = 0; i < bind_addresses.length; ++i) {
                if (bind_addresses[i] == null) continue;
                this.log("    " + bind_addresses[i].getHostAddress());
            }
        }
        if (this.doTest(4)) {
            checked_public = true;
            NetworkAdminProtocol[] outbound_protocols = admin.getOutboundProtocols();
            if (outbound_protocols.length == 0) {
                this.log("No outbound protocols");
            } else {
                for (int i6 = 0; i6 < outbound_protocols.length; ++i6) {
                    if (this.test_cancelled) {
                        return;
                    }
                    protocol = outbound_protocols[i6];
                    this.log("Testing " + protocol.getName());
                    try {
                        InetAddress public_address = protocol.test(null, new NetworkAdminProgressListener(){

                            public void reportProgress(String task2) {
                                NetStatusPluginTester.this.log("    " + task2);
                            }
                        });
                        this.logSuccess("    Test successful");
                        if (public_address == null) continue;
                        public_addresses.add(public_address);
                        continue;
                    }
                    catch (Throwable e) {
                        this.logError("    Test failed", e);
                    }
                }
            }
        }
        if (this.doTest(8)) {
            checked_public = true;
            NetworkAdminProtocol[] inbound_protocols = admin.getInboundProtocols();
            if (inbound_protocols.length == 0) {
                this.log("No inbound protocols");
            } else {
                for (int i7 = 0; i7 < inbound_protocols.length; ++i7) {
                    if (this.test_cancelled) {
                        return;
                    }
                    protocol = inbound_protocols[i7];
                    this.log("Testing " + protocol.getName());
                    try {
                        InetAddress public_address = protocol.test(null, new NetworkAdminProgressListener(){

                            public void reportProgress(String task2) {
                                NetStatusPluginTester.this.log("    " + task2);
                            }
                        });
                        this.logSuccess("    Test successful");
                        if (public_address == null) continue;
                        public_addresses.add(public_address);
                        continue;
                    }
                    catch (Throwable e) {
                        this.logError("    Test failed", e);
                    }
                }
            }
        }
        if (checked_public) {
            if (public_addresses.size() == 0) {
                this.log("No public addresses found");
            } else {
                Iterator it = public_addresses.iterator();
                this.log(public_addresses.size() + " public/external addresses found");
                while (it.hasNext()) {
                    InetAddress pub_address = (InetAddress)it.next();
                    this.log("    " + pub_address.getHostAddress());
                    try {
                        NetworkAdminASN asn = admin.lookupASN(pub_address);
                        this.log("    AS details: " + asn.getString());
                    }
                    catch (Throwable e) {
                        this.logError("    failed to lookup AS", e);
                    }
                }
            }
        }
        if (this.doTest(16)) {
            this.log("Distributed protocol test");
            NetStatusProtocolTesterBT bt_test = this.plugin.getProtocolTester().runTest(new NetStatusProtocolTesterListener(){
                private List sessions = new ArrayList();

                public void complete(NetStatusProtocolTesterBT tester2) {
                    this.log("Results");
                    if (tester2.getOutboundConnects() < 4) {
                        this.log("    insufficient outbound connects for analysis");
                        return;
                    }
                    int outgoing_seed_ok = 0;
                    int outgoing_leecher_ok = 0;
                    int outgoing_seed_bad = 0;
                    int outgoing_leecher_bad = 0;
                    int incoming_connect_ok = 0;
                    for (int i = 0; i < this.sessions.size(); ++i) {
                        NetStatusProtocolTesterBT.Session session = (NetStatusProtocolTesterBT.Session)this.sessions.get(i);
                        if (session.isOK()) {
                            if (session.isInitiator()) {
                                if (session.isSeed()) {
                                    ++outgoing_seed_ok;
                                } else {
                                    ++outgoing_leecher_ok;
                                }
                            } else {
                                ++incoming_connect_ok;
                            }
                        } else if (session.isConnected()) {
                            if (session.isInitiator()) {
                                if (session.isSeed()) {
                                    ++outgoing_seed_bad;
                                } else {
                                    ++outgoing_leecher_bad;
                                }
                            } else {
                                ++incoming_connect_ok;
                            }
                        }
                        this.log("  " + (session.isInitiator() ? "Outbound" : "Inbound") + "," + (session.isSeed() ? "Seed" : "Leecher") + "," + session.getProtocolString());
                    }
                    if (incoming_connect_ok == 0) {
                        this.logError("  No incoming connections received, likely NAT problems");
                    }
                    if (outgoing_leecher_ok > 0 && outgoing_seed_ok == 0 && outgoing_seed_bad > 0) {
                        this.logError("  Outgoing seed connects appear to be failing while non-seeds succeed");
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void sessionAdded(NetStatusProtocolTesterBT.Session session) {
                    List list = this.sessions;
                    synchronized (list) {
                        this.sessions.add(session);
                    }
                }

                public void log(String str) {
                    NetStatusPluginTester.this.log("  " + str);
                }

                public void logError(String str) {
                    NetStatusPluginTester.this.logError("  " + str);
                }

                public void logError(String str, Throwable e) {
                    NetStatusPluginTester.this.logError("  " + str, e);
                }
            });
            while (!bt_test.waitForCompletion(5000L)) {
                if (this.isCancelled()) {
                    bt_test.destroy();
                    break;
                }
                this.log("    Status: " + bt_test.getStatus());
            }
        }
    }

    protected void cancel() {
        this.test_cancelled = true;
    }

    protected boolean isCancelled() {
        return this.test_cancelled;
    }

    protected void log(String str) {
        this.logger.log(str);
    }

    protected void logSuccess(String str) {
        this.logger.logSuccess(str);
    }

    protected void log(String str, Throwable e) {
        this.logger.log(str + ": " + e.getLocalizedMessage());
    }

    protected void logError(String str) {
        this.logger.logFailure(str);
    }

    protected void logError(String str, Throwable e) {
        this.logger.logFailure(str + ": " + e.getLocalizedMessage());
    }

    protected static interface loggerProvider {
        public void log(String var1);

        public void logSuccess(String var1);

        public void logFailure(String var1);
    }
}

