/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.removerules;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.HostNameToIPResolverListener;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;

public class DownloadRemoveRulesPlugin
implements Plugin,
DownloadManagerListener,
HostNameToIPResolverListener {
    public static final int INITIAL_DELAY = 60000;
    public static final int DELAYED_REMOVAL_PERIOD = 60000;
    public static final int AELITIS_BIG_TORRENT_SEED_LIMIT = 10000;
    public static final int AELITIS_SMALL_TORRENT_SEED_LIMIT = 1000;
    public static final int MAX_SEED_TO_PEER_RATIO = 10;
    public static final String AELITIS_HOST_CORE = "aelitis.com";
    public static final String AELITIS_TRACKER = "tracker.aelitis.com";
    protected String aelitis_ip;
    protected PluginInterface plugin_interface;
    protected boolean closing;
    protected Map dm_listener_map = new HashMap(10);
    protected List monitored_downloads = new ArrayList();
    protected LoggerChannel log;
    protected BooleanParameter remove_unauthorised;
    protected BooleanParameter remove_unauthorised_seeding_only;
    protected BooleanParameter remove_update_torrents;

    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", "Download Remove Rules");
    }

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        HostNameToIPResolver.addResolverRequest(AELITIS_TRACKER, this);
        this.log = this.plugin_interface.getLogger().getChannel("DLRemRules");
        BasicPluginConfigModel config = this.plugin_interface.getUIManager().createBasicPluginConfigModel("torrents", "download.removerules.name");
        config.addLabelParameter2("download.removerules.unauthorised.info");
        this.remove_unauthorised = config.addBooleanParameter2("download.removerules.unauthorised", "download.removerules.unauthorised", false);
        this.remove_unauthorised_seeding_only = config.addBooleanParameter2("download.removerules.unauthorised.seedingonly", "download.removerules.unauthorised.seedingonly", true);
        this.remove_unauthorised.addEnabledOnSelection(this.remove_unauthorised_seeding_only);
        this.remove_update_torrents = config.addBooleanParameter2("download.removerules.updatetorrents", "download.removerules.updatetorrents", true);
        new DelayedEvent("DownloadRemovalRules", 60000L, new AERunnable(){

            public void runSupport() {
                DownloadRemoveRulesPlugin.this.plugin_interface.getDownloadManager().addListener(DownloadRemoveRulesPlugin.this);
            }
        });
    }

    public void hostNameResolutionComplete(InetAddress address) {
        if (address != null) {
            this.aelitis_ip = address.getHostAddress();
        }
    }

    public void downloadAdded(final Download download) {
        if (!download.isPersistent()) {
            return;
        }
        DownloadTrackerListener listener = new DownloadTrackerListener(){

            public void scrapeResult(DownloadScrapeResult response) {
                if (DownloadRemoveRulesPlugin.this.closing) {
                    return;
                }
                DownloadRemoveRulesPlugin.this.handleScrape(download, response);
            }

            public void announceResult(DownloadAnnounceResult response) {
                if (DownloadRemoveRulesPlugin.this.closing) {
                    return;
                }
                DownloadRemoveRulesPlugin.this.handleAnnounce(download, response);
            }
        };
        this.monitored_downloads.add(download);
        this.dm_listener_map.put(download, listener);
        download.addTrackerListener(listener);
    }

    protected void handleScrape(Download download, DownloadScrapeResult response) {
        String status = response.getStatus();
        if (status == null) {
            status = "";
        }
        this.handleAnnounceScrapeStatus(download, status);
    }

    protected void handleAnnounce(Download download, DownloadAnnounceResult response) {
        String reason = "";
        if (response.getResponseType() == 2 && (reason = response.getError()) == null) {
            reason = "";
        }
        this.handleAnnounceScrapeStatus(download, reason);
    }

    protected void handleAnnounceScrapeStatus(Download download, String status) {
        String url_string;
        if (!this.monitored_downloads.contains(download)) {
            return;
        }
        status = status.toLowerCase();
        boolean download_completed = download.isComplete();
        if (!(status.indexOf("not authori") == -1 && status.toLowerCase().indexOf("unauthori") == -1 || !this.remove_unauthorised.getValue() || this.remove_unauthorised_seeding_only.getValue() && !download_completed)) {
            this.log.log((Object)download.getTorrent(), 1, "Download '" + download.getName() + "' is unauthorised and removal triggered");
            this.removeDownload(download);
            return;
        }
        Torrent torrent = download.getTorrent();
        if (torrent != null && torrent.getAnnounceURL() != null && ((url_string = torrent.getAnnounceURL().toString().toLowerCase()).indexOf(AELITIS_HOST_CORE) != -1 || this.aelitis_ip != null && url_string.indexOf(this.aelitis_ip) != -1)) {
            if (download_completed && status.indexOf("too many seeds") != -1 || status.indexOf("too many peers") != -1) {
                this.log.log((Object)download.getTorrent(), 1, "Download '" + download.getName() + "' being removed on instruction from the tracker");
                this.removeDownloadDelayed(download);
            } else if (download_completed && this.remove_update_torrents.getValue()) {
                long peers;
                long seeds = download.getLastScrapeResult().getSeedCount();
                if (seeds / ((peers = (long)download.getLastScrapeResult().getNonSeedCount()) == 0L ? 1L : peers) > 10L) {
                    this.log.log((Object)download.getTorrent(), 1, "Download '" + download.getName() + "' being removed to reduce swarm size");
                    this.removeDownloadDelayed(download);
                } else {
                    long creation_time = download.getCreationTime();
                    long running_mins = (SystemTime.getCurrentTime() - creation_time) / 60000L;
                    if (running_mins > 15L) {
                        boolean big_torrent;
                        boolean bl = big_torrent = torrent.getSize() > 0x100000L;
                        if (seeds > 10000L && big_torrent || seeds > 1000L && !big_torrent) {
                            this.log.log("Download '" + download.getName() + "' being removed to reduce swarm size");
                            this.removeDownloadDelayed(download);
                        }
                    }
                }
            }
        }
    }

    protected void removeDownloadDelayed(final Download download) {
        this.monitored_downloads.remove(download);
        this.plugin_interface.getUtilities().createThread("delayedRemoval", new AERunnable(){

            public void runSupport() {
                try {
                    Thread.sleep(60000L);
                    DownloadRemoveRulesPlugin.this.removeDownload(download);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        });
    }

    protected void removeDownload(Download download) {
        this.monitored_downloads.remove(download);
        if (download.getState() == 7) {
            try {
                download.remove();
            }
            catch (Throwable e) {
                this.log.logAlert("Automatic removal of download '" + download.getName() + "' failed", e);
            }
        } else {
            download.addListener(new DownloadListener(){

                public void stateChanged(Download download, int old_state, int new_state) {
                    DownloadRemoveRulesPlugin.this.log.log((Object)download.getTorrent(), 1, "download state changed to '" + new_state + "'");
                    if (new_state == 7) {
                        try {
                            download.remove();
                            String msg = DownloadRemoveRulesPlugin.this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("download.removerules.removed.ok", new String[]{download.getName()});
                            if (download.getFlag(16L)) {
                                DownloadRemoveRulesPlugin.this.log.log((Object)download.getTorrent(), 1, msg);
                            } else {
                                DownloadRemoveRulesPlugin.this.log.logAlert(1, msg);
                            }
                        }
                        catch (Throwable e) {
                            DownloadRemoveRulesPlugin.this.log.logAlert("Automatic removal of download '" + download.getName() + "' failed", e);
                        }
                    }
                }

                public void positionChanged(Download download, int oldPosition, int newPosition) {
                }
            });
            try {
                download.stop();
            }
            catch (DownloadException e) {
                this.log.logAlert("Automatic removal of download '" + download.getName() + "' failed", e);
            }
        }
    }

    public void downloadRemoved(Download download) {
        this.monitored_downloads.remove(download);
        DownloadTrackerListener listener = (DownloadTrackerListener)this.dm_listener_map.remove(download);
        if (listener != null) {
            download.removeTrackerListener(listener);
        }
    }

    public void destroyInitiated() {
        this.closing = true;
    }

    public void destroyed() {
    }
}

