/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.AzureusCoreListener;
import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.launcher.Launcher;
import com.aelitis.azureus.ui.IUIIntializer;
import com.aelitis.azureus.ui.InitializerListener;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.UIConfigDefaultsSWTv3;
import com.aelitis.azureus.ui.swt.browser.PlatformAuthorizedSenderImpl;
import com.aelitis.azureus.ui.swt.browser.listener.BrowserRpcBuddyListener;
import com.aelitis.azureus.ui.swt.browser.listener.ConfigListener;
import com.aelitis.azureus.ui.swt.browser.listener.DisplayListener;
import com.aelitis.azureus.ui.swt.browser.listener.LightBoxBrowserRequestListener;
import com.aelitis.azureus.ui.swt.browser.listener.StatusListener;
import com.aelitis.azureus.ui.swt.browser.listener.TorrentListener;
import com.aelitis.azureus.ui.swt.browser.listener.VuzeListener;
import com.aelitis.azureus.ui.swt.browser.msg.MessageDispatcherSWT;
import com.aelitis.azureus.ui.swt.shells.main.MainWindow;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionManagerUI;
import com.aelitis.azureus.ui.swt.utils.UIMagnetHandler;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.InitialisationFunctions;
import java.util.Iterator;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;
import org.gudy.azureus2.ui.common.util.UserAlerts;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.LocaleUtilSWT;
import org.gudy.azureus2.ui.swt.Main;
import org.gudy.azureus2.ui.swt.StartServer;
import org.gudy.azureus2.ui.swt.UIConfigDefaultsSWT;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.auth.AuthenticatorWindow;
import org.gudy.azureus2.ui.swt.auth.CertificateTrustWindow;
import org.gudy.azureus2.ui.swt.auth.CryptoWindow;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThreadAlreadyInstanciatedException;
import org.gudy.azureus2.ui.swt.mainwindow.SplashWindow;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.networks.SWTNetworkSelection;
import org.gudy.azureus2.ui.swt.pluginsinstaller.InstallPluginWizard;
import org.gudy.azureus2.ui.swt.progress.ProgressWindow;
import org.gudy.azureus2.ui.swt.update.UpdateMonitor;
import org.gudy.azureus2.ui.swt.updater2.PreUpdateChecker;
import org.gudy.azureus2.ui.swt.updater2.SWTUpdateChecker;

public class Initializer
implements IUIIntializer {
    private static StartServer startServer;
    private final AzureusCore core;
    private final String[] args;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private AEMonitor listeners_mon = new AEMonitor("Initializer:l");
    private int curPercent = 0;
    private AESemaphore init_task = new AESemaphore("delayed init");

    public static void main(String[] args) {
        if (Launcher.checkAndLaunch(Initializer.class, args)) {
            return;
        }
        if (System.getProperty("ui.temp") == null) {
            System.setProperty("ui.temp", "az3");
        }
        Main.main(args);
    }

    public Initializer(AzureusCore core, boolean createSWTThreadAndRun, String[] args) {
        this.core = core;
        this.args = args;
        if (createSWTThreadAndRun) {
            try {
                SWTThread.createInstance(this);
            }
            catch (SWTThreadAlreadyInstanciatedException e) {
                Debug.printStackTrace(e);
            }
        } else {
            ConstantsV3.initialize(core);
            this.initializePlatformClientMessageContext();
            PlatformMessenger.setAuthorizedTransferListener(new PlatformAuthorizedSenderImpl());
            PlatformConfigMessenger.login(0L);
        }
    }

    public void run() {
        UtilitiesImpl.DelayedTaskImpl delayed_task = UtilitiesImpl.addDelayedTask("SWT Initialisation", new Runnable(){

            public void run() {
                Initializer.this.init_task.reserve();
            }
        });
        delayed_task.queue();
        long startTime = SystemTime.getCurrentTime();
        new LocaleUtilSWT(this.core);
        final Display display = SWTThread.getInstance().getDisplay();
        new UIMagnetHandler(this.core);
        UIConfigDefaultsSWT.initialize();
        UIConfigDefaultsSWTv3.initialize(this.core);
        ImageRepository.loadImagesForSplashWindow(display);
        if (COConfigurationManager.getBooleanParameter("Show Splash")) {
            display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    new SplashWindow(display, Initializer.this);
                }
            });
        }
        System.out.println("Locale Initializing took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        this.core.addListener(new AzureusCoreListener(){
            int fakePercent;
            long startTime;
            long lastTaskTimeSecs;
            String sLastTask;
            {
                this.fakePercent = Math.min(70, 100 - Initializer.this.curPercent);
                this.startTime = SystemTime.getCurrentTime();
                this.lastTaskTimeSecs = this.startTime / 500L;
            }

            public void reportCurrentTask(AzureusCoreOperation op, String currentTask) {
                if (op.getOperationType() != 1) {
                    return;
                }
                Initializer.this.reportCurrentTask(currentTask);
                long now = SystemTime.getCurrentTime();
                if (this.fakePercent > 0 && this.lastTaskTimeSecs != now / 200L) {
                    this.lastTaskTimeSecs = SystemTime.getCurrentTime() / 200L;
                    --this.fakePercent;
                    Initializer.this.reportPercent(Initializer.this.curPercent + 1);
                }
                if (this.sLastTask != null && !this.sLastTask.startsWith("Loading Torrent")) {
                    long diff = now - this.startTime;
                    if (diff > 10L && diff < 300000L) {
                        System.out.println(TimeFormatter.milliStamp() + "   Core: " + diff + "ms for activity between '" + this.sLastTask + "' and '" + currentTask + "'");
                    }
                    this.startTime = SystemTime.getCurrentTime();
                }
                this.sLastTask = currentTask;
            }

            public void reportPercent(AzureusCoreOperation op, int percent) {
                long now;
                long diff;
                if (op.getOperationType() != 1) {
                    return;
                }
                if (percent == 100 && (diff = (now = SystemTime.getCurrentTime()) - this.startTime) > 10L && diff < 300000L) {
                    System.out.println("   Core: " + diff + "ms for " + this.sLastTask);
                }
            }
        });
        this.core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){
            private GlobalManager gm;

            public void componentCreated(AzureusCore core, AzureusCoreComponent component) {
                Initializer.this.reportPercent(Initializer.this.curPercent + 1);
                if (component instanceof GlobalManager) {
                    Initializer.this.reportCurrentTaskByKey("splash.initializePlugins");
                    this.gm = (GlobalManager)component;
                    InitialisationFunctions.earlyInitialisation(core);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void started(AzureusCore core) {
                boolean main_window_will_report_complete = false;
                try {
                    InitialisationFunctions.lateInitialisation(core);
                    if (this.gm == null) {
                        return;
                    }
                    Colors.getInstance();
                    Initializer.this.reportPercent(Initializer.this.curPercent + 1);
                    new UserAlerts(this.gm);
                    Initializer.this.reportCurrentTaskByKey("splash.initializeGui");
                    Initializer.this.reportPercent(Initializer.this.curPercent + 1);
                    Cursors.init();
                    Initializer.this.reportPercent(Initializer.this.curPercent + 1);
                    main_window_will_report_complete = true;
                    new MainWindow(core, Display.getDefault(), Initializer.this);
                    Initializer.this.reportCurrentTaskByKey("splash.openViews");
                    SWTUpdateChecker.initialize();
                    PreUpdateChecker.initialize(core, COConfigurationManager.getStringParameter("ui"));
                    UpdateMonitor.getSingleton(core);
                    Alerts.initComplete();
                    for (int i = 0; i < Initializer.this.args.length; ++i) {
                        try {
                            TorrentOpener.openTorrent(Initializer.this.args[i]);
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
                finally {
                    if (!main_window_will_report_complete) {
                        Initializer.this.init_task.release();
                    }
                }
            }

            public void stopping(AzureusCore core) {
                Alerts.stopInitiated();
            }

            public void stopped(AzureusCore core) {
            }

            public boolean syncInvokeRequired() {
                return true;
            }

            public boolean requiresPluginInitCompleteBeforeStartedEvent() {
                return false;
            }

            public boolean stopRequested(AzureusCore _core) throws AzureusCoreException {
                return org.gudy.azureus2.ui.swt.mainwindow.Initializer.handleStopRestart(false);
            }

            public boolean restartRequested(AzureusCore core) {
                return org.gudy.azureus2.ui.swt.mainwindow.Initializer.handleStopRestart(true);
            }
        });
        this.reportCurrentTaskByKey("splash.initializeCore");
        try {
            new SubscriptionManagerUI(this.core);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        this.core.start();
        this.reportPercent(50);
        System.out.println("Core Initializing took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        this.reportCurrentTaskByKey("splash.initializeUIElements");
        Colors.getInstance();
        this.reportPercent(this.curPercent + 1);
        Alerts.init();
        this.reportPercent(this.curPercent + 1);
        ProgressWindow.register(this.core);
        this.reportPercent(this.curPercent + 1);
        new SWTNetworkSelection();
        this.reportPercent(this.curPercent + 1);
        new AuthenticatorWindow();
        new CryptoWindow();
        this.reportPercent(this.curPercent + 1);
        new CertificateTrustWindow();
        InstallPluginWizard.register(this.core, display);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stopIt(boolean isForRestart, boolean isCloseAreadyInProgress) throws AzureusCoreException {
        if (this.core != null && !isCloseAreadyInProgress && isForRestart) {
            this.core.checkRestartSupported();
        }
        try {
            try {
                UIFunctionsManager.getUIFunctions().getUIUpdater().stopIt();
            }
            catch (Exception e) {
                Debug.out(e);
            }
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    SWTThread.getInstance().terminate();
                }
            });
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (this.core == null || isCloseAreadyInProgress) throw throwable;
                try {
                    if (isForRestart) {
                        this.core.restart();
                        throw throwable;
                    }
                    long lStopStarted = System.currentTimeMillis();
                    System.out.println("core.stop");
                    this.core.stop();
                    System.out.println("core.stop done in " + (System.currentTimeMillis() - lStopStarted));
                    throw throwable;
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
                throw throwable;
            }
            finally {
                if (startServer != null) {
                    startServer.stopIt();
                }
            }
        }
        try {
            if (this.core == null || isCloseAreadyInProgress) return;
            try {
                if (isForRestart) {
                    this.core.restart();
                    return;
                }
                long lStopStarted = System.currentTimeMillis();
                System.out.println("core.stop");
                this.core.stop();
                System.out.println("core.stop done in " + (System.currentTimeMillis() - lStopStarted));
                return;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            return;
        }
        finally {
            if (startServer != null) {
                startServer.stopIt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(InitializerListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.add(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(InitializerListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.remove(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportCurrentTask(String currentTaskString) {
        try {
            this.listeners_mon.enter();
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                InitializerListener listener = (InitializerListener)iter.next();
                try {
                    listener.reportCurrentTask(currentTaskString);
                }
                catch (Exception e) {}
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    private void reportCurrentTaskByKey(String key) {
        this.reportCurrentTask(MessageText.getString(key));
    }

    public void increaseProgress() {
        if (this.curPercent < 100) {
            this.reportPercent(this.curPercent + 1);
        }
    }

    public void abortProgress() {
        this.reportPercent(101);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportPercent(int percent) {
        if (this.curPercent > percent) {
            return;
        }
        this.curPercent = percent;
        try {
            this.listeners_mon.enter();
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                InitializerListener listener = (InitializerListener)iter.next();
                try {
                    listener.reportPercent(percent);
                }
                catch (Exception e) {}
            }
            if (percent > 100) {
                this.listeners.clear();
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public void initializationComplete() {
        this.core.getPluginManager().firePluginEvent(6);
        new DelayedEvent("SWTInitComplete:delay", 8500L, new AERunnable(){

            public void runSupport() {
                Initializer.this.init_task.release();
            }
        });
    }

    private void initializePlatformClientMessageContext() {
        ClientMessageContext clientMsgContext = PlatformMessenger.getClientMessageContext();
        if (clientMsgContext != null) {
            clientMsgContext.setMessageDispatcher(new MessageDispatcherSWT(clientMsgContext));
            clientMsgContext.addMessageListener(new TorrentListener());
            clientMsgContext.addMessageListener(new VuzeListener());
            clientMsgContext.addMessageListener(new DisplayListener(null));
            clientMsgContext.addMessageListener(new ConfigListener(null));
            clientMsgContext.addMessageListener(new LightBoxBrowserRequestListener());
            clientMsgContext.addMessageListener(new StatusListener());
            clientMsgContext.addMessageListener(new BrowserRpcBuddyListener());
        }
    }
}

