/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser;

import com.aelitis.azureus.core.impl.AzureusCoreImpl;
import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.messenger.ClientMessageContextImpl;
import com.aelitis.azureus.core.messenger.browser.listeners.BrowserMessageListener;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.ui.swt.browser.msg.MessageDispatcherSWT;
import com.aelitis.azureus.ui.swt.shells.main.MainWindow;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.JSONUtils;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.ui.swt.Utils;

public class BrowserContext
extends ClientMessageContextImpl
implements DisposeListener {
    private static final String CONTEXT_KEY = "BrowserContext";
    private static final String KEY_ENABLE_MENU = "browser.menu.enable";
    private Browser browser;
    private Display display;
    private boolean pageLoading = false;
    private long pageLoadingStart = 0L;
    private String lastValidURL = null;
    private final boolean forceVisibleAfterLoad;
    private TimerEventPeriodic checkURLEvent;
    private Control widgetWaitIndicator;
    private MessageDispatcherSWT messageDispatcherSWT;
    protected boolean wiggleBrowser = Constants.isOSX;
    private ClientMessageContext.torrentURLHandler torrentURLHandler;
    private List loadingListeners = Collections.EMPTY_LIST;

    public BrowserContext(String _id, Browser _browser, Control _widgetWaitingIndicator, boolean _forceVisibleAfterLoad) {
        super(_id, null);
        this.browser = _browser;
        this.forceVisibleAfterLoad = _forceVisibleAfterLoad;
        this.widgetWaitIndicator = _widgetWaitingIndicator;
        this.messageDispatcherSWT = new MessageDispatcherSWT(this);
        this.setMessageDispatcher(this.messageDispatcherSWT);
        final TimerEventPerformer showBrowersPerformer = new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                if (BrowserContext.this.browser != null && !BrowserContext.this.browser.isDisposed()) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (BrowserContext.this.forceVisibleAfterLoad && BrowserContext.this.browser != null && !BrowserContext.this.browser.isDisposed() && !BrowserContext.this.browser.isVisible()) {
                                BrowserContext.this.browser.setVisible(true);
                            }
                        }
                    });
                }
            }
        };
        final TimerEventPerformer hideIndicatorPerformer = new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                BrowserContext.this.setPageLoading(false, BrowserContext.this.browser.getUrl());
                if (BrowserContext.this.widgetWaitIndicator != null && !BrowserContext.this.widgetWaitIndicator.isDisposed()) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (BrowserContext.this.widgetWaitIndicator != null && !BrowserContext.this.widgetWaitIndicator.isDisposed()) {
                                BrowserContext.this.widgetWaitIndicator.setVisible(false);
                            }
                        }
                    });
                }
            }
        };
        final TimerEventPerformer checkURLEventPerformer = new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                if (BrowserContext.this.browser != null && !BrowserContext.this.browser.isDisposed()) {
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        public void runSupport() {
                            if (BrowserContext.this.browser != null && !BrowserContext.this.browser.isDisposed()) {
                                BrowserContext.this.browser.execute("try { tuxLocString = document.location.toString();if (tuxLocString.indexOf('res://') == 0) {  document.title = 'err: ' + tuxLocString;} else {  tuxTitleString = document.title.toString();  if (tuxTitleString.indexOf('408 ') == 0 || tuxTitleString.indexOf('503 ') == 0 || tuxTitleString.indexOf('500 ') == 0)   { document.title = 'err: ' + tuxTitleString; } }} catch (e) { }");
                            }
                        }
                    });
                }
            }
        };
        if (this.forceVisibleAfterLoad) {
            this.browser.setVisible(false);
        }
        this.setPageLoading(false, this.browser.getUrl());
        if (this.widgetWaitIndicator != null && !this.widgetWaitIndicator.isDisposed()) {
            this.widgetWaitIndicator.setVisible(false);
        }
        this.browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event2) {
                if (BrowserContext.this.browser.isDisposed()) {
                    return;
                }
                if (!BrowserContext.this.browser.isVisible()) {
                    SimpleTimer.addEvent("Show Browser", System.currentTimeMillis() + 700L, showBrowersPerformer);
                }
                if (event2.title.startsWith("err: ")) {
                    BrowserContext.this.fillWithRetry(event2.title);
                }
            }
        });
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event2) {
            }

            public void completed(ProgressEvent event2) {
                if (BrowserContext.this.browser.isDisposed()) {
                    return;
                }
                checkURLEventPerformer.perform(null);
                if (BrowserContext.this.forceVisibleAfterLoad && !BrowserContext.this.browser.isVisible()) {
                    BrowserContext.this.browser.setVisible(true);
                }
                BrowserContext.this.browser.execute("try { if (azureusClientWelcome) { azureusClientWelcome('" + ConstantsV3.AZID + "'," + "{ 'azv':'" + "4.0.0.1_B06" + "', 'browser-id':'" + BrowserContext.this.getID() + "' }" + ");} } catch (e) { }");
                if ((Constants.isCVSVersion() || System.getProperty("debug.https", null) != null) && BrowserContext.this.browser.getUrl().indexOf("https") == 0) {
                    BrowserContext.this.browser.execute("try { o = document.getElementsByTagName('body'); if (o) o[0].style.borderTop = '2px dotted #3b3b3b'; } catch (e) {}");
                }
                if (BrowserContext.this.wiggleBrowser) {
                    Shell shell = BrowserContext.this.browser.getShell();
                    Point size = shell.getSize();
                    --size.x;
                    --size.y;
                    shell.setSize(size);
                    ++size.x;
                    ++size.y;
                    shell.setSize(size);
                }
            }
        });
        this.checkURLEvent = SimpleTimer.addPeriodicEvent("checkURL", 10000L, checkURLEventPerformer);
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event2) {
                event2.required = true;
                final Browser subBrowser = new Browser((Composite)BrowserContext.this.browser, 0);
                subBrowser.addLocationListener(new LocationListener(){

                    public void changed(LocationEvent arg0) {
                    }

                    public void changing(LocationEvent event2) {
                        event2.doit = false;
                        System.out.println("SubBrowser URL : " + event2.location);
                        if (!PlatformConfigMessenger.isURLBlocked(event2.location) && (event2.location.startsWith("http://") || event2.location.startsWith("https://"))) {
                            Program.launch((String)event2.location);
                        }
                        Utils.execSWTThreadLater(0, new AERunnable(){

                            public void runSupport() {
                                subBrowser.dispose();
                            }
                        });
                    }
                });
                event2.browser = subBrowser;
            }
        });
        this.browser.addLocationListener(new LocationListener(){
            private TimerEvent timerevent;

            public void changed(LocationEvent event2) {
                if (this.timerevent != null) {
                    this.timerevent.cancel();
                }
                checkURLEventPerformer.perform(null);
                BrowserContext.this.setPageLoading(false, event2.location);
                if (BrowserContext.this.widgetWaitIndicator != null && !BrowserContext.this.widgetWaitIndicator.isDisposed()) {
                    BrowserContext.this.widgetWaitIndicator.setVisible(false);
                }
            }

            public void changing(LocationEvent event2) {
                boolean isWebURL;
                if (BrowserContext.this.browser.isDisposed()) {
                    return;
                }
                String event_location = event2.location;
                if (event_location.startsWith("javascript") && event_location.indexOf("back()") > 0) {
                    if (BrowserContext.this.browser.isBackEnabled()) {
                        BrowserContext.this.browser.back();
                    } else if (BrowserContext.this.lastValidURL != null) {
                        BrowserContext.this.fillWithRetry(event_location);
                    }
                    return;
                }
                boolean bl = isWebURL = event_location.startsWith("http://") || event_location.startsWith("https://");
                if (!isWebURL) {
                    if (event_location.startsWith("res://") && BrowserContext.this.lastValidURL != null) {
                        BrowserContext.this.fillWithRetry(event_location);
                    }
                    return;
                }
                boolean blocked = PlatformConfigMessenger.isURLBlocked(event_location);
                if (blocked) {
                    event2.doit = false;
                    Utils.openMessageBox(Utils.findAnyShell(), 32, "URL blocked", "Tried to open " + event_location + " but it's blocked");
                    BrowserContext.this.browser.back();
                } else {
                    BrowserContext.this.lastValidURL = event_location;
                    BrowserContext.this.setPageLoading(true, event2.location);
                    if (event2.top) {
                        if (BrowserContext.this.widgetWaitIndicator != null && !BrowserContext.this.widgetWaitIndicator.isDisposed()) {
                            BrowserContext.this.widgetWaitIndicator.setVisible(true);
                        }
                        this.timerevent = SimpleTimer.addEvent("Hide Indicator", System.currentTimeMillis() + 20000L, hideIndicatorPerformer);
                    } else {
                        Object url;
                        boolean isTorrent = false;
                        boolean isVuzeFile = false;
                        if (event_location.endsWith(".torrent")) {
                            isTorrent = true;
                        } else {
                            boolean test_for_vuze;
                            boolean can_rpc = PlatformConfigMessenger.urlCanRPC(event_location);
                            boolean test_for_torrent = !can_rpc && event_location.indexOf(".htm") == -1;
                            boolean bl2 = test_for_vuze = can_rpc && (event_location.endsWith(".xml") || event_location.endsWith(".vuze"));
                            if (test_for_torrent || test_for_vuze) {
                                try {
                                    String contentDisposition;
                                    url = new URL(event_location);
                                    URLConnection conn = ((URL)url).openConnection();
                                    ((HttpURLConnection)conn).setRequestMethod("HEAD");
                                    String referer_str = null;
                                    try {
                                        URL referer = new URL(((Browser)event2.widget).getUrl());
                                        if (referer != null) {
                                            referer_str = referer.toExternalForm();
                                        }
                                    }
                                    catch (Throwable e) {
                                        // empty catch block
                                    }
                                    UrlUtils.setBrowserHeaders(conn, referer_str);
                                    UrlUtils.connectWithTimeouts(conn, 1500L, 5000L);
                                    String contentType = conn.getContentType();
                                    if (contentType != null) {
                                        if (test_for_torrent && contentType.indexOf("torrent") != -1) {
                                            isTorrent = true;
                                        }
                                        if (test_for_vuze && contentType.indexOf("vuze") != -1) {
                                            isVuzeFile = true;
                                        }
                                    }
                                    if ((contentDisposition = conn.getHeaderField("Content-Disposition")) != null) {
                                        if (test_for_torrent && contentDisposition.indexOf(".torrent") != -1) {
                                            isTorrent = true;
                                        }
                                        if (test_for_vuze && contentDisposition.indexOf(".vuze") != -1) {
                                            isVuzeFile = true;
                                        }
                                    }
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                            }
                        }
                        if (isTorrent) {
                            event2.doit = false;
                            try {
                                String referer_str = null;
                                try {
                                    referer_str = new URL(((Browser)event2.widget).getUrl()).toExternalForm();
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                                Map headers = UrlUtils.getBrowserHeaders(referer_str);
                                String cookies = (String)((Browser)event2.widget).getData("current-cookies");
                                if (cookies != null) {
                                    headers.put("Cookie", cookies);
                                }
                                url = event_location;
                                if (BrowserContext.this.torrentURLHandler != null) {
                                    try {
                                        BrowserContext.this.torrentURLHandler.handleTorrentURL((String)url);
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                    }
                                }
                                AzureusCoreImpl.getSingleton().getPluginManager().getDefaultPluginInterface().getDownloadManager().addDownload(new URL((String)url), headers);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        } else if (isVuzeFile) {
                            event2.doit = false;
                            try {
                                String referer_str = null;
                                try {
                                    referer_str = new URL(((Browser)event2.widget).getUrl()).toExternalForm();
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                                Map headers = UrlUtils.getBrowserHeaders(referer_str);
                                String cookies = (String)((Browser)event2.widget).getData("current-cookies");
                                if (cookies != null) {
                                    headers.put("Cookie", cookies);
                                }
                                ResourceDownloader rd = StaticUtilities.getResourceDownloaderFactory().create(new URL(event_location));
                                VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
                                VuzeFile vf = vfh.loadVuzeFile(rd.download());
                                if (vf == null) {
                                    event2.doit = true;
                                } else {
                                    vfh.handleFiles(new VuzeFile[]{vf}, 0);
                                }
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        });
        this.browser.setData(CONTEXT_KEY, (Object)this);
        this.browser.addDisposeListener((DisposeListener)this);
        final boolean enableMenu = System.getProperty(KEY_ENABLE_MENU, "0").equals("1");
        this.browser.addListener(35, new Listener(){

            public void handleEvent(Event event2) {
                event2.doit = enableMenu;
            }
        });
        this.messageDispatcherSWT.registerBrowser(this.browser);
        this.display = this.browser.getDisplay();
    }

    protected void setPageLoading(boolean b, String url) {
        if (this.pageLoading == b) {
            return;
        }
        this.pageLoading = b;
        if (this.pageLoading) {
            this.pageLoadingStart = SystemTime.getCurrentTime();
        } else if (this.pageLoadingStart > 0L) {
            int i;
            long diff = SystemTime.getCurrentTime() - this.pageLoadingStart;
            if (Constants.isCVSVersion() && diff > 0L && PlatformConfigMessenger.urlCanRPC(this.lastValidURL) && (i = this.lastValidURL.lastIndexOf(47) + 1) >= 0 && i < this.lastValidURL.length()) {
                int j = this.lastValidURL.lastIndexOf("azid=") - 1;
                String s = j > i ? this.lastValidURL.substring(i, j) : this.lastValidURL.substring(i);
                s = s.replaceAll(";jsessionid.*\\?", "\\?");
                MainWindow.addUsageStat("web:" + s, diff);
            }
            this.pageLoadingStart = 0L;
        }
        Object[] listeners = this.loadingListeners.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            loadingListener l = (loadingListener)listeners[i];
            l.browserLoadingChanged(b, url);
        }
    }

    public void setTorrentURLHandler(ClientMessageContext.torrentURLHandler handler) {
        this.torrentURLHandler = handler;
    }

    public void fillWithRetry(String s) {
        Color bg = this.browser.getDisplay().getSystemColor(22);
        Color fg = this.browser.getDisplay().getSystemColor(21);
        this.browser.setText("<html><body style='overflow:auto; font-family: verdana; font-size: 10pt' bgcolor=#" + Utils.toColorHexString(bg) + " text=#" + Utils.toColorHexString(fg) + ">" + "<br>Sorry, there was a problem loading this page.<br> " + "Please check if your internet connection is working and click <a href='" + this.lastValidURL + "' style=\"color: rgb(100, 155, 255); \">retry</a> to continue." + "<div style='word-wrap: break-word'><font size=1 color=#" + Utils.toColorHexString(bg) + ">" + s + "</font></div>" + "</body></html>");
    }

    private void deregisterBrowser() {
        if (this.browser == null) {
            throw new IllegalStateException("Context " + this.getID() + " doesn't have a registered browser");
        }
        this.browser.setData(CONTEXT_KEY, null);
        this.browser.removeDisposeListener((DisposeListener)this);
        this.messageDispatcherSWT.deregisterBrowser(this.browser);
        this.browser = null;
        if (this.checkURLEvent != null && !this.checkURLEvent.isCancelled()) {
            this.checkURLEvent.cancel();
            this.checkURLEvent = null;
        }
    }

    public static BrowserContext getContext(Browser browser) {
        Object data = browser.getData(CONTEXT_KEY);
        if (data != null && !(data instanceof BrowserContext)) {
            Debug.out("Data in Browser with key BrowserContext is not a BrowserContext");
            return null;
        }
        return (BrowserContext)data;
    }

    public void addMessageListener(BrowserMessageListener listener) {
        this.messageDispatcherSWT.addListener(listener);
    }

    public Object getBrowserData(String key) {
        return this.browser.getData(key);
    }

    public void setBrowserData(String key, Object value) {
        this.browser.setData(key, value);
    }

    public boolean sendBrowserMessage(String key, String op) {
        return this.sendBrowserMessage(key, op, (Map)null);
    }

    public boolean sendBrowserMessage(String key, String op, Map params) {
        StringBuffer msg = new StringBuffer();
        msg.append("az.msg.dispatch('").append(key).append("', '").append(op).append("'");
        if (params != null) {
            msg.append(", ").append(JSONUtils.encodeToJSON(params));
        }
        msg.append(")");
        return this.executeInBrowser(msg.toString());
    }

    public boolean sendBrowserMessage(String key, String op, Collection params) {
        StringBuffer msg = new StringBuffer();
        msg.append("az.msg.dispatch('").append(key).append("', '").append(op).append("'");
        if (params != null) {
            msg.append(", ").append(JSONUtils.encodeToJSON(params));
        }
        msg.append(")");
        return this.executeInBrowser(msg.toString());
    }

    protected boolean maySend(String key, String op, Map params) {
        return !this.pageLoading;
    }

    public boolean executeInBrowser(final String javascript) {
        if (!this.mayExecute(javascript)) {
            this.debug("BLOCKED: browser.execute( " + this.getShortJavascript(javascript) + " )");
            return false;
        }
        if (this.display == null || this.display.isDisposed()) {
            this.debug("CANNOT: browser.execute( " + this.getShortJavascript(javascript) + " )");
            return false;
        }
        final String reallyExecute = "try { " + javascript + " } catch ( e ) { }";
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (BrowserContext.this.browser == null || BrowserContext.this.browser.isDisposed()) {
                    BrowserContext.this.debug("CANNOT: browser.execute( " + BrowserContext.this.getShortJavascript(javascript) + " )");
                } else if (!BrowserContext.this.browser.execute(reallyExecute)) {
                    BrowserContext.this.debug("FAILED: browser.execute( " + BrowserContext.this.getShortJavascript(javascript) + " )");
                } else {
                    BrowserContext.this.debug("SUCCESS: browser.execute( " + BrowserContext.this.getShortJavascript(javascript) + " )");
                }
            }
        });
        return true;
    }

    protected boolean mayExecute(String javascript) {
        return !this.pageLoading;
    }

    public void widgetDisposed(DisposeEvent event2) {
        if (event2.widget == this.browser) {
            this.deregisterBrowser();
        }
    }

    private String getShortJavascript(String javascript) {
        if (javascript.length() < 515) {
            return javascript;
        }
        StringBuffer result = new StringBuffer();
        result.append(javascript.substring(0, 256));
        result.append("...");
        result.append(javascript.substring(javascript.length() - 256));
        return result.toString();
    }

    public void setWiggleBrowser(boolean wiggleBrowser) {
        this.wiggleBrowser = wiggleBrowser;
    }

    public boolean isPageLoading() {
        return this.pageLoading;
    }

    public void addListener(loadingListener l) {
        if (this.loadingListeners == Collections.EMPTY_LIST) {
            this.loadingListeners = new ArrayList(1);
        }
        this.loadingListeners.add(l);
    }

    public static interface loadingListener {
        public void browserLoadingChanged(boolean var1, String var2);
    }
}

