/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener;

import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.core.messenger.browser.listeners.AbstractBrowserMessageListener;
import com.aelitis.azureus.ui.swt.browser.listener.IBrowserRequestListener;
import com.aelitis.azureus.util.MapUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractBrowserRequestListener
extends AbstractBrowserMessageListener
implements IBrowserRequestListener {
    public static final String LISTENER_ID = "lightbox-browser";
    protected Map decodedMap = new HashMap(0);
    private String url = null;
    private String redirectURL = null;
    private String prefixVerifier = null;
    private int width = -1;
    private int height = -1;
    private boolean isMovable = false;
    private boolean isResizable = false;

    public AbstractBrowserRequestListener() {
        super(LISTENER_ID);
    }

    public void handleMessage(BrowserMessage message) {
        String opID = message.getOperationId();
        this.decodedMap = message.getDecodedMap();
        if ("open-url".equals(opID)) {
            this.handleOpenURL();
        } else if ("close".equals(opID)) {
            this.handleClose();
        } else if ("refresh".equals(opID)) {
            this.handleRefresh();
        } else if ("resize".equals(opID)) {
            this.handleResize();
        }
    }

    public int getHeight() {
        if (this.decodedMap.containsKey("height")) {
            this.height = MapUtils.getMapInt(this.decodedMap, "height", -1);
        }
        return this.height;
    }

    public String getPrefixVerifier() {
        if (this.decodedMap.containsKey("title-prefix-verifier")) {
            this.prefixVerifier = MapUtils.getMapString(this.decodedMap, "title-prefix-verifier", "");
        }
        return this.prefixVerifier;
    }

    public String getURL() {
        if (this.decodedMap.containsKey("url")) {
            this.url = MapUtils.getMapString(this.decodedMap, "url", "");
        }
        return this.url;
    }

    public int getWidth() {
        if (this.decodedMap.containsKey("width")) {
            this.width = MapUtils.getMapInt(this.decodedMap, "width", -1);
        }
        return this.width;
    }

    public boolean isMovable() {
        if (this.decodedMap.containsKey("movable")) {
            this.isMovable = MapUtils.getMapBoolean(this.decodedMap, "movable", false);
        }
        return this.isMovable;
    }

    public boolean isResizable() {
        if (this.decodedMap.containsKey("resizable")) {
            this.isResizable = MapUtils.getMapBoolean(this.decodedMap, "resizable", false);
        }
        return this.isResizable;
    }

    public String getStatusMessage() {
        if (this.decodedMap.containsKey("status")) {
            return MapUtils.getMapString(this.decodedMap, "status", null);
        }
        return null;
    }

    public String getDisplayMessage() {
        if (this.decodedMap.containsKey("display")) {
            return MapUtils.getMapString(this.decodedMap, "display", null);
        }
        return null;
    }

    public String getRedirectURL() {
        if (this.decodedMap.containsKey("redirect-url")) {
            this.redirectURL = MapUtils.getMapString(this.decodedMap, "redirect-url", "");
        }
        return this.redirectURL;
    }

    public boolean isRedirect() {
        String onCloseValue;
        return true == this.decodedMap.containsKey("on-close") && null != (onCloseValue = MapUtils.getMapString(this.decodedMap, "on-close", null)) && true == onCloseValue.equals("redirect");
    }

    public void handleClose() {
    }

    public void handleRefresh() {
    }

    public void handleResize() {
    }

    public void handleOpenURL() {
    }
}

