/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.core.messenger.browser.listeners.AbstractBrowserMessageListener;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.net.magneturi.MagnetURIHandler;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.ui.swt.update.UpdateMonitor;

public class ConfigListener
extends AbstractBrowserMessageListener {
    public static final String DEFAULT_LISTENER_ID = "config";
    public static final String OP_GET_VERSION = "get-version";
    public static final String OP_NEW_INSTALL = "is-new-install";
    public static final String OP_CHECK_FOR_UPDATES = "check-for-updates";
    public static final String OP_GET_MAGNET_PORT = "get-magnet-port";
    public static final String OP_LOG_DIAGS = "log-diags";

    public ConfigListener(String id, Browser browser) {
        super(id);
    }

    public ConfigListener(Browser browser) {
        this(DEFAULT_LISTENER_ID, browser);
    }

    public void handleMessage(BrowserMessage message) {
        try {
            String opid = message.getOperationId();
            if (OP_GET_VERSION.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                String callback = MapUtils.getMapString(decodedMap, "callback", null);
                if (callback != null) {
                    this.context.executeInBrowser(callback + "('" + "4.0.0.1_B06" + "')");
                } else {
                    message.debug("bad or no callback param");
                }
            } else if (OP_NEW_INSTALL.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                String callback = MapUtils.getMapString(decodedMap, "callback", null);
                if (callback != null) {
                    this.context.executeInBrowser(callback + "(" + COConfigurationManager.isNewInstall() + ")");
                } else {
                    message.debug("bad or no callback param");
                }
            } else if (OP_CHECK_FOR_UPDATES.equals(opid)) {
                ConfigListener.checkForUpdates();
            } else if (OP_GET_MAGNET_PORT.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                String callback = MapUtils.getMapString(decodedMap, "callback", null);
                if (callback != null) {
                    this.context.executeInBrowser(callback + "('" + MagnetURIHandler.getSingleton().getPort() + "')");
                } else {
                    message.debug("bad or no callback param");
                }
            } else if (OP_LOG_DIAGS.equals(opid)) {
                ConfigListener.logDiagnostics();
            }
        }
        catch (Throwable t) {
            message.debug("handle Config message", t);
        }
    }

    public static void logDiagnostics() {
        AEDiagnostics.dumpThreads();
    }

    public static void checkForUpdates() {
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null) {
            uiFunctions.bringToFront();
        }
        UpdateMonitor.getSingleton(AzureusCoreFactory.getSingleton()).performCheck(true, false, false, null);
    }
}

