/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.custom.CustomizationManagerFactory;
import com.aelitis.azureus.core.impl.AzureusCoreImpl;
import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.core.messenger.browser.listeners.AbstractBrowserMessageListener;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.MetaSearch;
import com.aelitis.azureus.core.metasearch.MetaSearchManager;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchException;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.ExternalLoginListener;
import com.aelitis.azureus.core.metasearch.impl.ExternalLoginWindow;
import com.aelitis.azureus.core.metasearch.impl.web.CookieParser;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionDownloadListener;
import com.aelitis.azureus.core.subs.SubscriptionException;
import com.aelitis.azureus.core.subs.SubscriptionHistory;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.core.subs.SubscriptionResult;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.ui.swt.browser.OpenCloseSearchDetailsListener;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.util.JSONUtils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class MetaSearchListener
extends AbstractBrowserMessageListener {
    public static final String LISTENER_ID = "metasearch";
    public static final String OP_SEARCH = "search";
    public static final String OP_GET_ENGINES = "get-engines";
    public static final String OP_GET_ALL_ENGINES = "get-all-engines";
    public static final String OP_CHANGE_ENGINE_SELECTION = "change-engine-selection";
    public static final String OP_SET_SELECTED_ENGINES = "set-selected-engines";
    public static final String OP_GET_AUTO_MODE = "get-auto-mode";
    public static final String OP_SAVE_TEMPLATE = "save-template";
    public static final String OP_LOAD_TEMPLATE = "load-template";
    public static final String OP_DELETE_TEMPLATE = "delete-template";
    public static final String OP_TEST_TEMPLATE = "test-template";
    public static final String OP_EXPORT_TEMPLATE = "export-template";
    public static final String OP_IMPORT_TEMPLATE = "import-template";
    public static final String OP_OPEN_SEARCH_RESULTS = "open-search-results";
    public static final String OP_CLOSE_SEARCH_RESULTS = "close-search-results";
    public static final String OP_LOAD_TORRENT = "load-torrent";
    public static final String OP_HAS_LOAD_TORRENT = "has-load-torrent";
    public static final String OP_ENGINE_LOGIN = "engine-login";
    public static final String OP_GET_LOGIN_COOKIES = "get-login-cookies";
    public static final String OP_CREATE_SUBSCRIPTION = "create-subscription";
    public static final String OP_READ_SUBSCRIPTION = "read-subscription";
    public static final String OP_UPDATE_SUBSCRIPTION = "update-subscription";
    public static final String OP_READ_SUBSCRIPTION_RESULTS = "read-subscription-results";
    public static final String OP_DELETE_SUBSCRIPTION_RESULTS = "delete-subscription-results";
    public static final String OP_MARK_SUBSCRIPTION_RESULTS = "mark-subscription-results";
    public static final String OP_DOWNLOAD_SUBSCRIPTION = "download-subscription";
    public static final String OP_SUBSCRIPTION_SET_AUTODL = "subscription-set-auto-download";
    public static final String OP_IS_CUSTOMISED = "is-customized";
    private static final Set active_subs_auth = new HashSet();
    private static final Set pending_play_now_urls = new HashSet();
    private final OpenCloseSearchDetailsListener openCloseSearchDetailsListener;

    private static void playOrStream(final DownloadManager download) {
        new AEThread2("MSL:POS", true){

            public void run() {
                TorrentListViewsUtils.playOrStream(download);
            }
        }.start();
    }

    public MetaSearchListener(OpenCloseSearchDetailsListener openCloseSearchDetailsListener) {
        super(LISTENER_ID);
        this.openCloseSearchDetailsListener = openCloseSearchDetailsListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void handleMessage(BrowserMessage message) {
        List l_engines;
        HashSet<Long> selected;
        MetaSearchManager metaSearchManager;
        block115: {
            block113: {
                Engine[] engines;
                String subscriptionId;
                block112: {
                    String opid;
                    block116: {
                        block114: {
                            block111: {
                                opid = message.getOperationId();
                                metaSearchManager = MetaSearchManagerFactory.getSingleton();
                                metaSearchManager.log("BrowserListener: received " + message);
                                if (OP_SEARCH.equals(opid)) {
                                    Map decodedMap = message.getDecodedMap();
                                    this.search(decodedMap, null);
                                    return;
                                }
                                if (OP_ENGINE_LOGIN.equals(opid)) {
                                    final Map decodedMap = message.getDecodedMap();
                                    long engine_id = (Long)decodedMap.get("engine_id");
                                    Long sid = (Long)decodedMap.get("sid");
                                    final Engine engine = this.getEngineFromId(engine_id);
                                    if (engine != null && engine instanceof WebEngine) {
                                        final WebEngine webEngine = (WebEngine)engine;
                                        Utils.execSWTThread(new Runnable(){

                                            public void run() {
                                                new ExternalLoginWindow(new ExternalLoginListener(){
                                                    private String previous_cookies;
                                                    private boolean search_done;

                                                    public void canceled(ExternalLoginWindow window) {
                                                    }

                                                    public void cookiesFound(ExternalLoginWindow window, String cookies) {
                                                        if (this.handleCookies(cookies, false)) {
                                                            window.close();
                                                        }
                                                    }

                                                    public void done(ExternalLoginWindow window, String cookies) {
                                                        this.handleCookies(cookies, true);
                                                    }

                                                    private boolean handleCookies(String cookies, boolean force_if_ready) {
                                                        boolean skip_search;
                                                        if (this.search_done) {
                                                            return false;
                                                        }
                                                        String[] required = webEngine.getRequiredCookies();
                                                        boolean bl = skip_search = required.length == 0 && !force_if_ready;
                                                        if (CookieParser.cookiesContain(required, cookies)) {
                                                            webEngine.setCookies(cookies);
                                                            if (this.previous_cookies == null || !this.previous_cookies.equals(cookies)) {
                                                                this.previous_cookies = cookies;
                                                                if (!skip_search) {
                                                                    this.search_done = true;
                                                                    MetaSearchListener.this.search(decodedMap, webEngine);
                                                                }
                                                            }
                                                        }
                                                        return this.search_done;
                                                    }
                                                }, webEngine.getName(), webEngine.getLoginPageUrl(), false, webEngine.getAuthMethod(), engine.isMine());
                                            }
                                        });
                                        return;
                                    }
                                    HashMap<String, Object> params = new HashMap<String, Object>();
                                    if (sid != null) {
                                        params.put("sid", sid);
                                    }
                                    params.put("error", "engine not found or not a web engine");
                                    this.sendBrowserMessage(LISTENER_ID, "engineFailed", params);
                                    return;
                                }
                                if (OP_GET_LOGIN_COOKIES.equals(opid)) {
                                    Map decodedMap = message.getDecodedMap();
                                    final String url = ((String)decodedMap.get("url")).replaceAll("%s", "");
                                    Utils.execSWTThread(new Runnable(){

                                        public void run() {
                                            new ExternalLoginWindow(new ExternalLoginListener(){

                                                public void canceled(ExternalLoginWindow window) {
                                                    MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "setCookiesFailed", new HashMap());
                                                }

                                                public void cookiesFound(ExternalLoginWindow window, String cookies) {
                                                }

                                                public void done(ExternalLoginWindow window, String cookies) {
                                                    String[] cookieNames = CookieParser.getCookiesNames(cookies);
                                                    HashMap<String, Object> params = new HashMap<String, Object>();
                                                    params.put("cookieNames", cookieNames);
                                                    params.put("currentCookie", cookies);
                                                    params.put("cookieMethod", window.proxyCaptureModeRequired() ? "proxy" : "transparent");
                                                    MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "setCookies", params);
                                                }
                                            }, url, url, true, "proxy", true);
                                        }
                                    });
                                    return;
                                }
                                if (!OP_GET_ENGINES.equals(opid)) break block111;
                                subscriptionId = null;
                                try {
                                    if (message.isParamObject()) {
                                        Map decodedMap = message.getDecodedMap();
                                        subscriptionId = (String)decodedMap.get("subs_id");
                                    }
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                engines = null;
                                if (subscriptionId != null) {
                                    engines = new Engine[]{};
                                    Subscription subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(subscriptionId);
                                    if (subs != null) {
                                        try {
                                            Engine engine = subs.getEngine();
                                            if (engine != null) {
                                                engines = new Engine[]{engine};
                                            }
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                }
                                if (engines == null) {
                                    engines = metaSearchManager.getMetaSearch().getEngines(true, true);
                                }
                                break block112;
                            }
                            if (OP_GET_ALL_ENGINES.equals(opid)) break block113;
                            if (OP_SET_SELECTED_ENGINES.equals(opid)) {
                                Map decodedMap = message.getDecodedMap();
                                List template_ids = (List)decodedMap.get("template_ids");
                                long[] ids = new long[template_ids.size()];
                                for (int i = 0; i < ids.length; ++i) {
                                    Map m = (Map)template_ids.get(i);
                                    ids[i] = (Long)m.get("id");
                                }
                                boolean auto = (Boolean)decodedMap.get("auto");
                                Boolean is_default = (Boolean)decodedMap.get("set_default");
                                boolean skip = false;
                                if (is_default != null && is_default.booleanValue() && CustomizationManagerFactory.getSingleton().getActiveCustomization() != null) {
                                    skip = true;
                                }
                                try {
                                    if (!skip) {
                                        metaSearchManager.setSelectedEngines(ids, auto);
                                    }
                                    HashMap params = new HashMap();
                                    this.sendBrowserMessage(LISTENER_ID, "setSelectedCompleted", params);
                                    return;
                                }
                                catch (Throwable e) {
                                    HashMap<String, String> params = new HashMap<String, String>();
                                    params.put("error", Debug.getNestedExceptionMessage(e));
                                    this.sendBrowserMessage(LISTENER_ID, "setSelectedFailed", params);
                                    return;
                                }
                            }
                            if (!OP_CHANGE_ENGINE_SELECTION.equals(opid)) break block114;
                            Map decodedMap = message.getDecodedMap();
                            MetaSearch ms = metaSearchManager.getMetaSearch();
                            Engine[] engines2 = ms.getEngines(false, true);
                            selected = new HashSet<Long>();
                            for (int i = 0; i < engines2.length; ++i) {
                                Engine e = engines2[i];
                                if (e.getSelectionState() != 2) continue;
                                selected.add(new Long(e.getId()));
                            }
                            l_engines = (List)decodedMap.get("engines");
                            break block115;
                        }
                        if (OP_GET_AUTO_MODE.equals(opid)) {
                            boolean mode = metaSearchManager.isAutoMode();
                            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
                            params.put("auto", new Boolean(mode));
                            boolean custom = CustomizationManagerFactory.getSingleton().getActiveCustomization() != null;
                            params.put("is_custom", new Boolean(custom));
                            this.sendBrowserMessage(LISTENER_ID, "getAutoModeResult", params);
                            return;
                        }
                        if (OP_SAVE_TEMPLATE.equals(opid)) {
                            Map decodedMap = message.getDecodedMap();
                            String type_str = (String)decodedMap.get("type");
                            String name = (String)decodedMap.get("name");
                            Long l_id = (Long)decodedMap.get("id");
                            long id = l_id == null ? -1L : l_id;
                            String json = (String)decodedMap.get("value");
                            String cookies = (String)decodedMap.get("current_cookie");
                            try {
                                Engine engine = metaSearchManager.addEngine(id, type_str.equals("json") ? 2 : 1, name, json);
                                engine.setMine(true);
                                if (cookies != null && engine instanceof WebEngine) {
                                    WebEngine we = (WebEngine)engine;
                                    we.setCookies(cookies);
                                }
                                HashMap<String, Long> params = new HashMap<String, Long>();
                                params.put("id", new Long(engine.getId()));
                                this.sendBrowserMessage(LISTENER_ID, "saveTemplateCompleted", params);
                                return;
                            }
                            catch (Throwable e) {
                                HashMap<String, Object> params = new HashMap<String, Object>();
                                params.put("id", new Long(id));
                                params.put("error", Debug.getNestedExceptionMessage(e));
                                this.sendBrowserMessage(LISTENER_ID, "saveTemplateFailed", params);
                                return;
                            }
                        }
                        if (OP_LOAD_TEMPLATE.equals(opid)) {
                            Map decodedMap = message.getDecodedMap();
                            long id = (Long)decodedMap.get("id");
                            Engine engine = metaSearchManager.getMetaSearch().getEngine(id);
                            if (engine == null) {
                                HashMap<String, Object> params = new HashMap<String, Object>();
                                params.put("id", new Long(id));
                                params.put("error", "Template not found");
                                this.sendBrowserMessage(LISTENER_ID, "loadTemplateFailed", params);
                                return;
                            }
                            try {
                                HashMap<String, Object> params = new HashMap<String, Object>();
                                params.put("id", new Long(engine.getId()));
                                params.put("name", engine.getName());
                                params.put("type", Engine.ENGINE_TYPE_STRS[engine.getType()]);
                                params.put("value", JSONObject.escape(engine.exportToJSONString()));
                                params.put("shareable", new Boolean(engine.isShareable()));
                                params.put("uid", engine.getUID());
                                params.put("supports_direct_download", new Boolean(engine.supportsField(102) || engine.supportsField(105)));
                                this.sendBrowserMessage(LISTENER_ID, "loadTemplateCompleted", params);
                                return;
                            }
                            catch (Throwable e) {
                                HashMap<String, Object> params = new HashMap<String, Object>();
                                params.put("id", new Long(id));
                                params.put("error", Debug.getNestedExceptionMessage(e));
                                this.sendBrowserMessage(LISTENER_ID, "loadTemplateFailed", params);
                                return;
                            }
                        }
                        if (OP_DELETE_TEMPLATE.equals(opid)) {
                            Map decodedMap = message.getDecodedMap();
                            long id = (Long)decodedMap.get("id");
                            Engine engine = metaSearchManager.getMetaSearch().getEngine(id);
                            if (engine == null) {
                                HashMap<String, Object> params = new HashMap<String, Object>();
                                params.put("id", new Long(id));
                                params.put("error", "Template not found");
                                this.sendBrowserMessage(LISTENER_ID, "deleteTemplateFailed", params);
                                return;
                            }
                            if (engine.getSource() != 2) {
                                HashMap<String, Object> params = new HashMap<String, Object>();
                                params.put("id", new Long(id));
                                params.put("error", "Template is not local");
                                this.sendBrowserMessage(LISTENER_ID, "deleteTemplateFailed", params);
                                return;
                            }
                            engine.delete();
                            HashMap<String, Long> params = new HashMap<String, Long>();
                            params.put("id", new Long(id));
                            this.sendBrowserMessage(LISTENER_ID, "deleteTemplateCompleted", params);
                            return;
                        }
                        if (OP_TEST_TEMPLATE.equals(opid)) {
                            Map decodedMap = message.getDecodedMap();
                            final long id = (Long)decodedMap.get("id");
                            long match_count = (Long)decodedMap.get("max_matches");
                            String searchText = (String)decodedMap.get("searchText");
                            String headers = (String)decodedMap.get("headers");
                            final Long sid = (Long)decodedMap.get("sid");
                            Engine engine = metaSearchManager.getMetaSearch().getEngine(id);
                            if (engine == null) {
                                HashMap<String, Object> params = new HashMap<String, Object>();
                                params.put("id", new Long(id));
                                params.put("error", "Template not found");
                                if (sid != null) {
                                    params.put("sid", sid);
                                }
                                this.sendBrowserMessage(LISTENER_ID, "testTemplateFailed", params);
                                return;
                            }
                            SearchParameter parameter = new SearchParameter("s", searchText);
                            SearchParameter[] parameters = new SearchParameter[]{parameter};
                            try {
                                engine.search(parameters, new HashMap(), (int)match_count, (int)match_count, headers, new ResultListener(){
                                    private String content;
                                    private List matches = new ArrayList();

                                    public void contentReceived(Engine engine, String _content) {
                                        this.content = _content;
                                    }

                                    public void matchFound(Engine engine, String[] fields) {
                                        this.matches.add(fields);
                                    }

                                    public void resultsReceived(Engine engine, Result[] results) {
                                    }

                                    public void resultsComplete(Engine engine) {
                                        HashMap<String, Object> params = new HashMap<String, Object>();
                                        params.put("id", new Long(id));
                                        if (sid != null) {
                                            params.put("sid", sid);
                                        }
                                        params.put("content", JSONObject.escape(this.content));
                                        JSONArray l_matches = new JSONArray();
                                        params.put("matches", l_matches);
                                        for (int i = 0; i < this.matches.size(); ++i) {
                                            String[] match = (String[])this.matches.get(i);
                                            JSONArray l_match = new JSONArray();
                                            l_matches.add(l_match);
                                            for (int j = 0; j < match.length; ++j) {
                                                l_match.add(match[j]);
                                            }
                                        }
                                        MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "testTemplateCompleted", params);
                                    }

                                    public void engineFailed(Engine engine, Throwable e) {
                                        HashMap<String, Object> params = new HashMap<String, Object>();
                                        params.put("id", new Long(id));
                                        params.put("error", Debug.getNestedExceptionMessage(e));
                                        if (sid != null) {
                                            params.put("sid", sid);
                                        }
                                        MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "testTemplateFailed", params);
                                    }

                                    public void engineRequiresLogin(Engine engine, Throwable e) {
                                        HashMap<String, Object> params = new HashMap<String, Object>();
                                        params.put("id", new Long(id));
                                        params.put("error", Debug.getNestedExceptionMessage(e));
                                        if (sid != null) {
                                            params.put("sid", sid);
                                        }
                                        MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "testTemplateRequiresLogin", params);
                                    }
                                });
                                return;
                            }
                            catch (SearchException e) {
                                return;
                            }
                        }
                        if (OP_EXPORT_TEMPLATE.equals(opid)) {
                            Map decodedMap = message.getDecodedMap();
                            final long id = (Long)decodedMap.get("id");
                            final Engine engine = metaSearchManager.getMetaSearch().getEngine(id);
                            if (engine == null) {
                                HashMap<String, String> params = new HashMap<String, String>();
                                params.put("error", "template '" + id + "' not found");
                                this.sendBrowserMessage(LISTENER_ID, "exportTemplateFailed", params);
                                return;
                            }
                            final Shell shell = Utils.findAnyShell();
                            shell.getDisplay().asyncExec((Runnable)new AERunnable(){

                                public void runSupport() {
                                    FileDialog dialog = new FileDialog(shell, 139264);
                                    dialog.setFilterPath(TorrentOpener.getFilterPathData());
                                    dialog.setText(MessageText.getString("metasearch.export.select.template.file"));
                                    dialog.setFilterExtensions(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                                    dialog.setFilterNames(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                                    String path = TorrentOpener.setFilterPathData(dialog.open());
                                    if (path != null) {
                                        String lc = path.toLowerCase();
                                        if (!lc.endsWith(".vuze") && !lc.endsWith(".vuz")) {
                                            path = path + ".vuze";
                                        }
                                        try {
                                            engine.exportToVuzeFile(new File(path));
                                            HashMap<String, Long> params = new HashMap<String, Long>();
                                            params.put("id", new Long(id));
                                            MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "exportTemplateCompleted", params);
                                        }
                                        catch (Throwable e) {
                                            HashMap<String, Object> params = new HashMap<String, Object>();
                                            params.put("id", new Long(id));
                                            params.put("error", "save failed: " + Debug.getNestedExceptionMessage(e));
                                            MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "exportTemplateFailed", params);
                                        }
                                    } else {
                                        HashMap<String, Object> params = new HashMap<String, Object>();
                                        params.put("id", new Long(id));
                                        params.put("error", "operation cancelled");
                                        MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "exportTemplateFailed", params);
                                    }
                                }
                            });
                            return;
                        }
                        if (OP_IMPORT_TEMPLATE.equals(opid)) {
                            final Shell shell = Utils.findAnyShell();
                            shell.getDisplay().asyncExec((Runnable)new AERunnable(){

                                public void runSupport() {
                                    FileDialog dialog = new FileDialog(shell, 135168);
                                    dialog.setFilterPath(TorrentOpener.getFilterPathData());
                                    dialog.setText(MessageText.getString("metasearch.import.select.template.file"));
                                    dialog.setFilterExtensions(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                                    dialog.setFilterNames(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                                    String path = TorrentOpener.setFilterPathData(dialog.open());
                                    if (path != null) {
                                        VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
                                        VuzeFile vf = vfh.loadAndHandleVuzeFile(path, 1);
                                        if (vf == null) {
                                            HashMap<String, String> params = new HashMap<String, String>();
                                            params.put("error", "invalid .vuze file");
                                            MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "importTemplateFailed", params);
                                        } else {
                                            VuzeFileComponent[] comps = vf.getComponents();
                                            for (int i = 0; i < comps.length; ++i) {
                                                Engine engine;
                                                VuzeFileComponent comp2 = comps[i];
                                                if (comp2.getType() != 1 || (engine = (Engine)comp2.getData(Engine.VUZE_FILE_COMPONENT_ENGINE_KEY)) == null) continue;
                                                HashMap<String, Long> params = new HashMap<String, Long>();
                                                params.put("id", new Long(engine.getId()));
                                                MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "importTemplateCompleted", params);
                                                return;
                                            }
                                            HashMap<String, String> params = new HashMap<String, String>();
                                            params.put("error", "invalid search template file");
                                            MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "importTemplateFailed", params);
                                        }
                                    } else {
                                        HashMap<String, String> params = new HashMap<String, String>();
                                        params.put("error", "operation cancelled");
                                        MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "importTemplateFailed", params);
                                    }
                                }
                            });
                            return;
                        }
                        if (OP_OPEN_SEARCH_RESULTS.equals(opid)) {
                            Map decodedMap = message.isParamObject() ? message.getDecodedMap() : new HashMap();
                            this.openCloseSearchDetailsListener.openSearchResults(decodedMap);
                            return;
                        }
                        if (OP_CLOSE_SEARCH_RESULTS.equals(opid)) {
                            Map decodedMap = message.isParamObject() ? message.getDecodedMap() : new HashMap();
                            this.openCloseSearchDetailsListener.closeSearchResults(decodedMap);
                            return;
                        }
                        if (!OP_LOAD_TORRENT.equals(opid)) break block116;
                        Map decodedMap = message.isParamObject() ? message.getDecodedMap() : new HashMap();
                        String torrentUrl = (String)decodedMap.get("torrent_url");
                        String referer_str = (String)decodedMap.get("referer_url");
                        try {
                            Map headers;
                            block118: {
                                block117: {
                                    headers = UrlUtils.getBrowserHeaders(referer_str);
                                    String subscriptionId2 = (String)decodedMap.get("subs_id");
                                    String subscriptionResultId = (String)decodedMap.get("subs_rid");
                                    if (subscriptionId2 == null) break block117;
                                    Subscription subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(subscriptionId2);
                                    if (subs != null) {
                                        try {
                                            WebEngine webEngine;
                                            Engine engine = subs.getEngine();
                                            if (engine != null && engine instanceof WebEngine && (webEngine = (WebEngine)engine).isNeedsAuth()) {
                                                headers.put("Cookie", webEngine.getCookies());
                                            }
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                        if (subscriptionResultId != null) {
                                            subs.addPotentialAssociation(subscriptionResultId, torrentUrl);
                                        }
                                    }
                                    break block118;
                                }
                                try {
                                    WebEngine webEngine;
                                    long engineID = (Long)decodedMap.get("engine_id");
                                    Engine engine = metaSearchManager.getMetaSearch().getEngine(engineID);
                                    if (engine != null && engine instanceof WebEngine && (webEngine = (WebEngine)engine).isNeedsAuth()) {
                                        headers.put("Cookie", webEngine.getCookies());
                                    }
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                            }
                            Boolean play_now = (Boolean)decodedMap.get("play-now");
                            if (play_now != null && play_now.booleanValue()) {
                                Class<MetaSearchListener> e = MetaSearchListener.class;
                                // MONITORENTER : com.aelitis.azureus.ui.swt.browser.listener.MetaSearchListener.class
                                pending_play_now_urls.add(torrentUrl);
                                // MONITOREXIT : e
                            }
                            AzureusCoreImpl.getSingleton().getPluginManager().getDefaultPluginInterface().getDownloadManager().addDownload(new URL(torrentUrl), headers);
                            HashMap<String, String> params = new HashMap<String, String>();
                            params.put("torrent_url", torrentUrl);
                            params.put("referer_url", referer_str);
                            this.sendBrowserMessage(LISTENER_ID, "loadTorrentCompleted", params);
                            return;
                        }
                        catch (Exception e) {
                            HashMap<String, String> params = new HashMap<String, String>();
                            params.put("torrent_url", torrentUrl);
                            params.put("referer_url", referer_str);
                            params.put("error", e.getMessage());
                            this.sendBrowserMessage(LISTENER_ID, "loadTorrentFailed", params);
                            return;
                        }
                    }
                    if (OP_HAS_LOAD_TORRENT.equals(opid)) {
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("result", "1");
                        this.sendBrowserMessage(LISTENER_ID, "hasLoadTorrent", params);
                        return;
                    }
                    if (OP_CREATE_SUBSCRIPTION.equals(opid)) {
                        Map decodedMap = message.isParamObject() ? message.getDecodedMap() : new HashMap();
                        Long tid = (Long)decodedMap.get("tid");
                        String name = (String)decodedMap.get("name");
                        Boolean isPublic = (Boolean)decodedMap.get("is_public");
                        Map options = (Map)decodedMap.get("options");
                        Boolean isEnabled = (Boolean)options.get("is_enabled");
                        Boolean autoDownload = (Boolean)options.get("auto_dl");
                        HashMap<String, Object> result = new HashMap<String, Object>();
                        if (tid != null) {
                            result.put("tid", tid);
                        }
                        try {
                            JSONObject payload = new JSONObject();
                            payload.put("engine_id", decodedMap.get("engine_id"));
                            payload.put("search_term", decodedMap.get("search_term"));
                            payload.put("filters", decodedMap.get("filters"));
                            payload.put("schedule", decodedMap.get("schedule"));
                            payload.put("options", decodedMap.get("options"));
                            Subscription subs = SubscriptionManagerFactory.getSingleton().create(name, isPublic, payload.toString());
                            subs.getHistory().setDetails(isEnabled == null ? true : isEnabled, autoDownload == null ? false : autoDownload);
                            result.put("id", subs.getID());
                            this.sendBrowserMessage(LISTENER_ID, "createSubscriptionCompleted", result);
                            return;
                        }
                        catch (Throwable e) {
                            result.put("error", "create failed: " + Debug.getNestedExceptionMessage(e));
                            this.sendBrowserMessage(LISTENER_ID, "createSubscriptionFailed", result);
                            return;
                        }
                    }
                    if (OP_READ_SUBSCRIPTION.equals(opid)) {
                        Map decodedMap = message.isParamObject() ? message.getDecodedMap() : new HashMap();
                        Long tid = (Long)decodedMap.get("tid");
                        String sid = (String)decodedMap.get("id");
                        HashMap<String, Object> result = new HashMap<String, Object>();
                        if (tid != null) {
                            result.put("tid", tid);
                        }
                        try {
                            Subscription subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(sid);
                            if (subs == null) {
                                result.put("error", "Subscription not found");
                                this.sendBrowserMessage(LISTENER_ID, "readSubscriptionFailed", result);
                                return;
                            }
                            boolean shareable = subs.isShareable();
                            result.put("id", subs.getID());
                            result.put("name", subs.getName());
                            result.put("is_public", new Boolean(shareable && subs.isPublic()));
                            result.put("is_author", new Boolean(subs.isMine()));
                            result.put("is_shareable", new Boolean(shareable));
                            SubscriptionHistory history = subs.getHistory();
                            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                            result.put("options", options);
                            options.put("is_enabled", new Boolean(history.isEnabled()));
                            options.put("auto_dl", new Boolean(history.isAutoDownload()));
                            HashMap<String, Long> info = new HashMap<String, Long>();
                            result.put("info", info);
                            info.put("last_scan", new Long(history.getLastScanTime()));
                            info.put("last_new", new Long(history.getLastNewResultTime()));
                            info.put("num_unread", new Long(history.getNumUnread()));
                            info.put("num_read", new Long(history.getNumRead()));
                            String json = subs.getJSON();
                            Map map = JSONUtils.decodeJSON(json);
                            result.put("engine_id", map.get("engine_id"));
                            result.put("search_term", map.get("search_term"));
                            result.put("filters", map.get("filters"));
                            result.put("schedule", map.get("schedule"));
                            this.sendBrowserMessage(LISTENER_ID, "readSubscriptionCompleted", result);
                            return;
                        }
                        catch (Throwable e) {
                            result.put("error", "read failed: " + Debug.getNestedExceptionMessage(e));
                            this.sendBrowserMessage(LISTENER_ID, "readSubscriptionFailed", result);
                            return;
                        }
                    }
                    if (OP_UPDATE_SUBSCRIPTION.equals(opid)) {
                        Map decodedMap = message.isParamObject() ? message.getDecodedMap() : new HashMap();
                        Long tid = (Long)decodedMap.get("tid");
                        String name = (String)decodedMap.get("name");
                        Boolean isPublic = (Boolean)decodedMap.get("is_public");
                        String sid = (String)decodedMap.get("id");
                        Map options = (Map)decodedMap.get("options");
                        Boolean isEnabled = (Boolean)options.get("is_enabled");
                        Boolean autoDownload = (Boolean)options.get("auto_dl");
                        HashMap<String, Object> result = new HashMap<String, Object>();
                        if (tid != null) {
                            result.put("tid", tid);
                        }
                        try {
                            Subscription subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(sid);
                            if (subs == null) {
                                result.put("error", "Subscription not found");
                                this.sendBrowserMessage(LISTENER_ID, "updateSubscriptionFailed", result);
                                return;
                            }
                            JSONObject payload = new JSONObject();
                            payload.put("engine_id", decodedMap.get("engine_id"));
                            payload.put("search_term", decodedMap.get("search_term"));
                            payload.put("filters", decodedMap.get("filters"));
                            payload.put("schedule", decodedMap.get("schedule"));
                            payload.put("options", decodedMap.get("options"));
                            boolean changed = subs.setDetails(name, isPublic, payload.toString());
                            subs.getHistory().setDetails(isEnabled == null ? true : isEnabled, autoDownload == null ? false : autoDownload);
                            if (changed) {
                                subs.getHistory().reset();
                                try {
                                    subs.getManager().getScheduler().downloadAsync(subs, true);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                            result.put("id", subs.getID());
                            this.sendBrowserMessage(LISTENER_ID, "updateSubscriptionCompleted", result);
                            return;
                        }
                        catch (Throwable e) {
                            result.put("error", "update failed: " + Debug.getNestedExceptionMessage(e));
                            this.sendBrowserMessage(LISTENER_ID, "updateSubscriptionFailed", result);
                            return;
                        }
                    }
                    if (OP_SUBSCRIPTION_SET_AUTODL.equals(opid)) {
                        Map decodedMap = message.isParamObject() ? message.getDecodedMap() : new HashMap();
                        String sid = (String)decodedMap.get("id");
                        Long tid = (Long)decodedMap.get("tid");
                        Boolean autoDownload = (Boolean)decodedMap.get("auto_dl");
                        HashMap<String, Object> result = new HashMap<String, Object>();
                        if (tid != null) {
                            result.put("tid", tid);
                        }
                        try {
                            Subscription subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(sid);
                            if (subs == null) {
                                result.put("error", "Subscription not found");
                                this.sendBrowserMessage(LISTENER_ID, "setSubscriptionAutoDownloadFailed", result);
                                return;
                            }
                            subs.getHistory().setAutoDownload(autoDownload);
                            this.sendBrowserMessage(LISTENER_ID, "setSubscriptionAutoDownloadCompleted", result);
                            return;
                        }
                        catch (Throwable e) {
                            result.put("error", "update failed: " + Debug.getNestedExceptionMessage(e));
                            this.sendBrowserMessage(LISTENER_ID, "setSubscriptionAutoDownloadFailed", result);
                            return;
                        }
                    }
                    if (OP_READ_SUBSCRIPTION_RESULTS.equals(opid)) {
                        Map decodedMap = message.isParamObject() ? message.getDecodedMap() : new HashMap();
                        Long tid = (Long)decodedMap.get("tid");
                        String sid = (String)decodedMap.get("id");
                        final HashMap<String, Object> result = new HashMap<String, Object>();
                        if (tid != null) {
                            result.put("tid", tid);
                        }
                        try {
                            Subscription subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(sid);
                            if (subs == null) {
                                result.put("error", "Subscription not found");
                                this.sendBrowserMessage(LISTENER_ID, "readSubscriptionResultsFailed", result);
                                return;
                            }
                            result.put("id", subs.getID());
                            if (this.handleSubscriptionAuth(subs, result)) return;
                            if (subs.getHistory().getLastScanTime() == 0L) {
                                subs.getManager().getScheduler().download(subs, false, new SubscriptionDownloadListener(){

                                    public void complete(Subscription subs) {
                                        if (!MetaSearchListener.this.handleSubscriptionAuth(subs, result)) {
                                            MetaSearchListener.this.encodeResults(subs, result);
                                            MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "readSubscriptionResultsCompleted", result);
                                            MetaSearchListener.this.openCloseSearchDetailsListener.resizeMainBrowser();
                                        }
                                    }

                                    public void failed(Subscription subs, SubscriptionException error) {
                                        result.put("error", "read failed: " + Debug.getNestedExceptionMessage(error));
                                        MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "readSubscriptionResultsFailed", result);
                                    }
                                });
                                return;
                            }
                            this.encodeResults(subs, result);
                            this.sendBrowserMessage(LISTENER_ID, "readSubscriptionResultsCompleted", result);
                            this.openCloseSearchDetailsListener.resizeMainBrowser();
                            return;
                        }
                        catch (Throwable e) {
                            result.put("error", "read failed: " + Debug.getNestedExceptionMessage(e));
                            this.sendBrowserMessage(LISTENER_ID, "readSubscriptionFailed", result);
                            return;
                        }
                    }
                    if (OP_DELETE_SUBSCRIPTION_RESULTS.equals(opid)) {
                        Map decodedMap = message.isParamObject() ? message.getDecodedMap() : new HashMap();
                        String sid = (String)decodedMap.get("id");
                        List rids = (List)decodedMap.get("rids");
                        try {
                            Subscription subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(sid);
                            if (subs == null) {
                                HashMap<String, String> params = new HashMap<String, String>();
                                params.put("error", "Subscription not found");
                                this.sendBrowserMessage(LISTENER_ID, "deleteSubscriptionResultsFailed", params);
                                return;
                            }
                            String[] rids_a = rids.toArray(new String[rids.size()]);
                            subs.getHistory().deleteResults(rids_a);
                            HashMap<String, List> result = new HashMap<String, List>();
                            result.put("rids", rids);
                            this.sendBrowserMessage(LISTENER_ID, "deleteSubscriptionResultsCompleted", result);
                            return;
                        }
                        catch (Throwable e) {
                            HashMap<String, String> params = new HashMap<String, String>();
                            params.put("error", "delete failed: " + Debug.getNestedExceptionMessage(e));
                            this.sendBrowserMessage(LISTENER_ID, "deleteSubscriptionResultsFailed", params);
                            return;
                        }
                    }
                    if (OP_MARK_SUBSCRIPTION_RESULTS.equals(opid)) {
                        Map decodedMap = message.isParamObject() ? message.getDecodedMap() : new HashMap();
                        String sid = (String)decodedMap.get("id");
                        List rids = (List)decodedMap.get("rids");
                        List reads = (List)decodedMap.get("reads");
                        HashMap<String, Object> result = new HashMap<String, Object>();
                        try {
                            Subscription subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(sid);
                            if (subs == null) {
                                result.put("error", "Subscription not found");
                                this.sendBrowserMessage(LISTENER_ID, "markSubscriptionResultsFailed", result);
                                return;
                            }
                            String[] rids_a = rids.toArray(new String[rids.size()]);
                            boolean[] reads_a = new boolean[reads.size()];
                            int i = 0;
                            while (true) {
                                if (i >= reads.size()) {
                                    subs.getHistory().markResults(rids_a, reads_a);
                                    result.put("rids", rids);
                                    result.put("reads", reads);
                                    this.sendBrowserMessage(LISTENER_ID, "markSubscriptionResultsCompleted", result);
                                    return;
                                }
                                reads_a[i] = (Boolean)reads.get(i);
                                ++i;
                            }
                        }
                        catch (Throwable e) {
                            result.put("error", "mark failed: " + Debug.getNestedExceptionMessage(e));
                            this.sendBrowserMessage(LISTENER_ID, "markSubscriptionResultsFailed", result);
                            return;
                        }
                    }
                    if (OP_DOWNLOAD_SUBSCRIPTION.equals(opid)) {
                        Map decodedMap = message.isParamObject() ? message.getDecodedMap() : new HashMap();
                        Long tid = (Long)decodedMap.get("tid");
                        String sid = (String)decodedMap.get("id");
                        final HashMap<String, Object> result = new HashMap<String, Object>();
                        if (tid != null) {
                            result.put("tid", tid);
                        }
                        try {
                            Subscription subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(sid);
                            if (subs == null) {
                                result.put("error", "Subscription not found");
                                this.sendBrowserMessage(LISTENER_ID, "downloadSubscriptionFailed", result);
                                return;
                            }
                            result.put("id", subs.getID());
                            if (this.handleSubscriptionAuth(subs, result)) return;
                            subs.getManager().getScheduler().download(subs, false, new SubscriptionDownloadListener(){

                                public void complete(Subscription subs) {
                                    if (!MetaSearchListener.this.handleSubscriptionAuth(subs, result)) {
                                        MetaSearchListener.this.encodeResults(subs, result);
                                        MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "downloadSubscriptionCompleted", result);
                                    }
                                }

                                public void failed(Subscription subs, SubscriptionException error) {
                                    result.put("error", "read failed: " + Debug.getNestedExceptionMessage(error));
                                    MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "downloadSubscriptionFailed", result);
                                }
                            });
                            return;
                        }
                        catch (Throwable e) {
                            result.put("error", "read failed: " + Debug.getNestedExceptionMessage(e));
                            this.sendBrowserMessage(LISTENER_ID, "downloadSubscriptionFailed", result);
                            return;
                        }
                    }
                    if (!OP_IS_CUSTOMISED.equals(opid)) return;
                    boolean custom = CustomizationManagerFactory.getSingleton().getActiveCustomization() != null;
                    HashMap<String, Boolean> params = new HashMap<String, Boolean>();
                    params.put("is_custom", new Boolean(custom));
                    this.sendBrowserMessage(LISTENER_ID, "isCustomizedResult", params);
                    return;
                }
                ArrayList params = new ArrayList();
                int i = 0;
                while (true) {
                    if (i >= engines.length) {
                        this.sendBrowserMessage(LISTENER_ID, "enginesUsed", params);
                        return;
                    }
                    Engine engine = engines[i];
                    if (engine.isActive() && engine.getSource() != 0 || subscriptionId != null) {
                        HashMap<String, Object> engineMap = new HashMap<String, Object>();
                        engineMap.put("id", new Long(engine.getId()));
                        engineMap.put("name", engine.getName());
                        engineMap.put("favicon", engine.getIcon());
                        engineMap.put("dl_link_css", engine.getDownloadLinkCSS());
                        engineMap.put("selected", Engine.SEL_STATE_STRINGS[engine.getSelectionState()]);
                        engineMap.put("type", Engine.ENGINE_SOURCE_STRS[engine.getSource()]);
                        engineMap.put("shareable", new Boolean(engine.isShareable()));
                        params.add(engineMap);
                    }
                    ++i;
                }
            }
            Engine[] engines = metaSearchManager.getMetaSearch().getEngines(false, true);
            ArrayList params = new ArrayList();
            int i = 0;
            while (true) {
                if (i >= engines.length) {
                    this.sendBrowserMessage(LISTENER_ID, "engineList", params);
                    return;
                }
                Engine engine = engines[i];
                if (engine.getSource() != 0) {
                    HashMap<String, Object> engineMap = new HashMap<String, Object>();
                    engineMap.put("id", new Long(engine.getId()));
                    engineMap.put("name", engine.getName());
                    engineMap.put("favicon", engine.getIcon());
                    engineMap.put("dl_link_css", engine.getDownloadLinkCSS());
                    engineMap.put("selected", Engine.SEL_STATE_STRINGS[engine.getSelectionState()]);
                    engineMap.put("type", Engine.ENGINE_SOURCE_STRS[engine.getSource()]);
                    engineMap.put("shareable", new Boolean(engine.isShareable()));
                    params.add(engineMap);
                }
                ++i;
            }
        }
        for (int i = 0; i < l_engines.size(); ++i) {
            Map map = (Map)l_engines.get(i);
            long id = (Long)map.get("id");
            String str = (String)map.get("selected");
            if (str.equalsIgnoreCase(Engine.SEL_STATE_STRINGS[2])) {
                selected.add(new Long(id));
                continue;
            }
            if (!str.equalsIgnoreCase(Engine.SEL_STATE_STRINGS[0])) continue;
            selected.remove(new Long(id));
        }
        long[] ids = new long[selected.size()];
        Iterator it = selected.iterator();
        int pos = 0;
        while (it.hasNext()) {
            long id = (Long)it.next();
            ids[pos++] = id;
        }
        try {
            metaSearchManager.setSelectedEngines(ids, metaSearchManager.isAutoMode());
            HashMap params = new HashMap();
            this.sendBrowserMessage(LISTENER_ID, "changeEngineSelectionCompleted", params);
            return;
        }
        catch (Throwable e) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("error", Debug.getNestedExceptionMessage(e));
            this.sendBrowserMessage(LISTENER_ID, "changeEngineSelectionFailed", params);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleSubscriptionAuth(final Subscription subs, final Map result) {
        if (subs.getHistory().isAuthFail()) {
            try {
                Engine engine = subs.getEngine();
                if (engine instanceof WebEngine) {
                    final WebEngine webEngine = (WebEngine)engine;
                    Set set = active_subs_auth;
                    synchronized (set) {
                        if (active_subs_auth.contains(subs)) {
                            return false;
                        }
                        active_subs_auth.add(subs);
                    }
                    Utils.execSWTThread(new Runnable(){

                        public void run() {
                            new ExternalLoginWindow(new ExternalLoginListener(){
                                private String previous_cookies;
                                private boolean result_sent;

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void canceled(ExternalLoginWindow window) {
                                    try {
                                        MetaSearchListener.this.encodeResults(subs, result);
                                        MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "readSubscriptionResultsCompleted", result);
                                    }
                                    finally {
                                        this.completed();
                                    }
                                }

                                public void cookiesFound(ExternalLoginWindow window, String cookies) {
                                    if (this.handleCookies(cookies, false)) {
                                        window.close();
                                    }
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void done(ExternalLoginWindow window, String cookies) {
                                    try {
                                        if (!this.handleCookies(cookies, true)) {
                                            MetaSearchListener.this.encodeResults(subs, result);
                                            MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "readSubscriptionResultsCompleted", result);
                                        }
                                    }
                                    finally {
                                        this.completed();
                                    }
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                private void completed() {
                                    Set set = active_subs_auth;
                                    synchronized (set) {
                                        active_subs_auth.remove(subs);
                                    }
                                }

                                private boolean handleCookies(String cookies, boolean force_if_ready) {
                                    boolean skip;
                                    if (this.result_sent) {
                                        return false;
                                    }
                                    String[] required = webEngine.getRequiredCookies();
                                    boolean bl = skip = required.length == 0 && !force_if_ready;
                                    if (CookieParser.cookiesContain(required, cookies)) {
                                        webEngine.setCookies(cookies);
                                        if (this.previous_cookies == null || !this.previous_cookies.equals(cookies)) {
                                            this.previous_cookies = cookies;
                                            if (!skip) {
                                                this.result_sent = true;
                                                try {
                                                    subs.getManager().getScheduler().download(subs, false, new SubscriptionDownloadListener(){

                                                        public void complete(Subscription subs) {
                                                            result.put("id", subs.getID());
                                                            MetaSearchListener.this.encodeResults(subs, result);
                                                            MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "readSubscriptionResultsCompleted", result);
                                                        }

                                                        public void failed(Subscription subs, SubscriptionException error) {
                                                            result.put("error", "read failed: " + Debug.getNestedExceptionMessage(error));
                                                            MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "readSubscriptionResultsFailed", result);
                                                        }
                                                    });
                                                }
                                                catch (Throwable error) {
                                                    result.put("error", "read failed: " + Debug.getNestedExceptionMessage(error));
                                                    MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "readSubscriptionResultsFailed", result);
                                                }
                                            }
                                        }
                                    }
                                    return this.result_sent;
                                }
                            }, webEngine.getName(), webEngine.getLoginPageUrl(), false, webEngine.getAuthMethod(), subs.isMine());
                        }
                    });
                    return true;
                }
                return false;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return false;
            }
        }
        return false;
    }

    protected void search(Map decodedMap, Engine target) {
        Subscription subs;
        String subscriptionId;
        int max_per_engine;
        String searchText = (String)decodedMap.get("searchText");
        String headers = (String)decodedMap.get("headers");
        final Long sid = (Long)decodedMap.get("sid");
        Boolean mature = (Boolean)decodedMap.get("mature");
        Long l_max_per_engine = (Long)decodedMap.get("maxResultsPerEngine");
        int n = max_per_engine = l_max_per_engine == null ? 100 : l_max_per_engine.intValue();
        if (max_per_engine < 1) {
            max_per_engine = 1;
        }
        if (target == null && (subscriptionId = (String)decodedMap.get("subs_id")) != null && (subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(subscriptionId)) != null) {
            try {
                Engine engine = subs.getEngine();
                if (engine != null) {
                    target = engine;
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        ResultListener listener = new ResultListener(){

            public void contentReceived(Engine engine, String content) {
            }

            public void matchFound(Engine engine, String[] fields) {
            }

            public void engineFailed(Engine engine, Throwable e) {
                Map params = this.getParams(engine);
                params.put("error", Debug.getNestedExceptionMessage(e));
                MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "engineFailed", params);
            }

            public void engineRequiresLogin(Engine engine, Throwable e) {
                Map params = this.getParams(engine);
                params.put("error", Debug.getNestedExceptionMessage(e));
                MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "engineRequiresLogin", params);
            }

            public void resultsComplete(Engine engine) {
                MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "engineCompleted", this.getParams(engine));
            }

            public void resultsReceived(Engine engine, Result[] results) {
                Map params = this.getParams(engine);
                ArrayList<Map> resultsList = new ArrayList<Map>(results.length);
                for (int i = 0; i < results.length; ++i) {
                    Result result = results[i];
                    resultsList.add(result.toJSONMap());
                }
                params.put("results", resultsList);
                MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "resultsReceived", params);
            }

            protected Map getParams(Engine engine) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("id", new Long(engine.getId()));
                params.put("name", engine.getName());
                params.put("favicon", engine.getIcon());
                params.put("dl_link_css", engine.getDownloadLinkCSS());
                params.put("shareable", new Boolean(engine.isShareable()));
                if (sid != null) {
                    params.put("sid", sid);
                }
                return params;
            }
        };
        ArrayList<SearchParameter> sps = new ArrayList<SearchParameter>();
        sps.add(new SearchParameter("s", searchText));
        if (mature != null) {
            sps.add(new SearchParameter("m", mature.toString()));
        }
        SearchParameter[] parameters = sps.toArray(new SearchParameter[sps.size()]);
        MetaSearchManager metaSearchManager = MetaSearchManagerFactory.getSingleton();
        if (target == null) {
            metaSearchManager.getMetaSearch().search(listener, parameters, headers, max_per_engine);
        } else {
            metaSearchManager.getMetaSearch().search(target, listener, parameters, headers, max_per_engine);
        }
    }

    protected void encodeResults(Subscription subs, Map result) {
        JSONArray results_list = new JSONArray();
        SubscriptionResult[] results = subs.getHistory().getResults(false);
        for (int i = 0; i < results.length; ++i) {
            SubscriptionResult r = results[i];
            results_list.add(r.toJSONMap());
        }
        result.put("results", results_list);
    }

    protected Engine getEngineFromId(long id) {
        MetaSearchManager metaSearchManager = MetaSearchManagerFactory.getSingleton();
        Engine[] engines = metaSearchManager.getMetaSearch().getEngines(false, true);
        for (int i = 0; i < engines.length; ++i) {
            Engine engine = engines[i];
            if (engine.getId() != id) continue;
            return engine;
        }
        return null;
    }

    public boolean sendBrowserMessage(String key, String op, Map params) {
        MetaSearchManagerFactory.getSingleton().log("BrowserListener: sent " + op + ": " + params);
        return this.context.sendBrowserMessage(key, op, params);
    }

    public boolean sendBrowserMessage(String key, String op, Collection params) {
        MetaSearchManagerFactory.getSingleton().log("BrowserListener: sent " + op + ": " + params);
        return this.context.sendBrowserMessage(key, op, params);
    }

    static {
        TorrentUtils.addTorrentAttributeListener(new TorrentUtils.torrentAttributeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void attributeSet(TOTorrent torrent, String attribute, Object value) {
                if (attribute == "obtained_from") {
                    try {
                        String torrent_url = (String)value;
                        boolean hook_dm = false;
                        Set set = pending_play_now_urls;
                        synchronized (set) {
                            if (pending_play_now_urls.remove(torrent_url)) {
                                hook_dm = true;
                            }
                        }
                        if (hook_dm) {
                            final HashWrapper hash = torrent.getHashWrapper();
                            AzureusCore core = AzureusCoreFactory.getSingleton();
                            final GlobalManager gm = core.getGlobalManager();
                            DownloadManager existing = gm.getDownloadManager(hash);
                            if (existing != null) {
                                MetaSearchListener.playOrStream(existing);
                                return;
                            }
                            GlobalManagerAdapter l = new GlobalManagerAdapter(){
                                private final long listener_add_time = SystemTime.getMonotonousTime();

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void downloadManagerAdded(DownloadManager dm) {
                                    try {
                                        TOTorrent t = dm.getTorrent();
                                        if (t.getHashWrapper().equals(hash)) {
                                            gm.removeListener(this);
                                            MetaSearchListener.playOrStream(dm);
                                        }
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                    finally {
                                        if (SystemTime.getMonotonousTime() - this.listener_add_time > 300000L) {
                                            gm.removeListener(this);
                                        }
                                    }
                                }
                            };
                            gm.addListener(l, false);
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        });
    }
}

