/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.subscriptions;

import com.aelitis.azureus.core.subs.Subscription;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnSubscriptionLastChecked
extends CoreTableColumn
implements TableCellRefreshListener {
    SimpleDateFormat format = new SimpleDateFormat("MM/dd/yy hh:mm");
    public static String COLUMN_ID = "last-checked";

    public ColumnSubscriptionLastChecked(String sTableID) {
        super(COLUMN_ID, -2, 100, sTableID);
        this.setMinWidth(100);
    }

    public void refresh(TableCell cell) {
        Date date = null;
        String dateText = "--";
        Subscription sub = (Subscription)cell.getDataSource();
        if (sub != null) {
            date = new Date(sub.getHistory().getLastScanTime());
        }
        if (date != null) {
            dateText = this.format.format(date);
        }
        if (!cell.setSortValue(date) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(dateText);
    }
}

