/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.util.DataSourceUtils;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnInfo
extends CoreTableColumn
implements TableCellAddedListener,
TableCellMouseListener,
TableCellSWTPaintListener {
    public static final String COLUMN_ID = "Info";
    private static Rectangle imgBounds;
    private static int width;
    private static Image img;
    private TableRow previousSelection;

    public ColumnInfo(String sTableID) {
        super(COLUMN_ID, sTableID);
        this.initializeAsGraphic(width);
        this.setAlignment(3);
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
        if (cell instanceof TableCellSWT) {
            ((TableCellSWT)cell).setCursorID(21);
        }
    }

    public void cellPaint(GC gc, TableCellSWT cell) {
        TOTorrent torrent = DataSourceUtils.getTorrent(cell.getDataSource());
        if (PlatformTorrentUtils.isContent(torrent, true)) {
            Rectangle cellBounds = cell.getBounds();
            gc.drawImage(img, cellBounds.x + (cellBounds.width - ColumnInfo.imgBounds.width) / 2, cellBounds.y + (cellBounds.height - ColumnInfo.imgBounds.height) / 2);
        }
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        Object ds = event2.cell.getDataSource();
        TOTorrent torrent = null;
        if (ds instanceof TOTorrent) {
            torrent = (TOTorrent)ds;
        } else if (ds instanceof DownloadManager) {
            torrent = ((DownloadManager)ds).getTorrent();
        }
        if (!PlatformTorrentUtils.isContent(torrent, true)) {
            return;
        }
        TableRow row = event2.cell.getTableRow();
        if (row != null && !row.isSelected()) {
            return;
        }
        if (row != this.previousSelection) {
            this.previousSelection = row;
            return;
        }
        if (event2.button == 1 && event2.eventType == 1) {
            try {
                TorrentListViewsUtils.viewDetails(torrent.getHashWrapper().toBase32String(), "info-column");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    static {
        width = 38;
        img = ImageLoaderFactory.getInstance().getImage("icon.info");
        imgBounds = img.getBounds();
    }
}

