/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.ui.swt.columns.utils.ColumnImageClickArea;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.utils.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.ui.swt.views.skin.VuzeShareUtils;
import com.aelitis.azureus.util.DataSourceUtils;
import com.aelitis.azureus.util.PlayUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseMoveListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellVisibilityListener;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseListener;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnMediaThumb
extends CoreTableColumn
implements TableCellAddedListener,
TableCellRefreshListener,
TableCellDisposeListener,
TableCellVisibilityListener,
TableCellMouseMoveListener,
TableRowMouseListener,
TableCellToolTipListener {
    public static String COLUMN_ID = "MediaThumb";
    public static final boolean ROW_HOVER = System.getProperty("rowhover", "0").equals("1");
    private static final boolean SET_ALPHA = false;
    private static final int WIDTH = 60;
    private static final String BTN_PLAY = "play";
    private static final String BTN_DL = "download";
    private static final String BTN_DETAILS = "details";
    private static final String BTN_RUN = "run";
    private static final String BTN_SHARE = "share";
    private static final int BORDER_SIZE = 0;
    private static final int IMG_SIZE = 19;
    private static final int IMG_SIZE_HALF = 9;
    private static final boolean ICONS_BELOW = true;
    private Map mapCellTorrent = new HashMap();
    private final int maxThumbHeight;
    private Image imgPlay;
    private Rectangle imgPlayBounds;
    private List listClickAreas = new ArrayList();
    private ColumnImageClickArea clickAreaRun;
    private ColumnImageClickArea clickAreaPlay;
    private ColumnImageClickArea clickAreaDetails;
    private ColumnImageClickArea clickAreaDL;
    private ColumnImageClickArea clickAreaShare;

    public ColumnMediaThumb(String sTableID, int maxThumbHeight) {
        this(sTableID, maxThumbHeight, 60);
    }

    public ColumnMediaThumb(String sTableID) {
        this(sTableID, 40, 60);
    }

    public ColumnMediaThumb(String sTableID, int maxThumbHeight, int WIDTH) {
        super(COLUMN_ID, sTableID);
        this.maxThumbHeight = maxThumbHeight;
        this.initializeAsGraphic(WIDTH);
        this.setWidthLimits(WIDTH, WIDTH);
        this.setAlignment(3);
        if (this.imgPlay == null) {
            this.loadImages();
        }
        String IMG_PREFIX = "image.button.thumb.";
        this.clickAreaPlay = new ColumnImageClickArea(COLUMN_ID, BTN_PLAY, "image.button.thumb.play");
        this.clickAreaPlay.setTooltip(MessageText.getString("v3.MainWindow.button.play"));
        this.listClickAreas.add(this.clickAreaPlay);
        this.clickAreaDetails = new ColumnImageClickArea(COLUMN_ID, BTN_DETAILS, "image.button.thumb.details");
        this.clickAreaDetails.setTooltip(MessageText.getString("v3.MainWindow.button.viewdetails"));
        this.listClickAreas.add(this.clickAreaDetails);
        this.clickAreaDL = new ColumnImageClickArea(COLUMN_ID, BTN_DL, "image.button.thumb.download");
        this.clickAreaDL.setTooltip(MessageText.getString("v3.MainWindow.button.download"));
        this.listClickAreas.add(this.clickAreaDL);
        this.clickAreaRun = new ColumnImageClickArea(COLUMN_ID, BTN_RUN, "image.button.thumb.run");
        this.clickAreaRun.setTooltip(MessageText.getString("v3.MainWindow.button.run"));
        this.listClickAreas.add(this.clickAreaRun);
        this.clickAreaShare = new ColumnImageClickArea(COLUMN_ID, BTN_SHARE, "image.button.thumb.share");
        this.clickAreaShare.setTooltip(MessageText.getString("v3.MainWindow.button.share"));
        this.listClickAreas.add(this.clickAreaShare);
    }

    private void loadImages() {
        ImageLoader imageLoader = ImageLoaderFactory.getInstance();
        this.imgPlay = imageLoader.getImage("image.thumb.play");
        if (this.imgPlay != null) {
            this.imgPlayBounds = this.imgPlay.getBounds();
        }
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
        for (ColumnImageClickArea clickArea : this.listClickAreas) {
            clickArea.addCell(cell);
        }
        TableRow tableRow = cell.getTableRow();
        if (tableRow != null) {
            tableRow.addMouseListener(this);
        }
    }

    public void dispose(TableCell cell) {
        this.mapCellTorrent.remove(cell);
        this.disposeOldImage(cell);
    }

    public void refresh(TableCell cell) {
        this.refresh(cell, false);
    }

    public void refresh(final TableCell cell, final boolean bForce) {
        boolean canRun;
        Object ds = cell.getDataSource();
        DownloadManager dm = DataSourceUtils.getDM(ds);
        TOTorrent newTorrent = DataSourceUtils.getTorrent(ds);
        long lastUpdated = PlatformTorrentUtils.getContentLastUpdated(newTorrent);
        if (lastUpdated == 0L) {
            lastUpdated = -1L;
        }
        boolean bChanged = cell.setSortValue(lastUpdated) || bForce;
        TOTorrent torrent = (TOTorrent)this.mapCellTorrent.get(cell);
        if (newTorrent == torrent && !bChanged && cell.isValid()) {
            return;
        }
        if (!Utils.isThisThreadSWT()) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    ColumnMediaThumb.this.refresh(cell, bForce);
                }
            });
            return;
        }
        if (!bForce && !cell.isShown()) {
            return;
        }
        boolean cellHasMouse = cell instanceof TableCellCore ? ((TableCellCore)cell).isMouseOver() : false;
        cellHasMouse = true;
        torrent = newTorrent;
        this.mapCellTorrent.put(cell, torrent);
        this.disposeOldImage(cell);
        byte[] b = null;
        boolean canPlay = PlayUtils.canPlayDS(ds);
        boolean showPlayButton = false;
        if (ds instanceof VuzeActivitiesEntry) {
            b = ((VuzeActivitiesEntry)ds).getImageBytes();
        }
        if (b == null) {
            b = PlatformTorrentUtils.getContentThumbnail(torrent);
        }
        boolean bl = canRun = !canPlay && dm != null;
        if (canRun && dm != null && !dm.getAssumedComplete()) {
            canRun = false;
        }
        Image firstImage = null;
        int dx = 0;
        int dy = 0;
        if (b == null) {
            String path = null;
            if (dm == null) {
                TOTorrentFile[] files = torrent.getFiles();
                if (files.length > 0) {
                    path = files[0].getRelativePath();
                }
            } else {
                path = dm.getDownloadState().getPrimaryFile();
            }
            if (path != null) {
                firstImage = ImageRepository.getPathIcon(path, true, torrent != null && !torrent.isSimpleTorrent());
            }
        }
        int cellWidth = cell.getWidth();
        int cellHeight = cell.getHeight();
        int MAXH = this.maxThumbHeight < 0 ? cell.getHeight() : this.maxThumbHeight;
        MAXH -= 24;
        TableRow row = cell.getTableRow();
        if (ROW_HOVER) {
            boolean rowHasMouse = row instanceof TableRowCore ? ((TableRowCore)row).isMouseOver() : false;
            showPlayButton &= rowHasMouse;
        } else {
            showPlayButton &= cellHasMouse;
        }
        boolean disposeImage = false;
        if (firstImage == null) {
            if (b != null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(b);
                firstImage = new Image((Device)Display.getDefault(), (InputStream)bis);
            } else {
                firstImage = new Image((Device)Display.getDefault(), 1, 1);
            }
            disposeImage = true;
        }
        Image newImg = null;
        try {
            boolean canShare;
            int wImg;
            int w2;
            int hImg;
            int h2;
            int w = firstImage.getBounds().width;
            int h = firstImage.getBounds().height;
            boolean smaller = false;
            if (h > MAXH) {
                hImg = h2 = MAXH;
                wImg = w2 = h2 * w / h;
            } else {
                h2 = MAXH;
                hImg = h;
                w2 = h2 * w / h;
                wImg = hImg * w / h;
                dy = (h2 - hImg) / 2;
                smaller = true;
            }
            if (cellWidth > wImg) {
                dx = (cellWidth - wImg) / 2;
            }
            newImg = new Image(firstImage.getDevice(), cellWidth, cellHeight);
            GC gc = new GC((Drawable)newImg);
            gc.setAdvanced(true);
            try {
                gc.setInterpolation(2);
                gc.setAntialias(1);
            }
            catch (Exception e) {
                // empty catch block
            }
            int[] bg = cell.getBackground();
            if (bg != null) {
                gc.setBackground(ColorCache.getColor(firstImage.getDevice(), bg));
                gc.fillRectangle(newImg.getBounds());
            }
            gc.setBackground(ColorCache.getColor(firstImage.getDevice(), "COLOR_LIST_BACKGROUND"));
            gc.setForeground(ColorCache.getColor(firstImage.getDevice(), "COLOR_WIDGET_LIGHT_SHADOW"));
            if (smaller) {
                gc.fillRoundRectangle(0, 0, cellWidth - 1, h2, 11, 8);
                gc.drawRoundRectangle(0, 0, cellWidth - 1, h2, 11, 8);
            }
            gc.fillRoundRectangle(0, h2 + 2, cellWidth - 1, cellHeight - h2 - 3, 11, 8);
            if (cellHasMouse) {
                // empty if block
            }
            gc.drawImage(firstImage, 0, 0, w, h, dx + 0, dy + 0, wImg - 0, hImg - 0);
            if (cell instanceof TableCellSWT) {
                TableCellSWT cellSWT = (TableCellSWT)cell;
                cellSWT.setCursorID(showPlayButton && cellSWT.isMouseOver() ? 21 : 0);
            }
            float scale = ds instanceof DownloadManager ? 0.8f : 1.0f;
            int imgSize = (int)(19.0f * scale);
            int imgSizeHalf = (int)(9.0f * scale);
            int border = (int)(4.0f * scale);
            boolean bl2 = canShare = dm != null;
            if (!canShare && ds instanceof VuzeActivitiesEntry) {
                try {
                    SelectedContentV3 sc = ((VuzeActivitiesEntry)ds).createSelectedContentObject();
                    canShare = sc != null;
                }
                catch (Exception e) {
                    canShare = false;
                }
            }
            int yPos = cellHeight - imgSize - 2;
            if (this.clickAreaDL != null) {
                this.clickAreaDL.setPosition(cellWidth - imgSize - border, yPos);
                this.clickAreaDL.setVisible(dm == null);
                if (dm == null) {
                    canShare = false;
                }
            }
            if (this.clickAreaDetails != null) {
                this.clickAreaDetails.setPosition(border, yPos);
                this.clickAreaDetails.setVisible(this.getHash(ds, true) != null);
            }
            if (this.clickAreaRun != null) {
                this.clickAreaRun.setPosition(border, yPos);
                this.clickAreaRun.setVisible(canRun);
            }
            if (this.clickAreaPlay != null) {
                this.clickAreaPlay.setPosition(cellWidth / 2 - imgSizeHalf, yPos);
                this.clickAreaPlay.setVisible(canPlay);
            }
            if (this.clickAreaShare != null) {
                this.clickAreaShare.setPosition(cellWidth - imgSize - border, yPos);
                this.clickAreaShare.setVisible(canShare);
            }
            if (showPlayButton && this.imgPlay != null) {
                int imgW = this.imgPlayBounds.width;
                int imgH = this.imgPlayBounds.height;
                float h3 = (int)((double)h2 * 0.8);
                float w3 = h3 * (float)imgW / (float)imgH;
                float x = ((float)w2 - w3) / 2.0f;
                float y = ((float)h2 - h3) / 2.0f;
                gc.drawImage(this.imgPlay, 0, 0, imgW, imgH, (int)x, (int)y, (int)w3, (int)h3);
            }
            for (ColumnImageClickArea clickArea : this.listClickAreas) {
                if (!cellHasMouse) continue;
                clickArea.setScale(scale);
                clickArea.drawImage(cell, gc);
            }
            gc.dispose();
            if (disposeImage) {
                firstImage.dispose();
            }
            if (newImg == null) {
                cell.setGraphic(null);
            } else {
                disposableUISWTGraphic graphic = new disposableUISWTGraphic(newImg);
                cell.setGraphic(graphic);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private String getHash(Object ds, boolean onlyOurs) {
        if (onlyOurs && !DataSourceUtils.isPlatformContent(ds)) {
            return null;
        }
        return DataSourceUtils.getHash(ds);
    }

    private void disposeOldImage(TableCell cell) {
        Graphic oldGraphic = cell.getGraphic();
        if (oldGraphic instanceof disposableUISWTGraphic) {
            Image oldImage = ((UISWTGraphic)oldGraphic).getImage();
            Utils.disposeSWTObjects(new Object[]{oldImage});
        }
    }

    public void cellVisibilityChanged(TableCell cell, int visibility) {
        if (visibility == 1) {
            this.disposeOldImage(cell);
        } else if (visibility == 0) {
            this.refresh(cell, true);
        }
    }

    private void log(TableCell cell, String s) {
        System.out.println(((TableRowCore)cell.getTableRow()).getIndex() + ":" + System.currentTimeMillis() + ": " + s);
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        if (event2.data instanceof ColumnImageClickArea) {
            ISelectedContent[] contents;
            if (!((TableCellCore)event2.cell).isMouseOver()) {
                return;
            }
            ColumnImageClickArea clickArea = (ColumnImageClickArea)event2.data;
            String id = clickArea.getId();
            if (id.equals(BTN_PLAY)) {
                String referal = null;
                Object ds = event2.cell.getDataSource();
                if (ds instanceof VuzeActivitiesEntry) {
                    if (((VuzeActivitiesEntry)ds).isDRM() && ((VuzeActivitiesEntry)ds).getDownloadManger() == null) {
                        String hash = this.getHash(event2.cell.getDataSource(), true);
                        if (hash != null) {
                            TorrentListViewsUtils.viewDetails(hash, "thumb");
                        }
                        return;
                    }
                    referal = "playdashboardactivity-" + ((VuzeActivitiesEntry)ds).getTypeID();
                }
                TorrentListViewsUtils.playOrStreamDataSource(ds, null, referal);
            } else if (id.equals(BTN_DL)) {
                String referal = null;
                Object ds = event2.cell.getDataSource();
                if (ds instanceof VuzeActivitiesEntry) {
                    if (((VuzeActivitiesEntry)ds).isDRM()) {
                        String hash = this.getHash(event2.cell.getDataSource(), true);
                        if (hash != null) {
                            TorrentListViewsUtils.viewDetails(hash, "thumb");
                        }
                        return;
                    }
                    referal = "dashboardactivity-" + ((VuzeActivitiesEntry)ds).getTypeID();
                }
                TorrentListViewsUtils.downloadDataSource(ds, false, referal);
            } else if (id.equals(BTN_DETAILS)) {
                String hash = this.getHash(event2.cell.getDataSource(), true);
                if (hash != null) {
                    TorrentListViewsUtils.viewDetails(hash, "thumb");
                }
            } else if (id.equals(BTN_RUN)) {
                Object ds = event2.cell.getDataSource();
                TorrentListViewsUtils.playOrStreamDataSource(ds, null, "unknown");
            } else if (id.equals(BTN_SHARE) && (contents = SelectedContentManager.getCurrentlySelectedContent()).length > 0) {
                String referer = event2.cell.getTableID() + "-media-thumb-btn";
                VuzeShareUtils.getInstance().shareTorrent(contents[0], referer);
            }
            return;
        }
        boolean changed = false;
        if (event2.eventType == 4) {
            changed = true;
        } else if (event2.eventType == 5) {
            changed = true;
        }
        if (changed && event2.cell != null) {
            this.invalidateAndRefresh(event2.cell);
        }
    }

    private void invalidateAndRefresh(TableCell cell) {
        cell.invalidate();
        if (cell instanceof TableCellCore) {
            TableCellCore cellCore = (TableCellCore)cell;
            cellCore.refreshAsync();
        }
    }

    public void rowMouseTrigger(TableRowMouseEvent event2) {
        this.rowMouseTrigger(event2, event2.row.getTableCell(COLUMN_ID));
    }

    public void rowMouseTrigger(TableRowMouseEvent event2, TableCell cell) {
        boolean changed = false;
        if (event2.eventType == 4) {
            changed = true;
        } else if (event2.eventType == 5) {
            changed = true;
        }
        if (changed && cell != null) {
            cell.invalidate();
            this.invalidateAndRefresh(cell);
        }
    }

    public void cellHover(TableCell cell) {
        if (cell.getToolTip() != null) {
            return;
        }
        Object ds = cell.getDataSource();
        DownloadManager dm = DataSourceUtils.getDM(ds);
        if (dm != null) {
            cell.setToolTip(PlatformTorrentUtils.getContentTitle2(dm));
        }
    }

    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }

    public class disposableUISWTGraphic
    extends UISWTGraphicImpl {
        public disposableUISWTGraphic(Image newImage) {
            super(newImage);
        }
    }
}

