/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionAdapter;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import com.aelitis.azureus.ui.swt.views.RateItListView;
import com.aelitis.azureus.ui.swt.views.list.ListCell;
import com.aelitis.azureus.ui.swt.views.list.ListView;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnRateDropDown
extends CoreTableColumn
implements TableCellAddedListener {
    public static String COLUMN_ID = "RateDD";
    private static final int DROP_DOWN_ARROW_WIDTH = 20;
    final String[] ICON_NAMES = new String[]{"icon.frogfingers.0", "icon.frogfingers.1", "icon.frogfingers.2", "icon.frogfingers.3", "icon.frogfingers.4", "icon.frogfingers.5", "icon.frogfingers.6"};
    private Image imgDD;
    private Rectangle imgDDbounds;

    public ColumnRateDropDown(String sTableID) {
        super(COLUMN_ID, sTableID);
        if (this.imgDD == null) {
            this.imgDD = ImageLoaderFactory.getInstance().getImage("image.rateitdd");
            this.imgDDbounds = this.imgDD.getBounds();
        }
        this.initializeAsGraphic(this.imgDDbounds.width);
        this.setAlignment(3);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    private class Cell
    implements TableCellRefreshListener,
    TableCellMouseListener {
        private Composite cDropDownList = null;
        private long lClosedOn = 0L;
        private Image imgRating;

        public Cell(TableCell cell) {
            cell.addListeners(this);
            cell.setMarginWidth(0);
            cell.setMarginHeight(0);
            int i = (int)(Math.random() * (double)ColumnRateDropDown.this.ICON_NAMES.length);
            this.imgRating = ImageLoaderFactory.getInstance().getImage(ColumnRateDropDown.this.ICON_NAMES[i]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh(TableCell cell) {
            if (cell.isValid()) {
                return;
            }
            Image image = new Image((Device)Display.getCurrent(), ((ColumnRateDropDown)ColumnRateDropDown.this).imgDDbounds.width, ((ColumnRateDropDown)ColumnRateDropDown.this).imgDDbounds.height);
            GC gc = new GC((Drawable)image);
            try {
                gc.drawImage(ColumnRateDropDown.this.imgDD, 0, 0);
                gc.drawImage(this.imgRating, 3, 1);
            }
            finally {
                gc.dispose();
            }
            UISWTGraphicImpl graphic = new UISWTGraphicImpl(image);
            cell.setGraphic(graphic);
        }

        public void cellMouseTrigger(final TableCellMouseEvent event2) {
            if (event2.button != 1 || event2.eventType != 0) {
                return;
            }
            int width = event2.cell.getWidth();
            if (event2.x < width - 20) {
                return;
            }
            event2.skipCoreFunctionality = true;
            if (this.cDropDownList != null) {
                this.closeDropDownList();
                return;
            }
            if (SystemTime.getCurrentTime() - this.lClosedOn < 100L) {
                return;
            }
            if (!(event2.cell instanceof TableCellSWT)) {
                return;
            }
            TableCellSWT cellSWT = (TableCellSWT)event2.cell;
            final ListCell listCell = (ListCell)cellSWT.getBufferedTableItem();
            Composite parent = (Composite)((ListView)listCell.getRow().getView()).getControl();
            Rectangle bounds = cellSWT.getBounds();
            Point location = parent.toDisplay(bounds.x, bounds.y + bounds.height);
            this.cDropDownList = new Composite((Composite)parent.getShell(), 2048);
            this.cDropDownList.setSize(width, 200);
            location = parent.getShell().toControl(location);
            this.cDropDownList.setLocation(location.x, location.y);
            this.cDropDownList.moveAbove(null);
            this.cDropDownList.setBackground(parent.getDisplay().getSystemColor(25));
            this.cDropDownList.setForeground(parent.getDisplay().getSystemColor(24));
            this.cDropDownList.setBackgroundMode(2);
            this.cDropDownList.setLayout((Layout)new FormLayout());
            RateItListView view = new RateItListView(null, this.cDropDownList);
            view.getListView().setMouseClickIsDefaultSelection(true);
            view.getListView().addSelectionListener(new TableSelectionAdapter(){

                public void defaultSelected(TableRowCore[] rows, int stateMask) {
                    Cell.this.closeDropDownList();
                    ((ListView)listCell.getRow().getView()).getControl().setFocus();
                    String id = (String)rows[0].getDataSource(true);
                    Cell.this.imgRating = ImageLoaderFactory.getInstance().getImage(id);
                    event2.cell.invalidate();
                }

                public void selected(TableRowCore[] rows) {
                    Cell.this.closeDropDownList();
                }
            }, false);
            this.cDropDownList.layout(true, true);
            view.getListView().updateUI();
            this.cDropDownList.setFocus();
            view.getListView().getControl().addListener(16, new Listener(){

                public void handleEvent(Event event2) {
                    Cell.this.closeDropDownList();
                }
            });
            view.getListView().getControl().addListener(27, new Listener(){

                public void handleEvent(Event event2) {
                    Cell.this.closeDropDownList();
                }
            });
        }

        protected void closeDropDownList() {
            this.lClosedOn = SystemTime.getCurrentTime();
            this.cDropDownList.dispose();
            this.cDropDownList = null;
        }
    }
}

